/* -*- mode:c -*-
 *
 * Copyright (c) 2014 The Chromium OS Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

/* Declare symbolic names for all the GPIOs that we care about.
 * Note: Those with interrupt handlers must be declared first. */

/* Interrupts */
GPIO_INT(USB_C0_VBUS_WAKE,       PIN(E, 6),  GPIO_INT_BOTH,    vbus0_evt)
GPIO_INT(USB_C1_VBUS_WAKE,       PIN(F, 2),  GPIO_INT_BOTH,    vbus1_evt)
GPIO_INT(USB_C0_BC12_INT_L,      PIN(B, 0),  GPIO_INT_FALLING, usb0_evt)
GPIO_INT(USB_C1_BC12_INT_L,      PIN(C, 11), GPIO_INT_FALLING, usb1_evt)
GPIO_INT(PCH_SLP_S0_L,           PIN(C, 14), GPIO_INT_BOTH,    pch_evt)
GPIO_INT(PCH_SLP_S3_L,           PIN(C, 15), GPIO_INT_BOTH,    pch_evt)
GPIO_INT(PCH_SLP_S5_L,           PIN(D, 7),  GPIO_INT_BOTH,    pch_evt)
GPIO_INT(WP_L,                   PIN(D, 2),  GPIO_INT_BOTH,    switch_interrupt)

/* PD RX/TX */
GPIO(USB_C0_CC1_PD,          PIN(A, 0),  GPIO_ANALOG)
GPIO(USB_C0_REF,             PIN(A, 1),  GPIO_ANALOG)
GPIO(USB_C1_CC1_PD,          PIN(A, 2),  GPIO_ANALOG)
GPIO(USB_C0_CC2_PD,          PIN(A, 4),  GPIO_ANALOG)
GPIO(USB_C1_CC2_PD,          PIN(A, 5),  GPIO_ANALOG)
GPIO(USB_C0_REF_PD_ODL,      PIN(A, 6),  GPIO_ODR_LOW)

GPIO(USB_C_CC_EN,            PIN(C, 10), GPIO_OUT_LOW)
GPIO(USB_C1_CC_TX_EN,        PIN(A, 15), GPIO_OUT_LOW)
GPIO(USB_C0_CC_TX_EN,        PIN(B, 9),  GPIO_OUT_LOW)
GPIO(USB_C1_CC1_TX_DATA,     PIN(B, 4),  GPIO_OUT_LOW)
GPIO(USB_C0_CC1_TX_DATA,     PIN(B, 14), GPIO_OUT_LOW)
GPIO(USB_C1_CC2_TX_DATA,     PIN(E, 14), GPIO_OUT_LOW)
GPIO(USB_C0_CC2_TX_DATA,     PIN(D, 3),  GPIO_OUT_LOW)

#if 0
/* Alternate functions */
GPIO(USB_C1_TX_CLKOUT,       PIN(B, 1),  GPIO_OUT_LOW)
GPIO(USB_C0_TX_CLKOUT,       PIN(E, 1),  GPIO_OUT_LOW)
GPIO(USB_C1_TX_CLKIN,        PIN(B, 3),  GPIO_OUT_LOW)
GPIO(USB_C0_TX_CLKIN,        PIN(B, 13), GPIO_OUT_LOW)
#endif

/* Power and muxes control */
GPIO(PPVAR_BOOSTIN_SENSE,    PIN(C, 1),  GPIO_ANALOG)
GPIO(PP3300_USB_PD_EN,       PIN(A, 8),  GPIO_OUT_HIGH)
GPIO(USB_C0_CHARGE_EN_L,     PIN(D, 12), GPIO_OUT_LOW)
GPIO(USB_C1_CHARGE_EN_L,     PIN(D, 13), GPIO_OUT_LOW)
GPIO(USB_C0_5V_EN,           PIN(D, 14), GPIO_OUT_LOW)
GPIO(USB_C1_5V_EN,           PIN(D, 15), GPIO_OUT_LOW)
GPIO(USB_C0_CC1_VCONN1_EN_L, PIN(D, 8),  GPIO_OUT_HIGH)
GPIO(USB_C0_CC2_VCONN1_EN_L, PIN(D, 9),  GPIO_OUT_HIGH)
GPIO(USB_C1_CC1_VCONN1_EN_L, PIN(D, 10), GPIO_OUT_HIGH)
GPIO(USB_C1_CC2_VCONN1_EN_L, PIN(D, 11), GPIO_OUT_HIGH)
GPIO(USB_C0_CC_1A5_EN,       PIN(B, 12), GPIO_OUT_LOW)
GPIO(USB_C1_CC_1A5_EN,       PIN(E, 12), GPIO_OUT_LOW)
GPIO(ILIM_ADJ_PWM,           PIN(B, 15), GPIO_OUT_LOW)

GPIO(USB_C0_CC1_ODL,         PIN(B, 8),  GPIO_ODR_LOW)
GPIO(USB_C0_CC2_ODL,         PIN(E, 0),  GPIO_ODR_LOW)
GPIO(USB_C1_CC1_ODL,         PIN(F, 9),  GPIO_ODR_LOW)
GPIO(USB_C1_CC2_ODL,         PIN(F, 10), GPIO_ODR_LOW)

GPIO(USB_C_BC12_SEL,         PIN(C, 0),  GPIO_OUT_LOW)
GPIO(USB_C0_SS1_EN_L,        PIN(E, 2),  GPIO_OUT_HIGH)
GPIO(USB_C0_SS2_EN_L,        PIN(E, 3),  GPIO_OUT_HIGH)
GPIO(USB_C1_SS1_EN_L,        PIN(E, 9),  GPIO_OUT_HIGH)
GPIO(USB_C1_SS2_EN_L,        PIN(E, 10), GPIO_OUT_HIGH)
GPIO(USB_C0_SS1_DP_MODE,     PIN(E, 4),  GPIO_OUT_HIGH)
GPIO(USB_C0_SS2_DP_MODE,     PIN(E, 5),  GPIO_OUT_HIGH)
GPIO(USB_C1_SS1_DP_MODE,     PIN(E, 11), GPIO_OUT_HIGH)
GPIO(USB_C1_SS2_DP_MODE,     PIN(E, 13), GPIO_OUT_HIGH)
GPIO(USB_C0_DP_MODE_L,       PIN(E, 8),  GPIO_OUT_HIGH)
GPIO(USB_C1_DP_MODE_L,       PIN(F, 6),  GPIO_OUT_HIGH)
GPIO(USB_C0_DP_POLARITY,     PIN(E, 7),  GPIO_OUT_HIGH)
GPIO(USB_C1_DP_POLARITY,     PIN(F, 3),  GPIO_OUT_HIGH)
GPIO(USB_C0_DP_HPD,          PIN(F, 0),  GPIO_OUT_LOW)
GPIO(USB_C1_DP_HPD,          PIN(F, 1),  GPIO_OUT_LOW)

#if 0
/* Alternate functions */
GPIO(USB_DM,                 PIN(A, 11), GPIO_ANALOG)
GPIO(USB_DP,                 PIN(A, 12), GPIO_ANALOG)
GPIO(UART_TX,                PIN(A, 9),  GPIO_OUT_LOW)
GPIO(UART_RX,                PIN(A, 10), GPIO_OUT_LOW)
GPIO(TP64,                   PIN(A, 13), GPIO_ODR_HIGH)
GPIO(TP71,                   PIN(A, 14), GPIO_ODR_HIGH)
#endif

/*
 * I2C pins should be configured as inputs until I2C module is
 * initialized. This will avoid driving the lines unintentionally.
 */
GPIO(SLAVE_I2C_SCL,          PIN(B, 6),  GPIO_INPUT)
GPIO(SLAVE_I2C_SDA,          PIN(B, 7),  GPIO_INPUT)
GPIO(MASTER_I2C_SCL,         PIN(B, 10), GPIO_INPUT)
GPIO(MASTER_I2C_SDA,         PIN(B, 11), GPIO_INPUT)

/* Case closed debugging. */
GPIO(EC_INT,                 PIN(B, 2),  GPIO_OUT_LOW)
GPIO(EC_IN_RW,               PIN(C, 12), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_RST_L,               PIN(C, 13), GPIO_OUT_HIGH)
GPIO(SPI_FLASH_CS_L,         PIN(D, 0),  GPIO_INPUT)
GPIO(SPI_FLASH_CSK,          PIN(D, 1),  GPIO_INPUT)
GPIO(SPI_FLASH_MOSI,         PIN(C, 3),  GPIO_INPUT)
GPIO(SPI_FLASH_MISO,         PIN(C, 2),  GPIO_INPUT)
GPIO(EC_JTAG_TCK,            PIN(C, 6),  GPIO_INPUT)
GPIO(EC_JTAG_TMS,            PIN(C, 7),  GPIO_INPUT)
GPIO(EC_JTAG_TDO,            PIN(C, 8),  GPIO_INPUT)
GPIO(EC_JTAG_TDI,            PIN(C, 9),  GPIO_INPUT)
GPIO(ENTERING_RW,            PIN(B, 5),  GPIO_OUT_LOW)
GPIO(PD_DISABLE_DEBUG,       PIN(E, 15), GPIO_OUT_HIGH)
GPIO(PD_DEBUG_EN_L,          PIN(D, 4),  GPIO_INPUT | GPIO_PULL_UP)
GPIO(PD_SPI_PP3300_EN_L,     PIN(A, 7),  GPIO_OUT_HIGH)
GPIO(BST_DISABLE,            PIN(A, 3),  GPIO_OUT_LOW)

#if 0
/* Alternate functions */
GPIO(EC_UART_TX,             PIN(C, 4),  GPIO_OUT_LOW)
GPIO(EC_UART_RX,             PIN(C, 5),  GPIO_INPUT)
GPIO(AP_UART_TX,             PIN(D, 5),  GPIO_OUT_LOW)
GPIO(AP_UART_RX,             PIN(D, 6),  GPIO_INPUT)
#endif

ALTERNATE(PIN_MASK(B, 0x0008), 0, MODULE_USB_PD, 0) /* SPI1: SCK(PB3) */
ALTERNATE(PIN_MASK(B, 0x2000), 0, MODULE_USB_PD, 0) /* SPI2: SCK(PB13) */
ALTERNATE(PIN_MASK(B, 0x0002), 0, MODULE_USB_PD, 0) /* TIM14_CH1: PB1) */
ALTERNATE(PIN_MASK(E, 0x0002), 0, MODULE_USB_PD, 0) /* TIM17_CH1: PE1) */
ALTERNATE(PIN_MASK(A, 0x0600), 1, MODULE_UART,   0) /* USART1: PA9/PA10 */
ALTERNATE(PIN_MASK(D, 0x0060), 0, MODULE_UART,   0) /* USART2: PD5/PD6 */
ALTERNATE(PIN_MASK(C, 0x0030), 1, MODULE_UART,   0) /* USART3: PC4/PC5 */
ALTERNATE(PIN_MASK(B, 0x0cc0), 1, MODULE_I2C,    0) /* I2C SLAVE:PB6/7 MASTER:PB10/11 */

#ifdef CONFIG_PWM
ALTERNATE(PIN_MASK(B, 0x8000), 1, MODULE_PWM,    0) /* ILIM_PWM: PB15 */
#endif
