/* -*- mode:c -*-
 *
 * Copyright 2016 The Chromium OS Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

/* Outputs */
GPIO(UART1_EN_L,		PIN(A, 8), GPIO_OUT_HIGH)
GPIO(SERVO_JTAG_TRST_L,		PIN(A, 13), GPIO_OUT_LOW)
GPIO(SPI1_BUF_EN_L,		PIN(A, 14), GPIO_OUT_HIGH)
GPIO(SPI2_BUF_EN_L,		PIN(A, 15), GPIO_OUT_HIGH)

GPIO(UART2_EN_L,		PIN(B, 0), GPIO_OUT_HIGH)
GPIO(SPI1_VREF_33,		PIN(B, 2), GPIO_OUT_LOW)
GPIO(SPI1_VREF_18,		PIN(B, 3), GPIO_OUT_LOW)
GPIO(SPI2_VREF_33,		PIN(B, 4), GPIO_OUT_LOW)
GPIO(SPI2_VREF_18,		PIN(B, 5), GPIO_OUT_LOW)
GPIO(SERVO_JTAG_TRST_DIR,	PIN(B, 6), GPIO_OUT_HIGH)
GPIO(SERVO_JTAG_TDI_DIR,	PIN(B, 7), GPIO_OUT_HIGH)

GPIO(TCA6416_RESET_L,		PIN(C, 13), GPIO_OUT_LOW)
GPIO(SPI1_MUX_SEL,		PIN(A, 5), GPIO_OUT_LOW)
GPIO(SERVO_JTAG_TMS_DIR,	PIN(C, 14), GPIO_OUT_LOW)
GPIO(SERVO_JTAG_TDO_SEL,	PIN(C, 15), GPIO_OUT_LOW)
GPIO(JTAG_BUFOUT_EN_L,		PIN(F, 0), GPIO_OUT_HIGH)
GPIO(JTAG_BUFIN_EN_L,		PIN(F, 1), GPIO_OUT_HIGH)

/* Inputs */
GPIO(SERVO_JTAG_TMS,		PIN(A, 4), GPIO_INPUT)
GPIO(UART3_TX_SERVO_JTAG_TCK,	PIN(A, 0), GPIO_INPUT)
GPIO(UART3_RX_JTAG_BUFFER_TO_SERVO_TDO,		PIN(A, 1), GPIO_INPUT)
GPIO(SERVO_JTAG_TDO_BUFFER_EN,	PIN(A, 6), GPIO_INPUT)
GPIO(SERVO_JTAG_TDI,		PIN(A, 7), GPIO_INPUT)

GPIO(SERVO_JTAG_RTCK,		PIN(B, 1), GPIO_INPUT)

/* Flash SPI interface */
GPIO(SPI_CS,			PIN(B, 12), GPIO_OUT_HIGH)
GPIO(SPI_CLK,			PIN(B, 13), GPIO_INPUT)
GPIO(SPI_MISO,			PIN(B, 14), GPIO_INPUT)
GPIO(SPI_MOSI,			PIN(B, 15), GPIO_INPUT)

/* I2C pins should be configured as inputs until I2C module is    */
/* initialized. This will avoid driving the lines unintentionally.*/
GPIO(MASTER_I2C_SCL,		PIN(B, 8), GPIO_INPUT)
GPIO(MASTER_I2C_SDA,		PIN(B, 9), GPIO_INPUT)

/* Unimplemented signals since we are not an EC */
UNIMPLEMENTED(ENTERING_RW)
UNIMPLEMENTED(WP_L)

ALTERNATE(PIN_MASK(A, 0x0600), 1, MODULE_UART, 0) /* USART1: PA09/PA10 - Servo stm32 console UART*/
ALTERNATE(PIN_MASK(A, 0x000C), 1, MODULE_USART, 0) /* USART2: PA2/PA3 - Servo UART1 */
ALTERNATE(PIN_MASK(B, 0x0C00), 4, MODULE_USART, 0) /* USART3: PB10/PB11 - Servo UART2 */
ALTERNATE(PIN_MASK(A, 0x0003), 4, MODULE_USART, 0) /* USART4: PA0/PA1 - Servo UART3 */

ALTERNATE(PIN_MASK(B, 0x0300), 1, MODULE_I2C, 0) /* I2C MASTER:PB8/9 GPIO_ODR_HIGH */

ALTERNATE(PIN_MASK(B, 0xE000), 0, MODULE_SPI_FLASH, 0) /* SPI: PB15 - PB12 MOSI, MISO, CLK, CS */
