/* -*- mode:c -*-
 *
 * Copyright 2016 The Chromium OS Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

/* Outputs */
GPIO(DUT_CHG_EN,		PIN(A, 10), GPIO_OUT_LOW)
GPIO(HOST_OR_CHG_CTL,		PIN(A, 13), GPIO_OUT_HIGH)
GPIO(SBU_UART_SEL,		PIN(A, 15), GPIO_OUT_LOW)
GPIO(HOST_USB_HUB_RESET_L,	PIN(D, 2),  GPIO_OUT_HIGH)
GPIO(FASTBOOT_DUTHUB_MUX_SEL,	PIN(B, 5),  GPIO_OUT_HIGH)
GPIO(SBU_MUX_EN,		PIN(B, 6),  GPIO_OUT_LOW)
GPIO(FASTBOOT_DUTHUB_MUX_EN_L,	PIN(B, 7),  GPIO_OUT_LOW)
/* Power on init has reset asserted, we will pull the hub out of reset
 * in the board init to help avoid brownout.
 */
GPIO(DUT_HUB_USB_RESET_L,	PIN(B, 9),  GPIO_OUT_LOW)
GPIO(ATMEL_HWB_L,		PIN(B, 12), GPIO_OUT_HIGH)
GPIO(CMUX_EN,			PIN(C, 14), GPIO_OUT_HIGH)
GPIO(EMMC_MUX_EN_L,		PIN(F, 0),  GPIO_OUT_HIGH)
GPIO(EMMC_PWR_EN,		PIN(F, 1),  GPIO_OUT_LOW)

/* Inputs */
GPIO(DP_HPD,			PIN(A, 14), GPIO_INPUT)
GPIO(USERVO_FAULT_L,		PIN(A, 8),  GPIO_INPUT)
GPIO(USB_FAULT_L,		PIN(A, 9),  GPIO_INPUT)
GPIO(DONGLE_DET,		PIN(C, 15), GPIO_INPUT)

/* Type-C */
/* PD RX/TX */
GPIO(USB_C_REF,			PIN(A, 1),  GPIO_ANALOG)
GPIO(USB_CHG_CC1_PD,		PIN(A, 2),  GPIO_ANALOG)
GPIO(USB_CHG_CC2_PD,		PIN(A, 4),  GPIO_ANALOG)
GPIO(USB_DUT_CC1_PD,		PIN(A, 0),  GPIO_ANALOG)
GPIO(USB_DUT_CC2_PD,		PIN(A, 5),  GPIO_ANALOG)

GPIO(USB_DET_PP_DUT,		PIN(C, 12), GPIO_INPUT)
GPIO(USB_DET_PP_CHG,		PIN(C, 13), GPIO_INPUT)

GPIO(USB_CHG_CC1_TX_DATA,	PIN(B, 4),  GPIO_INPUT)
GPIO(USB_CHG_CC2_TX_DATA,	PIN(A, 6),  GPIO_INPUT)
GPIO(USB_DUT_CC1_TX_DATA,	PIN(B, 14), GPIO_INPUT)
GPIO(USB_DUT_CC2_TX_DATA,	PIN(C, 2),  GPIO_INPUT)

GPIO(USB_DUT_CC1_RP3A0,		PIN(C, 0),  GPIO_INPUT)
GPIO(USB_DUT_CC1_RP1A5,		PIN(C, 1),  GPIO_INPUT)
GPIO(USB_DUT_CC1_RPUSB,		PIN(C, 3),  GPIO_INPUT)
GPIO(USB_DUT_CC1_RD,		PIN(C, 6),  GPIO_INPUT)
GPIO(USB_DUT_CC1_RA,		PIN(C, 7),  GPIO_INPUT)

GPIO(USB_DUT_CC2_RP3A0,		PIN(C, 8),  GPIO_INPUT)
GPIO(USB_DUT_CC2_RP1A5,		PIN(C, 9),  GPIO_INPUT)
GPIO(USB_DUT_CC2_RPUSB,		PIN(B, 0),  GPIO_INPUT)
GPIO(USB_DUT_CC2_RD,		PIN(B, 1),  GPIO_INPUT)
GPIO(USB_DUT_CC2_RA,		PIN(B, 2),  GPIO_INPUT)

/* Alternate PD functions */
GPIO(USB_CHG_TX_CLKOUT,       PIN(B, 8),  GPIO_INPUT)
GPIO(USB_CHG_TX_CLKIN,        PIN(B, 3),  GPIO_INPUT)
GPIO(USB_DUT_TX_CLKOUT,       PIN(B, 15), GPIO_INPUT)
GPIO(USB_DUT_TX_CLKIN,        PIN(B, 13), GPIO_INPUT)

/* I2C pins should be configured as inputs until I2C module is    */
/* initialized. This will avoid driving the lines unintentionally.*/
GPIO(MASTER_I2C_SCL,		PIN(B, 10), GPIO_INPUT)
GPIO(MASTER_I2C_SDA,		PIN(B, 11), GPIO_INPUT)

/* Unimplemented signals since we are not an EC */
UNIMPLEMENTED(ENTERING_RW)
UNIMPLEMENTED(WP_L)

ALTERNATE(PIN_MASK(C, 0x0030), 1, MODULE_USART, 0) /* USART3: PC4/PC5 - Servo DUT UART */
ALTERNATE(PIN_MASK(C, 0x0C00), 0, MODULE_USART, 0) /* USART4: PC10/PC11 - Servo UART3 */
ALTERNATE(PIN_MASK(B, 0x0C00), 1, MODULE_I2C, GPIO_ODR_HIGH) /* I2C MASTER:PB8/9 */
ALTERNATE(PIN_MASK(B, 0x0008), 0, MODULE_USB_PD, 0) /* SPI1_SCK:  PB3   */
ALTERNATE(PIN_MASK(B, 0x2000), 0, MODULE_USB_PD, 0) /* SPI2_SCK:  PB13  */
ALTERNATE(PIN_MASK(B, 0x0100), 2, MODULE_USB_PD, 0) /* TIM16_CH1: PB8   */
ALTERNATE(PIN_MASK(B, 0x8000), 1, MODULE_USB_PD, 0) /* TIM15_CH2: PB15  */

