/* Copyright 2015 The Chromium OS Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 *
 * Objects which can be shared between RO and RW for 8042 keyboard protocol.
 */

#include "button.h"
#include "keyboard_8042_sharedlib.h"
#include "keyboard_config.h"
#include "keyboard_protocol.h"
#include "libsharedobjs.h"
#include "util.h"

/* The standard Chrome OS keyboard matrix table. */
#ifdef CONFIG_KEYBOARD_SCANCODE_MUTABLE
uint16_t scancode_set1[KEYBOARD_ROWS][KEYBOARD_COLS] = {
#else
SHAREDLIB(const uint16_t scancode_set1[KEYBOARD_ROWS][KEYBOARD_COLS] = {
#endif
	{0x0000, 0xe05b, 0x003b, 0x0030, 0x0044, 0x0073, 0x0031, 0x0000, 0x000d,
	 0x0000, 0xe038, 0x0000, 0x0000},
	{0x0000, 0x0001, 0x003e, 0x0022, 0x0041, 0x0000, 0x0023, 0x0000, 0x0028,
	 0x0043, 0x0000, 0x000e, 0x0079},
	{0x001d, 0x000f, 0x003d, 0x0014, 0x0040, 0x001b, 0x0015, 0x0056, 0x001a,
	 0x0042, 0x007d, 0x0000, 0x0000},
	{0xe05b, 0x0029, 0x003c, 0x0006, 0x003f, 0x0000, 0x0007, 0x0000, 0x000c,
	 0x005d, 0x0000, 0x002b, 0x007b},
	{0xe01d, 0x001e, 0x0020, 0x0021, 0x001f, 0x0025, 0x0024, 0x0000, 0x0027,
	 0x0026, 0x002b, 0x001c, 0x0000},
	{0xe058, 0x002c, 0x002e, 0x002f, 0x002d, 0x0033, 0x0032, 0x002a, 0x0035,
	 0x0034, 0x0000, 0x0039, 0x0000},
	{0x0000, 0x0002, 0x0004, 0x0005, 0x0003, 0x0009, 0x0008, 0x0000, 0x000b,
	 0x000a, 0x0038, 0xe050, 0xe04d},
	{0x0000, 0x0010, 0x0012, 0x0013, 0x0011, 0x0017, 0x0016, 0x0036, 0x0019,
	 0x0018, 0x0000, 0xe048, 0xe04b},
#ifdef CONFIG_KEYBOARD_SCANCODE_MUTABLE
};
#else
});
#endif

#ifdef CONFIG_KEYBOARD_SCANCODE_MUTABLE
uint16_t scancode_set2[KEYBOARD_ROWS][KEYBOARD_COLS] = {
#else
SHAREDLIB(uint16_t const scancode_set2[KEYBOARD_ROWS][KEYBOARD_COLS] = {
#endif
	{0x0000, 0xe01f, 0x0005, 0x0032, 0x0009, 0x0051, 0x0031, 0x0000, 0x0055,
	 0x0000, 0xe011, 0x0000, 0x0000},
	{0x0000, 0x0076, 0x000c, 0x0034, 0x0083, 0x0000, 0x0033, 0x0000, 0x0052,
	 0x0001, 0x0000, 0x0066, 0x0064},
	{0x0014, 0x000d, 0x0004, 0x002c, 0x000b, 0x005b, 0x0035, 0x0061, 0x0054,
	 0x000a, 0x006a, 0x0000, 0x0000},
	{0xe01f, 0x000e, 0x0006, 0x002e, 0x0003, 0x0000, 0x0036, 0x0000, 0x004e,
	 0x002f, 0x0000, 0x005d, 0x0067},
	{0xe014, 0x001c, 0x0023, 0x002b, 0x001b, 0x0042, 0x003b, 0x0000, 0x004c,
	 0x004b, 0x005d, 0x005a, 0x0000},
	{0xe007, 0x001a, 0x0021, 0x002a, 0x0022, 0x0041, 0x003a, 0x0012, 0x004a,
	 0x0049, 0x0000, 0x0029, 0x0000},
	{0x0000, 0x0016, 0x0026, 0x0025, 0x001e, 0x003e, 0x003d, 0x0000, 0x0045,
	 0x0046, 0x0011, 0xe072, 0xe074},
	{0x0000, 0x0015, 0x0024, 0x002d, 0x001d, 0x0043, 0x003c, 0x0059, 0x004d,
	 0x0044, 0x0000, 0xe075, 0xe06b},
#ifdef CONFIG_KEYBOARD_SCANCODE_MUTABLE
};
#else
});
#endif

/*
 * Button scancodes.
 * Must be in the same order as defined in keyboard_button_type.
 */
SHAREDLIB(const struct button_8042_t buttons_8042[] = {
	{0xe05e, 0xe037, 0}, /* Power */
	{0xe02e, 0xe021, 1}, /* Volume Down */
	{0xe030, 0xe032, 1}, /* Volume Up */
	{0x0002, 0x0016, 1}, /* 1 */
	{0x0003, 0x001e, 1}, /* 2 */
	{0x0004, 0x0026, 1}, /* 3 */
	{0x0005, 0x0025, 1}, /* 4 */
	{0x0006, 0x002e, 1}, /* 5 */
	{0x0007, 0x0036, 1}, /* 6 */
	{0x0008, 0x003d, 1}, /* 7 */
	{0x0009, 0x003e, 1}, /* 8 */
});
BUILD_ASSERT(ARRAY_SIZE(buttons_8042) == KEYBOARD_BUTTON_COUNT);
