#ifdef GETPIR
#include "pirq_routing.h"
#else
#include <arch/pirq_routing.h>
#endif

static const struct irq_routing_table intel_irq_routing_table = {
	PIRQ_SIGNATURE,	/* u32 signature */
	PIRQ_VERSION,	/* u16 version   */
	32+16*CONFIG_IRQ_SLOT_COUNT,	/* There can be total CONFIG_IRQ_SLOT_COUNT devices on the bus */
	0x0,		/* Where the interrupt router lies (bus) */
	(0x2 << 3)|0x4,
	0,		/* IRQs devoted exclusively to PCI usage */
	0,		/* Vendor */
	0,		/* Device */
	0,		/* Miniport data */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, /* u8 rfu[11] */
	0x2a,		/* u8 checksum. This has to be set to some
			   value that would give 0 after the sum of all
			   bytes for this structure (including checksum) */
	{
		/* bus,       dev|fn,   {link, bitmap}, {link, bitmap}, {link, bitmap}, {link, bitmap},  slot, rfu */
		{0x00,(0x18 << 3)|0x0, {{0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0x0def8}}, 0x0, 0x0}, // Host Bridge
		{0x00,(0x02 << 3)|0x0, {{0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0x0def8}}, 0x0, 0x0}, // Broadcom ht1000 legacy southbridge
		{0x00,(0x03 << 3)|0x0, {{0x02, 0x0400}, {0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0x0def8}}, 0x0, 0x0}, // Broadcom ht1000 usb
		{0x00,(0x04 << 3)|0x0, {{0x18, 0x08a8}, {0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0x0def8}}, 0x0, 0x0}, // VGA Contr
		{0x00,(0x01 << 3)|0x0, {{0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0x0def8}}, 0x0, 0x0}, // Broadcom ht1000 pci/pci-x bridge
		{0x01,(0x0e << 3)|0x0, {{0x08, 0x00a0}, {0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0x0def8}}, 0x0, 0x0}, // Broadcom BCM5785 [HT1000] SATA
		{0x01,(0x0d << 3)|0x0, {{0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0x0def8}}, 0x0, 0x0}, // BCM5785 [HT1000] PCI/PCI-X Bridge
		//{0x02,(0x01 << 3)|0x0, {{0x11, 0x08a8}, {0x12, 0x08a8}, {0x13, 0x08a8}, {0x14, 0x008a8}}, 0x2, 0x0},
		{0x00,(0x06 << 3)|0x0, {{0x2f, 0x08a8}, {0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0x0def8}}, 0x0, 0x0}, // Broadcom HT2100 PCI-Express Bridge
		//{0x03,(0x00 << 3)|0x0, {{0x21, 0x08a8}, {0x21, 0x08a8}, {0x21, 0x08a8}, {0x21, 0x008a8}}, 0x1, 0x0},
		{0x00,(0x07 << 3)|0x0, {{0x2f, 0x08a8}, {0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0x0def8}}, 0x0, 0x0}, // Broadcom HT2100 PCI-Express Bridge
		{0x00,(0x08 << 3)|0x0, {{0x2f, 0x08a8}, {0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0x0def8}}, 0x0, 0x0}, // Broadcom HT2100 PCI-Express Bridge
		{0x00,(0x09 << 3)|0x0, {{0x2f, 0x08a8}, {0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0x0def8}}, 0x0, 0x0}, // Broadcom HT2100 PCI-Express Bridge
		//{0x06,(0x00 << 3)|0x0, {{0x24, 0x08a8}, {0x24, 0x08a8}, {0x24, 0x08a8}, {0x24, 0x008a8}}, 0x2, 0x0},
		{0x00,(0x0a << 3)|0x0, {{0x2f, 0x08a8}, {0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0x0def8}}, 0x0, 0x0}, // Broadcom HT2100 PCI-Express Bridge
		//{0x07,(0x00 << 3)|0x0, {{0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0x0def8}}, 0x0, 0x0},
		{0x08,(0x04 << 3)|0x0, {{0x25, 0x08a8}, {0x25, 0x08a8}, {0x00, 0xdef8}, {0x00, 0x0def8}}, 0x0, 0x0}, // BCM5715 Gigabit Ethernet
		{0x00,(0x18 << 3)|0x0, {{0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0x0def8}}, 0x0, 0x0}, // Host Bridge
		//{0x10,(0x01 << 3)|0x0, {{0x28, 0x8000}, {0x28, 0x8000}, {0x28, 0x8000}, {0x28, 0x08000}}, 0x1, 0x0},
		{0x40,(0x01 << 3)|0x0, {{0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0xdef8}, {0x00, 0x0def8}}, 0x0, 0x0}, // HTX slot
	}
};

unsigned long write_pirq_routing_table(unsigned long addr)
{
	return copy_pirq_routing_table(addr, &intel_irq_routing_table);
}
