/*
 * This file is part of the coreboot project.
 *
 * Copyright (C) 2007-2010 coresystems GmbH
 * Copyright (C) 2011 The ChromiumOS Authors.  All rights reserved.
 * Copyright (C) 2017 James Ye <jye836@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <arch/io.h>
#include <device/pci_def.h>
#include <northbridge/intel/sandybridge/raminit_native.h>
#include <southbridge/intel/bd82x6x/pch.h>

void pch_enable_lpc(void)
{
	/* EC Decode Range Port60/64, Port62/66 */
	/* Enable TPM, EC, PS/2 Keyboard/Mouse */
	pci_write_config16(PCH_LPC_DEV, LPC_EN,
			   CNF2_LPC_EN | CNF1_LPC_EN | MC_LPC_EN | KBC_LPC_EN);

	pci_write_config32(PCH_LPC_DEV, LPC_GEN1_DEC, 0x007c1611);
	pci_write_config32(PCH_LPC_DEV, LPC_GEN2_DEC, 0x00040069);
	pci_write_config32(PCH_LPC_DEV, LPC_GEN3_DEC, 0x000c0701);
	pci_write_config32(PCH_LPC_DEV, LPC_GEN4_DEC, 0x000c06a1);
}

void rcba_config(void)
{
	RCBA32(FD) |= PCH_DISABLE_ALWAYS;
}

const struct southbridge_usb_port mainboard_usb_ports[] = {
	{1, 1, 0},
	{1, 1, 0},
	{0, 1, 1},
	{1, 1, 1},
	{1, 0, 2},
	{1, 0, 2},
	{0, 0, 3},
	{0, 0, 3},
	{0, 1, 4},
	{1, 1, 4},
	{0, 0, 5},
	{0, 0, 5},
	{0, 0, 6},
	{1, 0, 6},
};

void mainboard_get_spd(spd_raw_data *spd, bool id_only)
{
	read_spd(&spd[0], 0x50, id_only);
	read_spd(&spd[2], 0x52, id_only);
}

void mainboard_early_init(int s3resume)
{
}

void mainboard_config_superio(void)
{
}
