/*
* Copyright (C) 2015 Broadcom Corporation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation version 2.
*
* This program is distributed "as is" WITHOUT ANY WARRANTY of any
* kind, whether express or implied; without even the implied warranty
* of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*/

const unsigned int ddr_init_tab[] = {
        0xffffffff
	};

#ifdef DDR2_SUPPORT
const unsigned int ddr2_init_tab[] = {
		0,	0x00000400,
		3,	0x00000043,
		4,	0x000000a7,
		5,	0x0a040a02,
		6,	0x04020404,
		7,	0x05030e14,
		8,	0x030e1404,
		9,	0x04020305,
		10,	0x03005b26,
		11,	0x04020303,
		12,	0x03005b26,
		13,	0x01000003,
		16,	0x030000c8,
		17,	0x00860000,
		18,	0x05050086,
		20,	0x00002301,
		21,	0x00230a24,
		22,	0x00050a24,
		23,	0x00000200,
		24,	0x000a0002,
		25,	0x0002000a,
		26,	0x00020008,
		27,	0x00c80008,
		28,	0x00c80027,
		29,	0x00000027,
		30,	0x03000001,
		31,	0x00030303,
		44,	0x00085300,
		45,	0x00000004,
		46,	0x00040853,
		48,	0x08530000,
		49,	0x00000004,
		50,	0x00040853,
		52,	0x08530000,
		53,	0x00000004,
		54,	0x00040853,
		56,	0x08530000,
		57,	0x00000004,
		58,	0x00040853,
		82,	0x01030101,
		108,	0x02020101,
		109,	0x08080404,
		110,	0x03020200,
		111,	0x01000202,
		128,	0x001d1d00,
		129,	0x1d1d0001,
		133,	0x00011d1d,
		134,	0x00011d1d,
		137,	0x001d1d00,
		138,	0x1d1d0001,
		142,	0x00011d1d,
		143,	0x00011d1d,
		146,	0x001d1d00,
		147,	0x1d1d0001,
		169,	0x0a240000,
		172,	0x00000a24,
		173,	0x000032b4,
		174,	0x0a240404,
		177,	0x00000a24,
		178,	0x000032b4,
		179,	0x02020404,
		186,	0x15070303,
		202,	0x0001046b,
		203,	0x0001046b,
		206,	0x01030301,
		207,	0x00000001,
		0xffffffff
};

const unsigned int ddr2_init_tab_400[] = {
    0,    0x00000400,
    1,    0x00000000,
    3,    0x00000050,
    4,    0x000000c8,
    5,    0x0c050c02,
    6,    0x04020405,
    7,    0x05031015,
    8,    0x03101504,
    9,    0x05020305,
    10,   0x03006d60,
    11,   0x05020303,
    12,   0x03006d60,
    13,   0x01000003,
    14,   0x05061001,
    15,   0x000b0b06,
    16,   0x030000c8,
    17,   0x00a01212,
    18,   0x060600a0,
    19,   0x00000000,
    20,   0x00003001,
    21,   0x00300c2d,
    22,   0x00050c2d,
    23,   0x00000200,
    24,   0x000a0002,
    25,   0x0002000a,
    26,   0x00020008,
    27,   0x00c80008,
    28,   0x00c80037,
    29,   0x00000037,
    30,   0x03000001,
    31,   0x00030303,
    32,   0x00000000,
    35,   0x00000000,
    36,   0x01000000,
    37,   0x10000000,
    38,   0x00100400,
    39,   0x00000400,
    40,   0x00000100,
    41,   0x00000000,
    42,   0x00000001,
    43,   0x00000000,
    44,   0x000a6300,
    45,   0x00000004,
    46,   0x00040a63,
    47,   0x00000000,
    48,   0x0a630000,
    49,   0x00000004,
    50,   0x00040a63,
    51,   0x00000000,
    52,   0x0a630000,
    53,   0x00000004,
    54,   0x00040a63,
    55,   0x00000000,
    56,   0x0a630000,
    57,   0x00000004,
    58,   0x00040a63,
    59,   0x00000000,
    60,   0x00000000,
    61,   0x00010100,
    62,   0x00000000,
    63,   0x00000000,
    64,   0x00000000,
    65,   0x00000000,
    66,   0x00000000,
    67,   0x00000000,
    68,   0x00000000,
    69,   0x00000000,
    70,   0x00000000,
    71,   0x00000000,
    72,   0x00000000,
    73,   0x00000000,
    74,   0x00000000,
    75,   0x00000000,
    76,   0x00000000,
    77,   0x00000000,
    78,   0x01000200,
    79,   0x02000040,
    80,   0x00400100,
    81,   0x00000200,
    82,   0x01030001,
    83,   0x01ffff0a,
    84,   0x01010101,
    85,   0x03010101,
    86,   0x01000003,
    87,   0x0000010c,
    88,   0x00010000,
    89,   0x00000000,
    90,   0x00000000,
    91,   0x00000000,
    92,   0x00000000,
    93,   0x00000000,
    94,   0x00000000,
    95,   0x00000000,
    96,   0x00000000,
    97,   0x00000000,
    98,   0x00000000,
    99,   0x00000000,
    100,  0x00000000,
    101,  0x00000000,
    102,  0x00000000,
    103,  0x00000000,
    104,  0x00000000,
    105,  0x00000000,
    106,  0x00000000,
    107,  0x00000000,
    108,  0x02020101,
    109,  0x08080404,
    110,  0x03020200,
    111,  0x01000202,
    112,  0x00000200,
    113,  0x00000000,
    114,  0x00000000,
    115,  0x00000000,
    116,  0x19000000,
    117,  0x00000028,
    118,  0x00000000,
    119,  0x00010001,
    120,  0x00010001,
    121,  0x00010001,
    122,  0x00010001,
    123,  0x00010001,
    124,  0x00000000,
    125,  0x00000000,
    126,  0x00000000,
    127,  0x00000000,
    128,  0x001c1c00,
    129,  0x1c1c0001,
    130,  0x00000001,
    131,  0x00000000,
    132,  0x00000000,
    133,  0x00011c1c,
    134,  0x00011c1c,
    135,  0x00000000,
    136,  0x00000000,
    137,  0x001c1c00,
    138,  0x1c1c0001,
    139,  0x00000001,
    140,  0x00000000,
    141,  0x00000000,
    142,  0x00011c1c,
    143,  0x00011c1c,
    144,  0x00000000,
    145,  0x00000000,
    146,  0x001c1c00,
    147,  0x1c1c0001,
    148,  0xffff0001,
    149,  0x00ffff00,
    150,  0x0000ffff,
    151,  0x00000000,
    152,  0x03030303,
    153,  0x03030303,
    156,  0x02006400,
    157,  0x02020202,
    158,  0x02020202,
    160,  0x01020202,
    161,  0x01010064,
    162,  0x01010101,
    163,  0x01010101,
    165,  0x00020101,
    166,  0x00000064,
    167,  0x00000000,
    168,  0x000a0a00,
    169,  0x0c2d0000,
    170,  0x02000200,
    171,  0x02000200,
    172,  0x00000c2d,
    173,  0x00003ce1,
    174,  0x0c2d0505,
    175,  0x02000200,
    176,  0x02000200,
    177,  0x00000c2d,
    178,  0x00003ce1,
    179,  0x02020505,
    180,  0x80000100,
    181,  0x04070303,
    182,  0x0000000a,
    183,  0x00000000,
    184,  0x00000000,
    185,  0x0010ffff,
    186,  0x16070303,
    187,  0x0000000f,
    188,  0x00000000,
    189,  0x00000000,
    190,  0x00000000,
    191,  0x00000000,
    192,  0x00000000,
    193,  0x00000000,
    194,  0x00000204,
    195,  0x00000000,
    196,  0x00000000,
    197,  0x00000000,
    198,  0x00000000,
    199,  0x00000000,
    200,  0x00000000,
    201,  0x00000000,
    202,  0x00000050,
    203,  0x00000050,
    204,  0x00000000,
    205,  0x00000040,
    206,  0x01030301,
    207,  0x00000001,
    0xffffffff
};
#endif

#if IS_ENABLED(CONFIG_CYGNUS_DDR333)
const unsigned int ddr3_init_tab_667[] = {
        0, 0x00000600,
        1, 0x00000000,
        2, 0x00000000,
        3, 0x00000000,
        4, 0x00000000,
        5, 0x00000000,
        6, 0x00000000,
        7, 0x00000400,
        8, 0x00000000,
        9, 0x00000000,
        10, 0x00000000,
        11, 0x00000004,
        12, 0x00000000,
        13, 0x00000000,
        15, 0x0001046b,
        16, 0x00028b0b,
        17, 0x00000000,
        18, 0x02000000,
        19, 0x00050a00,
        20, 0x00000000,
        21, 0x00050a00,
        22, 0x00000000,
        23, 0x05040400,
        24, 0x0c110004,
        25, 0x0a050404,
        26, 0x11000405,
        27, 0x0504040c,
        28, 0x0404040a,
        29, 0x005b680c,
        30, 0x040c0303,
        31, 0x000c0404,
        32, 0x03005b68,
        33, 0x05000c03,
        34, 0x00050505,
        35, 0x010c0032,
        41, 0x00000000,
        43, 0x00570100,
        44, 0x00000a20,
        45, 0x00000057,
        46, 0x00000a20,
        47, 0x00000005,
        48, 0x00030003,
        49, 0x000a000a,
        50, 0x00000000,
        51, 0x00000000,
        52, 0x02000000,
        53, 0x0200005a,
        54, 0x0000005a,
        55, 0x05000001,
        56, 0x00050505,
        57, 0x00000000,
        58, 0x00000000,
        59, 0x00010000,
        60, 0x10040010,
        62, 0x00000200,
        63, 0x00000000,
        64, 0x00000001,
        65, 0x00000000,
        66, 0x00000000,
        67, 0x00000000,
        68, 0x00000000,
        69, 0x00000000,
        70, 0x00000000,
        71, 0x00000000,
        72, 0x00000000,
        73, 0x00000000,
        74, 0x00000000,
        75, 0x00000000,
        76, 0x00000000,
        77, 0x00000000,
        82, 0x00000000,
        85, 0x00000046,
        86, 0x00000000,
        89, 0x00000000,
        90, 0x00000000,
        91, 0x00000000,
        92, 0x00000000,
        93, 0x00000000,
        94, 0x00000000,
        95, 0x00000000,
        96, 0x00000000,
        97, 0x00000000,
        98, 0x00000210,
        99, 0x00000046,
        100, 0x00000000,
        101, 0x00000210,
        102, 0x00000046,
        103, 0x00000000,
        104, 0x00000000,
        105, 0x00000000,
        106, 0x00000000,
        107, 0x00000000,
        108, 0x00000000,
        109, 0x00000000,
        110, 0x00000000,
        111, 0x00000000,
        113, 0x00000000,
        114, 0x00000000,
        115, 0x00000000,
        118, 0x00000000,
        124, 0x00000000,
        125, 0x00000000,
        126, 0x00000000,
        127, 0x00000000,
        128, 0x00000000,
        129, 0x00000000,
        131, 0x00000000,
        132, 0x00000000,
        133, 0x00000000,
        134, 0x00000000,
        135, 0x00000000,
        136, 0x00000000,
        137, 0x00000000,
        138, 0x00000000,
        140, 0x01000000,
        141, 0x00000001,
        142, 0x00000000,
        143, 0x00000000,
        144, 0x00000000,
        145, 0x00000000,
        146, 0x00000000,
        147, 0x00000000,
        151, 0x00000000,
        154, 0x00000000,
        155, 0x00000000,
        159, 0x00400100,
        164, 0x0a020001,
        167, 0x01010101,
        169, 0x00000c03,
        172, 0x01000000,
        173, 0x00000100,
        174, 0x00000000,
        177, 0x00000000,
        178, 0x00000000,
        179, 0x00000000,
        183, 0x00000000,
        184, 0x00000000,
        186, 0x00000000,
        188, 0x00000000,
        189, 0x00000000,
        190, 0x00000000,
        191, 0x00000000,
        192, 0x00000000,
        193, 0x00000000,
        195, 0x00000000,
        196, 0x01010200,
        197, 0x00000002,
        198, 0x06040400,
        199, 0x00000106,
        200, 0x00000000,
        201, 0x02020002,
        202, 0x02020101,
        203, 0x02000102,
        204, 0x00000000,
        206, 0x00000000,
        207, 0x00000000,
        208, 0x00000000,
        209, 0x0000280d,
        210, 0x00010000,
        211, 0x00010000,
        212, 0x00000003,
        213, 0x00000000,
        214, 0x00000000,
        215, 0x00000000,
        216, 0x00000000,
        217, 0x00000000,
        218, 0x00000000,
        219, 0x00000000,
        220, 0x00000000,
        221, 0x01000000,
        222, 0x00000001,
        223, 0x00000100,
        224, 0x00030300,
        225, 0x0556AA00,
        226, 0x000aa955,
        227, 0x000aa955,
        228, 0x000556aa,
        229, 0x000556aa,
        230, 0x000aa955,
        231, 0x000aa955,
        232, 0x030556aa,
        233, 0x01000001,
        234, 0x00010300,
        235, 0x00676700,
        236, 0x00676700,
        237, 0x00676700,
        238, 0x00676700,
        239, 0x00676700,
        240, 0x00676700,
        241, 0x00676700,
        242, 0x00676700,
        243, 0x00676700,
        244, 0x00000000,
        245, 0x01000000,
        246, 0x00000001,
        247, 0x00000101,
        248, 0x00010100,
        249, 0x03000000,
        250, 0x03030303,
        251, 0x00030303,
        252, 0x02020064,
        253, 0x02020202,
        254, 0x00010202,
        255, 0x01010064,
        256, 0x01010101,
        257, 0x00020101,
        258, 0x00000064,
        259, 0x00000000,
        260, 0x000d0d00,
        261, 0x00000000,
        262, 0x00001440,
        263, 0x02000200,
        264, 0x02000200,
        265, 0x00001440,
        266, 0x00006540,
        267, 0x00000505,
        268, 0x00001440,
        269, 0x02000200,
        270, 0x02000200,
        271, 0x00001440,
        272, 0x00006540,
        273, 0x02020505,
        274, 0x000a0100,
        275, 0x0000000a,
        276, 0x00000000,
        277, 0x00000000,
        278, 0x00000f0a,
        279, 0x00000000,
        280, 0x00000000,
        281, 0x00000000,
        282, 0x00000000,
        283, 0x00000000,
        284, 0x00000103,
        285, 0x00010003,
        286, 0x00000003,
        287, 0x00000000,
        288, 0x00000000,
        289, 0x00000000,
        290, 0x04010000,
        291, 0x00040404,
        292, 0x00000000,
        293, 0x00000000,
        294, 0x00000000,
        295, 0x00000000,
        296, 0x00000000,
        297, 0x00000000,
        298, 0x00000000,
        299, 0x00000000,
        300, 0x00000000,
        301, 0x00000000,
        302, 0x00000000,
        303, 0x00000000,
        304, 0x00000000,
        305, 0x00000000,
        0xffffffff
};
#endif

#if IS_ENABLED(CONFIG_CYGNUS_DDR400)
const unsigned int ddr3_init_tab_800[] = {
        14, 0x01000000,
        36, 0x0a140a0a,
        37, 0x0100000a,
        38, 0x0c0c0101,
        39, 0x00060603,
        40, 0x00010100,
        42, 0x00000000,
        61, 0x00000400,
        78, 0x00000000,
        79, 0x00000000,
        80, 0x00000000,
        81, 0x00000000,
        83, 0x00000000,
        84, 0x00000420,
        87, 0x00000420,
        88, 0x00000046,
        112, 0x00000000,
        116, 0x00000000,
        117, 0x00000000,
        119, 0x00000000,
        120, 0x00000000,
        121, 0x00000000,
        122, 0x00000000,
        123, 0x00000000,
        130, 0x00000000,
        139, 0x00000000,
        148, 0x00000000,
        149, 0x00000000,
        150, 0x00000000,
        152, 0x00000000,
        153, 0x00000000,
        156, 0x00000000,
        157, 0x01000200,
        158, 0x02000040,
        160, 0x00000200,
        161, 0x00000040,
        162, 0x00000000,
        163, 0x01000000,
        165, 0x0101ffff,
        166, 0x01010101,
        168, 0x00000103,
        170, 0x00000001,
        171, 0x00000000,
        175, 0x00000000,
        176, 0x00000000,
        180, 0x00000000,
        181, 0x00000000,
        182, 0x00000000,
        185, 0x00000000,
        187, 0x00000000,
        194, 0x00000000,
        205, 0x00000000,
        0, 0x00000600,
        1, 0x00000000,
        2, 0x00000000,
        3, 0x00000000,
        4, 0x00000000,
        5, 0x00000000,
        6, 0x00000000,
        7, 0x00000400,
        8, 0x00000000,
        9, 0x00000000,
        10, 0x00000000,
        11, 0x00000004,
        12, 0x00000000,
        13, 0x00000000,
        15, 0x00013880,
        16, 0x00030d40,
        17, 0x00000000,
        18, 0x02000000,
        19, 0x00050c00,
        20, 0x00000000,
        21, 0x00050c00,
        22, 0x00000000,
        23, 0x05040400,
        24, 0x0e140004,
        25, 0x0c060404,
        26, 0x14000405,
        27, 0x0604040e,
        28, 0x0404040c,
        29, 0x006db00c,
        30, 0x040c0303,
        31, 0x000c0404,
        32, 0x03006db0,
        33, 0x06000c03,
        34, 0x00060606,
        35, 0x010c003c,
        41, 0x00000000,
        43, 0x00680100,
        44, 0x00000c28,
        45, 0x00000068,
        46, 0x00000c28,
        47, 0x00000005,
        48, 0x00030003,
        49, 0x000a000a,
        50, 0x00000000,
        51, 0x00000000,
        52, 0x02000000,
        53, 0x0200006c,
        54, 0x0000006c,
        55, 0x05000001,
        56, 0x00050505,
        57, 0x00000000,
        58, 0x00000000,
        59, 0x00010000,
        60, 0x10040010,
        62, 0x00000200,
        63, 0x00000000,
        64, 0x00000001,
        65, 0x00000000,
        66, 0x00000000,
        67, 0x00000000,
        68, 0x00000000,
        69, 0x00000000,
        70, 0x00000000,
        71, 0x00000000,
        72, 0x00000000,
        73, 0x00000000,
        74, 0x00000000,
        75, 0x00000000,
        76, 0x00000000,
        77, 0x00000000,
        82, 0x00000000,
        85, 0x00000046,
        86, 0x00000000,
        89, 0x00000000,
        90, 0x00000000,
        91, 0x00000000,
        92, 0x00000000,
        93, 0x00000000,
        94, 0x00000000,
        95, 0x00000000,
        96, 0x00000000,
        97, 0x00000000,
        98, 0x00000420,
        99, 0x00000046,
        100, 0x00000000,
        101, 0x00000420,
        102, 0x00000046,
        103, 0x00000000,
        104, 0x00000000,
        105, 0x00000000,
        106, 0x00000000,
        107, 0x00000000,
        108, 0x00000000,
        109, 0x00000000,
        110, 0x00000000,
        111, 0x00000000,
        113, 0x00000000,
        114, 0x00000000,
        115, 0x00000000,
        118, 0x00000000,
        124, 0x00000000,
        125, 0x00000000,
        126, 0x00000000,
        127, 0x00000000,
        128, 0x00000000,
        129, 0x00000000,
        131, 0x00000000,
        132, 0x00000000,
        133, 0x00000000,
        134, 0x00000000,
        135, 0x00000000,
        136, 0x00000000,
        137, 0x00000000,
        138, 0x00000000,
        140, 0x01000000,
        141, 0x00000001,
        142, 0x00000000,
        143, 0x00000000,
        144, 0x00000000,
        145, 0x00000000,
        146, 0x00000000, // disable ECC
        147, 0x00000000,
        151, 0x00000000,
        154, 0x00000000,
        155, 0x00000000,
        159, 0x00400100,
        164, 0x0a020001,
        167, 0x01010101,
        169, 0x00000c03,
        172, 0x01000000,
        173, 0x00000100,
        174, 0x00000000,
        177, 0x00000000,
        178, 0x00000000,
        179, 0x00000000,
        183, 0x00000000,
        184, 0x00000000,
        186, 0x00000000,
        188, 0x00000000,
        189, 0x00000000,
        190, 0x00000000,
        191, 0x00000000,
        192, 0x00000000,
        193, 0x00000000,
        195, 0x00000000,
        196, 0x01010200,
        197, 0x00000002,
        198, 0x06040400,
        199, 0x00000106,
        200, 0x01010000,
        201, 0x02020002,
        202, 0x02020101,
        203, 0x02000102,
        204, 0x00000000,
        206, 0x00000000,
        207, 0x00000000,
        208, 0x00000000,
        209, 0x0000280d,
        210, 0x00010000,
        211, 0x00010000,
        212, 0x00000003,
        213, 0x00000000,
        214, 0x00000000,
        215, 0x00000000,
        216, 0x00000000,
        217, 0x00000000,
        218, 0x00000000,
        219, 0x00000000,
        220, 0x00000000,
        221, 0x01000000,
        222, 0x00000001,
        223, 0x00000100,
        224, 0x00030300,
        225, 0x0556AA00,
        226, 0x000aa955,
        227, 0x000aa955,
        228, 0x000556aa,
        229, 0x000556aa,
        230, 0x000aa955,
        231, 0x000aa955,
        232, 0x030556aa,
        233, 0x01000001,
        234, 0x00010300,
        235, 0x00676700,
        236, 0x00676700,
        237, 0x00676700,
        238, 0x00676700,
        239, 0x00676700,
        240, 0x00676700,
        241, 0x00676700,
        242, 0x00676700,
        243, 0x00676700,
        244, 0x00000000,
        245, 0x01000000,
        246, 0x00000001,
        247, 0x00000101,
        248, 0x00010100,
        249, 0x03000000,
        250, 0x03030303,
        251, 0x00030303,
        252, 0x02020064,
        253, 0x02020202,
        254, 0x00010202,
        255, 0x01010064,
        256, 0x01010101,
        257, 0x00020101,
        258, 0x00000064,
        259, 0x00000000,
        260, 0x000d0d00,
        261, 0x00000000,
        262, 0x00001850,
        263, 0x02000200,
        264, 0x02000200,
        265, 0x00001850,
        266, 0x00007990,
        267, 0x00000505,
        268, 0x00001850,
        269, 0x02000200,
        270, 0x02000200,
        271, 0x00001850,
        272, 0x00007990,
        273, 0x02020505,
        274, 0x000a0100,
        275, 0x0000000a,
        276, 0x00000000,
        277, 0x00000000,
        278, 0x00000f0a,
        279, 0x00000000,
        280, 0x00000000,
        281, 0x00000000,
        282, 0x00000000,
        283, 0x00000000,
        284, 0x00000103,
        285, 0x00010003,
        286, 0x00000003,
        287, 0x00000000,
        288, 0x00000000,
        289, 0x00000000,
        290, 0x05000000,
        291, 0x00040504,
        292, 0x00000000,
        293, 0x00000000,
        294, 0x00000000,
        295, 0x00000000,
        296, 0x00000000,
        297, 0x00000000,
        298, 0x00000000,
        299, 0x00000000,
        300, 0x00000000,
        301, 0x00000000,
        302, 0x00000000,
        303, 0x00000000,
        304, 0x00000000,
        305, 0x00000000,
        0xffffffff
};
#endif

#if IS_ENABLED(CONFIG_CYGNUS_DDR533)
const unsigned int ddr3_init_tab_1066[] = {
        14, 0x01000000,
        36, 0x0a140a0a,
        37, 0x0100000a,
        38, 0x10100101,
        39, 0x00080803,
        40, 0x00010100,
        42, 0x00000000,
        61, 0x00000400,
        78, 0x00000000,
        79, 0x00000000,
        80, 0x00000000,
        81, 0x00000000,
        83, 0x00000000,
        84, 0x00000840,
        87, 0x00000840,
        88, 0x00000046,
        112, 0x00000000,
        116, 0x00000000,
        117, 0x00000000,
        119, 0x00000000,
        120, 0x00000000,
        121, 0x00000000,
        122, 0x00000000,
        123, 0x00000000,
        130, 0x00000000,
        139, 0x00000000,
        148, 0x00000000,
        149, 0x00000000,
        150, 0x00000000,
        152, 0x00000000,
        153, 0x00000000,
        156, 0x00000000,
        157, 0x01000200,
        158, 0x02000040,
        160, 0x00000200,
        161, 0x00000040,
        162, 0x00000000,
        163, 0x01000000,
        165, 0x0101ffff,
        166, 0x01010101,
        168, 0x00000103,
        170, 0x00000001,
        171, 0x00000000,
        175, 0x00000000,
        176, 0x00000000,
        180, 0x00000000,
        181, 0x00000000,
        182, 0x00000000,
        185, 0x00000000,
        187, 0x00000000,
        194, 0x00000000,
        205, 0x00000000,
        0, 0x00000600,
        1, 0x00000000,
        2, 0x00000000,
        3, 0x00000000,
        4, 0x00000000,
        5, 0x00000000,
        6, 0x00000000,
        7, 0x00000600,
        8, 0x00000000,
        9, 0x00000000,
        10, 0x00000000,
        11, 0x00000006,
        12, 0x00000000,
        13, 0x00000000,
        15, 0x00019f8f,
        16, 0x00040ee6,
        17, 0x00000000,
        18, 0x02000000,
        19, 0x00061000,
        20, 0x00000000,
        21, 0x00061000,
        22, 0x00000000,
        23, 0x05040400,
        24, 0x131a0004,
        25, 0x10080404,
        26, 0x1a000405,
        27, 0x08040413,
        28, 0x04040410,
        29, 0x0091dc0c,
        30, 0x040c0303,
        31, 0x000c0404,
        32, 0x030091dc,
        33, 0x08000c03,
        34, 0x00080808,
        35, 0x010c0050,
        41, 0x00000000,
        43, 0x008b0100,
        44, 0x0000102c,
        45, 0x0000008b,
        46, 0x0000102c,
        47, 0x00000005,
        48, 0x00040004,
        49, 0x000d000d,
        50, 0x00000000,
        51, 0x00000000,
        52, 0x02000000,
        53, 0x02000090,
        54, 0x00000090,
        55, 0x06000001,
        56, 0x00060606,
        57, 0x00000000,
        58, 0x00000000,
        59, 0x00010000,
        60, 0x10040010,
        62, 0x00000200,
        63, 0x00000000,
        64, 0x00000001,
        65, 0x00000000,
        66, 0x00000000,
        67, 0x00000000,
        68, 0x00000000,
        69, 0x00000000,
        70, 0x00000000,
        71, 0x00000000,
        72, 0x00000000,
        73, 0x00000000,
        74, 0x00000000,
        75, 0x00000000,
        76, 0x00000000,
        77, 0x00000000,
        82, 0x00000000,
        85, 0x00000046,
        86, 0x00000008,
        89, 0x00000008,
        90, 0x00000000,
        91, 0x00000000,
        92, 0x00000000,
        93, 0x00000000,
        94, 0x00000000,
        95, 0x00000000,
        96, 0x00000000,
        97, 0x00000000,
        98, 0x00000840,
        99, 0x00000046,
        100, 0x00000008,
        101, 0x00000840,
        102, 0x00000046,
        103, 0x00000008,
        104, 0x00000000,
        105, 0x00000000,
        106, 0x00000000,
        107, 0x00000000,
        108, 0x00000000,
        109, 0x00000000,
        110, 0x00000000,
        111, 0x00000000,
        113, 0x00000000,
        114, 0x00000000,
        115, 0x00000000,
        118, 0x00000000,
        124, 0x00000000,
        125, 0x00000000,
        126, 0x00000000,
        127, 0x00000000,
        128, 0x00000000,
        129, 0x00000000,
        131, 0x00000000,
        132, 0x00000000,
        133, 0x00000000,
        134, 0x00000000,
        135, 0x00000000,
        136, 0x00000000,
        137, 0x00000000,
        138, 0x00000000,
        140, 0x01000000,
        141, 0x00000001,
        142, 0x00000000,
        143, 0x00000000,
        144, 0x00000000,
        145, 0x00000000,
        146, 0x00000000, // disable ECC
        147, 0x00000000,
        151, 0x00000000,
        154, 0x00000000,
        155, 0x00000000,
        159, 0x00400100,
        164, 0x0a020001,
        167, 0x01010101,
        169, 0x00000c03,
        172, 0x01000000,
        173, 0x00000100,
        174, 0x00000000,
        177, 0x00000000,
        178, 0x00000000,
        179, 0x00000000,
        183, 0x00000000,
        184, 0x00000000,
        186, 0x00000000,
        188, 0x00000000,
        189, 0x00000000,
        190, 0x00000000,
        191, 0x00000000,
        192, 0x00000000,
        193, 0x00000000,
        195, 0x00000000,
        196, 0x01010200,
        197, 0x00000002,
        198, 0x06050500,
        199, 0x00000106,
        200, 0x02020000,
        201, 0x02020002,
        202, 0x02020101,
        203, 0x02000102,
        204, 0x00000000,
        206, 0x00000000,
        207, 0x00000000,
        208, 0x00000000,
        209, 0x0000280d,
        210, 0x00010000,
        211, 0x00010000,
        212, 0x00000003,
        213, 0x00000000,
        214, 0x00000000,
        215, 0x00000000,
        216, 0x00000000,
        217, 0x00000000,
        218, 0x00000000,
        219, 0x00000000,
        220, 0x00000000,
        221, 0x01000000,
        222, 0x00000001,
        223, 0x00000100,
        224, 0x00030300,
        225, 0x0556AA00,
        226, 0x000aa955,
        227, 0x000aa955,
        228, 0x000556aa,
        229, 0x000556aa,
        230, 0x000aa955,
        231, 0x000aa955,
        232, 0x030556aa,
        233, 0x01000001,
        234, 0x00010300,
        235, 0x00676700,
        236, 0x00676700,
        237, 0x00676700,
        238, 0x00676700,
        239, 0x00676700,
        240, 0x00676700,
        241, 0x00676700,
        242, 0x00676700,
        243, 0x00676700,
        244, 0x00000000,
        245, 0x01000000,
        246, 0x00000001,
        247, 0x00000101,
        248, 0x00010100,
        249, 0x03000000,
        250, 0x03030303,
        251, 0x00030303,
        252, 0x02020064,
        253, 0x02020202,
        254, 0x00010202,
        255, 0x01010064,
        256, 0x01010101,
        257, 0x00020101,
        258, 0x00000064,
        259, 0x00000000,
        260, 0x000d0d00,
        261, 0x00000000,
        262, 0x00002058,
        263, 0x02000200,
        264, 0x02000200,
        265, 0x00002058,
        266, 0x0000a1b8,
        267, 0x00000607,
        268, 0x00002058,
        269, 0x02000200,
        270, 0x02000200,
        271, 0x00002058,
        272, 0x0000a1b8,
        273, 0x02020607,
        274, 0x000a0100,
        275, 0x0000000a,
        276, 0x00000000,
        277, 0x00000000,
        278, 0x00000f0a,
        279, 0x00000000,
        280, 0x00000000,
        281, 0x00000000,
        282, 0x00000000,
        283, 0x00000000,
        284, 0x00000103,
        285, 0x00010003,
        286, 0x00000003,
        287, 0x00000000,
        288, 0x00000000,
        289, 0x00000000,
        290, 0x07000000,
        291, 0x00050705,
        292, 0x00000000,
        293, 0x00000000,
        294, 0x00000000,
        295, 0x00000000,
        296, 0x00000000,
        297, 0x00000000,
        298, 0x00000000,
        299, 0x00000000,
        300, 0x00000000,
        301, 0x00000000,
        302, 0x00000000,
        303, 0x00000000,
        304, 0x00000000,
        305, 0x00000000,
        0xffffffff
};
#endif

#if IS_ENABLED(CONFIG_CYGNUS_DDR667)
const unsigned int ddr3_init_tab_1333[] = {
        14, 0x01000000,
        36, 0x0a140a0a,
        37, 0x0100000a,
        38, 0x14140101,
        39, 0x000a0a03,
        40, 0x00010100,
        42, 0x00000000,
        61, 0x00000400,
        78, 0x00000000,
        79, 0x00000000,
        80, 0x00000000,
        81, 0x00000000,
        83, 0x00000000,
        84, 0x00000a50,
        87, 0x00000a50,
        88, 0x00000046,
        112, 0x00000000,
        116, 0x00000000,
        117, 0x00000000,
        119, 0x00000000,
        120, 0x00000000,
        121, 0x00000000,
        122, 0x00000000,
        123, 0x00000000,
        130, 0x00000000,
        139, 0x00000000,
        148, 0x00000000,
        149, 0x00000000,
        150, 0x00000000,
        152, 0x00000000,
        153, 0x00000000,
        156, 0x00000000,
        157, 0x01000200,
        158, 0x02000040,
        160, 0x00000200,
        161, 0x00000040,
        162, 0x00000000,
        163, 0x01000000,
        165, 0x0101ffff,
        166, 0x01010101,
        168, 0x00000103,
        170, 0x00000001,
        171, 0x00000000,
        175, 0x00000000,
        176, 0x00000000,
        180, 0x00000000,
        181, 0x00000000,
        182, 0x00000000,
        185, 0x00000000,
        187, 0x00000000,
        194, 0x00000000,
        205, 0x00000000,
        0, 0x00000600,
        1, 0x00000000,
        2, 0x00000000,
        3, 0x00000000,
        4, 0x00000000,
        5, 0x00000000,
        6, 0x00000000,
        7, 0x00000700,
        8, 0x00000000,
        9, 0x00000000,
        10, 0x00000000,
        11, 0x00000007,
        12, 0x00000000,
        13, 0x00000000,
        15, 0x000208d6,
        16, 0x00051616,
        17, 0x00000000,
        18, 0x02000000,
        19, 0x00071200,
        20, 0x00000000,
        21, 0x00071200,
        22, 0x00000000,
        23, 0x05040400,
        24, 0x18210004,
        25, 0x140a0505,
        26, 0x21000405,
        27, 0x0a050518,
        28, 0x04050514,
        29, 0x00b6d00c,
        30, 0x050c0404,
        31, 0x000c0405,
        32, 0x0400b6d0,
        33, 0x0a000c04,
        34, 0x000a0a0a,
        35, 0x010c0064,
        41, 0x00000000,
        43, 0x00ae0100,
        44, 0x00001448,
        45, 0x000000ae,
        46, 0x00001448,
        47, 0x00000005,
        48, 0x00040004,
        49, 0x00100010,
        50, 0x00000000,
        51, 0x00000000,
        52, 0x02000000,
        53, 0x020000b4,
        54, 0x000000b4,
        55, 0x07000001,
        56, 0x00070707,
        57, 0x00000000,
        58, 0x00000000,
        59, 0x00010000,
        60, 0x10040010,
        62, 0x00000200,
        63, 0x00000000,
        64, 0x00000001,
        65, 0x00000000,
        66, 0x00000000,
        67, 0x00000000,
        68, 0x00000000,
        69, 0x00000000,
        70, 0x00000000,
        71, 0x00000000,
        72, 0x00000000,
        73, 0x00000000,
        74, 0x00000000,
        75, 0x00000000,
        76, 0x00000000,
        77, 0x00000000,
        82, 0x00000000,
        85, 0x00000046,
        86, 0x00000010,
        89, 0x00000010,
        90, 0x00000000,
        91, 0x00000000,
        92, 0x00000000,
        93, 0x00000000,
        94, 0x00000000,
        95, 0x00000000,
        96, 0x00000000,
        97, 0x00000000,
        98, 0x00000a50,
        99, 0x00000046,
        100, 0x00000010,
        101, 0x00000a50,
        102, 0x00000046,
        103, 0x00000010,
        104, 0x00000000,
        105, 0x00000000,
        106, 0x00000000,
        107, 0x00000000,
        108, 0x00000000,
        109, 0x00000000,
        110, 0x00000000,
        111, 0x00000000,
        113, 0x00000000,
        114, 0x00000000,
        115, 0x00000000,
        118, 0x00000000,
        124, 0x00000000,
        125, 0x00000000,
        126, 0x00000000,
        127, 0x00000000,
        128, 0x00000000,
        129, 0x00000000,
        131, 0x00000000,
        132, 0x00000000,
        133, 0x00000000,
        134, 0x00000000,
        135, 0x00000000,
        136, 0x00000000,
        137, 0x00000000,
        138, 0x00000000,
        140, 0x01000000,
        141, 0x00000001,
        142, 0x00000000,
        143, 0x00000000,
        144, 0x00000000,
        145, 0x00000000,
        146, 0x00000000, //disable ECC
        147, 0x00000000,
        151, 0x00000000,
        154, 0x00000000,
        155, 0x00000000,
        159, 0x00400100,
        164, 0x0a020001,
        167, 0x01010101,
        169, 0x00000c03,
        172, 0x01000000,
        173, 0x00000100,
        174, 0x00000000,
        177, 0x00000000,
        178, 0x00000000,
        179, 0x00000000,
        183, 0x00000000,
        184, 0x00000000,
        186, 0x00000000,
        188, 0x00000000,
        189, 0x00000000,
        190, 0x00000000,
        191, 0x00000000,
        192, 0x00000000,
        193, 0x00000000,
        195, 0x00000000,
        196, 0x01010200,
        197, 0x00000002,
        198, 0x06060600,
        199, 0x00000106,
        200, 0x02020000,
        201, 0x02020002,
        202, 0x02020101,
        203, 0x02000102,
        204, 0x00000000,
        206, 0x00000000,
        207, 0x00000000,
        208, 0x00000000,
        209, 0x0000280d,
        210, 0x00010000,
        211, 0x00010000,
        212, 0x00000003,
        213, 0x00000000,
        214, 0x00000000,
        215, 0x00000000,
        216, 0x00000000,
        217, 0x00000000,
        218, 0x00000000,
        219, 0x00000000,
        220, 0x00000000,
        221, 0x01000000,
        222, 0x00000001,
        223, 0x00000100,
        224, 0x00030300,
        225, 0x0556AA00,
        226, 0x000aa955,
        227, 0x000aa955,
        228, 0x000556aa,
        229, 0x000556aa,
        230, 0x000aa955,
        231, 0x000aa955,
        232, 0x030556aa,
        233, 0x01000001,
        234, 0x00010300,
        235, 0x00676700,
        236, 0x00676700,
        237, 0x00676700,
        238, 0x00676700,
        239, 0x00676700,
        240, 0x00676700,
        241, 0x00676700,
        242, 0x00676700,
        243, 0x00676700,
        244, 0x00000000,
        245, 0x01000000,
        246, 0x00000001,
        247, 0x00000101,
        248, 0x00010100,
        249, 0x03000000,
        250, 0x03030303,
        251, 0x00030303,
        252, 0x02020064,
        253, 0x02020202,
        254, 0x00010202,
        255, 0x01010064,
        256, 0x01010101,
        257, 0x00020101,
        258, 0x00000064,
        259, 0x00000000,
        260, 0x000e0e00,
        261, 0x00000000,
        262, 0x00002890,
        263, 0x02000200,
        264, 0x02000200,
        265, 0x00002890,
        266, 0x0000cad0,
        267, 0x00000708,
        268, 0x00002890,
        269, 0x02000200,
        270, 0x02000200,
        271, 0x00002890,
        272, 0x0000cad0,
        273, 0x02020708,
        274, 0x000a0100,
        275, 0x0000000a,
        276, 0x00000000,
        277, 0x00000000,
        278, 0x00000f0a,
        279, 0x00000000,
        280, 0x00000000,
        281, 0x00000000,
        282, 0x00000000,
        283, 0x00000000,
        284, 0x00000103,
        285, 0x00010003,
        286, 0x00000003,
        287, 0x00000000,
        288, 0x00000000,
        289, 0x00000000,
        290, 0x08000000,
        291, 0x00060806,
        292, 0x00000000,
        293, 0x00000000,
        294, 0x00000000,
        295, 0x00000000,
        296, 0x00000000,
        297, 0x00000000,
        298, 0x00000000,
        299, 0x00000000,
        300, 0x00000000,
        301, 0x00000000,
        302, 0x00000000,
        303, 0x00000000,
        304, 0x00000000,
        305, 0x00000000,
        0xffffffff
};
#endif

#if IS_ENABLED(CONFIG_CYGNUS_DDR800)
const unsigned int ddr3_init_tab_1600[] = {
        14, 0x01000000,
        36, 0x0a140a0a,
        37, 0x0100000a,
        38, 0x17170101,
        39, 0x000b0b03,
        40, 0x00010100,
        42, 0x00000000,
        61, 0x00000400,
        78, 0x00000000,
        79, 0x00000000,
        80, 0x00000000,
        81, 0x00000000,
        83, 0x00000000,
        84, 0x00000c70,
        87, 0x00000c70,
        88, 0x00000046,
        112, 0x00000000,
        116, 0x00000000,
        117, 0x00000000,
        119, 0x00000000,
        120, 0x00000000,
        121, 0x00000000,
        122, 0x00000000,
        123, 0x00000000,
        130, 0x00000000,
        139, 0x00000000,
        148, 0x00000000,
        149, 0x00000000,
        150, 0x00000000,
        152, 0x00000000,
        153, 0x00000000,
        156, 0x00000000,
        157, 0x01000200,
        158, 0x02000040,
        160, 0x00000200,
        161, 0x00000040,
        162, 0x00000000,
        163, 0x01000000,
        165, 0x0101ffff,
        166, 0x01010101,
        168, 0x00000103,
        170, 0x00000001,
        171, 0x00000000,
        175, 0x00000000,
        176, 0x00000000,
        180, 0x00000000,
        181, 0x00000000,
        182, 0x00000000,
        185, 0x00000000,
        187, 0x00000000,
        194, 0x00000000,
        205, 0x00000000,
        0, 0x00000600,
        1, 0x00000000,
        2, 0x00000000,
        3, 0x00000000,
        4, 0x00000000,
        5, 0x00000000,
        6, 0x00000000,
        7, 0x00000800,
        8, 0x00000000,
        9, 0x00000000,
        10, 0x00000000,
        11, 0x00000008,
        12, 0x00000000,
        13, 0x00000000,
        15, 0x00027100,
        16, 0x00061a80,
        17, 0x00000000,
        18, 0x02000000,
        19, 0x00081600,
        20, 0x00000000,
        21, 0x00081600,
        22, 0x00000000,
        23, 0x05040400,
        24, 0x1c270005,
        25, 0x180b0606,
        26, 0x27000505,
        27, 0x0b06061c,
        28, 0x04060618,
        29, 0x00db600c,
        30, 0x060c0404,
        31, 0x000c0406,
        32, 0x0400db60,
        33, 0x0b000c04,
        34, 0x000c0b0c,
        35, 0x010c0078,
        41, 0x00000000,
        43, 0x00d00100,
        44, 0x00001858,
        45, 0x000000d0,
        46, 0x00001858,
        47, 0x00000005,
        48, 0x00050005,
        49, 0x00140014,
        50, 0x00000000,
        51, 0x00000000,
        52, 0x02000000,
        53, 0x020000d8,
        54, 0x000000d8,
        55, 0x08000001,
        56, 0x00080808,
        57, 0x00000000,
        58, 0x00000000,
        59, 0x00010000,
        60, 0x10040010,
        62, 0x00000200,
        63, 0x00000000,
        64, 0x00000001,
        65, 0x00000000,
        66, 0x00000000,
        67, 0x00000000,
        68, 0x00000000,
        69, 0x00000000,
        70, 0x00000000,
        71, 0x00000000,
        72, 0x00000000,
        73, 0x00000000,
        74, 0x00000000,
        75, 0x00000000,
        76, 0x00000000,
        77, 0x00000000,
        82, 0x00000000,
        85, 0x00000046,
        86, 0x00000018,
        89, 0x00000018,
        90, 0x00000000,
        91, 0x00000000,
        92, 0x00000000,
        93, 0x00000000,
        94, 0x00000000,
        95, 0x00000000,
        96, 0x00000000,
        97, 0x00000000,
        98, 0x00000c70,
        99, 0x00000046,
        100, 0x00000018,
        101, 0x00000c70,
        102, 0x00000046,
        103, 0x00000018,
        104, 0x00000000,
        105, 0x00000000,
        106, 0x00000000,
        107, 0x00000000,
        108, 0x00000000,
        109, 0x00000000,
        110, 0x00000000,
        111, 0x00000000,
        113, 0x00000000,
        114, 0x00000000,
        115, 0x00000000,
        118, 0x00000000,
        124, 0x00000000,
        125, 0x00000000,
        126, 0x00000000,
        127, 0x00000000,
        128, 0x00000000,
        129, 0x00000000,
        131, 0x00000000,
        132, 0x00000000,
        133, 0x00000000,
        134, 0x00000000,
        135, 0x00000000,
        136, 0x00000000,
        137, 0x00000000,
        138, 0x00000000,
        140, 0x01000000,
        141, 0x00000001,
        142, 0x00000000,
        143, 0x00000000,
        144, 0x00000000,
        145, 0x00000000,
        146, 0x00000000, //disable ECC
        147, 0x00000000,
        151, 0x00000000,
        154, 0x00000000,
        155, 0x00000000,
        159, 0x00400100,
        164, 0x0a020001,
        167, 0x01010101,
        169, 0x00000c03,
        172, 0x01000000,
        173, 0x00000100,
        174, 0x00000000,
        177, 0x00000000,
        178, 0x00000000,
        179, 0x00000000,
        183, 0x00000000,
        184, 0x00000000,
        186, 0x00000000,
        188, 0x00000000,
        189, 0x00000000,
        190, 0x00000000,
        191, 0x00000000,
        192, 0x00000000,
        193, 0x00000000,
        195, 0x00000000,
        196, 0x01010200,
        197, 0x00000002,
        198, 0x06070700,
        199, 0x00000106,
        200, 0x03030000,
        201, 0x02020002,
        202, 0x02020101,
        203, 0x02000102,
        204, 0x00000000,
        206, 0x00000000,
        207, 0x00000000,
        208, 0x00000000,
        209, 0x0000280d,
        210, 0x00010000,
        211, 0x00010000,
        212, 0x00000003,
        213, 0x00000000,
        214, 0x00000000,
        215, 0x00000000,
        216, 0x00000000,
        217, 0x00000000,
        218, 0x00000000,
        219, 0x00000000,
        220, 0x00000000,
        221, 0x01000000,
        222, 0x00000001,
        223, 0x00000100,
        224, 0x00030300,
        225, 0x0556AA00,
        226, 0x000aa955,
        227, 0x000aa955,
        228, 0x000556aa,
        229, 0x000556aa,
        230, 0x000aa955,
        231, 0x000aa955,
        232, 0x030556aa,
        233, 0x01000001,
        234, 0x00010300,
        235, 0x00676700,
        236, 0x00676700,
        237, 0x00676700,
        238, 0x00676700,
        239, 0x00676700,
        240, 0x00676700,
        241, 0x00676700,
        242, 0x00676700,
        243, 0x00676700,
        244, 0x00000000,
        245, 0x01000000,
        246, 0x00000001,
        247, 0x00000101,
        248, 0x00010100,
        249, 0x03000000,
        250, 0x03030303,
        251, 0x00030303,
        252, 0x02020064,
        253, 0x02020202,
        254, 0x00010202,
        255, 0x01010064,
        256, 0x01010101,
        257, 0x00020101,
        258, 0x00000064,
        259, 0x00000000,
        260, 0x000e0e00,
        261, 0x00000000,
        262, 0x000030b0,
        263, 0x02000200,
        264, 0x02000200,
        265, 0x000030b0,
        266, 0x0000f370,
        267, 0x0000080a,
        268, 0x000030b0,
        269, 0x02000200,
        270, 0x02000200,
        271, 0x000030b0,
        272, 0x0000f370,
        273, 0x0202080a,
        274, 0x000a0100,
        275, 0x0000000a,
        276, 0x00000000,
        277, 0x00000000,
        278, 0x00000f0a,
        279, 0x00000000,
        280, 0x00000000,
        281, 0x00000000,
        282, 0x00000000,
        283, 0x00000000,
        284, 0x00000103,
        285, 0x00010003,
        286, 0x00000003,
        287, 0x00000000,
        288, 0x00000000,
        289, 0x00000000,
        290, 0x0a000000,
        291, 0x00070a07,
        292, 0x00000000,
        293, 0x00000000,
        294, 0x00000000,
        295, 0x00000000,
        296, 0x00000000,
        297, 0x00000000,
        298, 0x00000000,
        299, 0x00000000,
        300, 0x00000000,
        301, 0x00000000,
        302, 0x00000000,
        303, 0x00000000,
        304, 0x00000000,
        305, 0x00000000,
        0xffffffff
};
#endif

#ifdef DDR2_SUPPORT
const unsigned int ddr2_mode_reg_tab[] = {
		0x0320,
		0x0046,
		0x0000,
		0x0000
};
#endif
