/*
 * This file is part of the coreboot project.
 *
 * Copyright (C) 2016 Marvell, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#ifndef __SOC_MARVELL_MVMAP2315_GIC_H__
#define __SOC_MARVELL_MVMAP2315_GIC_H__

#include <stdint.h>

#include <soc/addressmap.h>
#include <types.h>

#define MVMAP2315_BCM_GICC_EN0			BIT(0)
#define MVMAP2315_BCM_GICD_FIQ_EN		BIT(3)
struct mvmap2315_bcm_gicc_regs {
	 u32 ctrl;
	 u32 pmr;
	 u32 bpr;
	 u32 iar;
	 u32 eoir;
	 u32 rpr;
	 u32 hppir;
	 u32 abpr;
	 u32 aiar;
	 u32 aeoir;
	 u32 ahppir;
};

check_member(mvmap2315_bcm_gicc_regs, ahppir, 0x28);
static struct mvmap2315_bcm_gicc_regs * const mvmap2315_bcm_gicc
					= (void *)MVMAP2315_BCM_GICC_BASE;

#define MVMAP2315_BCM_GICD_EN0			BIT(0)
struct mvmap2315_bcm_gicd_regs {
	 u32 ctrl;
	 u32 typer;
	 u32 iidr;
	 u8 _reserved0[0x74];
	 u32 igroup0;
	 u32 igroup1;
	 u32 igroup2;
	 u32 igroup3;
	 u32 igroup4;
	 u32 igroup5;
	 u32 igroup6;
	 u32 igroup7;
	 u32 igroup8;
	 u32 igroup9;
	 u32 igroup10;
	 u32 igroup11;
	 u8 _reserved1[0x50];
	 u32 isenable0;
	 u32 isenable1;
	 u32 isenable2;
	 u32 isenable3;
	 u32 isenable4;
	 u32 isenable5;
	 u32 isenable6;
	 u32 isenable7;
	 u32 isenable8;
	 u32 isenable9;
	 u32 isenable10;
	 u32 isenable11;
	 u8 _reserved2[0x50];
	 u32 icenable0;
	 u32 icenable1;
	 u32 icenable2;
	 u32 icenable3;
	 u32 icenable4;
	 u32 icenable5;
	 u32 icenable6;
	 u32 icenable7;
	 u32 icenable8;
	 u32 icenable9;
	 u32 icenable10;
	 u32 icenable11;
	 u8 _reserved3[0x50];
	 u32 ispendr0;
	 u32 ispendr1;
	 u32 ispendr2;
	 u32 ispendr3;
	 u32 ispendr4;
	 u32 ispendr5;
	 u32 ispendr6;
	 u32 ispendr7;
	 u32 ispendr8;
	 u32 ispendr9;
	 u32 ispendr10;
	 u32 ispendr11;
	 u8 _reserved4[0x50];
	 u32 icpendr0;
	 u32 icpendr1;
	 u32 icpendr2;
	 u32 icpendr3;
	 u32 icpendr4;
	 u32 icpendr5;
	 u32 icpendr6;
	 u32 icpendr7;
	 u32 icpendr8;
	 u32 icpendr9;
	 u32 icpendr10;
	 u32 icpendr11;
	 u8 _reserved5[0x50];
	 u32 isactive0;
	 u32 isactive1;
	 u32 isactive2;
	 u32 isactive3;
	 u32 isactive4;
	 u32 isactive5;
	 u32 isactive6;
	 u32 isactive7;
	 u32 isactive8;
	 u32 isactive9;
	 u32 isactive10;
	 u32 isactive11;
	 u8 _reserved6[0x50];
	 u32 icactive0;
	 u32 icactive1;
	 u32 icactive2;
	 u32 icactive3;
	 u32 icactive4;
	 u32 icactive5;
	 u32 icactive6;
	 u32 icactive7;
	 u32 icactive8;
	 u32 icactive9;
	 u32 icactive10;
	 u32 icactive11;
	 u8 _reserved7[0x50];
	 u32 ipriority0;
	 u32 ipriority1;
	 u32 ipriority2;
	 u32 ipriority3;
	 u32 ipriority4;
	 u32 ipriority5;
	 u32 ipriority6;
	 u32 ipriority7;
	 u32 ipriority8;
	 u32 ipriority9;
	 u32 ipriority10;
	 u32 ipriority11;
	 u32 ipriority12;
	 u32 ipriority13;
	 u32 ipriority14;
	 u32 ipriority15;
	 u32 ipriority16;
	 u32 ipriority17;
	 u32 ipriority18;
	 u32 ipriority19;
	 u32 ipriority20;
	 u32 ipriority21;
	 u32 ipriority22;
	 u32 ipriority23;
	 u32 ipriority24;
	 u32 ipriority25;
	 u32 ipriority26;
	 u32 ipriority27;
	 u32 ipriority28;
	 u32 ipriority29;
	 u32 ipriority30;
	 u32 ipriority31;
	 u32 ipriority32;
	 u32 ipriority33;
	 u32 ipriority34;
	 u32 ipriority35;
	 u32 ipriority36;
	 u32 ipriority37;
	 u32 ipriority38;
	 u32 ipriority39;
	 u32 ipriority40;
	 u32 ipriority41;
	 u32 ipriority42;
	 u32 ipriority43;
	 u32 ipriority44;
	 u32 ipriority45;
	 u32 ipriority46;
	 u32 ipriority47;
	 u32 ipriority48;
	 u32 ipriority49;
	 u32 ipriority50;
	 u32 ipriority51;
	 u32 ipriority52;
	 u32 ipriority53;
	 u32 ipriority54;
	 u32 ipriority55;
	 u32 ipriority56;
	 u32 ipriority57;
	 u32 ipriority58;
	 u32 ipriority59;
	 u32 ipriority60;
	 u32 ipriority61;
	 u32 ipriority62;
	 u32 ipriority63;
	 u32 ipriority64;
	 u32 ipriority65;
	 u32 ipriority66;
	 u32 ipriority67;
	 u32 ipriority68;
	 u32 ipriority69;
	 u32 ipriority70;
	 u32 ipriority71;
	 u32 ipriority72;
	 u32 ipriority73;
	 u32 ipriority74;
	 u32 ipriority75;
	 u32 ipriority76;
	 u32 ipriority77;
	 u32 ipriority78;
	 u32 ipriority79;
	 u32 ipriority80;
	 u32 ipriority81;
	 u32 ipriority82;
	 u32 ipriority83;
	 u32 ipriority84;
	 u32 ipriority85;
	 u32 ipriority86;
	 u32 ipriority87;
	 u32 ipriority88;
	 u32 ipriority89;
	 u32 ipriority90;
	 u32 ipriority91;
	 u32 ipriority92;
	 u32 ipriority93;
	 u32 ipriority94;
	 u32 ipriority95;
	 u8 _reserved8[0x280];
	 u32 itargets0;
	 u32 itargets1;
	 u32 itargets2;
	 u32 itargets3;
	 u32 itargets4;
	 u32 itargets5;
	 u32 itargets6;
	 u32 itargets7;
	 u32 itargets8;
	 u32 itargets9;
	 u32 itargets10;
	 u32 itargets11;
	 u32 itargets12;
	 u32 itargets13;
	 u32 itargets14;
	 u32 itargets15;
	 u32 itargets16;
	 u32 itargets17;
	 u32 itargets18;
	 u32 itargets19;
	 u32 itargets20;
	 u32 itargets21;
	 u32 itargets22;
	 u32 itargets23;
	 u32 itargets24;
	 u32 itargets25;
	 u32 itargets26;
	 u32 itargets27;
	 u32 itargets28;
	 u32 itargets29;
	 u32 itargets30;
	 u32 itargets31;
	 u32 itargets32;
	 u32 itargets33;
	 u32 itargets34;
	 u32 itargets35;
	 u32 itargets36;
	 u32 itargets37;
	 u32 itargets38;
	 u32 itargets39;
	 u32 itargets40;
	 u32 itargets41;
	 u32 itargets42;
	 u32 itargets43;
	 u32 itargets44;
	 u32 itargets45;
	 u32 itargets46;
	 u32 itargets47;
	 u32 itargets48;
	 u32 itargets49;
	 u32 itargets50;
	 u32 itargets51;
	 u32 itargets52;
	 u32 itargets53;
	 u32 itargets54;
	 u32 itargets55;
	 u32 itargets56;
	 u32 itargets57;
	 u32 itargets58;
	 u32 itargets59;
	 u32 itargets60;
	 u32 itargets61;
	 u32 itargets62;
	 u32 itargets63;
	 u32 itargets64;
	 u32 itargets65;
	 u32 itargets66;
	 u32 itargets67;
	 u32 itargets68;
	 u32 itargets69;
	 u32 itargets70;
	 u32 itargets71;
	 u32 itargets72;
	 u32 itargets73;
	 u32 itargets74;
	 u32 itargets75;
	 u32 itargets76;
	 u32 itargets77;
	 u32 itargets78;
	 u32 itargets79;
	 u32 itargets80;
	 u32 itargets81;
	 u32 itargets82;
	 u32 itargets83;
	 u32 itargets84;
	 u32 itargets85;
	 u32 itargets86;
	 u32 itargets87;
	 u32 itargets88;
	 u32 itargets89;
	 u32 itargets90;
	 u32 itargets91;
	 u32 itargets92;
	 u32 itargets93;
	 u32 itargets94;
	 u32 itargets95;
	 u8 _reserved9[0x280];
	 u32 icfg0;
	 u32 icfg1;
	 u32 icfg2;
	 u32 icfg3;
	 u32 icfg4;
	 u32 icfg5;
	 u32 icfg6;
	 u32 icfg7;
	 u32 icfg8;
	 u32 icfg9;
	 u32 icfg10;
	 u32 icfg11;
	 u32 icfg12;
	 u32 icfg13;
	 u32 icfg14;
	 u32 icfg15;
	 u32 icfg16;
	 u32 icfg17;
	 u32 icfg18;
	 u32 icfg19;
	 u32 icfg20;
	 u32 icfg21;
	 u32 icfg22;
	 u32 icfg23;
	 u8 _reserved10[0xa0];
	 u32 ppisr;
	 u32 spisr0;
	 u32 spisr1;
	 u32 spisr2;
	 u32 spisr3;
	 u32 spisr4;
	 u32 spisr5;
	 u32 spisr6;
	 u32 spisr7;
	 u32 spisr8;
	 u32 spisr9;
	 u32 spisr10;
	 u8 _reserved11[0xd0];
	 u32 nsacr0;
	 u32 nsacr1;
	 u32 nsacr2;
	 u32 nsacr3;
	 u32 nsacr4;
	 u32 nsacr5;
	 u32 nsacr6;
	 u32 nsacr7;
	 u32 nsacr8;
	 u32 nsacr9;
	 u32 nsacr10;
	 u32 nsacr11;
	 u32 nsacr12;
	 u32 nsacr13;
	 u32 nsacr14;
	 u32 nsacr15;
	 u32 nsacr16;
	 u32 nsacr17;
	 u32 nsacr18;
	 u32 nsacr19;
	 u32 nsacr20;
	 u32 nsacr21;
	 u8 _reserved12[0xa8];
	 u32 sgir;
	 u8 _reserved13[0x0c];
	 u32 cpendsgir0;
	 u32 cpendsgir1;
	 u32 cpendsgir2;
	 u32 cpendsgir3;
	 u32 spendsgir0;
	 u32 spendsgir1;
	 u32 spendsgir2;
	 u32 spendsgir3;
};

check_member(mvmap2315_bcm_gicd_regs, spendsgir3, 0xF2C);
static struct mvmap2315_bcm_gicd_regs * const mvmap2315_bcm_gicd
					= (void *)MVMAP2315_BCM_GICD_BASE;

void enable_bcm_gic(void);

#endif /* __SOC_MARVELL_MVMAP2315_GIC_H__ */
