/*
 * This file is part of the coreboot project.
 *
 * Copyright (C) 2016 Marvell, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>

#include <arch/io.h>
#include <console/console.h>
#include <soc/sdram.h>

void sdram_init(struct mvmap2315_sdram_params *sdram_params)
{
	printk(BIOS_DEBUG, "Entering %s\n", __func__);

	write32(&mvmap2315_dphy0->dphy_dll_ctrl_0,
		sdram_params->dphy_params[0]);
	write32(&mvmap2315_dphy0->dphy_dll_ctrl0,
		sdram_params->dphy_params[1]);
	write32(&mvmap2315_dphy0->dphy_dll_ctrl0,
		sdram_params->dphy_params[2]);
	write32(&mvmap2315_dphy1->dphy_dll_ctrl_0,
		sdram_params->dphy_params[3]);
	write32(&mvmap2315_dphy1->dphy_dll_ctrl0,
		sdram_params->dphy_params[4]);
	write32(&mvmap2315_dphy1->dphy_dll_ctrl0,
		sdram_params->dphy_params[5]);
	write32(&mvmap2315_dphy2->dphy_dll_ctrl_0,
		sdram_params->dphy_params[6]);
	write32(&mvmap2315_dphy2->dphy_dll_ctrl0,
		sdram_params->dphy_params[7]);
	write32(&mvmap2315_dphy2->dphy_dll_ctrl0,
		sdram_params->dphy_params[8]);
	write32(&mvmap2315_dphy3->dphy_dll_ctrl_0,
		sdram_params->dphy_params[9]);
	write32(&mvmap2315_dphy3->dphy_dll_ctrl0,
		sdram_params->dphy_params[10]);
	write32(&mvmap2315_dphy3->dphy_dll_ctrl0,
		sdram_params->dphy_params[11]);
	write32(&mvmap2315_dphy0->dphy_dll_ctrl0,
		sdram_params->dphy_params[12]);
	write32(&mvmap2315_dphy0->dphy_dll_ctrl0,
		sdram_params->dphy_params[13]);
	write32(&mvmap2315_dphy0->dphy_dfi_ctrl2,
		sdram_params->dphy_params[14]);
	write32(&mvmap2315_dphy1->dphy_dll_ctrl0,
		sdram_params->dphy_params[15]);
	write32(&mvmap2315_dphy1->dphy_dll_ctrl0,
		sdram_params->dphy_params[16]);
	write32(&mvmap2315_dphy1->dphy_dfi_ctrl2,
		sdram_params->dphy_params[17]);
	write32(&mvmap2315_dphy2->dphy_dll_ctrl0,
		sdram_params->dphy_params[18]);
	write32(&mvmap2315_dphy2->dphy_dll_ctrl0,
		sdram_params->dphy_params[19]);
	write32(&mvmap2315_dphy2->dphy_dfi_ctrl2,
		sdram_params->dphy_params[20]);
	write32(&mvmap2315_dphy3->dphy_dll_ctrl0,
		sdram_params->dphy_params[21]);
	write32(&mvmap2315_dphy3->dphy_dll_ctrl0,
		sdram_params->dphy_params[22]);
	write32(&mvmap2315_dphy3->dphy_dfi_ctrl2,
		sdram_params->dphy_params[23]);
	write32(&mvmap2315_dphy0->dphy_dfi_ctrl4,
		sdram_params->dphy_params[24]);
	write32(&mvmap2315_dphy0->dphy_dfi_ctrl4,
		sdram_params->dphy_params[25]);
	write32(&mvmap2315_dphy0->dphy_dfi_ctrl4,
		sdram_params->dphy_params[26]);
	write32(&mvmap2315_dphy0->dphy_dfi_ctrl4,
		sdram_params->dphy_params[27]);
	write32(&mvmap2315_dphy1->dphy_dfi_ctrl4,
		sdram_params->dphy_params[28]);
	write32(&mvmap2315_dphy1->dphy_dfi_ctrl4,
		sdram_params->dphy_params[29]);
	write32(&mvmap2315_dphy1->dphy_dfi_ctrl4,
		sdram_params->dphy_params[30]);
	write32(&mvmap2315_dphy1->dphy_dfi_ctrl4,
		sdram_params->dphy_params[31]);
	write32(&mvmap2315_dphy2->dphy_dfi_ctrl4,
		sdram_params->dphy_params[32]);
	write32(&mvmap2315_dphy2->dphy_dfi_ctrl4,
		sdram_params->dphy_params[33]);
	write32(&mvmap2315_dphy2->dphy_dfi_ctrl4,
		sdram_params->dphy_params[34]);
	write32(&mvmap2315_dphy2->dphy_dfi_ctrl4,
		sdram_params->dphy_params[35]);
	write32(&mvmap2315_dphy3->dphy_dfi_ctrl4,
		sdram_params->dphy_params[36]);
	write32(&mvmap2315_dphy3->dphy_dfi_ctrl4,
		sdram_params->dphy_params[37]);
	write32(&mvmap2315_dphy3->dphy_dfi_ctrl4,
		sdram_params->dphy_params[38]);
	write32(&mvmap2315_dphy3->dphy_dfi_ctrl4,
		sdram_params->dphy_params[39]);
	write32(&mvmap2315_mc->ch0_mc_config_cs0,
		sdram_params->mc_params[0]);
	write32(&mvmap2315_mc->ch1_mc_config_cs0,
		sdram_params->mc_params[1]);
	write32(&mvmap2315_mc->ch2_mc_config_cs0,
		sdram_params->mc_params[2]);
	write32(&mvmap2315_mc->ch3_mc_config_cs0,
		sdram_params->mc_params[3]);
	write32(&mvmap2315_mc->ch0_mc_config_cs1,
		sdram_params->mc_params[4]);
	write32(&mvmap2315_mc->ch1_mc_config_cs1,
		sdram_params->mc_params[5]);
	write32(&mvmap2315_mc->ch2_mc_config_cs1,
		sdram_params->mc_params[6]);
	write32(&mvmap2315_mc->ch3_mc_config_cs1,
		sdram_params->mc_params[7]);
	write32(&mvmap2315_mc->ch0_dram_config_4,
		sdram_params->mc_params[8]);
	write32(&mvmap2315_mc->ch1_dram_config_4,
		sdram_params->mc_params[9]);
	write32(&mvmap2315_mc->ch2_dram_config_4,
		sdram_params->mc_params[10]);
	write32(&mvmap2315_mc->ch3_dram_config_4,
		sdram_params->mc_params[11]);
	write32(&mvmap2315_mc->ch0_dram_config_5_cs0,
		sdram_params->mc_params[12]);
	write32(&mvmap2315_mc->ch1_dram_config_5_cs0,
		sdram_params->mc_params[13]);
	write32(&mvmap2315_mc->ch2_dram_config_5_cs0,
		sdram_params->mc_params[14]);
	write32(&mvmap2315_mc->ch3_dram_config_5_cs0,
		sdram_params->mc_params[15]);
	write32(&mvmap2315_mc->ch0_dram_config_5_cs1,
		sdram_params->mc_params[16]);
	write32(&mvmap2315_mc->ch1_dram_config_5_cs1,
		sdram_params->mc_params[17]);
	write32(&mvmap2315_mc->ch2_dram_config_5_cs1,
		sdram_params->mc_params[18]);
	write32(&mvmap2315_mc->ch3_dram_config_5_cs1,
		sdram_params->mc_params[19]);
	write32(&mvmap2315_mc->mmap0_high_ch0,
		sdram_params->mc_params[20]);
	write32(&mvmap2315_mc->mmap0_low_ch0,
		sdram_params->mc_params[21]);
	write32(&mvmap2315_mc->mmap0_high_ch1,
		sdram_params->mc_params[22]);
	write32(&mvmap2315_mc->mmap0_low_ch1,
		sdram_params->mc_params[23]);
	write32(&mvmap2315_mc->mmap0_high_ch2,
		sdram_params->mc_params[24]);
	write32(&mvmap2315_mc->mmap0_low_ch2,
		sdram_params->mc_params[25]);
	write32(&mvmap2315_mc->mmap0_high_ch3,
		sdram_params->mc_params[26]);
	write32(&mvmap2315_mc->mmap0_low_ch3,
		sdram_params->mc_params[27]);
	write32(&mvmap2315_mc->mmap1_high_ch0,
		sdram_params->mc_params[28]);
	write32(&mvmap2315_mc->mmap1_low_ch0,
		sdram_params->mc_params[29]);
	write32(&mvmap2315_mc->mmap1_high_ch1,
		sdram_params->mc_params[30]);
	write32(&mvmap2315_mc->mmap1_low_ch1,
		sdram_params->mc_params[31]);
	write32(&mvmap2315_mc->mmap1_high_ch2,
		sdram_params->mc_params[32]);
	write32(&mvmap2315_mc->mmap1_low_ch2,
		sdram_params->mc_params[33]);
	write32(&mvmap2315_mc->mmap1_high_ch3,
		sdram_params->mc_params[34]);
	write32(&mvmap2315_mc->mmap1_low_ch3,
		sdram_params->mc_params[35]);
	write32(&mvmap2315_mc->ch0_precharge_timing,
		sdram_params->mc_params[36]);
	write32(&mvmap2315_mc->ch1_precharge_timing,
		sdram_params->mc_params[37]);
	write32(&mvmap2315_mc->ch2_precharge_timing,
		sdram_params->mc_params[38]);
	write32(&mvmap2315_mc->ch3_precharge_timing,
		sdram_params->mc_params[39]);
	write32(&mvmap2315_mc->ch0_act_timing,
		sdram_params->mc_params[40]);
	write32(&mvmap2315_mc->ch1_act_timing,
		sdram_params->mc_params[41]);
	write32(&mvmap2315_mc->ch2_act_timing,
		sdram_params->mc_params[42]);
	write32(&mvmap2315_mc->ch3_act_timing,
		sdram_params->mc_params[43]);
	write32(&mvmap2315_mc->ch0_cas_ras_timing_0,
		sdram_params->mc_params[44]);
	write32(&mvmap2315_mc->ch1_cas_ras_timing_0,
		sdram_params->mc_params[45]);
	write32(&mvmap2315_mc->ch2_cas_ras_timing_0,
		sdram_params->mc_params[46]);
	write32(&mvmap2315_mc->ch3_cas_ras_timing_0,
		sdram_params->mc_params[47]);
	write32(&mvmap2315_mc->ch0_cas_ras_timing_1,
		sdram_params->mc_params[48]);
	write32(&mvmap2315_mc->ch1_cas_ras_timing_1,
		sdram_params->mc_params[49]);
	write32(&mvmap2315_mc->ch2_cas_ras_timing_1,
		sdram_params->mc_params[50]);
	write32(&mvmap2315_mc->ch3_cas_ras_timing_1,
		sdram_params->mc_params[51]);
	write32(&mvmap2315_mc->ch0_mrs_timing,
		sdram_params->mc_params[52]);
	write32(&mvmap2315_mc->ch1_mrs_timing,
		sdram_params->mc_params[53]);
	write32(&mvmap2315_mc->ch2_mrs_timing,
		sdram_params->mc_params[54]);
	write32(&mvmap2315_mc->ch3_mrs_timing,
		sdram_params->mc_params[55]);
	write32(&mvmap2315_mc->ch0_ddr_init_timing_control_0,
		sdram_params->mc_params[56]);
	write32(&mvmap2315_mc->ch0_ddr_init_timing_control_1,
		sdram_params->mc_params[57]);
	write32(&mvmap2315_mc->ch0_ddr_init_timing_control_2,
		sdram_params->mc_params[58]);
	write32(&mvmap2315_mc->ch1_ddr_init_timing_control_0,
		sdram_params->mc_params[59]);
	write32(&mvmap2315_mc->ch1_ddr_init_timing_control_1,
		sdram_params->mc_params[60]);
	write32(&mvmap2315_mc->ch1_ddr_init_timing_control_2,
		sdram_params->mc_params[61]);
	write32(&mvmap2315_mc->ch2_ddr_init_timing_control_0,
		sdram_params->mc_params[62]);
	write32(&mvmap2315_mc->ch2_ddr_init_timing_control_1,
		sdram_params->mc_params[63]);
	write32(&mvmap2315_mc->ch2_ddr_init_timing_control_2,
		sdram_params->mc_params[64]);
	write32(&mvmap2315_mc->ch3_ddr_init_timing_control_0,
		sdram_params->mc_params[65]);
	write32(&mvmap2315_mc->ch3_ddr_init_timing_control_1,
		sdram_params->mc_params[66]);
	write32(&mvmap2315_mc->ch3_ddr_init_timing_control_2,
		sdram_params->mc_params[67]);
	write32(&mvmap2315_mc->ch0_off_spec_timing_0,
		sdram_params->mc_params[68]);
	write32(&mvmap2315_mc->ch1_off_spec_timing_0,
		sdram_params->mc_params[69]);
	write32(&mvmap2315_mc->ch2_off_spec_timing_0,
		sdram_params->mc_params[70]);
	write32(&mvmap2315_mc->ch3_off_spec_timing_0,
		sdram_params->mc_params[71]);
	write32(&mvmap2315_mc->ch0_off_spec_timing_1,
		sdram_params->mc_params[72]);
	write32(&mvmap2315_mc->ch1_off_spec_timing_1,
		sdram_params->mc_params[73]);
	write32(&mvmap2315_mc->ch2_off_spec_timing_1,
		sdram_params->mc_params[74]);
	write32(&mvmap2315_mc->ch3_off_spec_timing_1,
		sdram_params->mc_params[75]);
	write32(&mvmap2315_mc->ch0_dram_read_timing,
		sdram_params->mc_params[76]);
	write32(&mvmap2315_mc->ch1_dram_read_timing,
		sdram_params->mc_params[77]);
	write32(&mvmap2315_mc->ch2_dram_read_timing,
		sdram_params->mc_params[78]);
	write32(&mvmap2315_mc->ch3_dram_read_timing,
		sdram_params->mc_params[79]);
	write32(&mvmap2315_mc->ch0_refresh_timing,
		sdram_params->mc_params[80]);
	write32(&mvmap2315_mc->ch1_refresh_timing,
		sdram_params->mc_params[81]);
	write32(&mvmap2315_mc->ch2_refresh_timing,
		sdram_params->mc_params[82]);
	write32(&mvmap2315_mc->ch3_refresh_timing,
		sdram_params->mc_params[83]);
	write32(&mvmap2315_mc->ch0_selfrefresh_timing_0,
		sdram_params->mc_params[84]);
	write32(&mvmap2315_mc->ch1_selfrefresh_timing_0,
		sdram_params->mc_params[85]);
	write32(&mvmap2315_mc->ch2_selfrefresh_timing_0,
		sdram_params->mc_params[86]);
	write32(&mvmap2315_mc->ch3_selfrefresh_timing_0,
		sdram_params->mc_params[87]);
	write32(&mvmap2315_mc->ch0_powerdown_timing_0,
		sdram_params->mc_params[88]);
	write32(&mvmap2315_mc->ch1_powerdown_timing_0,
		sdram_params->mc_params[89]);
	write32(&mvmap2315_mc->ch2_powerdown_timing_0,
		sdram_params->mc_params[90]);
	write32(&mvmap2315_mc->ch3_powerdown_timing_0,
		sdram_params->mc_params[91]);
	write32(&mvmap2315_mc->ch0_odt_control_1,
		sdram_params->mc_params[92]);
	write32(&mvmap2315_mc->ch1_odt_control_1,
		sdram_params->mc_params[93]);
	write32(&mvmap2315_mc->ch2_odt_control_1,
		sdram_params->mc_params[94]);
	write32(&mvmap2315_mc->ch3_odt_control_1,
		sdram_params->mc_params[95]);
	write32(&mvmap2315_mc->ch0_odt_control_2,
		sdram_params->mc_params[96]);
	write32(&mvmap2315_mc->ch1_odt_control_2,
		sdram_params->mc_params[97]);
	write32(&mvmap2315_mc->ch2_odt_control_2,
		sdram_params->mc_params[98]);
	write32(&mvmap2315_mc->ch3_odt_control_2,
		sdram_params->mc_params[99]);
	write32(&mvmap2315_mc->ch0_dram_config_1,
		sdram_params->mc_params[100]);
	write32(&mvmap2315_mc->ch1_dram_config_1,
		sdram_params->mc_params[101]);
	write32(&mvmap2315_mc->ch2_dram_config_1,
		sdram_params->mc_params[102]);
	write32(&mvmap2315_mc->ch3_dram_config_1,
		sdram_params->mc_params[103]);
	write32(&mvmap2315_mc->mc_control_0,
		sdram_params->mc_params[104]);
	write32(&mvmap2315_mc->ch0_mc_control_2,
		sdram_params->mc_params[105]);
	write32(&mvmap2315_mc->ch1_mc_control_2,
		sdram_params->mc_params[106]);
	write32(&mvmap2315_mc->ch2_mc_control_2,
		sdram_params->mc_params[107]);
	write32(&mvmap2315_mc->ch3_mc_control_2,
		sdram_params->mc_params[108]);
	write32(&mvmap2315_mc->ch0_dram_config_2,
		sdram_params->mc_params[109]);
	write32(&mvmap2315_mc->ch1_dram_config_2,
		sdram_params->mc_params[110]);
	write32(&mvmap2315_mc->ch2_dram_config_2,
		sdram_params->mc_params[111]);
	write32(&mvmap2315_mc->ch3_dram_config_2,
		sdram_params->mc_params[112]);
	write32(&mvmap2315_dphy0->dphy_dfi_ctrl0,
		sdram_params->dphy_params[40]);
	write32(&mvmap2315_dphy0->dphy_dfi_ctrl0,
		sdram_params->dphy_params[41]);
	write32(&mvmap2315_dphy0->dphy_dq_pad_ctrl0,
		sdram_params->dphy_params[42]);
	write32(&mvmap2315_dphy0->dphy_dq_pad_ctrl0,
		sdram_params->dphy_params[43]);
	write32(&mvmap2315_dphy0->dphy_dq_pad_ctrl2,
		sdram_params->dphy_params[44]);
	write32(&mvmap2315_dphy0->dphy_dq_pad_ctrl2,
		sdram_params->dphy_params[45]);
	write32(&mvmap2315_dphy0->dphy_adcm_pad_ctrl2,
		sdram_params->dphy_params[46]);
	write32(&mvmap2315_dphy0->dphy_adcm_pad_ctrl2,
		sdram_params->dphy_params[47]);
	write32(&mvmap2315_dphy1->dphy_dfi_ctrl0,
		sdram_params->dphy_params[48]);
	write32(&mvmap2315_dphy1->dphy_dfi_ctrl0,
		sdram_params->dphy_params[49]);
	write32(&mvmap2315_dphy1->dphy_dq_pad_ctrl0,
		sdram_params->dphy_params[50]);
	write32(&mvmap2315_dphy1->dphy_dq_pad_ctrl0,
		sdram_params->dphy_params[51]);
	write32(&mvmap2315_dphy1->dphy_dq_pad_ctrl2,
		sdram_params->dphy_params[52]);
	write32(&mvmap2315_dphy1->dphy_dq_pad_ctrl2,
		sdram_params->dphy_params[53]);
	write32(&mvmap2315_dphy1->dphy_adcm_pad_ctrl2,
		sdram_params->dphy_params[54]);
	write32(&mvmap2315_dphy1->dphy_adcm_pad_ctrl2,
		sdram_params->dphy_params[55]);
	write32(&mvmap2315_dphy2->dphy_dfi_ctrl0,
		sdram_params->dphy_params[56]);
	write32(&mvmap2315_dphy2->dphy_dfi_ctrl0,
		sdram_params->dphy_params[57]);
	write32(&mvmap2315_dphy2->dphy_dq_pad_ctrl0,
		sdram_params->dphy_params[58]);
	write32(&mvmap2315_dphy2->dphy_dq_pad_ctrl0,
		sdram_params->dphy_params[59]);
	write32(&mvmap2315_dphy2->dphy_dq_pad_ctrl2,
		sdram_params->dphy_params[60]);
	write32(&mvmap2315_dphy2->dphy_dq_pad_ctrl2,
		sdram_params->dphy_params[61]);
	write32(&mvmap2315_dphy2->dphy_adcm_pad_ctrl2,
		sdram_params->dphy_params[62]);
	write32(&mvmap2315_dphy2->dphy_adcm_pad_ctrl2,
		sdram_params->dphy_params[63]);
	write32(&mvmap2315_dphy3->dphy_dfi_ctrl0,
		sdram_params->dphy_params[64]);
	write32(&mvmap2315_dphy3->dphy_dfi_ctrl0,
		sdram_params->dphy_params[65]);
	write32(&mvmap2315_dphy3->dphy_dq_pad_ctrl0,
		sdram_params->dphy_params[66]);
	write32(&mvmap2315_dphy3->dphy_dq_pad_ctrl0,
		sdram_params->dphy_params[67]);
	write32(&mvmap2315_dphy3->dphy_dq_pad_ctrl2,
		sdram_params->dphy_params[68]);
	write32(&mvmap2315_dphy3->dphy_dq_pad_ctrl2,
		sdram_params->dphy_params[69]);
	write32(&mvmap2315_dphy3->dphy_adcm_pad_ctrl2,
		sdram_params->dphy_params[70]);
	write32(&mvmap2315_dphy3->dphy_adcm_pad_ctrl2,
		sdram_params->dphy_params[71]);
	write32(&mvmap2315_mc->ch0_dfi_phy_control_1,
		sdram_params->mc_params[113]);
	write32(&mvmap2315_mc->ch1_dfi_phy_control_1,
		sdram_params->mc_params[114]);
	write32(&mvmap2315_mc->ch2_dfi_phy_control_1,
		sdram_params->mc_params[115]);
	write32(&mvmap2315_mc->ch3_dfi_phy_control_1,
		sdram_params->mc_params[116]);
	write32(&mvmap2315_dphy0->dphy_vref_ctrl0,
		sdram_params->dphy_params[72]);
	write32(&mvmap2315_dphy0->dphy_vref_ctrl0,
		sdram_params->dphy_params[73]);
	write32(&mvmap2315_dphy1->dphy_vref_ctrl0,
		sdram_params->dphy_params[74]);
	write32(&mvmap2315_dphy1->dphy_vref_ctrl0,
		sdram_params->dphy_params[75]);
	write32(&mvmap2315_dphy2->dphy_vref_ctrl0,
		sdram_params->dphy_params[76]);
	write32(&mvmap2315_dphy2->dphy_vref_ctrl0,
		sdram_params->dphy_params[77]);
	write32(&mvmap2315_dphy3->dphy_vref_ctrl0,
		sdram_params->dphy_params[78]);
	write32(&mvmap2315_dphy3->dphy_vref_ctrl0,
		sdram_params->dphy_params[79]);
	write32(&mvmap2315_mc->mc_pwr_ctl,
		sdram_params->mc_params[117]);
	write32(&mvmap2315_mc->user_command_0,
		sdram_params->mc_params[118]);

	while ((read32(&mvmap2315_mc->dram_status) & MVMAP2315_MC_DRAM_READY)
	       != MVMAP2315_MC_DRAM_READY)
		;

	write32(&mvmap2315_dphy0->dphy_qsg_ctrl0,
		sdram_params->dphy_params[80]);
	write32(&mvmap2315_dphy0->dphy_dq_pad_ctrl0,
		sdram_params->dphy_params[81]);
	write32(&mvmap2315_dphy0->dphy_qsg_ctrl0,
		sdram_params->dphy_params[82]);
	write32(&mvmap2315_dphy0->dphy_qsg_ctrl0,
		sdram_params->dphy_params[83]);
	write32(&mvmap2315_dphy0->dphy_qsg_ctrl0,
		sdram_params->dphy_params[84]);
	write32(&mvmap2315_dphy1->dphy_qsg_ctrl0,
		sdram_params->dphy_params[85]);
	write32(&mvmap2315_dphy1->dphy_dq_pad_ctrl0,
		sdram_params->dphy_params[86]);
	write32(&mvmap2315_dphy1->dphy_qsg_ctrl0,
		sdram_params->dphy_params[87]);
	write32(&mvmap2315_dphy1->dphy_qsg_ctrl0,
		sdram_params->dphy_params[88]);
	write32(&mvmap2315_dphy1->dphy_qsg_ctrl0,
		sdram_params->dphy_params[89]);
	write32(&mvmap2315_dphy2->dphy_qsg_ctrl0,
		sdram_params->dphy_params[90]);
	write32(&mvmap2315_dphy2->dphy_dq_pad_ctrl0,
		sdram_params->dphy_params[91]);
	write32(&mvmap2315_dphy2->dphy_qsg_ctrl0,
		sdram_params->dphy_params[92]);
	write32(&mvmap2315_dphy2->dphy_qsg_ctrl0,
		sdram_params->dphy_params[93]);
	write32(&mvmap2315_dphy2->dphy_qsg_ctrl0,
		sdram_params->dphy_params[94]);
	write32(&mvmap2315_dphy3->dphy_qsg_ctrl0,
		sdram_params->dphy_params[95]);
	write32(&mvmap2315_dphy3->dphy_dq_pad_ctrl0,
		sdram_params->dphy_params[96]);
	write32(&mvmap2315_dphy3->dphy_qsg_ctrl0,
		sdram_params->dphy_params[97]);
	write32(&mvmap2315_dphy3->dphy_qsg_ctrl0,
		sdram_params->dphy_params[98]);
	write32(&mvmap2315_dphy3->dphy_qsg_ctrl0,
		sdram_params->dphy_params[99]);
	write32(&mvmap2315_mc->user_command_1,
		sdram_params->mc_params[119]);
	write32(&mvmap2315_mc->user_command_1,
		sdram_params->mc_params[120]);
	write32(&mvmap2315_mc->user_command_1,
		sdram_params->mc_params[121]);

	printk(BIOS_DEBUG, "Exiting %s\n", __func__);
}

size_t sdram_size_mb(void)
{
	return CONFIG_DRAM_SIZE_MB;
}
