/*
 * This file is part of the coreboot project.
 *
 * Copyright (C) 2005 Tyan Computer
 * (Written by Yinghai Lu <yinghailu@gmail.com> for Tyan Computer)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <console/console.h>
#include <device/device.h>
#include <device/pci.h>
#include <device/pci_ids.h>

static void pci_init(struct device *dev)
{
	u16 reg16;

	/* Clear possible errors. */
	reg16 = pci_read_config16(dev, PCI_STATUS);
	reg16 |= 0xf900;
	pci_write_config16(dev, PCI_STATUS, reg16);
}

static struct device_operations pci_ops = {
	.read_resources		= pci_bus_read_resources,
	.set_resources		= pci_dev_set_resources,
	.enable_resources	= pci_bus_enable_resources,
	.init			= pci_init,
	.scan_bus		= pci_scan_bridge,
};

/* 82801AA (ICH) */
static const struct pci_driver i82801aa_pci __pci_driver = {
	.ops	= &pci_ops,
	.vendor	= PCI_VENDOR_ID_INTEL,
	.device	= 0x2418,
};

/* 82801AB (ICH0) */
static const struct pci_driver i82801ab_pci __pci_driver = {
	.ops	= &pci_ops,
	.vendor	= PCI_VENDOR_ID_INTEL,
	.device	= 0x2428,
};
