/* $NoKeywords:$ */
/**
 * @file
 *
 * AMD F15Or Microcode patch.
 *
 * F15Or Microcode Patch rev 06000624 for 6012 or equivalent.
 *
 * @xrefitem bom "File Content Label" "Release Content"
 * @e project:      AGESA
 * @e sub-project:  CPU/Family/0x15/OR
 * @e \$Revision: 60770 $   @e \$Date: 2011-10-21 15:51:10 -0600 (Fri, 21 Oct 2011) $
 */
/*****************************************************************************
 *
 * Copyright (c) 2008 - 2012, Advanced Micro Devices, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Advanced Micro Devices, Inc. nor the names of
 *       its contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL ADVANCED MICRO DEVICES, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ***************************************************************************/



/*----------------------------------------------------------------------------------------
 *                             M O D U L E S    U S E D
 *----------------------------------------------------------------------------------------
 */
#include "AGESA.h"
#include "Ids.h"
#include "cpuRegisters.h"
#include "cpuEarlyInit.h"
CODE_GROUP (G3_DXE)
RDATA_GROUP (G3_DXE)

/*----------------------------------------------------------------------------------------
 *                   D E F I N I T I O N S    A N D    M A C R O S
 *----------------------------------------------------------------------------------------
 */

/*----------------------------------------------------------------------------------------
 *                  T Y P E D E F S     A N D     S T R U C T U R E S
 *----------------------------------------------------------------------------------------
 */


// Encrypt Patch code 06000624 for 6012 and equivalent

CONST UINT8 ROMDATA CpuF15OrMicrocodePatch06000624_Enc [IDS_PAD_4K] =
{
  0x11,
  0x20,
  0x21,
  0x10,
  0x24,
  0x06,
  0x00,
  0x06,
  0x02,
  0x80,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x12,
  0x60,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x53,
  0x66,
  0x89,
  0xc4,
  0x38,
  0x90,
  0x15,
  0xbf,
  0xec,
  0xee,
  0x70,
  0xc6,
  0xdb,
  0x18,
  0x66,
  0x84,
  0xa6,
  0x2f,
  0x3a,
  0xe5,
  0x2e,
  0x91,
  0x6c,
  0x46,
  0x2f,
  0x1a,
  0xdb,
  0x02,
  0xdc,
  0x29,
  0x17,
  0xbd,
  0x66,
  0x14,
  0x13,
  0x10,
  0xba,
  0x9a,
  0xa7,
  0x1d,
  0x79,
  0x73,
  0x29,
  0x07,
  0x12,
  0x9d,
  0xaf,
  0x3d,
  0xdd,
  0x7d,
  0xa5,
  0x44,
  0x88,
  0x88,
  0x5b,
  0x0b,
  0xfd,
  0x07,
  0xd1,
  0x94,
  0x4f,
  0xdf,
  0xa2,
  0x0c,
  0xa4,
  0x2d,
  0x61,
  0x77,
  0x3d,
  0x0b,
  0x37,
  0xb8,
  0x21,
  0x82,
  0xe4,
  0xdb,
  0x21,
  0xc7,
  0x10,
  0x67,
  0x4f,
  0x68,
  0x90,
  0xec,
  0x65,
  0xe5,
  0x0e,
  0x49,
  0x91,
  0x85,
  0xaa,
  0x07,
  0x98,
  0xbe,
  0x64,
  0xaf,
  0x48,
  0xb7,
  0x17,
  0x5f,
  0xcf,
  0x34,
  0x4b,
  0x2f,
  0x9f,
  0x9c,
  0xf0,
  0xcd,
  0xfa,
  0xb2,
  0x29,
  0x92,
  0xa0,
  0xc8,
  0x80,
  0xcf,
  0x03,
  0x69,
  0x8a,
  0xb0,
  0x70,
  0x8d,
  0x1a,
  0x9c,
  0xab,
  0xe9,
  0x0b,
  0x69,
  0x3d,
  0xc5,
  0x73,
  0x40,
  0xab,
  0x2c,
  0x50,
  0xeb,
  0x7c,
  0x66,
  0x4b,
  0x36,
  0x71,
  0x18,
  0x38,
  0xf3,
  0x02,
  0x87,
  0x89,
  0x92,
  0xc6,
  0xae,
  0x04,
  0x29,
  0xa9,
  0x26,
  0xcd,
  0x5d,
  0x06,
  0xc5,
  0x11,
  0x45,
  0xc8,
  0x6d,
  0x0d,
  0x0f,
  0x78,
  0xa1,
  0xcc,
  0x9f,
  0x73,
  0x35,
  0x6d,
  0x97,
  0x54,
  0xe8,
  0x99,
  0xc2,
  0x61,
  0xca,
  0x36,
  0xfa,
  0x45,
  0x8d,
  0x5c,
  0xa1,
  0x05,
  0x5e,
  0xe2,
  0x97,
  0xab,
  0x45,
  0x5c,
  0x18,
  0x8c,
  0xc9,
  0x1f,
  0xe2,
  0x8a,
  0xe8,
  0x7f,
  0x42,
  0xf5,
  0x40,
  0x58,
  0x1a,
  0xd2,
  0xf2,
  0x37,
  0xfd,
  0x1b,
  0xa4,
  0x80,
  0x2c,
  0xe1,
  0x16,
  0x72,
  0x8e,
  0x56,
  0x40,
  0x77,
  0x94,
  0xd3,
  0x9c,
  0xd1,
  0x6c,
  0x19,
  0x53,
  0x14,
  0x7f,
  0x58,
  0x9e,
  0x83,
  0xda,
  0xf5,
  0x49,
  0xe4,
  0xff,
  0x46,
  0x10,
  0x7c,
  0xcf,
  0xc2,
  0x3c,
  0xbc,
  0xcc,
  0x7e,
  0x97,
  0x76,
  0x7e,
  0x96,
  0x2b,
  0x28,
  0xfc,
  0x92,
  0xa2,
  0x5c,
  0xf5,
  0x82,
  0x9a,
  0x1d,
  0x38,
  0x2b,
  0x76,
  0x64,
  0xf6,
  0x43,
  0xd7,
  0x9b,
  0x92,
  0x92,
  0x8a,
  0x8e,
  0xe8,
  0x3b,
  0xd2,
  0x46,
  0x68,
  0x4b,
  0xe2,
  0x51,
  0xcb,
  0x5c,
  0x85,
  0x4c,
  0x64,
  0xaf,
  0x3f,
  0x41,
  0x36,
  0x73,
  0x61,
  0x74,
  0xa4,
  0xc5,
  0x7f,
  0xf2,
  0x3e,
  0xd6,
  0xf4,
  0x68,
  0x43,
  0xe3,
  0x74,
  0xe4,
  0x08,
  0x8f,
  0x08,
  0xc6,
  0xb7,
  0x87,
  0x10,
  0xb8,
  0x31,
  0xfd,
  0x97,
  0xff,
  0xfa,
  0x64,
  0xdb,
  0xf5,
  0xc2,
  0x98,
  0x12,
  0xfe,
  0x04,
  0x66,
  0xc6,
  0x83,
  0x58,
  0x16,
  0x35,
  0xde,
  0xd6,
  0xa0,
  0x9c,
  0x8d,
  0x94,
  0x4e,
  0xc0,
  0xa4,
  0x38,
  0xd1,
  0x8b,
  0x79,
  0x79,
  0x03,
  0xd7,
  0x3b,
  0x72,
  0x87,
  0x1f,
  0xcf,
  0x4b,
  0x8d,
  0x4a,
  0xbe,
  0x99,
  0xe9,
  0xe8,
  0x12,
  0x87,
  0x3a,
  0xdf,
  0x72,
  0x79,
  0x96,
  0x19,
  0x6b,
  0x7a,
  0x68,
  0x50,
  0xc2,
  0x57,
  0x9d,
  0x85,
  0x18,
  0x07,
  0x63,
  0xa5,
  0x74,
  0x8a,
  0x5f,
  0x40,
  0x9c,
  0xef,
  0x69,
  0x6d,
  0x69,
  0x74,
  0x04,
  0xf5,
  0xc9,
  0x25,
  0xdd,
  0x8c,
  0x02,
  0x88,
  0xe6,
  0xb2,
  0x4a,
  0x09,
  0xa8,
  0xda,
  0xb1,
  0xf2,
  0x9d,
  0x33,
  0x2b,
  0x95,
  0xb3,
  0x79,
  0x7a,
  0x8d,
  0x81,
  0xdf,
  0xfa,
  0xd2,
  0xb7,
  0x56,
  0x67,
  0x31,
  0x43,
  0x29,
  0xc4,
  0x7c,
  0x1d,
  0x89,
  0xf0,
  0x50,
  0x2c,
  0x9c,
  0xb5,
  0x2b,
  0x9e,
  0xf5,
  0x85,
  0x49,
  0x4e,
  0x25,
  0x8e,
  0x1c,
  0x90,
  0x4d,
  0xba,
  0x04,
  0x90,
  0x2e,
  0x4e,
  0x13,
  0xeb,
  0xe5,
  0xfa,
  0xbe,
  0x1e,
  0x3f,
  0x22,
  0x7c,
  0x0d,
  0x1f,
  0xf9,
  0x2a,
  0xa9,
  0xe0,
  0xe9,
  0x01,
  0x16,
  0x52,
  0x44,
  0x69,
  0x08,
  0x0d,
  0xcb,
  0x1f,
  0xdf,
  0xee,
  0x9b,
  0xe5,
  0xd8,
  0xab,
  0x73,
  0x92,
  0x13,
  0xb5,
  0x69,
  0x5f,
  0x6b,
  0x33,
  0xdd,
  0xc4,
  0x76,
  0x10,
  0x09,
  0xb8,
  0x20,
  0x3f,
  0x11,
  0xed,
  0x69,
  0x3b,
  0x14,
  0x99,
  0xbc,
  0x3c,
  0x78,
  0x0f,
  0xdc,
  0x96,
  0xd7,
  0x09,
  0xb9,
  0x84,
  0x17,
  0x52,
  0x53,
  0x23,
  0xc9,
  0x98,
  0xa1,
  0xf9,
  0x32,
  0x63,
  0xd6,
  0x9f,
  0x9f,
  0x0c,
  0x57,
  0x03,
  0xee,
  0x36,
  0xa9,
  0xf1,
  0x9c,
  0xda,
  0xab,
  0x8b,
  0x8f,
  0x9e,
  0x59,
  0xea,
  0x3a,
  0x4c,
  0x2a,
  0x95,
  0xa3,
  0xf7,
  0x09,
  0x25,
  0x99,
  0xfb,
  0x93,
  0x9f,
  0x10,
  0xfd,
  0xb4,
  0xb1,
  0x65,
  0x35,
  0xc9,
  0x74,
  0xaf,
  0x82,
  0xb4,
  0x2f,
  0x68,
  0x30,
  0xbe,
  0x33,
  0x0b,
  0x98,
  0x0f,
  0xcf,
  0x82,
  0x47,
  0xe8,
  0x33,
  0x6a,
  0x6d,
  0xf1,
  0x44,
  0x66,
  0x1c,
  0xa7,
  0x85,
  0xdd,
  0x69,
  0x27,
  0x58,
  0xcc,
  0x30,
  0xf5,
  0x07,
  0x1c,
  0x03,
  0x72,
  0x40,
  0x5e,
  0xd1,
  0xca,
  0xc7,
  0x2c,
  0xf0,
  0xb7,
  0x83,
  0x52,
  0x82,
  0xdb,
  0x0b,
  0xf0,
  0xdf,
  0xf3,
  0x45,
  0x69,
  0xc9,
  0xd7,
  0x6c,
  0xd6,
  0x69,
  0x06,
  0x90,
  0x49,
  0x80,
  0xc5,
  0x07,
  0x45,
  0x6c,
  0xa8,
  0x78,
  0x3e,
  0xe9,
  0xf6,
  0x55,
  0x10,
  0xaa,
  0x50,
  0xe2,
  0x68,
  0xc4,
  0x28,
  0xb1,
  0xae,
  0xdf,
  0x25,
  0x33,
  0x3b,
  0x3d,
  0xf3,
  0xf6,
  0x7d,
  0x4d,
  0xe8,
  0xde,
  0x2a,
  0x6e,
  0xee,
  0x98,
  0x1a,
  0x4c,
  0xd1,
  0x1b,
  0xfa,
  0x17,
  0x9e,
  0x6b,
  0xff,
  0x43,
  0xb2,
  0x5b,
  0xd9,
  0x10,
  0x38,
  0x4b,
  0xa2,
  0x19,
  0xbd,
  0x4f,
  0xdd,
  0x10,
  0xc2,
  0x08,
  0xc8,
  0x52,
  0x7c,
  0xfe,
  0x32,
  0x9c,
  0x29,
  0xe4,
  0xe0,
  0x76,
  0x4d,
  0xf0,
  0x86,
  0x23,
  0xed,
  0xa9,
  0x5a,
  0x7c,
  0xf8,
  0x4e,
  0x05,
  0x8e,
  0x93,
  0x30,
  0x02,
  0x16,
  0xbc,
  0xeb,
  0x90,
  0x15,
  0xbf,
  0x74,
  0x72,
  0x8b,
  0x3f,
  0x87,
  0x01,
  0x1c,
  0x66,
  0x8d,
  0xb8,
  0x21,
  0x97,
  0x7d,
  0x97,
  0x06,
  0x65,
  0x55,
  0x0e,
  0x15,
  0x57,
  0xa7,
  0x96,
  0xe2,
  0x3c,
  0x91,
  0xdc,
  0x73,
  0x8f,
  0xca,
  0x8e,
  0xd6,
  0x14,
  0x6c,
  0x65,
  0x24,
  0x9e,
  0x36,
  0x71,
  0xa2,
  0x81,
  0x64,
  0x28,
  0x02,
  0x8d,
  0xe7,
  0x04,
  0x1b,
  0xea,
  0x95,
  0x86,
  0x2b,
  0x22,
  0x8b,
  0x1d,
  0x9d,
  0x77,
  0x40,
  0xf4,
  0xb6,
  0x66,
  0xd6,
  0x0d,
  0x23,
  0x0f,
  0x9a,
  0x9b,
  0x6b,
  0x02,
  0x33,
  0x96,
  0x6a,
  0xbb,
  0x22,
  0x32,
  0x14,
  0xec,
  0x38,
  0x76,
  0x3b,
  0x4b,
  0x0c,
  0x7f,
  0x65,
  0xc9,
  0xcb,
  0x18,
  0xc7,
  0xb0,
  0x88,
  0xa8,
  0xe3,
  0x18,
  0xa8,
  0x66,
  0xaf,
  0x4c,
  0x10,
  0xb6,
  0x60,
  0x3d,
  0x06,
  0x33,
  0x14,
  0x83,
  0x6f,
  0x26,
  0xf7,
  0x05,
  0x8e,
  0x94,
  0x3a,
  0x12,
  0x3a,
  0x29,
  0x96,
  0xda,
  0x79,
  0xa4,
  0xaa,
  0xdd,
  0x35,
  0x99,
  0x18,
  0x3f,
  0xd2,
  0xb1,
  0x92,
  0x3c,
  0x17,
  0xe1,
  0x88,
  0xd8,
  0x1f,
  0xc4,
  0xeb,
  0xb4,
  0x82,
  0xfd,
  0x59,
  0xbd,
  0x80,
  0x0a,
  0x44,
  0x5b,
  0x95,
  0xe7,
  0x3a,
  0x4e,
  0xfc,
  0x81,
  0x8c,
  0x15,
  0x5b,
  0x46,
  0xc9,
  0x55,
  0x7c,
  0x14,
  0x90,
  0xc4,
  0xa1,
  0x7b,
  0xc3,
  0xd5,
  0xb8,
  0xc1,
  0xb3,
  0x28,
  0x02,
  0xcd,
  0xd2,
  0xd7,
  0x41,
  0x6e,
  0x18,
  0xca,
  0x46,
  0x08,
  0xc7,
  0x16,
  0x7d,
  0xc5,
  0xd7,
  0xbd,
  0xae,
  0x08,
  0x14,
  0x4a,
  0x9f,
  0x5f,
  0x59,
  0xce,
  0xa4,
  0x1b,
  0xf5,
  0xc5,
  0x2a,
  0xb9,
  0xb8,
  0xc3,
  0x9d,
  0x9b,
  0xca,
  0x81,
  0x3a,
  0x1c,
  0x55,
  0xf4,
  0xbb,
  0xba,
  0xf3,
  0x7f,
  0xe2,
  0x1d,
  0x88,
  0xbe,
  0x86,
  0x3c,
  0x77,
  0xaa,
  0xd3,
  0x3e,
  0xc2,
  0xf0,
  0x44,
  0xd9,
  0x47,
  0x9d,
  0x1d,
  0xf0,
  0x1b,
  0x8f,
  0x8a,
  0xc5,
  0x75,
  0x20,
  0x3c,
  0xb6,
  0x3a,
  0xb5,
  0xb7,
  0xdb,
  0x00,
  0x14,
  0x60,
  0x19,
  0x5e,
  0xcc,
  0x7c,
  0x70,
  0x9a,
  0x4a,
  0x21,
  0x7b,
  0x67,
  0xa1,
  0x62,
  0xe9,
  0x2a,
  0x3f,
  0x71,
  0x8b,
  0xbf,
  0xc2,
  0x68,
  0xec,
  0xbc,
  0x2a,
  0xa3,
  0x53,
  0x5f,
  0xbf,
  0x3e,
  0x8a,
  0x2d,
  0x09,
  0x4d,
  0xb1,
  0x82,
  0xb6,
  0xfe,
  0x83,
  0xe7,
  0x16,
  0xf7,
  0x64,
  0x6e,
  0x55,
  0xd9,
  0xdf,
  0xc0,
  0xef,
  0x09,
  0x68,
  0x8a,
  0x16,
  0xe4,
  0xd3,
  0x24,
  0x1f,
  0xb4,
  0x77,
  0x10,
  0xb6,
  0x94,
  0x2a,
  0xda,
  0x47,
  0x49,
  0xc7,
  0x15,
  0x5c,
  0x68,
  0x34,
  0xfc,
  0x30,
  0xd2,
  0x94,
  0x37,
  0x00,
  0x35,
  0x7f,
  0x6f,
  0xb9,
  0x5e,
  0xa9,
  0xc8,
  0x82,
  0x77,
  0x7f,
  0xbf,
  0xa3,
  0xb3,
  0xdd,
  0x2a,
  0xfd,
  0x0d,
  0x01,
  0x5e,
  0xbb,
  0x03,
  0x0b,
  0x0b,
  0x74,
  0x80,
  0x5d,
  0x38,
  0x01,
  0x54,
  0x04,
  0xa2,
  0x22,
  0xbc,
  0x3f,
  0xc8,
  0xbc,
  0x63,
  0x17,
  0x5f,
  0x3c,
  0x9b,
  0xd0,
  0xf3,
  0xc8,
  0xb7,
  0x37,
  0xe4,
  0xbe,
  0x20,
  0x1c,
  0x6f,
  0x3d,
  0x0f,
  0x75,
  0xc6,
  0x1a,
  0xc8,
  0x38,
  0xe5,
  0x6a,
  0x02,
  0xc3,
  0x8a,
  0xcd,
  0x80,
  0x4e,
  0x18,
  0xb0,
  0xd2,
  0x50,
  0x2a,
  0x4f,
  0x2f,
  0x80,
  0xac,
  0xa2,
  0xb7,
  0xba,
  0x17,
  0x23,
  0xd0,
  0x89,
  0x37,
  0xb2,
  0xbe,
  0x7d,
  0x7c,
  0x74,
  0xbb,
  0xaf,
  0x60,
  0x1d,
  0xa5,
  0x0c,
  0x15,
  0x53,
  0xeb,
  0xc3,
  0x45,
  0x16,
  0x5e,
  0x3d,
  0xe2,
  0xe4,
  0x58,
  0x63,
  0x99,
  0x5e,
  0x9f,
  0x2c,
  0x2b,
  0x1d,
  0xee,
  0x56,
  0x3f,
  0x75,
  0x50,
  0x50,
  0x7b,
  0x8d,
  0x97,
  0xc5,
  0x51,
  0x02,
  0xe5,
  0xa6,
  0xfb,
  0x4b,
  0x31,
  0xe7,
  0x2f,
  0xeb,
  0x6d,
  0x05,
  0xfc,
  0x66,
  0xd3,
  0xc7,
  0x98,
  0x05,
  0x25,
  0xb0,
  0x58,
  0xce,
  0xd6,
  0xef,
  0xd7,
  0xf4,
  0x9f,
  0x47,
  0x1f,
  0xfb,
  0x1c,
  0x05,
  0x64,
  0x6b,
  0xf7,
  0xbf,
  0xd1,
  0xfe,
  0x07,
  0x4a,
  0xe9,
  0xca,
  0x61,
  0xa5,
  0x0e,
  0xab,
  0x15,
  0xce,
  0x9e,
  0x9c,
  0x91,
  0x8e,
  0x0b,
  0x1b,
  0x9b,
  0xd6,
  0x22,
  0x49,
  0x10,
  0xb4,
  0x53,
  0xf7,
  0xbc,
  0x32,
  0x72,
  0x14,
  0xb7,
  0x2b,
  0x1f,
  0x77,
  0x3a,
  0x8b,
  0xe5,
  0x28,
  0x5e,
  0xe0,
  0xe2,
  0x39,
  0xc0,
  0xb5,
  0x10,
  0xd7,
  0x79,
  0x35,
  0x6c,
  0x27,
  0xe7,
  0xde,
  0xc0,
  0x89,
  0x2d,
  0xe4,
  0x8c,
  0x60,
  0x76,
  0x6a,
  0x0f,
  0x51,
  0xfc,
  0x1e,
  0x02,
  0x7a,
  0x20,
  0xcd,
  0xc7,
  0x5c,
  0xd4,
  0xf1,
  0x1d,
  0xd0,
  0xc2,
  0x79,
  0x59,
  0x67,
  0x0d,
  0x26,
  0x97,
  0xa2,
  0x9f,
  0xfc,
  0x9d,
  0xad,
  0x7a,
  0x91,
  0x98,
  0x3b,
  0x95,
  0xe0,
  0x06,
  0x52,
  0x09,
  0xc0,
  0x86,
  0x7c,
  0x94,
  0xb2,
  0x8e,
  0x86,
  0xb5,
  0x73,
  0x88,
  0xef,
  0x18,
  0x59,
  0xe8,
  0x9e,
  0xc5,
  0xd0,
  0x56,
  0x53,
  0xf5,
  0xbf,
  0x34,
  0x12,
  0xd4,
  0x06,
  0x11,
  0xe3,
  0xc6,
  0xdd,
  0xa6,
  0x2d,
  0x02,
  0x0b,
  0x7d,
  0x51,
  0xdd,
  0x17,
  0xd3,
  0x6a,
  0x2b,
  0x9f,
  0x24,
  0x9e,
  0xd8,
  0x98,
  0x03,
  0x3a,
  0xa4,
  0xee,
  0x99,
  0x31,
  0x72,
  0xfe,
  0x12,
  0x48,
  0xcf,
  0x59,
  0xd4,
  0x66,
  0x3a,
  0xdf,
  0xf1,
  0x13,
  0x2e,
  0x9a,
  0x05,
  0x87,
  0x60,
  0x41,
  0x56,
  0x09,
  0xef,
  0x0d,
  0x9c,
  0x2d,
  0xc1,
  0xc8,
  0xc3,
  0x8f,
  0x61,
  0xf3,
  0x66,
  0x7c,
  0xdc,
  0x49,
  0xc1,
  0x3b,
  0xfa,
  0xa8,
  0xa1,
  0xf5,
  0xcb,
  0xfa,
  0xc8,
  0x74,
  0x2f,
  0xdb,
  0x33,
  0x8b,
  0x48,
  0x5e,
  0x1d,
  0x81,
  0x8e,
  0x99,
  0xba,
  0x82,
  0xd1,
  0x4b,
  0xfe,
  0x68,
  0x73,
  0x6c,
  0x92,
  0x8e,
  0xf8,
  0xf0,
  0x5a,
  0x43,
  0x6d,
  0xef,
  0xc3,
  0x17,
  0x99,
  0x5b,
  0xe5,
  0x63,
  0x5f,
  0x72,
  0xd4,
  0x22,
  0x88,
  0xb7,
  0x52,
  0xc8,
  0x12,
  0x7f,
  0x26,
  0xf2,
  0xaf,
  0x16,
  0x37,
  0xc8,
  0x7c,
  0x85,
  0xb9,
  0x15,
  0x27,
  0xbc,
  0x2d,
  0x7e,
  0x86,
  0x76,
  0x62,
  0xb9,
  0xda,
  0xf4,
  0x0c,
  0x1f,
  0x7b,
  0xed,
  0xde,
  0xb7,
  0x54,
  0x15,
  0x69,
  0x2c,
  0x03,
  0xfd,
  0xaf,
  0xb1,
  0x6d,
  0x20,
  0x9d,
  0x81,
  0xdc,
  0xe8,
  0x83,
  0xa4,
  0xf3,
  0x70,
  0x75,
  0x9c,
  0xcd,
  0x30,
  0x5e,
  0x7d,
  0x6a,
  0xbb,
  0x98,
  0x64,
  0x6a,
  0x03,
  0xb0,
  0xc1,
  0x17,
  0x7d,
  0x89,
  0x18,
  0x56,
  0xed,
  0x6b,
  0xde,
  0xbf,
  0x1e,
  0x3a,
  0x97,
  0x37,
  0xd9,
  0xf2,
  0xcc,
  0x72,
  0xa0,
  0xd5,
  0xaa,
  0x5f,
  0xe8,
  0x36,
  0x2a,
  0x0d,
  0x04,
  0xa5,
  0x66,
  0x28,
  0xe8,
  0x41,
  0x04,
  0x98,
  0x3b,
  0xd1,
  0x88,
  0x88,
  0xe6,
  0xee,
  0x5e,
  0xf8,
  0xdd,
  0xf3,
  0xc1,
  0x61,
  0x3c,
  0xfa,
  0x95,
  0x3a,
  0xf6,
  0x07,
  0xfd,
  0xf3,
  0xc6,
  0x55,
  0xcb,
  0x7b,
  0x94,
  0x4a,
  0x9f,
  0x45,
  0xb9,
  0xb2,
  0x01,
  0xe5,
  0xe1,
  0x9a,
  0xdb,
  0x69,
  0xae,
  0x70,
  0x6e,
  0x58,
  0x5b,
  0x06,
  0x52,
  0x12,
  0xef,
  0xb3,
  0x9a,
  0x3c,
  0x9b,
  0x56,
  0x4d,
  0xd8,
  0x5c,
  0x29,
  0xed,
  0x3a,
  0x60,
  0xfc,
  0x28,
  0x65,
  0xe2,
  0x85,
  0x26,
  0x2a,
  0x49,
  0x59,
  0x46,
  0xe9,
  0xb1,
  0x55,
  0x5e,
  0x49,
  0xe4,
  0x40,
  0xa6,
  0xf2,
  0x5c,
  0x20,
  0xdf,
  0x39,
  0x29,
  0x1a,
  0x8d,
  0x49,
  0x2d,
  0xe2,
  0x4d,
  0xfe,
  0x7a,
  0x36,
  0x27,
  0x4e,
  0xf4,
  0xec,
  0x75,
  0x94,
  0x1e,
  0x09,
  0x9f,
  0xbe,
  0x6c,
  0x08,
  0x22,
  0x38,
  0x5e,
  0x15,
  0x71,
  0x2c,
  0x26,
  0xe1,
  0xf2,
  0xa2,
  0x60,
  0xee,
  0xb7,
  0x22,
  0x50,
  0x95,
  0x0e,
  0xc6,
  0xa2,
  0xf3,
  0x61,
  0x28,
  0xfa,
  0xfa,
  0x86,
  0x78,
  0x22,
  0xdd,
  0x90,
  0xaa,
  0x70,
  0x93,
  0x9c,
  0xe3,
  0xa6,
  0xd7,
  0xfa,
  0x2f,
  0xe9,
  0xe7,
  0xfd,
  0xb0,
  0x19,
  0xce,
  0x87,
  0x61,
  0x76,
  0xba,
  0xee,
  0x97,
  0x11,
  0xbf,
  0x6a,
  0x26,
  0x72,
  0xa0,
  0x62,
  0x3c,
  0xd7,
  0x72,
  0xda,
  0xb5,
  0x84,
  0x59,
  0xda,
  0x68,
  0x47,
  0x75,
  0x1f,
  0xfd,
  0x49,
  0x8a,
  0xeb,
  0x6d,
  0x50,
  0x3a,
  0x4b,
  0x63,
  0xe3,
  0x7b,
  0xff,
  0xf1,
  0xae,
  0x3e,
  0x4e,
  0xf2,
  0xcd,
  0x0a,
  0xcb,
  0x1d,
  0xde,
  0xc7,
  0x63,
  0x2a,
  0x60,
  0x6e,
  0x2c,
  0x56,
  0x83,
  0x6b,
  0xa7,
  0xfd,
  0x9f,
  0x68,
  0x10,
  0x92,
  0x70,
  0x07,
  0xba,
  0x98,
  0xd5,
  0xf3,
  0x1e,
  0x73,
  0x17,
  0x41,
  0x51,
  0x3a,
  0x77,
  0xed,
  0x43,
  0xda,
  0x39,
  0x8e,
  0xb6,
  0xf6,
  0x94,
  0x66,
  0x48,
  0x0c,
  0x4f,
  0xaa,
  0x64,
  0x52,
  0xa6,
  0xca,
  0x37,
  0xa4,
  0xc6,
  0x20,
  0x9b,
  0x69,
  0x85,
  0xa4,
  0xc0,
  0x95,
  0xf5,
  0x91,
  0x4d,
  0x08,
  0x12,
  0xae,
  0x97,
  0xf8,
  0x58,
  0xa2,
  0xb9,
  0xfb,
  0xff,
  0x93,
  0xa5,
  0xe5,
  0x4c,
  0xdc,
  0x3e,
  0x33,
  0xe3,
  0xf3,
  0xcb,
  0x0a,
  0x24,
  0xfb,
  0x9c,
  0xdc,
  0xb3,
  0x2d,
  0xf3,
  0x01,
  0x01,
  0x23,
  0x65,
  0xac,
  0x18,
  0xe1,
  0xf6,
  0x6a,
  0xda,
  0x00,
  0x01,
  0x7e,
  0x67,
  0xc4,
  0xe4,
  0x46,
  0x9e,
  0xf1,
  0xe1,
  0x70,
  0xaf,
  0x0e,
  0xb9,
  0xd1,
  0xf8,
  0xac,
  0x02,
  0xd8,
  0x1b,
  0x7e,
  0x05,
  0x3c,
  0x75,
  0x22,
  0x9a,
  0x95,
  0xf1,
  0x76,
  0x8f,
  0x12,
  0xcc,
  0x6c,
  0x60,
  0x13,
  0x33,
  0x52,
  0x12,
  0x20,
  0xdc,
  0x83,
  0x03,
  0x88,
  0x59,
  0x91,
  0x0b,
  0x87,
  0xc1,
  0x0e,
  0x8c,
  0x69,
  0x18,
  0x49,
  0x56,
  0x22,
  0xfc,
  0xbe,
  0x5b,
  0x7c,
  0x09,
  0x89,
  0x28,
  0xae,
  0xc8,
  0x93,
  0x1c,
  0x42,
  0x5f,
  0x43,
  0xfb,
  0xb8,
  0xc9,
  0x0c,
  0x91,
  0xce,
  0xad,
  0x05,
  0xd3,
  0x0d,
  0x01,
  0x38,
  0x6a,
  0x5f,
  0xaa,
  0x82,
  0x6b,
  0x91,
  0x4d,
  0xab,
  0xaf,
  0x1a,
  0x4d,
  0x59,
  0x83,
  0x8f,
  0x85,
  0x12,
  0xe4,
  0x36,
  0xd9,
  0x9f,
  0x8d,
  0xc4,
  0x7b,
  0xa6,
  0x98,
  0x94,
  0x12,
  0x5c,
  0xb9,
  0x42,
  0x24,
  0xf9,
  0x55,
  0x4d,
  0x5d,
  0x05,
  0xe5,
  0x2e,
  0xfb,
  0xe4,
  0xca,
  0x34,
  0xf1,
  0xd4,
  0x6b,
  0x86,
  0x5a,
  0x59,
  0x88,
  0x4b,
  0xff,
  0xaa,
  0xf7,
  0x78,
  0xa3,
  0x64,
  0x71,
  0x87,
  0x76,
  0xc6,
  0x10,
  0x42,
  0xcf,
  0xa9,
  0x20,
  0x47,
  0x1c,
  0xfa,
  0xae,
  0x20,
  0x2e,
  0xf0,
  0x09,
  0x90,
  0x9d,
  0xf7,
  0xb5,
  0x22,
  0x3d,
  0x39,
  0x3b,
  0x54,
  0x3b,
  0x8d,
  0xa1,
  0x41,
  0x4f,
  0xe2,
  0x78,
  0x7d,
  0x71,
  0x41,
  0xf1,
  0xf2,
  0x2f,
  0x45,
  0x90,
  0x8f,
  0xa4,
  0x38,
  0x9c,
  0x7c,
  0x17,
  0x44,
  0xe6,
  0x97,
  0x95,
  0xad,
  0x48,
  0x3d,
  0x22,
  0x15,
  0x23,
  0x10,
  0x91,
  0xba,
  0x81,
  0x11,
  0x5d,
  0x05,
  0xb9,
  0x15,
  0xdf,
  0xe1,
  0x19,
  0xde,
  0x55,
  0x33,
  0x9d,
  0x70,
  0xb9,
  0x84,
  0x39,
  0x35,
  0x1c,
  0x7c,
  0x0d,
  0xd0,
  0xb7,
  0x34,
  0xf1,
  0xce,
  0xe7,
  0x76,
  0xfd,
  0x71,
  0xe6,
  0x46,
  0xa5,
  0x62,
  0x70,
  0x27,
  0xdc,
  0x04,
  0x52,
  0xfb,
  0x65,
  0x03,
  0xfa,
  0x0f,
  0xdc,
  0x76,
  0x5b,
  0xe2,
  0x6d,
  0xbb,
  0x49,
  0x99,
  0x5a,
  0xfe,
  0xab,
  0xc2,
  0x33,
  0x4d,
  0x4b,
  0xad,
  0xef,
  0xa8,
  0x65,
  0x20,
  0xaf,
  0x9c,
  0xe8,
  0x34,
  0xee,
  0xa4,
  0xdd,
  0xd3,
  0xf3,
  0x58,
  0xbb,
  0x10,
  0x34,
  0x6c,
  0x5a,
  0x02,
  0xa2,
  0xc0,
  0x29,
  0x3f,
  0xc3,
  0xde,
  0x67,
  0x25,
  0x0c,
  0xd2,
  0x1c,
  0xd0,
  0x9e,
  0xa6,
  0xe9,
  0xbf,
  0x09,
  0xbd,
  0xf9,
  0xc1,
  0xc0,
  0x87,
  0x05,
  0x31,
  0x2b,
  0x35,
  0x7c,
  0x4e,
  0x14,
  0x82,
  0x3f,
  0x7c,
  0x53,
  0x9e,
  0xa5,
  0xff,
  0x2a,
  0x0b,
  0xf8,
  0x5b,
  0xab,
  0xa2,
  0x45,
  0x60,
  0x1b,
  0xb0,
  0x32,
  0x3d,
  0xe1,
  0xc5,
  0xc4,
  0x5a,
  0x75,
  0xee,
  0x10,
  0x69,
  0x76,
  0x37,
  0x1a,
  0x28,
  0x42,
  0xc9,
  0xea,
  0xcc,
  0xa1,
  0xda,
  0x0b,
  0x8c,
  0x3b,
  0xd0,
  0x06,
  0xa6,
  0x90,
  0x49,
  0x07,
  0xfd,
  0x54,
  0x8e,
  0x9a,
  0xa0,
  0x24,
  0xb0,
  0x58,
  0x26,
  0x8f,
  0x04,
  0x75,
  0x45,
  0x70,
  0x70,
  0x98,
  0xb8,
  0xdd,
  0xc7,
  0xa0,
  0x0d,
  0x8c,
  0xbe,
  0x1c,
  0x94,
  0x70,
  0xb0,
  0xd7,
  0x83,
  0x2f,
  0xdd,
  0xf7,
  0xb0,
  0x25,
  0x3a,
  0x9d,
  0x2d,
  0x5b,
  0x08,
  0x74,
  0x0c,
  0x74,
  0x0a,
  0x5d,
  0x9c,
  0x2c,
  0x32,
  0xe6,
  0x29,
  0x66,
  0x00,
  0xa7,
  0x33,
  0x08,
  0x13,
  0x98,
  0x7e,
  0x2a,
  0xc7,
  0x75,
  0x76,
  0xa5,
  0xcd,
  0x13,
  0xec,
  0x9d,
  0x56,
  0xb1,
  0x8f,
  0x8b,
  0x40,
  0x71,
  0x00,
  0xa0,
  0x0a,
  0x29,
  0x92,
  0x08,
  0x56,
  0x12,
  0xd0,
  0x2e,
  0xcd,
  0x45,
  0xaa,
  0x6d,
  0x01,
  0xe7,
  0x70,
  0x08,
  0x08,
  0xb8,
  0xd6,
  0xbb,
  0xfa,
  0x6c,
  0x63,
  0x04,
  0x91,
  0x82,
  0x12,
  0x5a,
  0xf0,
  0x6f,
  0xd0,
  0xc0,
  0x57,
  0x6e,
  0x05,
  0x94,
  0x59,
  0x9b,
  0x67,
  0xeb,
  0xd5,
  0xf0,
  0x5a,
  0x1b,
  0x12,
  0x83,
  0xe0,
  0xce,
  0x15,
  0x90,
  0x05,
  0x8c,
  0xbb,
  0xb1,
  0x09,
  0x49,
  0x67,
  0xff,
  0x15,
  0x3a,
  0x5f,
  0x1a,
  0x6e,
  0xe5,
  0xb2,
  0xb8,
  0x9c,
  0x8d,
  0x3c,
  0x77,
  0xf8,
  0x3a,
  0xf6,
  0x9d,
  0x8a,
  0x4f,
  0xa7,
  0x07,
  0xaf,
  0x19,
  0xa1,
  0x3a,
  0x65,
  0x03,
  0x51,
  0xdb,
  0x24,
  0xf7,
  0x82,
  0x76,
  0x2b,
  0xb6,
  0x38,
  0xc6,
  0xb8,
  0xb0,
  0x40,
  0xcd,
  0xf4,
  0xdc,
  0x50,
  0x74,
  0x55,
  0x12,
  0x6c,
  0xef,
  0xbb,
  0xd4,
  0x47,
  0x1a,
  0xf7,
  0xd1,
  0xd6,
  0x28,
  0x2d,
  0x91,
  0x9f,
  0xc8,
  0x0f,
  0xae,
  0x4a,
  0xcf,
  0x8a,
  0xbd,
  0xee,
  0x96,
  0x0d,
  0x5d,
  0xf4,
  0x2c,
  0xfe,
  0x77,
  0x4a,
  0x41,
  0xe0,
  0x39,
  0xaa,
  0x4f,
  0x5c,
  0xb3,
  0x6d,
  0xa6,
  0xb1,
  0x50,
  0xe9,
  0x21,
  0xec,
  0xc2,
  0x04,
  0x34,
  0x31,
  0x2c,
  0xea,
  0x24,
  0xdd,
  0x2b,
  0x6a,
  0xe6,
  0x7e,
  0x44,
  0x90,
  0x5c,
  0x57,
  0x0c,
  0x4d,
  0xd8,
  0x7b,
  0x3a,
  0x68,
  0x16,
  0x5e,
  0x87,
  0xda,
  0x0d,
  0x0d,
  0x85,
  0xb3,
  0x3a,
  0x67,
  0x92,
  0x06,
  0x30,
  0x1a,
  0x96,
  0x89,
  0xa8,
  0x08,
  0xc9,
  0x35,
  0xd4,
  0x48,
  0x4a,
  0x98,
  0x0e,
  0x7e,
  0x1d,
  0x4c,
  0x0e,
  0xcf,
  0xc5,
  0xd4,
  0xa3,
  0x34,
  0x50,
  0x93,
  0xed,
  0xa4,
  0xf2,
  0x3e,
  0x50,
  0x4a,
  0x48,
  0x66,
  0xda,
  0xc6,
  0xb9,
  0x4a,
  0xef,
  0x27,
  0xb3,
  0x77,
  0x6f,
  0x29,
  0xf9,
  0xba,
  0xad,
  0x90,
  0xe2,
  0xeb,
  0xeb,
  0x43,
  0x9d,
  0x46,
  0xa4,
  0x7d,
  0x51,
  0x7f,
  0x21,
  0xea,
  0x64,
  0x29,
  0x16,
  0x90,
  0x71,
  0x16,
  0x3b,
  0xf0,
  0xae,
  0x2a,
  0xf9,
  0x12,
  0x63,
  0x5a,
  0xab,
  0xea,
  0x3d,
  0xfc,
  0x21,
  0xb6,
  0x16,
  0x97,
  0xf7,
  0x26,
  0x3e,
  0x65,
  0x7d,
  0xb0,
  0x0c,
  0xcc,
  0xa0,
  0x33,
  0x01,
  0x89,
  0xa5,
  0x73,
  0xcb,
  0x6f,
  0xe4,
  0x9a,
  0x13,
  0xf4,
  0x6b,
  0x2f,
  0xf2,
  0xfc,
  0x11,
  0x81,
  0x88,
  0xb6,
  0x4f,
  0xed,
  0xc1,
  0xb2,
  0x6e,
  0x37,
  0xd9,
  0x09,
  0xd1,
  0xd5,
  0x34,
  0xf1,
  0xee,
  0x2a,
  0xfd,
  0x5c,
  0x9a,
  0x07,
  0xf1,
  0xec,
  0x96,
  0x9c,
  0xdd,
  0x0c,
  0x8e,
  0xd9,
  0x8a,
  0x81,
  0x5a,
  0xfd,
  0x8b,
  0x9c,
  0x2f,
  0xb3,
  0x29,
  0xd2,
  0x19,
  0x6f,
  0xfd,
  0x04,
  0x6d,
  0x75,
  0x3d,
  0x5e,
  0x4e,
  0x0a,
};

/*----------------------------------------------------------------------------------------
 *           P R O T O T Y P E S     O F     L O C A L     F U N C T I O N S
 *----------------------------------------------------------------------------------------
 */

/*----------------------------------------------------------------------------------------
 *                          E X P O R T E D    F U N C T I O N S
 *----------------------------------------------------------------------------------------
 */
