/** @file

Copyright (c) 2017, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPUPDVPD_H__
#define __FSPUPDVPD_H__

#pragma pack(push, 1)


#define MRC_MAX_RCOMP          3
#define MRC_MAX_RCOMP_TARGETS  5
#define MAX_CHANNELS_NUM       2
#define MAX_DIMMS_NUM          2

typedef struct {
  UINT16  RcompResistor[MRC_MAX_RCOMP];       ///< Offset 0: Reference RCOMP resistors on motherboard
  UINT16  RcompTarget[MRC_MAX_RCOMP_TARGETS]; ///< Offset 6: RCOMP target values for DqOdt, DqDrv, CmdDrv, CtlDrv, ClkDrv
} MEMORY_RCOMP;


typedef struct {
  UINT32 VendorDeviceId;     /* Vendor ID/Device ID */
  UINT16 SubSystemId;        /* SubSystem ID */
  UINT8  RevisionId;         /* Revision ID. 0xFF applies to all steppings */
  UINT8  FrontPanelSupport;  /* Front panel support (1=yes, 2=no) */
  UINT16 NumberOfRearJacks;  /* Number of Rear Jacks */
  UINT16 NumberOfFrontJacks; /* Number of Front Jacks */
} SA_HDA_HEADER;

typedef struct {
  UINT16 VendorId;          /* Codec Vendor ID */
  UINT16 DeviceId;          /* Codec Device ID */
  UINT8  RevisionId;        /* Revision ID of the codec. 0xFF matches any revision. */
  UINT8  SdiNo;             /* SDI number, 0xFF matches any SDI. */
  UINT16 DataDwords;        /* Number of data DWORDs pointed by the codec data buffer. */
  UINT32 Reserved;          /* Reserved for future use. Must be set to 0. */
} AZALIA_HEADER;

typedef struct {
  AZALIA_HEADER Header;     /* AZALIA PCH header */
  UINT32        *Data;      /* Pointer to the data buffer. Its length is specified in the header */
} AUDIO_AZALIA_VERB_TABLE;

///
/// Refer to the definition of PCH_INT_PIN
///
typedef enum {
  SiPchNoInt,        ///< No Interrupt Pin
  SiPchIntA,
  SiPchIntB,
  SiPchIntC,
  SiPchIntD
} SI_PCH_INT_PIN;
///
/// The PCH_DEVICE_INTERRUPT_CONFIG block describes interrupt pin, IRQ and interrupt mode for PCH device.
///
typedef struct {
  UINT8        Device;                  ///< Device number
  UINT8        Function;                ///< Device function
  UINT8        IntX;                    ///< Interrupt pin: INTA-INTD (see SI_PCH_INT_PIN)
  UINT8        Irq;                     ///< IRQ to be set for device.
} SI_PCH_DEVICE_INTERRUPT_CONFIG;

#define SI_PCH_MAX_DEVICE_INTERRUPT_CONFIG  64       ///< Number of all PCH devices

///
/// USB Overcurrent pins definition, the values match the setting of PCH EDS, please refer to PCH EDS for more details
///
typedef enum {
  UsbOverCurrentPin0 = 0,
  UsbOverCurrentPin1,
  UsbOverCurrentPin2,
  UsbOverCurrentPin3,
  UsbOverCurrentPin4,
  UsbOverCurrentPin5,
  UsbOverCurrentPin6,
  UsbOverCurrentPin7,
  UsbOverCurrentPinSkip,
  UsbOverCurrentPinMax
} USB_OVERCURRENT_PIN;


///
/// The ChipsetInit Info structure provides the information of ME ChipsetInit CRC and BIOS ChipsetInit CRC.
///
typedef struct {
  UINT8             Revision;
  UINT8             Rsvd[3];
  UINT16            MeChipInitCrc;
  UINT16            BiosChipInitCrc;
} CHIPSET_INIT_INFO;


typedef struct {
  UINT8         DimmId;
  UINT32        SizeInMb;
  UINT16        MfgId;
  UINT8         ModulePartNum[20];/* Module part number for DDR3 is 18 bytes however for DRR4 20 bytes as per JEDEC Spec, so reserving 20 bytes */
} DIMM_INFO;

typedef struct {
  UINT8         ChannelId;
  UINT8         DimmCount;
  DIMM_INFO     DimmInfo[MAX_DIMMS_NUM];
} CHANNEL_INFO;

typedef struct {
  UINT8         Revision;
  UINT16        DataWidth;
  /** As defined in SMBIOS 3.0 spec
    Section 7.18.2 and Table 75
  **/
  UINT8         MemoryType;
  UINT16        MemoryFrequencyInMHz;
  /** As defined in SMBIOS 3.0 spec
    Section 7.17.3 and Table 72
  **/
  UINT8         ErrorCorrectionType;
  UINT8         ChannelCount;
  CHANNEL_INFO  ChannelInfo[MAX_CHANNELS_NUM];
} FSP_SMBIOS_MEMORY_INFO;



/** UPD data structure for FspMemoryInitApi
**/
typedef struct {

/** Offset 0x0020
**/
  UINT64                      Signature;

/** Offset 0x0028 - Revision
  Revision version of the MemoryInitUpd Region
**/
  UINT8                       Revision;

/** Offset 0x0029
**/
  UINT8                       UnusedUpdSpace0[7];

/** Offset 0x0030 - Platform Reserved Memory Size
  The minimum platform memory size required to pass control into DXE
  0x400000 : 0x400000
**/
  UINT64                      PlatformMemorySize;

/** Offset 0x0038 - Memory SPD Pointer Channel 0 Dimm 0
  Pointer to SPD data in Memory. Default: 0 for empty channel
**/
  UINT32                      MemorySpdPtr00;

/** Offset 0x003C - Memory SPD Pointer Channel 0 Dimm 1
  Pointer to SPD data in Memory. Default: 0 for empty channel
**/
  UINT32                      MemorySpdPtr01;

/** Offset 0x0040 - Memory SPD Pointer Channel 1 Dimm 0
  Pointer to SPD data in Memory. Default: 0 for empty channel
**/
  UINT32                      MemorySpdPtr10;

/** Offset 0x0044 - Memory SPD Pointer Channel 1 Dimm 1
  Pointer to SPD data in Memory. Default: 0 for empty channel
**/
  UINT32                      MemorySpdPtr11;

/** Offset 0x0048 - SPD Data Length
  Length of SPD Data
  0x100:256 Bytes, 0x200:512 Bytes
**/
  UINT16                      MemorySpdDataLen;

/** Offset 0x004A - Dq Byte Map CH0
  Dq byte mapping between CPU and DRAM, Channel 0: board-dependent
**/
  UINT8                       DqByteMapCh0[12];

/** Offset 0x0056 - Dq Byte Map CH1
  Dq byte mapping between CPU and DRAM, Channel 1: board-dependent
**/
  UINT8                       DqByteMapCh1[12];

/** Offset 0x0062 - Dqs Map CPU to DRAM CH 0
  Set Dqs mapping relationship between CPU and DRAM, Channel 0: board-dependent
**/
  UINT8                       DqsMapCpu2DramCh0[8];

/** Offset 0x006A - Dqs Map CPU to DRAM CH 1
  Set Dqs mapping relationship between CPU and DRAM, Channel 1: board-dependent
**/
  UINT8                       DqsMapCpu2DramCh1[8];

/** Offset 0x0072 - RcompResister settings
  Indicates  RcompReister settings: Board-dependent
**/
  UINT16                      RcompResistor[3];

/** Offset 0x0078 - RcompTarget settings
  RcompTarget settings: board-dependent
**/
  UINT16                      RcompTarget[5];

/** Offset 0x0082 - Dqs Pins Interleaved Setting
  Indicates DqPinsInterleaved setting: board-dependent
  $EN_DIS
**/
  UINT8                       DqPinsInterleaved;

/** Offset 0x0083 - VREF_CA
  CA Vref routing: board-dependent
  0:VREF_CA goes to both CH_A and CH_B, 1: VREF_CA to CH_A and VREF_DQ_A to CH_B, 2:VREF_CA to CH_A and VREF_DQ_B to CH_B
**/
  UINT8                       CaVrefConfig;

/** Offset 0x0084 - Smram Mask
  The SMM Regions AB-SEG and/or H-SEG reserved
  0: Neither, 1:AB-SEG, 2:H-SEG, 3: Both
**/
  UINT8                       SmramMask;

/** Offset 0x0085 - MRC Fast Boot
  Enables/Disable the MRC fast path thru the MRC
  $EN_DIS
**/
  UINT8                       MrcFastBoot;

/** Offset 0x0086
**/
  UINT16                      UnusedUpdSpace1;

/** Offset 0x0088 - Intel Enhanced Debug
  Intel Enhanced Debug (IED): 0=Disabled, 0x400000=Enabled and 4MB SMRAM occupied
  0 : Disable, 0x400000 : Enable
**/
  UINT32                      IedSize;

/** Offset 0x008C - Tseg Size
  Size of SMRAM memory reserved. 0x400000 for Release build and 0x1000000 for Debug build
  0x0400000:4MB, 0x01000000:16MB
**/
  UINT32                      TsegSize;

/** Offset 0x0090 - MMIO Size
  Size of memory address space reserved for MMIO (Memory Mapped I/O) in MB.
  0x0600 : 0x0600
**/
  UINT16                      MmioSize;

/** Offset 0x0092 - Probeless Trace
  Probeless Trace: 0=Disabled, 1=Enable. Enabling Probeless Trace will reserve 128MB. This also requires IED to be enabled.
  $EN_DIS
**/
  UINT8                       ProbelessTrace;

/** Offset 0x0093
**/
  UINT8                       UnusedUpdSpace2[3];

/** Offset 0x0096 - Enable Trace Hub
  Enable/disable Trace Hub function.
  $EN_DIS
**/
  UINT8                       EnableTraceHub;

/** Offset 0x0097
**/
  UINT8                       UnusedUpdSpace3[60];

/** Offset 0x00D3 - Internal Graphics Pre-allocated Memory
  Size of memory preallocated for internal graphics.
  0x00:0 MB, 0x01:32 MB, 0x02:64 MB, 0x03:128 MB, 0x04:256 MB,  0x05:512 MB
**/
  UINT8                       IgdDvmt50PreAlloc;

/** Offset 0x00D4 - Internal Graphics
  Enable/disable internal graphics.
  $EN_DIS
**/
  UINT8                       InternalGfx;

/** Offset 0x00D5 - Aperture Size
  Select the Aperture Size.
  0:128 MB, 1:256 MB, 2:512 MB
**/
  UINT8                       ApertureSize;

/** Offset 0x00D6 - SA GV
  System Agent dynamic frequency support and when enabled memory will be training at two different frequencies. Only effects ULX/ULT CPUs. 0=Disabled, 1=FixedLow, 2=FixedHigh, and 3=Enabled.
  0:Disabled, 1:FixedLow, 2:FixedHigh, 3:Enabled
**/
  UINT8                       SaGv;

/** Offset 0x00D7 - Rank Margin Tool
  Enable/disable Rank Margin Tool.
  $EN_DIS
**/
  UINT8                       RMT;

/** Offset 0x00D8 - DDR Frequency Limit
  Maximum Memory Frequency Selections in Mhz. Options are 1067, 1333, 1600, 1867, 2133, 2400 and 0 for Auto.
  1067:1067, 1333:1333, 1600:1600, 1867:1867, 2133:2133, 2400:2400, 0:Auto
**/
  UINT16                      DdrFreqLimit;

/** Offset 0x00DA - Board Type
  MrcBoardType, Options are 0=Mobile/Mobile Halo, 1=Desktop/DT Halo, 5=ULT/ULX/Mobile Halo, 7=UP Server
  0:Mobile/Mobile Halo, 1:Desktop/DT Halo, 5:ULT/ULX/Mobile Halo, 7:UP Server
**/
  UINT8                       UserBd;

/** Offset 0x00DB
**/
  UINT8                       UnusedUpdSpace4[105];

/** Offset 0x0144 - MMA Test Content Pointer
  Pointer to MMA Test Content in Memory
**/
  UINT32                      MmaTestContentPtr;

/** Offset 0x0148 - MMA Test Content Size
  Size of MMA Test Content in Memory
**/
  UINT32                      MmaTestContentSize;

/** Offset 0x014C - MMA Test Config Pointer
  Pointer to MMA Test Config in Memory
**/
  UINT32                      MmaTestConfigPtr;

/** Offset 0x0150 - MMA Test Config Size
  Size of MMA Test Config in Memory
**/
  UINT32                      MmaTestConfigSize;

/** Offset 0x0154
**/
  UINT32                      FspCarBase;

/** Offset 0x0158
**/
  UINT32                      FspCarSize;

/** Offset 0x015C - SMBUS SPD Write Disable
  Set/Clear Smbus SPD Write Disable. 0: leave SPD Write Disable bit; 1: set SPD Write Disable bit. For security recommendations, SPD write disable bit must be set.
  $EN_DIS
**/
  UINT8                       SmbusSpdWriteDisable;

/** Offset 0x015D
**/
  UINT8                       ReservedMemoryInitUpd[163];
} MEMORY_INIT_UPD;

/** UPD data structure for FspSiliconInitApi
**/
typedef struct {

/** Offset 0x0200
**/
  UINT64                      Signature;

/** Offset 0x0208 - Revision
  Revision version of the SiliconInitUpd Region
**/
  UINT8                       Revision;

/** Offset 0x0209
**/
  UINT8                       UnusedUpdSpace5[7];

/** Offset 0x0210 - Logo Pointer
  Points to PEI Display Logo Image
  0 : 0
**/
  UINT32                      LogoPtr;

/** Offset 0x0214 - Logo Size
  Size of PEI Display Logo Image
  0 : 0
**/
  UINT32                      LogoSize;

/** Offset 0x0218 - Graphics Configuration Ptr
  Points to VBT
  0 : 0
**/
  UINT32                      GraphicsConfigPtr;

/** Offset 0x021C - Enable Device 4
  Enable/disable Device 4
  $EN_DIS
**/
  UINT8                       Device4Enable;

/** Offset 0x021D - Enable Azalia
  Enable/disable Azalia controller.
  $EN_DIS
**/
  UINT8                       EnableAzalia;

/** Offset 0x021E - Enable HD Audio DSP
  Enable/disable HD Audio DSP feature.
  $EN_DIS
**/
  UINT8                       DspEnable;

/** Offset 0x021F - Select HDAudio IoBuffer Ownership
  Indicates the ownership of the I/O buffer between Intel HD Audio link vs I2S0 / I2S port. 0: Intel HD-Audio link owns all the I/O buffers. 1: Intel HD-Audio link owns 4 of the I/O buffers for 1 HD-Audio codec connection, and I2S1 port owns 4 of the I/O buffers for 1 I2S codec connection. 2: Reserved. 3: I2S0 and I2S1 ports own all the I/O buffers.
  0:HD-A Link, 1:Shared HD-A Link and I2S Port, 3:I2S Ports
**/
  UINT8                       IoBufferOwnership;

/** Offset 0x0220 - Enable CIO2 Controller
  Enable/disable SKYCAM CIO2 Controller.
  $EN_DIS
**/
  UINT8                       Cio2Enable;

/** Offset 0x0221 - Enable eMMC Controller
  Enable/disable eMMC Controller.
  $EN_DIS
**/
  UINT8                       ScsEmmcEnabled;

/** Offset 0x0222 - Enable eMMC HS400 Mode
  Enable eMMC HS400 Mode.
  $EN_DIS
**/
  UINT8                       ScsEmmcHs400Enabled;

/** Offset 0x0223 - Enable SdCard Controller
  Enable/disable SD Card Controller.
  $EN_DIS
**/
  UINT8                       ScsSdCardEnabled;

/** Offset 0x0224 - Enable ISH Controller
  Enable/disable ISH Controller.
  $EN_DIS
**/
  UINT8                       IshEnable;

/** Offset 0x0225 - Show SPI controller
  Enable/disable to show SPI controller.
  $EN_DIS
**/
  UINT8                       ShowSpiController;

/** Offset 0x0226 - HSIO HECI Messaging
  Enable/Disable. 0: Disable, prevent the HSIO version check and HSIO init messages from being sent, 1: enable
  $EN_DIS
**/
  UINT8                       HsioMessaging;

/** Offset 0x0227 - HECI3 state
  The HECI3 state from Mbp for reference in S3 path or when MbpHob is not installed. This must be enabled if Integrated Touch (iTouch) is supported. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       Heci3Enabled;

/** Offset 0x0228 - MicrocodeRegionBase
  Memory Base of Microcode Updates
**/
  UINT32                      MicrocodeRegionBase;

/** Offset 0x022C - MicrocodeRegionSize
  Size of Microcode Updates
**/
  UINT32                      MicrocodeRegionSize;

/** Offset 0x0230 - Turbo Mode
  Enable/Disable Turbo mode. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       TurboMode;

/** Offset 0x0231 - Enable SATA SALP Support
  Enable/disable SATA Aggressive Link Power Management.
  $EN_DIS
**/
  UINT8                       SataSalpSupport;

/** Offset 0x0232 - Enable SATA ports
  Enable/disable SATA ports. One byte for each port, byte0 for port0, byte1 for port1, and so on.
**/
  UINT8                       SataPortsEnable[8];

/** Offset 0x023A - Enable SATA DEVSLP Feature
  Enable/disable SATA DEVSLP per port. 0 is disable, 1 is enable. One byte for each port, byte0 for port0, byte1 for port1, and so on.
**/
  UINT8                       SataPortsDevSlp[8];

/** Offset 0x0242 - Enable USB2 ports
  Enable/disable per USB2 ports. One byte for each port, byte0 for port0, byte1 for port1, and so on.
**/
  UINT8                       PortUsb20Enable[16];

/** Offset 0x0252 - Enable USB3 ports
  Enable/disable per USB3 ports. One byte for each port, byte0 for port0, byte1 for port1, and so on.
**/
  UINT8                       PortUsb30Enable[10];

/** Offset 0x025C - Enable xDCI controller
  Enable/disable to xDCI controller.
  $EN_DIS
**/
  UINT8                       XdciEnable;

/** Offset 0x025D - Enable XHCI SSIC Eanble
  Enable/disable XHCI SSIC port.
  $EN_DIS
**/
  UINT8                       SsicPortEnable;

/** Offset 0x025E - Enable SMBus
  Enable/disable SMBus controller.
  $EN_DIS
**/
  UINT8                       SmbusEnable;

/** Offset 0x025F - Enable SerialIo Device Mode
  0:Disabled, 1:ACPI Mode, 2:PCI Mode, 3:Hidden mode, 4:Legacy UART mode - Enable/disable SerialIo I2C0,I2C1,I2C2,I2C3,I2C4,I2C5,SPI0,SPI1,UART0,UART1,UART2 device mode respectively. One byte for each controller, byte0 for I2C0, byte1 for I2C1, and so on.
**/
  UINT8                       SerialIoDevMode[11];

/** Offset 0x026A - Address of PCH_DEVICE_INTERRUPT_CONFIG table.
  The address of the table of PCH_DEVICE_INTERRUPT_CONFIG.
**/
  UINT32                      DevIntConfigPtr;

/** Offset 0x026E - Number of DevIntConfig Entry
  Number of Device Interrupt Configuration Entry. If this is not zero, the DevIntConfigPtr must not be NULL.
**/
  UINT8                       NumOfDevIntConfig;

/** Offset 0x026F - PIRQx to IRQx Map Config
  PIRQx to IRQx mapping. The valid value is 0x00 to 0x0F for each. First byte is for PIRQA, second byte is for PIRQB, and so on. The setting is only available in Legacy 8259 PCI mode.
**/
  UINT8                       PxRcConfig[8];

/** Offset 0x0277 - Select GPIO IRQ Route
  GPIO IRQ Select. The valid value is 14 or 15.
  0 : 0xFF
**/
  UINT8                       GpioIrqRoute;

/** Offset 0x0278 - Select SciIrqSelect
  SCI IRQ Select. The valid value is 9, 10, 11, and 20, 21, 22, 23 for APIC only.
  0 : 0xFF
**/
  UINT8                       SciIrqSelect;

/** Offset 0x0279 - Select TcoIrqSelect
  TCO IRQ Select. The valid value is 9, 10, 11, 20, 21, 22, 23.
  0 : 0xFF
**/
  UINT8                       TcoIrqSelect;

/** Offset 0x027A - Enable/Disable Tco IRQ
  Enable/disable TCO IRQ
  $EN_DIS
**/
  UINT8                       TcoIrqEnable;

/** Offset 0x027B - AzaliaVerbTableNumEntries
  Number of Entries in Azalia Verb Table
**/
  UINT8                       AzaliaVerbTableNumEntries;

/** Offset 0x027C - AzaliaVerbTablePtr
  Pointer to Array of pointers to Codec Table.
**/
  UINT32                      AzaliaVerbTablePtr;

/** Offset 0x0280 - RTC CMOS RAM LOCK
  Enable RTC lower and upper 128 byte Lock bits to lock Bytes 38h-3Fh in the upper and and lower 128-byte bank of RTC RAM.
  $EN_DIS
**/
  UINT8                       LockDownConfigRtcLock;

/** Offset 0x0281 - Enable SATA
  Enable/disable SATA controller.
  $EN_DIS
**/
  UINT8                       EnableSata;

/** Offset 0x0282 - SATA Mode
  Select SATA controller working mode.
  0:AHCI, 1:RAID
**/
  UINT8                       SataMode;

/** Offset 0x0283 - USB Per Port HS Preemphasis Bias
  USB Per Port HS Preemphasis Bias. 000b-0mV, 001b-11.25mV, 010b-16.9mV, 011b-28.15mV, 100b-28.15mV, 101b-39.35mV, 110b-45mV, 111b-56.3mV. One byte for each port.
**/
  UINT8                       Usb2AfePetxiset[16];

/** Offset 0x0293 - USB Per Port HS Transmitter Bias
  USB Per Port HS Transmitter Bias. 000b-0mV, 001b-11.25mV, 010b-16.9mV, 011b-28.15mV, 100b-28.15mV, 101b-39.35mV, 110b-45mV, 111b-56.3mV, One byte for each port.
**/
  UINT8                       Usb2AfeTxiset[16];

/** Offset 0x02A3 - USB Per Port HS Transmitter Emphasis
  USB Per Port HS Transmitter Emphasis. 00b - Emphasis OFF, 01b - De-emphasis ON, 10b - Pre-emphasis ON, 11b - Pre-emphasis & De-emphasis ON. One byte for each port.
**/
  UINT8                       Usb2AfePredeemp[16];

/** Offset 0x02B3 - USB Per Port Half Bit Pre-emphasis
  USB Per Port Half Bit Pre-emphasis. 1b - half-bit pre-emphasis, 0b - full-bit pre-emphasis. One byte for each port.
**/
  UINT8                       Usb2AfePehalfbit[16];

/** Offset 0x02C3 - Enable the write to USB 3.0 TX Output -3.5dB De-Emphasis Adjustment
  Enable the write to USB 3.0 TX Output -3.5dB De-Emphasis Adjustment. Each value in arrary can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxDeEmphEnable[10];

/** Offset 0x02CD - USB 3.0 TX Output -3.5dB De-Emphasis Adjustment Setting
  USB 3.0 TX Output -3.5dB De-Emphasis Adjustment Setting, HSIO_TX_DWORD5[21:16], <b>Default = 29h</b> (approximately -3.5dB De-Emphasis). One byte for each port.
**/
  UINT8                       Usb3HsioTxDeEmph[10];

/** Offset 0x02D7 - Enable the write to USB 3.0 TX Output Downscale Amplitude Adjustment
  Enable the write to USB 3.0 TX Output Downscale Amplitude Adjustment, Each value in arrary can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxDownscaleAmpEnable[10];

/** Offset 0x02E1 - USB 3.0 TX Output Downscale Amplitude Adjustment
  USB 3.0 TX Output Downscale Amplitude Adjustment, HSIO_TX_DWORD8[21:16], <b>Default = 00h</b>. One byte for each port.
**/
  UINT8                       Usb3HsioTxDownscaleAmp[10];

/** Offset 0x02EB - Enable PCIE RP
  Enable/disable PCIE Root Ports. 0: disable, 1: enable. One byte for each port, byte0 for port1, byte1 for port2, and so on.
**/
  UINT8                       PcieRpEnable[20];

/** Offset 0x02FF - Enable PCIE RP PMSCI
  Indicate whether the root port power manager SCI is enabled - 0: disable, 1: enable. One byte for each port, byte0 for port1, byte1 for port2, and so on.
**/
  UINT8                       PcieRpPmSci[20];

/** Offset 0x0313 - Enable PCIE RP CLKREQ Support
  Enable/disable PCIE Root Port CLKREQ support. 0: disable, 1: enable. One byte for each port, byte0 for port1, byte1 for port2, and so on.
**/
  UINT8                       PcieRpClkReqSupport[20];

/** Offset 0x0327 - Configure CLKREQ Number
  Configure Root Port CLKREQ Number if CLKREQ is supported. Each value in arrary can be between 0-6. One byte for each port, byte0 for port1, byte1 for port2, and so on.
**/
  UINT8                       PcieRpClkReqNumber[20];

/** Offset 0x033B - Enable LAN
  Enable/Disable LAN controller.
  $EN_DIS
**/
  UINT8                       EnableLan;

/** Offset 0x033C - LAN LTR Programming
  Enable/Disable LTR capabilty of PCH internal LAN.
  $EN_DIS
**/
  UINT8                       LanLtrEnable;

/** Offset 0x033D - SATA eSATASpeedLimit
  When enabled, BIOS will configure the PxSCTL.SPD to 2 to limit the eSATA port speed. 0: disable, 1: enable. 
  $EN_DIS
**/
  UINT8                       eSATASpeedLimit;

/** Offset 0x033E - SATA RST RAID0
  Enable/Disable RAID0.
  $EN_DIS
**/
  UINT8                       SataRstRaid0;

/** Offset 0x033F - SATA RST RAID1
  Enable/Disable RAID1.
  $EN_DIS
**/
  UINT8                       SataRstRaid1;

/** Offset 0x0340 - SATA RST RAID10
  Enable/Disable RAID10.
  $EN_DIS
**/
  UINT8                       SataRstRaid10;

/** Offset 0x0341 - SATA RST RAID5
  Enable/Disable RAID5.
  $EN_DIS
**/
  UINT8                       SataRstRaid5;

/** Offset 0x0342 - Skip Multi-Processor Initialization
  When this is skipped, boot loader must initialize processors before SilicionInit API. 0: Initialize, 1: Skip
  $EN_DIS
**/
  UINT8                       SkipMpInit;

/** Offset 0x0343 - Enable PCIE RP HotPlug
  Enable/disable PCIE Root Ports HogPlug. 0: disable, 1: enable. One byte for each port, byte0 for port1, byte1 for port2, and so on.
**/
  UINT8                       PcieRpHotPlug[20];

/** Offset 0x0357 - Enable PCIE RP Function Swap
  Enable/disable PCIE RP function swap. 0: disable, 1: enable. It allows BIOS to use root port function number swapping when root port of function 0 is disabled. NOTE: This option will not work if ports 1, 9, 17 are fused or configured for RST PCIe storage. Disabling function swap may have adverse impact on power management.
  $EN_DIS
**/
  UINT8                       RpFunctionSwap;

/** Offset 0x0358 - USB2 Port Over Current Configuration
  Configure over current pin assignment per USB2 ports. Refer to USB_OVERCURRENT_PIN. 0x08 means "skip over current pin". One byte for each port, byte0 for port0, byte1 for port1, and so on.
**/
  UINT8                       Usb2OverCurrentPin[16];

/** Offset 0x0368 - USB3 Port Over Current Configuration
  Configure over current pin assignment per USB3 ports. Refer to USB_OVERCURRENT_PIN. 0x08 means "skip over current pin". One byte for each port, byte0 for port0, byte1 for port1, and so on.
**/
  UINT8                       Usb3OverCurrentPin[10];

/** Offset 0x0372 - Psi1Threshold
  Power State 1 current cuttof in 1/4 Amp increments. Range is 0-128A. Array index maps to VR 0 = System Agent, 1 = IA Core, 2 = Ring, 3 = GT unsliced,  4 = GT sliced
**/
  UINT16                      Psi1Threshold[5];

/** Offset 0x037C - Psi2Threshold
  Power State 2 current cuttof in 1/4 Amp increments. Range is 0-128A. Array index maps to VR 0 = System Agent, 1 = IA Core, 2 = Ring, 3 = GT unsliced,  4 = GT sliced
**/
  UINT16                      Psi2Threshold[5];

/** Offset 0x0386 - Psi3Threshold
  State 3 current cuttof in 1/4 Amp increments. Range is 0-128A. Array index maps to VR 0 = System Agent, 1 = IA Core, 2 = Ring, 3 = GT unsliced,  4 = GT sliced
**/
  UINT16                      Psi3Threshold[5];

/** Offset 0x0390 - Psi3Enable
  Power State 3 0: Disable 1: Enable. Array index maps to VR 0 = System Agent, 1 = IA Core, 2 = Ring, 3 = GT unsliced,  4 = GT sliced
**/
  UINT8                       Psi3Enable[5];

/** Offset 0x0395 - Psi4Enable
  Power State 4 0: Disable 1: Enable. Array index maps to VR 0 = System Agent, 1 = IA Core, 2 = Ring, 3 = GT unsliced,  4 = GT sliced
**/
  UINT8                       Psi4Enable[5];

/** Offset 0x039A - ImonSlope
  Imon slope correction. Specified in 1/100 increment values. Range is 0-200. 125 = 1.25. 0: Auto Array index maps to VR 0 = System Agent, 1 = IA Core, 2 = Ring, 3 = GT unsliced,  4 = GT sliced
**/
  UINT8                       ImonSlope[5];

/** Offset 0x039F - ImonOffset
  Imon offset correction. Units 1/4, Range 0-255. Value of 100 = 100/4 = 25 offset. 0: Auto Array index maps to VR 0 = System Agent, 1 = IA Core, 2 = Ring, 3 = GT unsliced,  4 = GT sliced
**/
  UINT8                       ImonOffset[5];

/** Offset 0x03A4 - IccMax
  VR Icc Max limit. 0-255A in 1/4 A units. 400 = 100A Array index maps to VR 0 = System Agent, 1 = IA Core, 2 = Ring, 3 = GT unsliced,  4 = GT sliced
**/
  UINT16                      IccMax[5];

/** Offset 0x03AE - VrVoltageLimit
  VR Voltage Limit. Range is 0-7999mV. Array index maps to VR 0 = System Agent, 1 = IA Core, 2 = Ring, 3 = GT unsliced,  4 = GT sliced
**/
  UINT16                      VrVoltageLimit[5];

/** Offset 0x03B8 - VrConfigEnable
  BIOS configuration of VR 0: Disable 1: Enable. Array index maps to VR 0 = System Agent, 1 = IA Core, 2 = Ring, 3 = GT unsliced,  4 = GT sliced
**/
  UINT8                       VrConfigEnable[5];

/** Offset 0x03BD - CPU S3 Resume Data
  CPU S3 Resume Data passed from the FSP CPU S3 Resume HOB during normal boot.
**/
  UINT32                      CpuS3ResumeHobData;

/** Offset 0x03C1 - CpuS3ResumeMtrrData
  Pointer CPU S3 Resume MTRR Data
**/
  UINT32                      CpuS3ResumeMtrrData;

/** Offset 0x03C5 - CpuS3ResumeMtrrDataSize
  Size of S3 resume MTRR data.
**/
  UINT16                      CpuS3ResumeMtrrDataSize;

/** Offset 0x03C7 - Lock Down Config Global Smi
  Enable SMI_LOCK bit to prevent writes to the Global SMI Enable bit. Value 0: Disable, 1: Enable.
  $EN_DIS
**/
  UINT8                       LockDownConfigGlobalSmi;

/** Offset 0x03C8 - Lock Down Config Bios Interface
  Enable BIOS Interface Lock Down bit to prevent writes to the Backup Control Register. Top Swap bit and the General Control and Status Registers Boot BIOS Straps. Value 0: Disable, 1: Enable.
  $EN_DIS
**/
  UINT8                       LockDownConfigBiosInterface;

/** Offset 0x03C9 - Lock Down Config Bios Lock
  When enabled, the BIOS Region can only be modified from SMM after EndOfDxe protocol is installed. Value 0: Disable, 1: Enable.
  $EN_DIS
**/
  UINT8                       LockDownConfigBiosLock;

/** Offset 0x03CA - Lock Down Config Spi Eiss
  Enable InSMM.STS (EISS) in SPI If this bit is set, then WPD must be a '1' and InSMM.STS must be '1' also in order to write to BIOS regions of SPI Flash. If this bit is clear, then the InSMM.STS is a don't care. The BIOS must set the EISS bit while BIOS Guard support is enabled. Value 0: Clear EISS bit, 1: Set EISS bit.
  $EN_DIS
**/
  UINT8                       LockDownConfigSpiEiss;

/** Offset 0x03CB - Subsystem Vendor ID
  Subsystem Vendor ID of the PCH devices.
**/
  UINT16                      PchConfigSubSystemVendorId;

/** Offset 0x03CD - Subsystem ID
  Subsystem ID of the PCH devices.
**/
  UINT16                      PchConfigSubSystemId;

/** Offset 0x03CF - Wol Enable Override
  Corresponds to the "WOL Enable Override" bit in the General PM Configuration B (GEN_PMCON_B) register. Value 0: Disable, 1: Enable.
  $EN_DIS
**/
  UINT8                       WakeConfigWolEnableOverride;

/** Offset 0x03D0 - Pcie Wake From DeepSx
  Determine if enable PCIe to wake from deep Sx. Value 0: Disable, 1: Enable.
  $EN_DIS
**/
  UINT8                       WakeConfigPcieWakeFromDeepSx;

/** Offset 0x03D1 - Power Management DeepSxPolicy
  Deep Sx Policy. Values 0: PchDeepSxPolDisable, 1: PchDpS5BatteryEn, 2: PchDpS5AlwaysEn, 3: PchDpS4S5BatteryEn, 4: PchDpS4S5AlwaysEn, 5: PchDpS3S4S5BatteryEn, 6: PchDpS3S4S5AlwaysEn.
  0 : 0x06
**/
  UINT8                       PmConfigDeepSxPol;

/** Offset 0x03D2 - Power Management SlpS3MinAssert
  SLP_S3 Minimum Assertion Width Policy. Values 0: PchSlpS360us, 1: PchSlpS31ms, 2: PchSlpS350ms, 3: PchSlpS32s.
  0 : 0x03
**/
  UINT8                       PmConfigSlpS3MinAssert;

/** Offset 0x03D3 - Power Management SlpS4MinAssert
  SLP_S4 Minimum Assertion Width Policy. Values 0: PchSlpS4PchTime, 1: PchSlpS41s, 2: PchSlpS42s, 3: PchSlpS43s, 4: PchSlpS44s.
  0 : 0x04
**/
  UINT8                       PmConfigSlpS4MinAssert;

/** Offset 0x03D4 - Power Management SlpSusMinAssert
  SLP_SUS Minimum Assertion Width Policy. Values 0: PchSlpSus0ms, 1: PchSlpSus500ms, 2: PchSlpSus1s, 3: PchSlpSus4s.
  0 : 0x03
**/
  UINT8                       PmConfigSlpSusMinAssert;

/** Offset 0x03D5 - Power Management SlpAMinAssert
  SLP_A Minimum Assertion Width Policy. Values 0: PchSlpA0ms, 1: PchSlpA4s, 2: PchSlpA98ms, 3: PchSlpA2s.
  0 : 0x03
**/
  UINT8                       PmConfigSlpAMinAssert;

/** Offset 0x03D6 - Power Management Pci Clock Run
  This member describes whether or not the PCI ClockRun feature of PCH should be enabled. Values 0: Disabled, 1: Enabled
  $EN_DIS
**/
  UINT8                       PmConfigPciClockRun;

/** Offset 0x03D7 - Power Management SLP_X Stretching After SUS Well
  SLP_X Stretching After SUS Well Power Up. Values 0: Disabled, 1: Enabled
  $EN_DIS
**/
  UINT8                       PmConfigSlpStrchSusUp;

/** Offset 0x03D8 - Power Management Power Button Override Period
  PCH power button override period. Values: 0x0 - 4s, 0x1 - 6s, 0x2 - 8s, 0x3 - 10s, 0x4 - 12s, 0x5 - 14s.
  0 : 0x05
**/
  UINT8                       PmConfigPwrBtnOverridePeriod;

/** Offset 0x03D9 - Power Management Power Reset Power Cycle Duration
  Reset Power Cycle Duration could be customized in the unit of second. PCH HW default is 4 seconds, and range is 1~4 seconds. Values: 0x0 - 0s, 0x1 - 1s, 0x2 - 2s, 0x3 - 3s, 0x4 - 4s.
  0 : 0x04
**/
  UINT8                       PmConfigPwrCycDur;

/** Offset 0x03DA - PCH Serial IRQ Configuration
  Determines if enable Serial IRQ. Values 0: Disabled, 1: Enabled
  $EN_DIS
**/
  UINT8                       SerialIrqConfigSirqEnable;

/** Offset 0x03DB - PCH Serial IRQ Mode Select
  Serial IRQ Mode Select. Values: 0: PchQuietMode, 1: PchContinuousMode.
  0 : 0x01
**/
  UINT8                       SerialIrqConfigSirqMode;

/** Offset 0x03DC - PCH Serial IRQ Start Frame Pulse Width
  Start Frame Pulse Width. Values: 0: PchSfpw4Clk, 1: PchSfpw6Clk, 2: PchSfpw8Clk.
  0 : 0x02
**/
  UINT8                       SerialIrqConfigStartFramePulse;

/** Offset 0x03DD - PSF Unlock
  The PSF registers will be locked before 3rd party code execution. This policy unlock the PSF space. NOTE: Do not set this policy "PsfUnlock" unless necessary.
  $EN_DIS
**/
  UINT8                       PsfUnlock;

/** Offset 0x03DE - IO voltage for I2C controllers
  Selects the IO voltage for I2C controllers, 0: PchSerialIoIs33V, 1: PchSerialIoIs18V.
**/
  UINT8                       SerialIoI2cVoltage[6];

/** Offset 0x03E4 - Enable 8254 Static Clock Gating in early POST time
  Set 8254CGE=1 is required for C11 support. However, set 8254CGE=1 in POST time might fail to boot legacy OS which using 8254 timer. Make sure it won't break legacy OS boot before enabling this.
  $EN_DIS
**/
  UINT8                       Early8254ClockGatingEnable;

/** Offset 0x03E5 - Enable VR specific mailbox command
  VR specific mailbox commands, 000b: no VR specific command sent, 001b: A VR mailbox command specifically for the MPS IMPV8 VR will be sent, 010b: VR specific command sent for PS4 exit issue, 011b: VR specific command sent for both MPS IMPV8 & PS4 exit issue.
  $EN_DIS
**/
  UINT8                       SendVrMbxCmd;

/** Offset 0x03E6
**/
  UINT8                       AcousticNoiseMitigation;

/** Offset 0x03E7
**/
  UINT8                       SlowSlewRateForIa;

/** Offset 0x03E8
**/
  UINT8                       SlowSlewRateForGt;

/** Offset 0x03E9
**/
  UINT8                       SlowSlewRateForSa;

/** Offset 0x03EA
**/
  UINT8                       FastPkgCRampDisable;

/** Offset 0x03EB
**/
  UINT8                       ReservedSiliconInitUpd[15];
} SILICON_INIT_UPD;

#define FSP_UPD_SIGNATURE                0x244450554C4B5324        /* '$SKLUPD$' */
#define FSP_MEMORY_INIT_UPD_SIGNATURE    0x244450554D454D24        /* '$MEMUPD$' */
#define FSP_SILICON_INIT_UPD_SIGNATURE   0x244450555F495324        /* '$SI_UPD$' */

/** UPD data structure. The UPD_DATA_REGION may contain some reserved or unused fields in the data structure. These fields are required to use the default values provided in the FSP binary. Intel always recommends copying the whole UPD_DATA_REGION from the flash to a local structure in the stack before overriding any field.
**/
typedef struct {

/** Offset 0x0000
**/
  UINT64                      Signature;

/** Offset 0x0008 - This field is not an option and is a Revision of the UPD_DATA_REGION. It can be used by the boot loader to validate the UPD region. If the value in this field is changed for an FSP release, the boot loader should not assume the same layout for the UPD_DATA_REGION data structure. Instead it should use the new FspUpdVpd.h from the FSP release package.
  Size of SMRAM memory reserved. 0x400000 for Release build and 0x1000000 for Debug build
**/
  UINT8                       Revision;

/** Offset 0x0009
**/
  UINT8                       ReservedUpd0[7];

/** Offset 0x0010 - MemoryInitUpdOffset
  This field contains the offset of the MemoryInitUpd structure relative to UPD_DATA_REGION
**/
  UINT32                      MemoryInitUpdOffset;

/** Offset 0x0014 - SiliconInitUpdOffset
  This field contains the offset of the SiliconInitUpd structure relative to UPD_DATA_REGION
**/
  UINT32                      SiliconInitUpdOffset;

/** Offset 0x0018
**/
  UINT64                      ReservedUpd1;

/** Offset 0x0020
**/
  MEMORY_INIT_UPD             MemoryInitUpd;

/** Offset 0x0200
**/
  SILICON_INIT_UPD            SiliconInitUpd;

/** Offset 0x03FA - RegionTerminator
  This field is not an option and is a termination field at the end of the data structure. This field is will have a value 0x55AA indicating the end of UPD data.The boot loader should never override this field.
**/
  UINT16                      RegionTerminator;
} UPD_DATA_REGION;

#define FSP_IMAGE_ID    0x245053464C4B5324        /* '$SKLFSP$' */
#define FSP_IMAGE_REV   0x01090000 

/** VPD data structure
**/
typedef struct {

/** Offset 0x0000
**/
  UINT64                      PcdVpdRegionSign;

/** Offset 0x0008 - PcdImageRevision
  This field is not an option and is a revision ID for the FSP release. It can be used by the boot loader to validate the VPD/UPD region. If the value in this field is changed for an FSP release, the boot loader should not assume the same layout for the UPD_DATA_REGION/VPD_DATA_REGION data structure. Instead it should use the new FspUpdVpd.h from the FSP release package.  This should match the ImageRevision in FSP_INFO_HEADER.
**/
  UINT32                      PcdImageRevision;

/** Offset 0x000C
**/
  UINT32                      PcdUpdRegionOffset;

/** Offset 0x0010
**/
  UINT8                       UnusedVpdSpace0[32];

/** Offset 0x0030 - PcdSerialIoUartDebugEnable
  Enable SerialIo Uart debug library with/without initializing SerialIo Uart device in FSP. 
  0:Disable, 1:Enable and Initialize, 2:Enable without Initializing
**/
  UINT8                       PcdSerialIoUartDebugEnable;

/** Offset 0x0031 - PcdSerialIoUartNumber
  Select SerialIo Uart Controller for debug.
  0:SerialIoUart0, 1:SerialIoUart1, 2:SerialIoUart2
**/
  UINT8                       PcdSerialIoUartNumber;

/** Offset 0x0032
**/
  UINT32                      PcdSerialIoUartInputClock;
} VPD_DATA_REGION;

#pragma pack(pop)

#endif
