/** @file

Copyright (c) 2017, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPSUPD_H__
#define __FSPSUPD_H__

#include <FspUpd.h>

#pragma pack(1)


///
/// Azalia Header structure
///
typedef struct {
  UINT16 VendorId;           ///< Codec Vendor ID
  UINT16 DeviceId;           ///< Codec Device ID
  UINT8  RevisionId;         ///< Revision ID of the codec. 0xFF matches any revision.
  UINT8  SdiNum;             ///< SDI number, 0xFF matches any SDI.
  UINT16 DataDwords;         ///< Number of data DWORDs pointed by the codec data buffer.
  UINT32 Reserved;           ///< Reserved for future use. Must be set to 0.
} AZALIA_HEADER;

///
/// Audio Azalia Verb Table structure
///
typedef struct {
  AZALIA_HEADER Header;      ///< AZALIA PCH header
  UINT32        *Data;       ///< Pointer to the data buffer. Its length is specified in the header
} AUDIO_AZALIA_VERB_TABLE;

///
/// Refer to the definition of PCH_INT_PIN
///
typedef enum {
  SiPchNoInt,        ///< No Interrupt Pin
  SiPchIntA,
  SiPchIntB,
  SiPchIntC,
  SiPchIntD
} SI_PCH_INT_PIN;
///
/// The PCH_DEVICE_INTERRUPT_CONFIG block describes interrupt pin, IRQ and interrupt mode for PCH device.
///
typedef struct {
  UINT8        Device;                  ///< Device number
  UINT8        Function;                ///< Device function
  UINT8        IntX;                    ///< Interrupt pin: INTA-INTD (see SI_PCH_INT_PIN)
  UINT8        Irq;                     ///< IRQ to be set for device.
} SI_PCH_DEVICE_INTERRUPT_CONFIG;

#define SI_PCH_MAX_DEVICE_INTERRUPT_CONFIG  64       ///< Number of all PCH devices


/** Fsp S Configuration
**/
typedef struct {

/** Offset 0x0020 - Logo Pointer
  Points to PEI Display Logo Image
**/
  UINT32                      LogoPtr;

/** Offset 0x0024 - Logo Size
  Size of PEI Display Logo Image
**/
  UINT32                      LogoSize;

/** Offset 0x0028 - Graphics Configuration Ptr
  Points to VBT
**/
  UINT32                      GraphicsConfigPtr;

/** Offset 0x002C - Enable Device 4
  Enable/disable Device 4
  $EN_DIS
**/
  UINT8                       Device4Enable;

/** Offset 0x002D - Enable HD Audio DSP
  Enable/disable HD Audio DSP feature.
  $EN_DIS
**/
  UINT8                       PchHdaDspEnable;

/** Offset 0x002E
**/
  UINT8                       UnusedUpdSpace0[3];

/** Offset 0x0031 - Enable eMMC Controller
  Enable/disable eMMC Controller.
  $EN_DIS
**/
  UINT8                       ScsEmmcEnabled;

/** Offset 0x0032 - Enable eMMC HS400 Mode
  Enable eMMC HS400 Mode.
  $EN_DIS
**/
  UINT8                       ScsEmmcHs400Enabled;

/** Offset 0x0033 - Enable SdCard Controller
  Enable/disable SD Card Controller.
  $EN_DIS
**/
  UINT8                       ScsSdCardEnabled;

/** Offset 0x0034 - Show SPI controller
  Enable/disable to show SPI controller.
  $EN_DIS
**/
  UINT8                       ShowSpiController;

/** Offset 0x0035
**/
  UINT8                       UnusedUpdSpace1[3];

/** Offset 0x0038 - MicrocodeRegionBase
  Memory Base of Microcode Updates
**/
  UINT32                      MicrocodeRegionBase;

/** Offset 0x003C - MicrocodeRegionSize
  Size of Microcode Updates
**/
  UINT32                      MicrocodeRegionSize;

/** Offset 0x0040 - Turbo Mode
  Enable/Disable Turbo mode. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       TurboMode;

/** Offset 0x0041 - Enable SATA SALP Support
  Enable/disable SATA Aggressive Link Power Management.
  $EN_DIS
**/
  UINT8                       SataSalpSupport;

/** Offset 0x0042 - Enable SATA ports
  Enable/disable SATA ports. One byte for each port, byte0 for port0, byte1 for port1,
  and so on.
**/
  UINT8                       SataPortsEnable[8];

/** Offset 0x004A - Enable SATA DEVSLP Feature
  Enable/disable SATA DEVSLP per port. 0 is disable, 1 is enable. One byte for each
  port, byte0 for port0, byte1 for port1, and so on.
**/
  UINT8                       SataPortsDevSlp[8];

/** Offset 0x0052 - Enable USB2 ports
  Enable/disable per USB2 ports. One byte for each port, byte0 for port0, byte1 for
  port1, and so on.
**/
  UINT8                       PortUsb20Enable[16];

/** Offset 0x0062 - Enable USB3 ports
  Enable/disable per USB3 ports. One byte for each port, byte0 for port0, byte1 for
  port1, and so on.
**/
  UINT8                       PortUsb30Enable[10];

/** Offset 0x006C - Enable xDCI controller
  Enable/disable to xDCI controller.
  $EN_DIS
**/
  UINT8                       XdciEnable;

/** Offset 0x006D
**/
  UINT8                       UnusedUpdSpace2[2];

/** Offset 0x006F - Enable SerialIo Device Mode
  0:Disabled, 1:PCI Mode, 2:Acpi mode, 3:Hidden mode (Legacy UART mode) - Enable/disable
  SerialIo I2C0,I2C1,I2C2,I2C3,I2C4,I2C5,SPI0,SPI1,SPI2,UART0,UART1,UART2 device
  mode respectively. One byte for each controller, byte0 for I2C0, byte1 for I2C1,
  and so on.
**/
  UINT8                       SerialIoDevMode[12];

/** Offset 0x007B - Address of PCH_DEVICE_INTERRUPT_CONFIG table.
  The address of the table of PCH_DEVICE_INTERRUPT_CONFIG.
**/
  UINT32                      DevIntConfigPtr;

/** Offset 0x007F - Number of DevIntConfig Entry
  Number of Device Interrupt Configuration Entry. If this is not zero, the DevIntConfigPtr
  must not be NULL.
**/
  UINT8                       NumOfDevIntConfig;

/** Offset 0x0080 - PIRQx to IRQx Map Config
  PIRQx to IRQx mapping. The valid value is 0x00 to 0x0F for each. First byte is for
  PIRQA, second byte is for PIRQB, and so on. The setting is only available in Legacy
  8259 PCI mode.
**/
  UINT8                       PxRcConfig[8];

/** Offset 0x0088 - Select GPIO IRQ Route
  GPIO IRQ Select. The valid value is 14 or 15.
**/
  UINT8                       GpioIrqRoute;

/** Offset 0x0089 - Select SciIrqSelect
  SCI IRQ Select. The valid value is 9, 10, 11, and 20, 21, 22, 23 for APIC only.
**/
  UINT8                       SciIrqSelect;

/** Offset 0x008A - Select TcoIrqSelect
  TCO IRQ Select. The valid value is 9, 10, 11, 20, 21, 22, 23.
**/
  UINT8                       TcoIrqSelect;

/** Offset 0x008B - Enable/Disable Tco IRQ
  Enable/disable TCO IRQ
  $EN_DIS
**/
  UINT8                       TcoIrqEnable;

/** Offset 0x008C - PCH HDA Verb Table Entry Number
  Number of Entries in Verb Table.
**/
  UINT8                       PchHdaVerbTableEntryNum;

/** Offset 0x008D - PCH HDA Verb Table Pointer
  Pointer to Array of pointers to Verb Table.
**/
  UINT32                      PchHdaVerbTablePtr;

/** Offset 0x0091 - PCH HDA Codec Sx Wake Capability
  Capability to detect wake initiated by a codec in Sx
**/
  UINT8                       PchHdaCodecSxWakeCapability;

/** Offset 0x0092 - Enable SATA
  Enable/disable SATA controller.
  $EN_DIS
**/
  UINT8                       SataEnable;

/** Offset 0x0093 - SATA Mode
  Select SATA controller working mode.
  0:AHCI, 1:RAID
**/
  UINT8                       SataMode;

/** Offset 0x0094 - USB Per Port HS Preemphasis Bias
  USB Per Port HS Preemphasis Bias. 000b-0mV, 001b-11.25mV, 010b-16.9mV, 011b-28.15mV,
  100b-28.15mV, 101b-39.35mV, 110b-45mV, 111b-56.3mV. One byte for each port.
**/
  UINT8                       Usb2AfePetxiset[16];

/** Offset 0x00A4 - USB Per Port HS Transmitter Bias
  USB Per Port HS Transmitter Bias. 000b-0mV, 001b-11.25mV, 010b-16.9mV, 011b-28.15mV,
  100b-28.15mV, 101b-39.35mV, 110b-45mV, 111b-56.3mV, One byte for each port.
**/
  UINT8                       Usb2AfeTxiset[16];

/** Offset 0x00B4 - USB Per Port HS Transmitter Emphasis
  USB Per Port HS Transmitter Emphasis. 00b - Emphasis OFF, 01b - De-emphasis ON,
  10b - Pre-emphasis ON, 11b - Pre-emphasis & De-emphasis ON. One byte for each port.
**/
  UINT8                       Usb2AfePredeemp[16];

/** Offset 0x00C4 - USB Per Port Half Bit Pre-emphasis
  USB Per Port Half Bit Pre-emphasis. 1b - half-bit pre-emphasis, 0b - full-bit pre-emphasis.
  One byte for each port.
**/
  UINT8                       Usb2AfePehalfbit[16];

/** Offset 0x00D4 - Enable the write to USB 3.0 TX Output -3.5dB De-Emphasis Adjustment
  Enable the write to USB 3.0 TX Output -3.5dB De-Emphasis Adjustment. Each value
  in arrary can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxDeEmphEnable[10];

/** Offset 0x00DE - USB 3.0 TX Output -3.5dB De-Emphasis Adjustment Setting
  USB 3.0 TX Output -3.5dB De-Emphasis Adjustment Setting, HSIO_TX_DWORD5[21:16],
  <b>Default = 29h</b> (approximately -3.5dB De-Emphasis). One byte for each port.
**/
  UINT8                       Usb3HsioTxDeEmph[10];

/** Offset 0x00E8 - Enable the write to USB 3.0 TX Output Downscale Amplitude Adjustment
  Enable the write to USB 3.0 TX Output Downscale Amplitude Adjustment, Each value
  in arrary can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxDownscaleAmpEnable[10];

/** Offset 0x00F2 - USB 3.0 TX Output Downscale Amplitude Adjustment
  USB 3.0 TX Output Downscale Amplitude Adjustment, HSIO_TX_DWORD8[21:16], <b>Default
  = 00h</b>. One byte for each port.
**/
  UINT8                       Usb3HsioTxDownscaleAmp[10];

/** Offset 0x00FC - Enable LAN
  Enable/disable LAN controller.
  $EN_DIS
**/
  UINT8                       PchLanEnable;

/** Offset 0x00FD - Enable HD Audio Link
  Enable/disable HD Audio Link. Muxed with SSP0/SSP1/SNDW1.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkHda;

/** Offset 0x00FE - Enable HD Audio DMIC0 Link
  Enable/disable HD Audio DMIC0 link. Muxed with SNDW4.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkDmic0;

/** Offset 0x00FF - Enable HD Audio DMIC1 Link
  Enable/disable HD Audio DMIC1 link. Muxed with SNDW3.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkDmic1;

/** Offset 0x0100 - Enable HD Audio SSP0 Link
  Enable/disable HD Audio SSP0/I2S link. Muxed with HDA.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSsp0;

/** Offset 0x0101 - Enable HD Audio SSP1 Link
  Enable/disable HD Audio SSP1/I2S link. Muxed with HDA/SNDW2.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSsp1;

/** Offset 0x0102 - Enable HD Audio SSP2 Link
  Enable/disable HD Audio SSP2/I2S link.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSsp2;

/** Offset 0x0103 - Enable HD Audio SoundWire#1 Link
  Enable/disable HD Audio SNDW1 link. Muxed with HDA.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSndw1;

/** Offset 0x0104 - Enable HD Audio SoundWire#2 Link
  Enable/disable HD Audio SNDW2 link. Muxed with SSP1.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSndw2;

/** Offset 0x0105 - Enable HD Audio SoundWire#3 Link
  Enable/disable HD Audio SNDW3 link. Muxed with DMIC1.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSndw3;

/** Offset 0x0106 - Enable HD Audio SoundWire#4 Link
  Enable/disable HD Audio SNDW4 link. Muxed with DMIC0.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSndw4;

/** Offset 0x0107 - Soundwire Clock Buffer GPIO RCOMP Setting
  0: non-ACT - 50 Ohm driver impedance, 1: ACT - 8 Ohm driver impedance.
  $EN_DIS
**/
  UINT8                       PchHdaSndwBufferRcomp;

/** Offset 0x0108 - PTM for PCIE RP Mask
  Enable/disable Precision Time Measurement for PCIE Root Ports. 0: disable, 1: enable.
  One bit for each port, bit0 for port1, bit1 for port2, and so on.
**/
  UINT32                      PcieRpPtmMask;

/** Offset 0x010C - DPC for PCIE RP Mask
  Enable/disable Downstream Port Containment for PCIE Root Ports. 0: disable, 1: enable.
  One bit for each port, bit0 for port1, bit1 for port2, and so on.
**/
  UINT32                      PcieRpDpcMask;

/** Offset 0x0110 - DPC Extensions PCIE RP Mask
  Enable/disable DPC Extensions for PCIE Root Ports. 0: disable, 1: enable. One bit
  for each port, bit0 for port1, bit1 for port2, and so on.
**/
  UINT32                      PcieRpDpcExtensionsMask;

/** Offset 0x0114 - USB PDO Programming
  Enable/disable PDO programming for USB in PEI phase. Disabling will allow for programming
  during later phase. 1: enable, 0: disable
  $EN_DIS
**/
  UINT8                       UsbPdoProgramming;

/** Offset 0x0115 - Power button debounce configuration
  Debounce time for PWRBTN in microseconds. For values not supported by HW, they will
  be rounded down to closest supported on. 0: disable, 250-1024000us: supported range
**/
  UINT32                      PmcPowerButtonDebounce;

/** Offset 0x0119 - PCH eSPI Master and Slave BME enabled
  PCH eSPI Master and Slave BME enabled
  $EN_DIS
**/
  UINT8                       PchEspiBmeMasterSlaveEnabled;

/** Offset 0x011A - PCH SATA use RST Legacy OROM
  Use PCH SATA RST Legacy OROM when CSM is Enabled
  $EN_DIS
**/
  UINT8                       SataRstLegacyOrom;

/** Offset 0x011B - Trace Hub Memory Base
  If Trace Hub is enabled and trace to memory is desired, BootLoader needs to allocate
  trace hub memory as reserved and uncacheable, set the base to ensure Trace Hub
  memory is configured properly.
**/
  UINT32                      TraceHubMemBase;

/** Offset 0x011F - PMC Debug Message Enable
  When Enabled, PMC HW will send debug messages to trace hub; When Disabled, PMC HW
  will never send debug meesages to trace hub. Noted: When Enabled, may not enter S0ix
  $EN_DIS
**/
  UINT8                       PmcDbgMsgEn;

/** Offset 0x0120 - PchPostMemRsvd
  Reserved for PCH Post-Mem
  $EN_DIS
**/
  UINT8                       PchPostMemRsvd[37];

/** Offset 0x0145 - Enable Ufs Controller
  Enable/disable Ufs 2.0 Controller.
  $EN_DIS
**/
  UINT8                       ScsUfsEnabled;

/** Offset 0x0146 - CNVi Configuration
  This option allows for automatic detection of Connectivity Solution. [Auto Detection]
  assumes that CNVi will be enabled when available, [Disable] allows for disabling CNVi.
  0:Disable, 1:Auto
**/
  UINT8                       PchCnviMode;

/** Offset 0x0147
**/
  UINT8                       UnusedUpdSpace3[2];

/** Offset 0x0149 - PCH USB OverCurrent mapping enable
  1: Will program USB OC pin mapping in xHCI controller memory, 0: Will clear OC pin
  mapping allow for NOA usage of OC pins
  $EN_DIS
**/
  UINT8                       PchUsbOverCurrentEnable;

/** Offset 0x014A
**/
  UINT8                       UnusedUpdSpace4;

/** Offset 0x014B - CNVi MfUart1 Type
  This option configures Uart type which connects to MfUart1
  0:ISH Uart0, 1:SerialIO Uart2, 2:Uart over external pads
**/
  UINT8                       PchCnviMfUart1Type;

/** Offset 0x014C - Espi Lgmr Memory Range decode 
  This option enables or disables espi lgmr 
  $EN_DIS
**/
  UINT8                       PchEspiLgmrEnable;

/** Offset 0x014D - HECI3 state
  The HECI3 state from Mbp for reference in S3 path or when MbpHob is not installed.
  0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       Heci3Enabled;

/** Offset 0x014E
**/
  UINT8                       UnusedUpdSpace5;

/** Offset 0x014F - PCHHOT# pin
  Enable PCHHOT# pin assertion when temperature is higher than PchHotLevel. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       PchHotEnable;

/** Offset 0x0150 - SATA LED
  SATA LED indicating SATA controller activity. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       SataLedEnable;

/** Offset 0x0151 - VRAlert# Pin
  When VRAlert# feature pin is enabled and its state is '0', the PMC requests throttling
  to a T3 Tstate to the PCH throttling unit.. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       PchPmVrAlert;

/** Offset 0x0152 - SLP_S0 VM Dynamic Control
  SLP_S0 Voltage Margining Runtime Control Policy. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       PchPmSlpS0VmRuntimeControl;

/** Offset 0x0153 - SLP_S0 VM 0.70V Support
  SLP_S0 Voltage Margining  0.70V Support Policy. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       PchPmSlpS0Vm070VSupport;

/** Offset 0x0154 - SLP_S0 VM 0.75V Support
  SLP_S0 Voltage Margining  0.75V Support Policy. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       PchPmSlpS0Vm075VSupport;

/** Offset 0x0155 - AMT Switch
  Enable/Disable. 0: Disable, 1: enable, Enable or disable AMT functionality.
  $EN_DIS
**/
  UINT8                       AmtEnabled;

/** Offset 0x0156 - WatchDog Timer Switch
  Enable/Disable. 0: Disable, 1: enable, Enable or disable WatchDog timer.
  $EN_DIS
**/
  UINT8                       WatchDog;

/** Offset 0x0157 - ASF Switch
  Enable/Disable. 0: Disable, 1: enable, Enable or disable ASF functionality.
  $EN_DIS
**/
  UINT8                       AsfEnabled;

/** Offset 0x0158 - Manageability Mode set by Mebx
  Enable/Disable. 0: Disable, 1: enable, Enable or disable  Manageability Mode.
  $EN_DIS
**/
  UINT8                       ManageabilityMode;

/** Offset 0x0159 - PET Progress
  Enable/Disable. 0: Disable, 1: enable, Enable/Disable PET Events Progress to receive
  PET Events.
  $EN_DIS
**/
  UINT8                       FwProgress;

/** Offset 0x015A - SOL Switch
  Enable/Disable. 0: Disable, 1: enable, Serial Over Lan enable/disable state by Mebx
  $EN_DIS
**/
  UINT8                       AmtSolEnabled;

/** Offset 0x015B - OS Timer
  16 bits Value, Set OS watchdog timer.
  $EN_DIS
**/
  UINT16                      WatchDogTimerOs;

/** Offset 0x015D - BIOS Timer
  16 bits Value, Set BIOS watchdog timer.
  $EN_DIS
**/
  UINT16                      WatchDogTimerBios;

/** Offset 0x015F
**/
  UINT8                       UnusedUpdSpace6[4];

/** Offset 0x0163 - PCH PCIe root port connection type
  0: built-in device, 1:slot
**/
  UINT8                       PcieRpSlotImplemented[24];

/** Offset 0x017B - Usage type for ClkSrc
  0-23: PCH rootport, 0x40: LAN, 0x80: unspecified but in use, 0xFF: not used
**/
  UINT8                       PcieClkSrcUsage[16];

/** Offset 0x018B - ClkReq-to-ClkSrc mapping
  Number of ClkReq signal assigned to ClkSrc
**/
  UINT8                       PcieClkSrcClkReq[16];

/** Offset 0x019B - PCIE RP Access Control Services Extended Capability
  Enable/Disable PCIE RP Access Control Services Extended Capability
**/
  UINT8                       PcieRpAcsEnabled[24];

/** Offset 0x01B3 - PCIE RP Clock Power Management
  Enable/Disable PCIE RP Clock Power Management, even if disabled, CLKREQ# signal
  can still be controlled by L1 PM substates mechanism
**/
  UINT8                       PcieRpEnableCpm[24];

/** Offset 0x01CB - PCIE RP Detect Timeout Ms
  The number of milliseconds within 0~65535 in reference code will wait for link to
  exit Detect state for enabled ports before assuming there is no device and potentially
  disabling the port.
**/
  UINT16                      PcieRpDetectTimeoutMs[24];

/** Offset 0x01FB
**/
  UINT8                       UnusedUpdSpace7[5];

/** Offset 0x0200 - Enable/Disable SA CRID
  Enable: SA CRID, Disable (Default): SA CRID
  $EN_DIS
**/
  UINT8                       CridEnable;

/** Offset 0x0201 - DMI ASPM
  0=Disable, 3(Default)=L0sL1
  0:Disable, 3:L0sL1
**/
  UINT8                       DmiAspm;

/** Offset 0x0202 - PCIe DeEmphasis control per root port
  0: -6dB, 1(Default): -3.5dB
  0:-6dB, 1:-3.5dB
**/
  UINT8                       PegDeEmphasis[4];

/** Offset 0x0206 - PCIe Slot Power Limit value per root port
  Slot power limit value per root port
**/
  UINT8                       PegSlotPowerLimitValue[4];

/** Offset 0x020A - PCIe Slot Power Limit scale per root port
  Slot power limit scale per root port
  0:1.0x, 1:0.1x, 2:0.01x, 3:0x001x
**/
  UINT8                       PegSlotPowerLimitScale[4];

/** Offset 0x020E - PCIe Physical Slot Number per root port
  Physical Slot Number per root port
**/
  UINT16                      PegPhysicalSlotNumber[4];

/** Offset 0x0216 - Enable/Disable PavpEnable
  Enable(Default): Enable PavpEnable, Disable: Disable PavpEnable
  $EN_DIS
**/
  UINT8                       PavpEnable;

/** Offset 0x0217 - CdClock Frequency selection
  0=168 Mhz, 1=336 Mhz, 2(Default)=528 Mhz
  0: 168 Mhz, 1: 336 Mhz, 2: 528 Mhz
**/
  UINT8                       CdClock;

/** Offset 0x0218 - Enable/Disable PeiGraphicsPeimInit
  Enable: Enable PeiGraphicsPeimInit, Disable(Default): Disable PeiGraphicsPeimInit
  $EN_DIS
**/
  UINT8                       PeiGraphicsPeimInit;

/** Offset 0x0219
**/
  UINT8                       UnusedUpdSpace8;

/** Offset 0x021A - Enable or disable GNA device
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       GnaEnable;

/** Offset 0x021B - State of X2APIC_OPT_OUT bit in the DMAR table
  0=Disable/Clear, 1(Default)=Enable/Set
  $EN_DIS
**/
  UINT8                       X2ApicOptOut;

/** Offset 0x021C - Base addresses for VT-d function MMIO access
  Base addresses for VT-d MMIO access per VT-d engine
**/
  UINT32                      VtdBaseAddress[3];

/** Offset 0x0228 - Enable or disable eDP device
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortEdp;

/** Offset 0x0229 - Enable or disable HPD of DDI port B
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortBHpd;

/** Offset 0x022A - Enable or disable HPD of DDI port C
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortCHpd;

/** Offset 0x022B - Enable or disable HPD of DDI port D
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortDHpd;

/** Offset 0x022C - Enable or disable HPD of DDI port F
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortFHpd;

/** Offset 0x022D - Enable or disable DDC of DDI port B
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortBDdc;

/** Offset 0x022E - Enable or disable DDC of DDI port C
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortCDdc;

/** Offset 0x022F - Enable or disable DDC of DDI port D
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortDDdc;

/** Offset 0x0230 - Enable or disable DDC of DDI port F
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPortFDdc;

/** Offset 0x0231 - SaPostMemProductionRsvd
  Reserved for SA Post-Mem Production
  $EN_DIS
**/
  UINT8                       SaPostMemProductionRsvd[46];

/** Offset 0x025F - PCIE RP Disable Gen2PLL Shutdown and L1 Clock Gating Enable
  PCIE RP Disable Gen2PLL Shutdown and L1 Clock Gating Enable Workaround needed for
  Alpine ridge 
**/
  UINT8                       PcieRootPortGen2PllL1CgDisable[24];

/** Offset 0x0277 - Advanced Encryption Standard (AES) feature
  Enable or Disable Advanced Encryption Standard (AES) feature; </b>0: Disable; <b>1: Enable
  $EN_DIS
**/
  UINT8                       AesEnable;

/** Offset 0x0278 - Power State 3 enable/disable
  PCODE MMIO Mailbox: Power State 3 enable/disable; 0: Disable; <b>1: Enable</b>.
  For all VR Indexes
**/
  UINT8                       Psi3Enable[5];

/** Offset 0x027D - Power State 4 enable/disable
  PCODE MMIO Mailbox: Power State 4 enable/disable; 0: Disable; <b>1: Enable</b>.For
  all VR Indexes
**/
  UINT8                       Psi4Enable[5];

/** Offset 0x0282 - Imon slope correction
  PCODE MMIO Mailbox: Imon slope correction. Specified in 1/100 increment values.
  Range is 0-200. 125 = 1.25. <b>0: Auto</b>.For all VR Indexes
**/
  UINT8                       ImonSlope[5];

/** Offset 0x0287 - Imon offset correction
  PCODE MMIO Mailbox: Imon offset correction. Value is a 2's complement signed integer.
  Units 1/1000, Range 0-63999. For an offset = 12.580, use 12580. <b>0: Auto</b>
**/
  UINT8                       ImonOffset[5];

/** Offset 0x028C - Enable/Disable BIOS configuration of VR
  Enable/Disable BIOS configuration of VR; <b>0: Disable</b>; 1: Enable.For all VR Indexes
**/
  UINT8                       VrConfigEnable[5];

/** Offset 0x0291 - Thermal Design Current enable/disable
  PCODE MMIO Mailbox: Thermal Design Current enable/disable; <b>0: Disable</b>; 1:
  Enable.For all VR Indexes
**/
  UINT8                       TdcEnable[5];

/** Offset 0x0296 - HECI3 state
  PCODE MMIO Mailbox: Thermal Design Current time window. Defined in milli seconds.
  Valid Values 1 - 1ms , 2 - 2ms , 3 - 3ms , 4 - 4ms , 5 - 5ms , 6 - 6ms , 7 - 7ms
  , 8 - 8ms , 10 - 10ms.For all VR Indexe
**/
  UINT8                       TdcTimeWindow[5];

/** Offset 0x029B - Thermal Design Current Lock
  PCODE MMIO Mailbox: Thermal Design Current Lock; <b>0: Disable</b>; 1: Enable.For
  all VR Indexes
**/
  UINT8                       TdcLock[5];

/** Offset 0x02A0 - Platform Psys slope correction
  PCODE MMIO Mailbox: Platform Psys slope correction. <b>0 - Auto</b> Specified in
  1/100 increment values. Range is 0-200. 125 = 1.25
**/
  UINT8                       PsysSlope;

/** Offset 0x02A1 - Platform Psys offset correction
  PCODE MMIO Mailbox: Platform Psys offset correction. <b>0 - Auto</b> Units 1/4,
  Range 0-255. Value of 100 = 100/4 = 25 offset
**/
  UINT8                       PsysOffset;

/** Offset 0x02A2 - Acoustic Noise Mitigation feature
  Enable or Disable Acoustic Noise Mitigation feature. <b>0: Disabled</b>; 1: Enabled
  $EN_DIS
**/
  UINT8                       AcousticNoiseMitigation;

/** Offset 0x02A3 - Disable Fast Slew Rate for Deep Package C States for VR IA domain
  Disable Fast Slew Rate for Deep Package C States based on Acoustic Noise Mitigation
  feature enabled. <b>0: False</b>; 1: True
  $EN_DIS
**/
  UINT8                       FastPkgCRampDisableIa;

/** Offset 0x02A4 - Slew Rate configuration for Deep Package C States for VR IA domain
  Slew Rate configuration for Deep Package C States for VR IA domain based on Acoustic
  Noise Mitigation feature enabled. <b>0: Fast/2</b>; 1: Fast/4; 2: Fast/8; 3: Fast/16
  0: Fast/2, 1: Fast/4, 2: Fast/8, 3: Fast/16
**/
  UINT8                       SlowSlewRateForIa;

/** Offset 0x02A5 - Slew Rate configuration for Deep Package C States for VR GT domain
  Slew Rate configuration for Deep Package C States for VR GT domain based on Acoustic
  Noise Mitigation feature enabled. <b>0: Fast/2</b>; 1: Fast/4; 2: Fast/8; 3: Fast/16
  0: Fast/2, 1: Fast/4, 2: Fast/8, 3: Fast/16
**/
  UINT8                       SlowSlewRateForGt;

/** Offset 0x02A6 - Slew Rate configuration for Deep Package C States for VR SA domain
  Slew Rate configuration for Deep Package C States for VR SA domain based on Acoustic
  Noise Mitigation feature enabled. <b>0: Fast/2</b>; 1: Fast/4; 2: Fast/8; 3: Fast/16
  0: Fast/2, 1: Fast/4, 2: Fast/8, 3: Fast/16
**/
  UINT8                       SlowSlewRateForSa;

/** Offset 0x02A7 - Thermal Design Current current limit
  PCODE MMIO Mailbox: Thermal Design Current current limit. Specified in 1/8A units.
  Range is 0-4095. 1000 = 125A. <b>0: Auto</b>. For all VR Indexes
**/
  UINT16                      TdcPowerLimit[5];

/** Offset 0x02B1 - AcLoadline
  PCODE MMIO Mailbox: AcLoadline in 1/100 mOhms (ie. 1250 = 12.50 mOhm); Range is
  0-6249. <b>Intel Recommended Defaults vary by domain and SKU.
**/
  UINT16                      AcLoadline[5];

/** Offset 0x02BB
**/
  UINT8                       UnusedUpdSpace9[10];

/** Offset 0x02C5 - DcLoadline
  PCODE MMIO Mailbox: DcLoadline in 1/100 mOhms (ie. 1250 = 12.50 mOhm); Range is
  0-6249.<b>Intel Recommended Defaults vary by domain and SKU.</b>
**/
  UINT16                      DcLoadline[5];

/** Offset 0x02CF - Power State 1 Threshold current
  PCODE MMIO Mailbox: Power State 1 current cuttof in 1/4 Amp increments. Range is 0-128A.
**/
  UINT16                      Psi1Threshold[5];

/** Offset 0x02D9 - Power State 2 Threshold current
  PCODE MMIO Mailbox: Power State 2 current cuttof in 1/4 Amp increments. Range is 0-128A.
**/
  UINT16                      Psi2Threshold[5];

/** Offset 0x02E3 - Power State 3 Threshold current
  PCODE MMIO Mailbox: Power State 3 current cuttof in 1/4 Amp increments. Range is 0-128A.
**/
  UINT16                      Psi3Threshold[5];

/** Offset 0x02ED - Icc Max limit
  PCODE MMIO Mailbox: VR Icc Max limit. 0-255A in 1/4 A units. 400 = 100A
**/
  UINT16                      IccMax[5];

/** Offset 0x02F7 - VR Voltage Limit
  PCODE MMIO Mailbox: VR Voltage Limit. Range is 0-7999mV.
**/
  UINT16                      VrVoltageLimit[5];

/** Offset 0x0301 - Disable Fast Slew Rate for Deep Package C States for VR GT domain
  Disable Fast Slew Rate for Deep Package C States based on Acoustic Noise Mitigation
  feature enabled. <b>0: False</b>; 1: True
  $EN_DIS
**/
  UINT8                       FastPkgCRampDisableGt;

/** Offset 0x0302 - Disable Fast Slew Rate for Deep Package C States for VR SA domain
  Disable Fast Slew Rate for Deep Package C States based on Acoustic Noise Mitigation
  feature enabled. <b>0: False</b>; 1: True
  $EN_DIS
**/
  UINT8                       FastPkgCRampDisableSa;

/** Offset 0x0303 - Enable VR specific mailbox command
  VR specific mailbox commands. <b>00b - no VR specific command sent.</b>  01b - A
  VR mailbox command specifically for the MPS IMPV8 VR will be sent. 10b - VR specific
  command sent for PS4 exit issue. 11b - Reserved.
  $EN_DIS
**/
  UINT8                       SendVrMbxCmd;

/** Offset 0x0304 - Reserved
  Reserved
**/
  UINT8                       Reserved2;

/** Offset 0x0305 - Enable or Disable TXT
  Enable or Disable TXT; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       TxtEnable;

/** Offset 0x0306
**/
  UINT8                       UnusedUpdSpace10[6];

/** Offset 0x030C - Skip Multi-Processor Initialization
  When this is skipped, boot loader must initialize processors before SilicionInit
  API. </b>0: Initialize; <b>1: Skip
  $EN_DIS
**/
  UINT8                       SkipMpInit;

/** Offset 0x030D - McIVR RFI Frequency Prefix
  PCODE MMIO Mailbox: McIVR RFI Frequency Adjustment Prefix. <b>0: Plus (+)</b>; 1:
  Minus (-).
**/
  UINT8                       McivrRfiFrequencyPrefix;

/** Offset 0x030E - McIVR RFI Frequency Adjustment
  PCODE MMIO Mailbox: Adjust the RFI frequency relative to the nominal frequency in
  increments of 100KHz. For subtraction, change McivrRfiFrequencyPrefix. <b>0: Auto</b>.
**/
  UINT8                       McivrRfiFrequencyAdjust;

/** Offset 0x030F - FIVR RFI Frequency
  PCODE MMIO Mailbox: Set the desired RFI frequency, in increments of 100KHz. <b>0:
  Auto</b>. Range varies based on XTAL clock: 0-1918 (Up to 191.8HMz) for 24MHz clock;
  0-1535 (Up to 153.5MHz) for 19MHz clock.
**/
  UINT16                      FivrRfiFrequency;

/** Offset 0x0311 - McIVR RFI Spread Spectrum
  PCODE MMIO Mailbox: McIVR RFI Spread Spectrum. <b>0: 0%</b>; 1: +/- 0.5%; 2: +/-
  1%; 3: +/- 1.5%; 4: +/- 2%; 5: +/- 3%; 6: +/- 4%; 7: +/- 5%; 8: +/- 6%.
**/
  UINT8                       McivrSpreadSpectrum;

/** Offset 0x0312 - FIVR RFI Spread Spectrum
  PCODE MMIO Mailbox: FIVR RFI Spread Spectrum, in 0.1% increments. <b>0: 0%</b>;
  Range: 0.0% to 10.0% (0-100).
**/
  UINT8                       FivrSpreadSpectrum;

/** Offset 0x0313 - Disable Fast Slew Rate for Deep Package C States for VR FIVR domain
  Disable Fast Slew Rate for Deep Package C States based on Acoustic Noise Mitigation
  feature enabled. <b>0: False</b>; 1: True
  $EN_DIS
**/
  UINT8                       FastPkgCRampDisableFivr;

/** Offset 0x0314 - Slew Rate configuration for Deep Package C States for VR FIVR domain
  Slew Rate configuration for Deep Package C States for VR FIVR domain based on Acoustic
  Noise Mitigation feature enabled. <b>0: Fast/2</b>; 1: Fast/4; 2: Fast/8; 3: Fast/16
  0: Fast/2, 1: Fast/4, 2: Fast/8, 3: Fast/16
**/
  UINT8                       SlowSlewRateForFivr;

/** Offset 0x0315 - CpuBistData
  Pointer CPU BIST Data
**/
  UINT32                      CpuBistData;

/** Offset 0x0319 - Activates VR mailbox command for Intersil VR C-state issues.
  Intersil VR mailbox command. <b>0 - no mailbox command sent.</b>  1 - VR mailbox
  command sent for IA/GT rails only. 2 - VR mailbox command sent for IA/GT/SA rails.
**/
  UINT8                       IslVrCmd;

/** Offset 0x031A - ReservedCpuPostMemProduction
  Reserved for CPU Post-Mem Production
  $EN_DIS
**/
  UINT8                       ReservedCpuPostMemProduction[17];

/** Offset 0x032B
**/
  UINT8                       UnusedUpdSpace11[27];

/** Offset 0x0346 - Enable DMI ASPM
  ASPM on PCH side of the DMI Link.
  $EN_DIS
**/
  UINT8                       PchDmiAspm;

/** Offset 0x0347 - Enable Power Optimizer
  Enable DMI Power Optimizer on PCH side.
  $EN_DIS
**/
  UINT8                       PchPwrOptEnable;

/** Offset 0x0348 - PCH Flash Protection Ranges Write Enble
  Write or erase is blocked by hardware.
**/
  UINT8                       PchWriteProtectionEnable[5];

/** Offset 0x034D - PCH Flash Protection Ranges Read Enble
  Read is blocked by hardware.
**/
  UINT8                       PchReadProtectionEnable[5];

/** Offset 0x0352 - PCH Protect Range Limit
  Left shifted address by 12 bits with address bits 11:0 are assumed to be FFFh for
  limit comparison.
**/
  UINT16                      PchProtectedRangeLimit[5];

/** Offset 0x035C - PCH Protect Range Base
  Left shifted address by 12 bits with address bits 11:0 are assumed to be 0.
**/
  UINT16                      PchProtectedRangeBase[5];

/** Offset 0x0366 - Enable Pme
  Enable Azalia wake-on-ring.
  $EN_DIS
**/
  UINT8                       PchHdaPme;

/** Offset 0x0367
**/
  UINT8                       UnusedUpdSpace12;

/** Offset 0x0368 - VC Type
  Virtual Channel Type Select: 0: VC0, 1: VC1.
  0: VC0, 1: VC1
**/
  UINT8                       PchHdaVcType;

/** Offset 0x0369 - HD Audio Link Frequency
  HDA Link Freq (PCH_HDAUDIO_LINK_FREQUENCY enum): 0: 6MHz, 1: 12MHz, 2: 24MHz.
  0: 6MHz, 1: 12MHz, 2: 24MHz
**/
  UINT8                       PchHdaLinkFrequency;

/** Offset 0x036A - iDisp-Link Frequency
  iDisp-Link Freq (PCH_HDAUDIO_LINK_FREQUENCY enum): 4: 96MHz, 3: 48MHz.
  4: 96MHz, 3: 48MHz
**/
  UINT8                       PchHdaIDispLinkFrequency;

/** Offset 0x036B - iDisp-Link T-mode
  iDisp-Link T-Mode (PCH_HDAUDIO_IDISP_TMODE enum): 0: 2T, 1: 1T.
  0: 2T, 1: 1T
**/
  UINT8                       PchHdaIDispLinkTmode;

/** Offset 0x036C - Universal Audio Architecture compliance for DSP enabled system
  0: Not-UAA Compliant (Intel SST driver supported only), 1: UAA Compliant (HDA Inbox
  driver or SST driver supported).
  $EN_DIS
**/
  UINT8                       PchHdaDspUaaCompliance;

/** Offset 0x036D - iDisplay Audio Codec disconnection
  0: Not disconnected, enumerable, 1: Disconnected SDI, not enumerable.
  $EN_DIS
**/
  UINT8                       PchHdaIDispCodecDisconnect;

/** Offset 0x036E
**/
  UINT8                       UnusedUpdSpace13[15];

/** Offset 0x037D - Enable PCH Io Apic Entry 24-119
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIoApicEntry24_119;

/** Offset 0x037E - PCH Io Apic ID
  This member determines IOAPIC ID. Default is 0x02.
**/
  UINT8                       PchIoApicId;

/** Offset 0x037F
**/
  UINT8                       UnusedUpdSpace14;

/** Offset 0x0380 - Enable PCH ISH SPI GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshSpiGpioAssign;

/** Offset 0x0381 - Enable PCH ISH UART0 GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshUart0GpioAssign;

/** Offset 0x0382 - Enable PCH ISH UART1 GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshUart1GpioAssign;

/** Offset 0x0383 - Enable PCH ISH I2C0 GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshI2c0GpioAssign;

/** Offset 0x0384 - Enable PCH ISH I2C1 GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshI2c1GpioAssign;

/** Offset 0x0385 - Enable PCH ISH I2C2 GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshI2c2GpioAssign;

/** Offset 0x0386 - Enable PCH ISH GP_0 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp0GpioAssign;

/** Offset 0x0387 - Enable PCH ISH GP_1 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp1GpioAssign;

/** Offset 0x0388 - Enable PCH ISH GP_2 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp2GpioAssign;

/** Offset 0x0389 - Enable PCH ISH GP_3 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp3GpioAssign;

/** Offset 0x038A - Enable PCH ISH GP_4 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp4GpioAssign;

/** Offset 0x038B - Enable PCH ISH GP_5 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp5GpioAssign;

/** Offset 0x038C - Enable PCH ISH GP_6 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp6GpioAssign;

/** Offset 0x038D - Enable PCH ISH GP_7 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp7GpioAssign;

/** Offset 0x038E - PCH ISH PDT Unlock Msg
  0: False; 1: True.
  $EN_DIS
**/
  UINT8                       PchIshPdtUnlock;

/** Offset 0x038F - Enable PCH Lan LTR capabilty of PCH internal LAN
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchLanLtrEnable;

/** Offset 0x0390
**/
  UINT8                       UnusedUpdSpace15[3];

/** Offset 0x0393 - Enable LOCKDOWN BIOS LOCK
  Enable the BIOS Lock feature and set EISS bit (D31:F5:RegDCh[5]) for the BIOS region
  protection.
  $EN_DIS
**/
  UINT8                       PchLockDownBiosLock;

/** Offset 0x0394 - PCH Compatibility Revision ID
  This member describes whether or not the CRID feature of PCH should be enabled.
  $EN_DIS
**/
  UINT8                       PchCrid;

/** Offset 0x0395 - RTC CMOS MEMORY LOCK
  Enable RTC lower and upper 128 byte Lock bits to lock Bytes 38h-3Fh in the upper
  and and lower 128-byte bank of RTC RAM.
  $EN_DIS
**/
  UINT8                       PchLockDownRtcMemoryLock;

/** Offset 0x0396 - Enable PCIE RP HotPlug
  Indicate whether the root port is hot plug available.
**/
  UINT8                       PcieRpHotPlug[24];

/** Offset 0x03AE - Enable PCIE RP Pm Sci
  Indicate whether the root port power manager SCI is enabled.
**/
  UINT8                       PcieRpPmSci[24];

/** Offset 0x03C6 - Enable PCIE RP Ext Sync
  Indicate whether the extended synch is enabled.
**/
  UINT8                       PcieRpExtSync[24];

/** Offset 0x03DE - Enable PCIE RP Transmitter Half Swing
  Indicate whether the Transmitter Half Swing is enabled.
**/
  UINT8                       PcieRpTransmitterHalfSwing[24];

/** Offset 0x03F6 - Enable PCIE RP Clk Req Detect
  Probe CLKREQ# signal before enabling CLKREQ# based power management.
**/
  UINT8                       PcieRpClkReqDetect[24];

/** Offset 0x040E - PCIE RP Advanced Error Report
  Indicate whether the Advanced Error Reporting is enabled.
**/
  UINT8                       PcieRpAdvancedErrorReporting[24];

/** Offset 0x0426 - PCIE RP Unsupported Request Report
  Indicate whether the Unsupported Request Report is enabled.
**/
  UINT8                       PcieRpUnsupportedRequestReport[24];

/** Offset 0x043E - PCIE RP Fatal Error Report
  Indicate whether the Fatal Error Report is enabled.
**/
  UINT8                       PcieRpFatalErrorReport[24];

/** Offset 0x0456 - PCIE RP No Fatal Error Report
  Indicate whether the No Fatal Error Report is enabled.
**/
  UINT8                       PcieRpNoFatalErrorReport[24];

/** Offset 0x046E - PCIE RP Correctable Error Report
  Indicate whether the Correctable Error Report is enabled.
**/
  UINT8                       PcieRpCorrectableErrorReport[24];

/** Offset 0x0486 - PCIE RP System Error On Fatal Error
  Indicate whether the System Error on Fatal Error is enabled.
**/
  UINT8                       PcieRpSystemErrorOnFatalError[24];

/** Offset 0x049E - PCIE RP System Error On Non Fatal Error
  Indicate whether the System Error on Non Fatal Error is enabled.
**/
  UINT8                       PcieRpSystemErrorOnNonFatalError[24];

/** Offset 0x04B6 - PCIE RP System Error On Correctable Error
  Indicate whether the System Error on Correctable Error is enabled.
**/
  UINT8                       PcieRpSystemErrorOnCorrectableError[24];

/** Offset 0x04CE - PCIE RP Max Payload
  Max Payload Size supported, Default 128B, see enum PCH_PCIE_MAX_PAYLOAD.
**/
  UINT8                       PcieRpMaxPayload[24];

/** Offset 0x04E6 - PCIE RP Device Reset Pad Active High
  Indicated whether PERST# is active 0: Low; 1: High, See: DeviceResetPad.
**/
  UINT8                       PcieRpDeviceResetPadActiveHigh[24];

/** Offset 0x04FE - PCIE RP Pcie Speed
  Determines each PCIE Port speed capability. 0: Auto; 1: Gen1; 2: Gen2; 3: Gen3 (see:
  PCH_PCIE_SPEED).
**/
  UINT8                       PcieRpPcieSpeed[24];

/** Offset 0x0516 - PCIE RP Gen3 Equalization Phase Method
  PCIe Gen3 Eq Ph3 Method (see PCH_PCIE_EQ_METHOD). 0: Default; 2: Software Search;
  4: Fixed Coeficients.
**/
  UINT8                       PcieRpGen3EqPh3Method[24];

/** Offset 0x052E - PCIE RP Physical Slot Number
  Indicates the slot number for the root port. Default is the value as root port index.
**/
  UINT8                       PcieRpPhysicalSlotNumber[24];

/** Offset 0x0546 - PCIE RP Completion Timeout
  The root port completion timeout(see: PCH_PCIE_COMPLETION_TIMEOUT). Default is PchPcieCompletionTO_Default.
**/
  UINT8                       PcieRpCompletionTimeout[24];

/** Offset 0x055E - PCIE RP Device Reset Pad
  The PCH pin assigned to device PERST# signal if available, zero otherwise.  See
  also DeviceResetPadActiveHigh.
**/
  UINT32                      PcieRpDeviceResetPad[24];

/** Offset 0x05BE
**/
  UINT8                       UnusedUpdSpace16[10];

/** Offset 0x05C8 - PCIE RP Aspm
  The ASPM configuration of the root port (see: PCH_PCIE_ASPM_CONTROL). Default is
  PchPcieAspmAutoConfig.
**/
  UINT8                       PcieRpAspm[24];

/** Offset 0x05E0 - PCIE RP L1 Substates
  The L1 Substates configuration of the root port (see: PCH_PCIE_L1SUBSTATES_CONTROL).
  Default is PchPcieL1SubstatesL1_1_2.
**/
  UINT8                       PcieRpL1Substates[24];

/** Offset 0x05F8 - PCIE RP Ltr Enable
  Latency Tolerance Reporting Mechanism.
**/
  UINT8                       PcieRpLtrEnable[24];

/** Offset 0x0610 - PCIE RP Ltr Config Lock
  0: Disable; 1: Enable.
**/
  UINT8                       PcieRpLtrConfigLock[24];

/** Offset 0x0628 - PCIE Eq Ph3 Lane Param Cm
  PCH_PCIE_EQ_LANE_PARAM. Coefficient C-1.
**/
  UINT8                       PcieEqPh3LaneParamCm[24];

/** Offset 0x0640 - PCIE Eq Ph3 Lane Param Cp
  PCH_PCIE_EQ_LANE_PARAM. Coefficient C+1.
**/
  UINT8                       PcieEqPh3LaneParamCp[24];

/** Offset 0x0658 - PCIE Sw Eq CoeffList Cm
  PCH_PCIE_EQ_PARAM. Coefficient C-1.
**/
  UINT8                       PcieSwEqCoeffListCm[5];

/** Offset 0x065D - PCIE Sw Eq CoeffList Cp
  PCH_PCIE_EQ_PARAM. Coefficient C+1.
**/
  UINT8                       PcieSwEqCoeffListCp[5];

/** Offset 0x0662 - PCIE Disable RootPort Clock Gating
  Describes whether the PCI Express Clock Gating for each root port is enabled by
  platform modules. 0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PcieDisableRootPortClockGating;

/** Offset 0x0663 - PCIE Enable Peer Memory Write
  This member describes whether Peer Memory Writes are enabled on the platform.
  $EN_DIS
**/
  UINT8                       PcieEnablePeerMemoryWrite;

/** Offset 0x0664
**/
  UINT8                       UnusedUpdSpace17;

/** Offset 0x0665 - PCIE Compliance Test Mode
  Compliance Test Mode shall be enabled when using Compliance Load Board.
  $EN_DIS
**/
  UINT8                       PcieComplianceTestMode;

/** Offset 0x0666 - PCIE Rp Function Swap
  Allows BIOS to use root port function number swapping when root port of function
  0 is disabled.
  $EN_DIS
**/
  UINT8                       PcieRpFunctionSwap;

/** Offset 0x0667
**/
  UINT8                       UnusedUpdSpace18[2];

/** Offset 0x0669 - PCH Pm PME_B0_S5_DIS
  When cleared (default), wake events from PME_B0_STS are allowed in S5 if PME_B0_EN = 1.
  $EN_DIS
**/
  UINT8                       PchPmPmeB0S5Dis;

/** Offset 0x066A - SPI ChipSelect signal polarity
  Selects SPI ChipSelect signal polarity.
**/
  UINT8                       SerialIoSpiCsPolarity[3];

/** Offset 0x066D - PCIE IMR
  Enables Isolated Memory Region for PCIe.
  $EN_DIS
**/
  UINT8                       PcieRpImrEnabled;

/** Offset 0x066E - PCIE IMR port number
  Selects PCIE root port number for IMR feature.
**/
  UINT8                       PcieRpImrSelection;

/** Offset 0x066F
**/
  UINT8                       UnusedUpdSpace19;

/** Offset 0x0670 - PCH Pm Wol Enable Override
  Corresponds to the WOL Enable Override bit in the General PM Configuration B (GEN_PMCON_B) register.
  $EN_DIS
**/
  UINT8                       PchPmWolEnableOverride;

/** Offset 0x0671 - PCH Pm Pcie Wake From DeepSx
  Determine if enable PCIe to wake from deep Sx.
  $EN_DIS
**/
  UINT8                       PchPmPcieWakeFromDeepSx;

/** Offset 0x0672 - PCH Pm WoW lan Enable
  Determine if WLAN wake from Sx, corresponds to the HOST_WLAN_PP_EN bit in the PWRM_CFG3 register.
  $EN_DIS
**/
  UINT8                       PchPmWoWlanEnable;

/** Offset 0x0673 - PCH Pm WoW lan DeepSx Enable
  Determine if WLAN wake from DeepSx, corresponds to the DSX_WLAN_PP_EN bit in the
  PWRM_CFG3 register.
  $EN_DIS
**/
  UINT8                       PchPmWoWlanDeepSxEnable;

/** Offset 0x0674 - PCH Pm Lan Wake From DeepSx
  Determine if enable LAN to wake from deep Sx.
  $EN_DIS
**/
  UINT8                       PchPmLanWakeFromDeepSx;

/** Offset 0x0675 - PCH Pm Deep Sx Pol
  Deep Sx Policy.
  $EN_DIS
**/
  UINT8                       PchPmDeepSxPol;

/** Offset 0x0676 - PCH Pm Slp S3 Min Assert
  SLP_S3 Minimum Assertion Width Policy. Default is PchSlpS350ms.
**/
  UINT8                       PchPmSlpS3MinAssert;

/** Offset 0x0677 - PCH Pm Slp S4 Min Assert
  SLP_S4 Minimum Assertion Width Policy. Default is PchSlpS44s.
**/
  UINT8                       PchPmSlpS4MinAssert;

/** Offset 0x0678 - PCH Pm Slp Sus Min Assert
  SLP_SUS Minimum Assertion Width Policy. Default is PchSlpSus4s.
**/
  UINT8                       PchPmSlpSusMinAssert;

/** Offset 0x0679 - PCH Pm Slp A Min Assert
  SLP_A Minimum Assertion Width Policy. Default is PchSlpA2s.
**/
  UINT8                       PchPmSlpAMinAssert;

/** Offset 0x067A - SLP_S0# Override
  Select 'Auto', it will be auto-configured according to probe type. Select 'Enabled'
  will disable SLP_S0# assertion whereas 'Disabled' will enable SLP_S0# assertion
  when debug is enabled. \n
  Note: This BIOS option should keep 'Auto', other options are intended for advanced 
  configuration only.
  0:Disabled, 1:Enabled, 2:Auto
**/
  UINT8                       SlpS0Override;

/** Offset 0x067B - S0ix Override Settings
  Select 'Auto', it will be auto-configured according to probe type. 'No Change' will
  keep PMC default settings. Or select the desired debug probe type for S0ix Override
  settings.\n
  Reminder: DCI OOB (aka BSSB) uses CCA probe.\n
  Note: This BIOS option should keep 'Auto', other options are intended for advanced 
  configuration only.
  0:No Change, 1:DCI OOB, 2:USB2 DbC, 3:Auto
**/
  UINT8                       SlpS0DisQForDebug;

/** Offset 0x067C - USB Overcurrent Override for DbC
  This option overrides USB Over Current enablement state that USB OC will be disabled
  after enabling this option. Enable when DbC is used to avoid signaling conflicts.
  $EN_DIS
**/
  UINT8                       PchEnableDbcObs;

/** Offset 0x067D
**/
  UINT8                       UnusedUpdSpace20[3];

/** Offset 0x0680 - PCH Pm Lpc Clock Run
  This member describes whether or not the LPC ClockRun feature of PCH should be enabled.
  $EN_DIS
**/
  UINT8                       PchPmLpcClockRun;

/** Offset 0x0681 - PCH Pm Slp Strch Sus Up
  Enable SLP_X Stretching After SUS Well Power Up.
  $EN_DIS
**/
  UINT8                       PchPmSlpStrchSusUp;

/** Offset 0x0682 - PCH Pm Slp Lan Low Dc
  Enable/Disable SLP_LAN# Low on DC Power.
  $EN_DIS
**/
  UINT8                       PchPmSlpLanLowDc;

/** Offset 0x0683 - PCH Pm Pwr Btn Override Period
  PCH power button override period. 000b-4s, 001b-6s, 010b-8s, 011b-10s, 100b-12s, 101b-14s.
**/
  UINT8                       PchPmPwrBtnOverridePeriod;

/** Offset 0x0684 - PCH Pm Disable Dsx Ac Present Pulldown
  When Disable, PCH will internal pull down AC_PRESENT in deep SX and during G3 exit.
  $EN_DIS
**/
  UINT8                       PchPmDisableDsxAcPresentPulldown;

/** Offset 0x0685
**/
  UINT8                       UnusedUpdSpace21;

/** Offset 0x0686 - PCH Pm Disable Native Power Button
  Power button native mode disable.
  $EN_DIS
**/
  UINT8                       PchPmDisableNativePowerButton;

/** Offset 0x0687 - PCH Pm Slp S0 Enable
  Indicates whether SLP_S0# is to be asserted when PCH reaches idle state.
  $EN_DIS
**/
  UINT8                       PchPmSlpS0Enable;

/** Offset 0x0688 - PCH Pm ME_WAKE_STS
  Clear the ME_WAKE_STS bit in the Power and Reset Status (PRSTS) register.
  $EN_DIS
**/
  UINT8                       PchPmMeWakeSts;

/** Offset 0x0689 - PCH Pm WOL_OVR_WK_STS
  Clear the WOL_OVR_WK_STS bit in the Power and Reset Status (PRSTS) register.
  $EN_DIS
**/
  UINT8                       PchPmWolOvrWkSts;

/** Offset 0x068A - PCH Pm Reset Power Cycle Duration
  Could be customized in the unit of second. Please refer to EDS for all support settings.
  0 is default, 1 is 1 second, 2 is 2 seconds, ...
**/
  UINT8                       PchPmPwrCycDur;

/** Offset 0x068B - PCH Pm Pcie Pll Ssc
  Specifies the Pcie Pll Spread Spectrum Percentage. The default is 0xFF: AUTO - No
  BIOS override.
**/
  UINT8                       PchPmPciePllSsc;

/** Offset 0x068C
**/
  UINT8                       UnusedUpdSpace22;

/** Offset 0x068D - PCH Sata Pwr Opt Enable
  SATA Power Optimizer on PCH side.
  $EN_DIS
**/
  UINT8                       SataPwrOptEnable;

/** Offset 0x068E - PCH Sata eSATA Speed Limit
  When enabled, BIOS will configure the PxSCTL.SPD to 2 to limit the eSATA port speed.
  $EN_DIS
**/
  UINT8                       EsataSpeedLimit;

/** Offset 0x068F - PCH Sata Speed Limit
  Indicates the maximum speed the SATA controller can support 0h: PchSataSpeedDefault.
**/
  UINT8                       SataSpeedLimit;

/** Offset 0x0690 - Enable SATA Port HotPlug
  Enable SATA Port HotPlug.
**/
  UINT8                       SataPortsHotPlug[8];

/** Offset 0x0698 - Enable SATA Port Interlock Sw
  Enable SATA Port Interlock Sw.
**/
  UINT8                       SataPortsInterlockSw[8];

/** Offset 0x06A0 - Enable SATA Port External
  Enable SATA Port External.
**/
  UINT8                       SataPortsExternal[8];

/** Offset 0x06A8 - Enable SATA Port SpinUp
  Enable the COMRESET initialization Sequence to the device.
**/
  UINT8                       SataPortsSpinUp[8];

/** Offset 0x06B0 - Enable SATA Port Solid State Drive
  0: HDD; 1: SSD.
**/
  UINT8                       SataPortsSolidStateDrive[8];

/** Offset 0x06B8 - Enable SATA Port Enable Dito Config
  Enable DEVSLP Idle Timeout settings (DmVal, DitoVal).
**/
  UINT8                       SataPortsEnableDitoConfig[8];

/** Offset 0x06C0 - Enable SATA Port DmVal
  DITO multiplier. Default is 15.
**/
  UINT8                       SataPortsDmVal[8];

/** Offset 0x06C8 - Enable SATA Port DmVal
  DEVSLP Idle Timeout (DITO), Default is 625.
**/
  UINT16                      SataPortsDitoVal[8];

/** Offset 0x06D8 - Enable SATA Port ZpOdd
  Support zero power ODD.
**/
  UINT8                       SataPortsZpOdd[8];

/** Offset 0x06E0 - PCH Sata Rst Raid Device Id
  Enable RAID Alternate ID.
  0:Client, 1:Alternate, 2:Server
**/
  UINT8                       SataRstRaidDeviceId;

/** Offset 0x06E1 - PCH Sata Rst Raid0
  RAID0.
  $EN_DIS
**/
  UINT8                       SataRstRaid0;

/** Offset 0x06E2 - PCH Sata Rst Raid1
  RAID1.
  $EN_DIS
**/
  UINT8                       SataRstRaid1;

/** Offset 0x06E3 - PCH Sata Rst Raid10
  RAID10.
  $EN_DIS
**/
  UINT8                       SataRstRaid10;

/** Offset 0x06E4 - PCH Sata Rst Raid5
  RAID5.
  $EN_DIS
**/
  UINT8                       SataRstRaid5;

/** Offset 0x06E5 - PCH Sata Rst Irrt
  Intel Rapid Recovery Technology.
  $EN_DIS
**/
  UINT8                       SataRstIrrt;

/** Offset 0x06E6 - PCH Sata Rst Orom Ui Banner
  OROM UI and BANNER.
  $EN_DIS
**/
  UINT8                       SataRstOromUiBanner;

/** Offset 0x06E7 - PCH Sata Rst Orom Ui Delay
  00b: 2 secs; 01b: 4 secs; 10b: 6 secs; 11: 8 secs (see: PCH_SATA_OROM_DELAY).
**/
  UINT8                       SataRstOromUiDelay;

/** Offset 0x06E8 - PCH Sata Rst Hdd Unlock
  Indicates that the HDD password unlock in the OS is enabled.
  $EN_DIS
**/
  UINT8                       SataRstHddUnlock;

/** Offset 0x06E9 - PCH Sata Rst Led Locate
  Indicates that the LED/SGPIO hardware is attached and ping to locate feature is
  enabled on the OS.
  $EN_DIS
**/
  UINT8                       SataRstLedLocate;

/** Offset 0x06EA - PCH Sata Rst Irrt Only
  Allow only IRRT drives to span internal and external ports.
  $EN_DIS
**/
  UINT8                       SataRstIrrtOnly;

/** Offset 0x06EB - PCH Sata Rst Smart Storage
  RST Smart Storage caching Bit.
  $EN_DIS
**/
  UINT8                       SataRstSmartStorage;

/** Offset 0x06EC - PCH Sata Rst Pcie Storage Remap enable
  Enable Intel RST for PCIe Storage remapping.
**/
  UINT8                       SataRstPcieEnable[3];

/** Offset 0x06EF - PCH Sata Rst Pcie Storage Port
  Intel RST for PCIe Storage remapping - PCIe Port Selection (1-based, 0 = autodetect).
**/
  UINT8                       SataRstPcieStoragePort[3];

/** Offset 0x06F2 - PCH Sata Rst Pcie Device Reset Delay
  PCIe Storage Device Reset Delay in milliseconds. Default value is 100ms
**/
  UINT8                       SataRstPcieDeviceResetDelay[3];

/** Offset 0x06F5 - Enable eMMC HS400 Training
  Determine if HS400 Training is required.
  $EN_DIS
**/
  UINT8                       PchScsEmmcHs400TuningRequired;

/** Offset 0x06F6 - Set HS400 Tuning Data Valid
  Set if HS400 Tuning Data Valid.
  $EN_DIS
**/
  UINT8                       PchScsEmmcHs400DllDataValid;

/** Offset 0x06F7 - Rx Strobe Delay Control
  Rx Strobe Delay Control - Rx Strobe Delay DLL 1 (HS400 Mode).
**/
  UINT8                       PchScsEmmcHs400RxStrobeDll1;

/** Offset 0x06F8 - Tx Data Delay Control
  Tx Data Delay Control 1 - Tx Data Delay (HS400 Mode).
**/
  UINT8                       PchScsEmmcHs400TxDataDll;

/** Offset 0x06F9 - I/O Driver Strength
  I/O driver strength: 0 - 33 Ohm, 1 - 40 Ohm, 2 - 50 Ohm.
  0:33 Ohm, 1:40 Ohm, 2:50 Ohm
**/
  UINT8                       PchScsEmmcHs400DriverStrength;

/** Offset 0x06FA - PCH SerialIo I2C Pads Termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo I2C0,I2C1,I2C2,I2C3,I2C4,I2C5
  pads termination respectively. One byte for each controller, byte0 for I2C0, byte1
  for I2C1, and so on.
  0x1:None, 0x13:1kOhm WPU, 0x15:5kOhm WPU, 0x19:20kOhm WPU
**/
  UINT8                       PchSerialIoI2cPadsTermination[6];

/** Offset 0x0700
**/
  UINT8                       UnusedUpdSpace23;

/** Offset 0x0701 - PcdSerialIoUart0PinMuxing
  Select SerialIo Uart0 pin muxing. Setting applicable only if SerialIO UART0 is enabled.
  0:default pins, 1:pins muxed with CNV_BRI/RGI
**/
  UINT8                       SerialIoUart0PinMuxing;

/** Offset 0x0702
**/
  UINT8                       UnusedUpdSpace24[1];

/** Offset 0x0703 - Enables UART hardware flow control, CTS and RTS lines
  Enables UART hardware flow control, CTS and RTS linesh.
**/
  UINT8                       SerialIoUartHwFlowCtrl[3];

/** Offset 0x0706 - UART Number For Debug Purpose
  UART number for debug purpose. 0:UART0, 1: UART1, 2:UART2. Note: If UART0 is selected
  as CNVi BT Core interface, it cannot be used for debug purpose.
   0:UART0, 1:UART1, 2:UART2
**/
  UINT8                       SerialIoDebugUartNumber;

/** Offset 0x0707 - Enable Debug UART Controller
  Enable debug UART controller after post.
  $EN_DIS
**/
  UINT8                       SerialIoEnableDebugUartAfterPost;

/** Offset 0x0708 - Enable Serial IRQ
  Determines if enable Serial IRQ.
  $EN_DIS
**/
  UINT8                       PchSirqEnable;

/** Offset 0x0709 - Serial IRQ Mode Select
  Serial IRQ Mode Select, 0: quiet mode, 1: continuous mode.
  $EN_DIS
**/
  UINT8                       PchSirqMode;

/** Offset 0x070A - Start Frame Pulse Width
  Start Frame Pulse Width, 0: PchSfpw4Clk, 1: PchSfpw6Clk, 2: PchSfpw8Clk.
  0: PchSfpw4Clk, 1: PchSfpw6Clk, 2: PchSfpw8Clk
**/
  UINT8                       PchStartFramePulse;

/** Offset 0x070B - Reserved
  Reserved
  $EN_DIS
**/
  UINT8                       ReservedForFuture1;

/** Offset 0x070C - Thermal Device SMI Enable
  This locks down SMI Enable on Alert Thermal Sensor Trip.
  $EN_DIS
**/
  UINT8                       PchTsmicLock;

/** Offset 0x070D - Thermal Throttling Custimized T0Level Value
  Custimized T0Level value.
**/
  UINT16                      PchT0Level;

/** Offset 0x070F - Thermal Throttling Custimized T1Level Value
  Custimized T1Level value.
**/
  UINT16                      PchT1Level;

/** Offset 0x0711 - Thermal Throttling Custimized T2Level Value
  Custimized T2Level value.
**/
  UINT16                      PchT2Level;

/** Offset 0x0713 - Enable The Thermal Throttle
  Enable the thermal throttle function.
  $EN_DIS
**/
  UINT8                       PchTTEnable;

/** Offset 0x0714 - PMSync State 13
  When set to 1 and the programmed GPIO pin is a 1, then PMSync state 13 will force
  at least T2 state.
  $EN_DIS
**/
  UINT8                       PchTTState13Enable;

/** Offset 0x0715 - Thermal Throttle Lock
  Thermal Throttle Lock.
  $EN_DIS
**/
  UINT8                       PchTTLock;

/** Offset 0x0716 - Thermal Throttling Suggested Setting
  Thermal Throttling Suggested Setting.
  $EN_DIS
**/
  UINT8                       TTSuggestedSetting;

/** Offset 0x0717 - Enable PCH Cross Throttling
  Enable/Disable PCH Cross Throttling
  $EN_DIS
**/
  UINT8                       TTCrossThrottling;

/** Offset 0x0718 - DMI Thermal Sensor Autonomous Width Enable
  DMI Thermal Sensor Autonomous Width Enable.
  $EN_DIS
**/
  UINT8                       PchDmiTsawEn;

/** Offset 0x0719 - DMI Thermal Sensor Suggested Setting
  DMT thermal sensor suggested representative values.
  $EN_DIS
**/
  UINT8                       DmiSuggestedSetting;

/** Offset 0x071A - Thermal Sensor 0 Target Width
  DMT thermal sensor suggested representative values.
  0:x1, 1:x2, 2:x4, 3:x8, 4:x16
**/
  UINT8                       DmiTS0TW;

/** Offset 0x071B - Thermal Sensor 1 Target Width
  Thermal Sensor 1 Target Width.
  0:x1, 1:x2, 2:x4, 3:x8, 4:x16
**/
  UINT8                       DmiTS1TW;

/** Offset 0x071C - Thermal Sensor 2 Target Width
  Thermal Sensor 2 Target Width.
  0:x1, 1:x2, 2:x4, 3:x8, 4:x16
**/
  UINT8                       DmiTS2TW;

/** Offset 0x071D - Thermal Sensor 3 Target Width
  Thermal Sensor 3 Target Width.
  0:x1, 1:x2, 2:x4, 3:x8, 4:x16
**/
  UINT8                       DmiTS3TW;

/** Offset 0x071E - Port 0 T1 Multipler
  Port 0 T1 Multipler.
**/
  UINT8                       SataP0T1M;

/** Offset 0x071F - Port 0 T2 Multipler
  Port 0 T2 Multipler.
**/
  UINT8                       SataP0T2M;

/** Offset 0x0720 - Port 0 T3 Multipler
  Port 0 T3 Multipler.
**/
  UINT8                       SataP0T3M;

/** Offset 0x0721 - Port 0 Tdispatch
  Port 0 Tdispatch.
**/
  UINT8                       SataP0TDisp;

/** Offset 0x0722 - Port 1 T1 Multipler
  Port 1 T1 Multipler.
**/
  UINT8                       SataP1T1M;

/** Offset 0x0723 - Port 1 T2 Multipler
  Port 1 T2 Multipler.
**/
  UINT8                       SataP1T2M;

/** Offset 0x0724 - Port 1 T3 Multipler
  Port 1 T3 Multipler.
**/
  UINT8                       SataP1T3M;

/** Offset 0x0725 - Port 1 Tdispatch
  Port 1 Tdispatch.
**/
  UINT8                       SataP1TDisp;

/** Offset 0x0726 - Port 0 Tinactive
  Port 0 Tinactive.
**/
  UINT8                       SataP0Tinact;

/** Offset 0x0727 - Port 0 Alternate Fast Init Tdispatch
  Port 0 Alternate Fast Init Tdispatch.
  $EN_DIS
**/
  UINT8                       SataP0TDispFinit;

/** Offset 0x0728 - Port 1 Tinactive
  Port 1 Tinactive.
**/
  UINT8                       SataP1Tinact;

/** Offset 0x0729 - Port 1 Alternate Fast Init Tdispatch
  Port 1 Alternate Fast Init Tdispatch.
  $EN_DIS
**/
  UINT8                       SataP1TDispFinit;

/** Offset 0x072A - Sata Thermal Throttling Suggested Setting
  Sata Thermal Throttling Suggested Setting.
  $EN_DIS
**/
  UINT8                       SataThermalSuggestedSetting;

/** Offset 0x072B - Enable Memory Thermal Throttling
  Enable Memory Thermal Throttling.
  $EN_DIS
**/
  UINT8                       PchMemoryThrottlingEnable;

/** Offset 0x072C - Memory Thermal Throttling
  Enable Memory Thermal Throttling.
**/
  UINT8                       PchMemoryPmsyncEnable[2];

/** Offset 0x072E - Enable Memory Thermal Throttling
  Enable Memory Thermal Throttling.
**/
  UINT8                       PchMemoryC0TransmitEnable[2];

/** Offset 0x0730 - Enable Memory Thermal Throttling
  Enable Memory Thermal Throttling.
**/
  UINT8                       PchMemoryPinSelection[2];

/** Offset 0x0732 - Thermal Device Temperature
  Decides the temperature.
**/
  UINT16                      PchTemperatureHotLevel;

/** Offset 0x0734 - Enable xHCI Compliance Mode
  Compliance Mode can be enabled for testing through this option but this is disabled
  by default.
  $EN_DIS
**/
  UINT8                       PchEnableComplianceMode;

/** Offset 0x0735 - USB2 Port Over Current Pin
  Describe the specific over current pin number of USB 2.0 Port N.
**/
  UINT8                       Usb2OverCurrentPin[16];

/** Offset 0x0745 - USB3 Port Over Current Pin
  Describe the specific over current pin number of USB 3.0 Port N.
**/
  UINT8                       Usb3OverCurrentPin[10];

/** Offset 0x074F - Enable 8254 Static Clock Gating
  Set 8254CGE=1 is required for SLP_S0 support. However, set 8254CGE=1 in POST time
  might fail to boot legacy OS using 8254 timer. Make sure it is disabled to support
  boot legacy OS using 8254 timer. Also enable this while S0ix is enabled.
  $EN_DIS
**/
  UINT8                       Enable8254ClockGating;

/** Offset 0x0750 - PCH Sata Rst Optane Memory
  Optane Memory
  $EN_DIS
**/
  UINT8                       SataRstOptaneMemory;

/** Offset 0x0751 - PCH Sata Rst CPU Attached Storage
  CPU Attached Storage
  $EN_DIS
**/
  UINT8                       SataRstCpuAttachedStorage;

/** Offset 0x0752
**/
  UINT8                       UnusedUpdSpace25[2];

/** Offset 0x0754 - Pch PCIE device override table pointer
  The PCIe device table is being used to override PCIe device ASPM settings. This
  is a pointer points to a 32bit address. And it's only used in PostMem phase. Please
  refer to PCH_PCIE_DEVICE_OVERRIDE structure for the table. Last entry VendorId
  must be 0.
**/
  UINT32                      PchPcieDeviceOverrideTablePtr;

/** Offset 0x0758 - Enable TCO timer.
  When FALSE, it disables PCH ACPI timer, and stops TCO timer. NOTE: This will have
  huge power impact when it's enabled. If TCO timer is disabled, uCode ACPI timer
  emulation must be enabled, and WDAT table must not be exposed to the OS.
  $EN_DIS
**/
  UINT8                       EnableTcoTimer;

/** Offset 0x0759 - BgpdtHash[4]
  BgpdtHash values
**/
  UINT64                      BgpdtHash[4];

/** Offset 0x0779 - BiosGuardAttr
  BiosGuardAttr default values
**/
  UINT32                      BiosGuardAttr;

/** Offset 0x077D - BiosGuardModulePtr
  BiosGuardModulePtr default values
**/
  UINT64                      BiosGuardModulePtr;

/** Offset 0x0785 - SendEcCmd
  SendEcCmd function pointer. \n
  @code typedef EFI_STATUS (EFIAPI *PLATFORM_SEND_EC_COMMAND) (IN EC_COMMAND_TYPE 
  EcCmdType, IN UINT8  EcCmd, IN UINT8  SendData, IN OUT UINT8  *ReceiveData); @endcode
**/
  UINT64                      SendEcCmd;

/** Offset 0x078D - EcCmdProvisionEav
  Ephemeral Authorization Value default values. Provisions an ephemeral shared secret to the EC
**/
  UINT8                       EcCmdProvisionEav;

/** Offset 0x078E - EcCmdLock
  EcCmdLock default values. Locks Ephemeral Authorization Value sent previously
**/
  UINT8                       EcCmdLock;

/** Offset 0x078F - SgxEpoch0
  SgxEpoch0 default values
**/
  UINT64                      SgxEpoch0;

/** Offset 0x0797 - SgxEpoch1
  SgxEpoch1 default values
**/
  UINT64                      SgxEpoch1;

/** Offset 0x079F - SgxSinitNvsData
  SgxSinitNvsData default values
**/
  UINT8                       SgxSinitNvsData;

/** Offset 0x07A0 - Si Config CSM Flag.
  Platform specific common policies that used by several silicon components. CSM status flag.
  $EN_DIS
**/
  UINT8                       SiCsmFlag;

/** Offset 0x07A1
**/
  UINT32                      SiSsidTablePtr;

/** Offset 0x07A5
**/
  UINT16                      SiNumberOfSsidTableEntry;

/** Offset 0x07A7 - SATA RST Interrupt Mode
  Allowes to choose which interrupts will be implemented by SATA controller in RAID mode.
  0:Msix, 1:Msi, 2:Legacy
**/
  UINT8                       SataRstInterrupt;

/** Offset 0x07A8 - ME Unconfig on RTC clear
  0: Disable ME Unconfig On Rtc Clear. <b>1: Enable ME Unconfig On Rtc Clear</b>.
  2: Cmos is clear, status unkonwn. 3: Reserved
  0: Disable ME Unconfig On Rtc Clear, 1: Enable ME Unconfig On Rtc Clear, 2: Cmos
  is clear, 3: Reserved
**/
  UINT8                       MeUnconfigOnRtcClear;

/** Offset 0x07A9 - Enable PS_ON.
  PS_ON is a new C10 state from the CPU on desktop SKUs that enables a lower power
  target that will be required by the California Energy Commission (CEC). When FALSE,
  PS_ON is to be disabled.
  $EN_DIS
**/
  UINT8                       PsOnEnable;

/** Offset 0x07AA - Pmc Cpu C10 Gate Pin Enable
  Enable/Disable platform support for CPU_C10_GATE# pin to control gating of CPU VccIO
  and VccSTG rails instead of SLP_S0# pin.
  $EN_DIS
**/
  UINT8                       PmcCpuC10GatePinEnable;

/** Offset 0x07AB
**/
  UINT8                       ReservedFspsUpd[2];
} FSP_S_CONFIG;

/** Fsp S Test Configuration
**/
typedef struct {

/** Offset 0x07AD
**/
  UINT32                      Signature;

/** Offset 0x07B1 - Enable/Disable Device 7 
  Enable: Device  7 enabled, Disable (Default): Device 7 disabled
  $EN_DIS
**/
  UINT8                       ChapDeviceEnable;

/** Offset 0x07B2 - Skip PAM regsiter lock
  Enable: PAM register will not be locked by RC, platform code should lock it, Disable(Default):
  PAM registers will be locked by RC
  $EN_DIS
**/
  UINT8                       SkipPamLock;

/** Offset 0x07B3 - EDRAM Test Mode
  Enable: PAM register will not be locked by RC, platform code should lock it, Disable(Default):
  PAM registers will be locked by RC
  0: EDRAM SW disable, 1: EDRAM SW Enable, 2: EDRAM HW mode
**/
  UINT8                       EdramTestMode;

/** Offset 0x07B4 - DMI Extended Sync Control
  Enable: Enable DMI Extended Sync Control, Disable(Default): Disable DMI Extended
  Sync Control
  $EN_DIS
**/
  UINT8                       DmiExtSync;

/** Offset 0x07B5 - DMI IOT Control
  Enable: Enable DMI IOT Control, Disable(Default): Disable DMI IOT Control
  $EN_DIS
**/
  UINT8                       DmiIot;

/** Offset 0x07B6 - PEG Max Payload size per root port
  0xFF(Default):Auto, 0x1: Force 128B, 0x2: Force 256B
  0xFF: Auto, 0x1: Force 128B, 0x2: Force 256B
**/
  UINT8                       PegMaxPayload[4];

/** Offset 0x07BA - Enable/Disable IGFX RenderStandby
  Enable(Default): Enable IGFX RenderStandby, Disable: Disable IGFX RenderStandby
  $EN_DIS
**/
  UINT8                       RenderStandby;

/** Offset 0x07BB - Enable/Disable IGFX PmSupport
  Enable(Default): Enable IGFX PmSupport, Disable: Disable IGFX PmSupport
  $EN_DIS
**/
  UINT8                       PmSupport;

/** Offset 0x07BC - Enable/Disable CdynmaxClamp
  Enable: Enable CdynmaxClamp, Disable(Default): Disable CdynmaxClamp
  $EN_DIS
**/
  UINT8                       CdynmaxClampEnable;

/** Offset 0x07BD - Disable VT-d
  0=Enable/FALSE(VT-d enabled), 1=Disable/TRUE (VT-d disabled)
  $EN_DIS
**/
  UINT8                       VtdDisable;

/** Offset 0x07BE - GT Frequency Limit
  0xFF: Auto(Default), 2: 100 Mhz, 3: 150 Mhz, 4: 200 Mhz, 5: 250 Mhz, 6: 300 Mhz,
  7: 350 Mhz, 8: 400 Mhz, 9: 450 Mhz, 0xA: 500 Mhz, 0xB: 550 Mhz, 0xC: 600 Mhz, 0xD:
  650 Mhz, 0xE: 700 Mhz, 0xF: 750 Mhz, 0x10: 800 Mhz, 0x11: 850 Mhz, 0x12:900 Mhz,
  0x13: 950 Mhz, 0x14: 1000 Mhz, 0x15: 1050 Mhz, 0x16: 1100 Mhz, 0x17: 1150 Mhz,
  0x18: 1200 Mhz
  0xFF: Auto(Default), 2: 100 Mhz, 3: 150 Mhz, 4: 200 Mhz, 5: 250 Mhz, 6: 300 Mhz,
  7: 350 Mhz, 8: 400 Mhz, 9: 450 Mhz, 0xA: 500 Mhz, 0xB: 550 Mhz, 0xC: 600 Mhz, 0xD:
  650 Mhz, 0xE: 700 Mhz, 0xF: 750 Mhz, 0x10: 800 Mhz, 0x11: 850 Mhz, 0x12:900 Mhz,
  0x13: 950 Mhz, 0x14: 1000 Mhz, 0x15: 1050 Mhz, 0x16: 1100 Mhz, 0x17: 1150 Mhz,
  0x18: 1200 Mhz
**/
  UINT8                       GtFreqMax;

/** Offset 0x07BF - Disable Turbo GT
   0=Disable: GT frequency is not limited, 1=Enable: Disables Turbo GT frequency
  $EN_DIS
**/
  UINT8                       DisableTurboGt;

/** Offset 0x07C0 - SaPostMemTestRsvd
  Reserved for SA Post-Mem Test
  $EN_DIS
**/
  UINT8                       SaPostMemTestRsvd[11];

/** Offset 0x07CB - 1-Core Ratio Limit
  1-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  1-Core Ratio Limit + OC Bins.This 1-Core Ratio Limit Must be greater than or equal
  to 2-Core Ratio Limit, 3-Core Ratio Limit, 4-Core Ratio Limit, 5-Core Ratio Limit,
  6-Core Ratio Limit, 7-Core Ratio Limit, 8-Core Ratio Limit. Range is 0 to 83
**/
  UINT8                       OneCoreRatioLimit;

/** Offset 0x07CC - 2-Core Ratio Limit
  2-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  2-Core Ratio Limit + OC Bins.This 2-Core Ratio Limit Must be Less than or equal
  to 1-Core Ratio Limit.Range is 0 to 83
**/
  UINT8                       TwoCoreRatioLimit;

/** Offset 0x07CD - 3-Core Ratio Limit
  3-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  3-Core Ratio Limit + OC Bins.This 3-Core Ratio Limit Must be Less than or equal
  to 1-Core Ratio Limit.Range is 0 to 83
**/
  UINT8                       ThreeCoreRatioLimit;

/** Offset 0x07CE - 4-Core Ratio Limit
  4-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  4-Core Ratio Limit + OC Bins.This 4-Core Ratio Limit Must be Less than or equal
  to 1-Core Ratio Limit.Range is 0 to 83
**/
  UINT8                       FourCoreRatioLimit;

/** Offset 0x07CF - Enable or Disable HWP
  Enable or Disable HWP(Hardware P states) Support. 0: Disable; <b>1: Enable;</b>
  2-3:Reserved
  $EN_DIS
**/
  UINT8                       Hwp;

/** Offset 0x07D0 - Hardware Duty Cycle Control
  Hardware Duty Cycle Control configuration. 0: Disabled; <b>1: Enabled</b> 2-3:Reserved
  $EN_DIS
**/
  UINT8                       HdcControl;

/** Offset 0x07D1 - Package Long duration turbo mode time
  Package Long duration turbo mode time window in seconds. Valid values(Unit in seconds)
  0 to 8 , 10 , 12 ,14 , 16 , 20 , 24 , 28 , 32 , 40 , 48 , 56 , 64 , 80 , 96 , 112 , 128
**/
  UINT8                       PowerLimit1Time;

/** Offset 0x07D2 - Short Duration Turbo Mode
  Enable or Disable short duration Turbo Mode. </b>0 : Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       PowerLimit2;

/** Offset 0x07D3 - Turbo settings Lock
  Lock all Turbo settings Enable/Disable; <b>0: Disable , </b> 1: Enable
  $EN_DIS
**/
  UINT8                       TurboPowerLimitLock;

/** Offset 0x07D4 - Package PL3 time window
  Package PL3 time window range for this policy from 0 to 64ms
**/
  UINT8                       PowerLimit3Time;

/** Offset 0x07D5 - Package PL3 Duty Cycle
  Package PL3 Duty Cycle; Valid Range is 0 to 100
**/
  UINT8                       PowerLimit3DutyCycle;

/** Offset 0x07D6 - Package PL3 Lock
  Package PL3 Lock Enable/Disable; <b>0: Disable ; <b> 1: Enable
  $EN_DIS
**/
  UINT8                       PowerLimit3Lock;

/** Offset 0x07D7 - Package PL4 Lock
  Package PL4 Lock Enable/Disable; <b>0: Disable ; <b>1: Enable
  $EN_DIS
**/
  UINT8                       PowerLimit4Lock;

/** Offset 0x07D8 - TCC Activation Offset
  TCC Activation Offset. Offset from factory set TCC activation temperature at which
  the Thermal Control Circuit must be activated. TCC will be activated at TCC Activation
  Temperature, in volts.For Y SKU, the recommended default for this policy is  <b>10</b>,
  For all other SKUs the recommended default are <b>0</b>
**/
  UINT8                       TccActivationOffset;

/** Offset 0x07D9 - Tcc Offset Clamp Enable/Disable
  Tcc Offset Clamp for Runtime Average Temperature Limit (RATL) allows CPU to throttle
  below P1.For Y SKU, the recommended default for this policy is <b>1: Enabled</b>,
  For all other SKUs the recommended default are  <b>0: Disabled</b>.
  $EN_DIS
**/
  UINT8                       TccOffsetClamp;

/** Offset 0x07DA - Tcc Offset Lock
  Tcc Offset Lock for Runtime Average Temperature Limit (RATL) to lock temperature
  target; 0: Disabled; <b>1: Enabled </b>.
  $EN_DIS
**/
  UINT8                       TccOffsetLock;

/** Offset 0x07DB - Custom Ratio State Entries
  The number of custom ratio state entries, ranges from 0 to 40 for a valid custom
  ratio table.Sets the number of custom P-states. At least 2 states must be present
**/
  UINT8                       NumberOfEntries;

/** Offset 0x07DC - Custom Short term Power Limit time window
  Short term Power Limit time window value for custom CTDP level 1. Valid Range 0 to 128
**/
  UINT8                       Custom1PowerLimit1Time;

/** Offset 0x07DD - Custom Turbo Activation Ratio
  Turbo Activation Ratio for custom cTDP level 1. Valid Range 0 to 255
**/
  UINT8                       Custom1TurboActivationRatio;

/** Offset 0x07DE - Custom Config Tdp Control
  Config Tdp Control (0/1/2) value for custom cTDP level 1. Valid Range is 0 to 2
**/
  UINT8                       Custom1ConfigTdpControl;

/** Offset 0x07DF - Custom Short term Power Limit time window
  Short term Power Limit time window value for custom CTDP level 2. Valid Range 0 to 128
**/
  UINT8                       Custom2PowerLimit1Time;

/** Offset 0x07E0 - Custom Turbo Activation Ratio
  Turbo Activation Ratio for custom cTDP level 2. Valid Range 0 to 255
**/
  UINT8                       Custom2TurboActivationRatio;

/** Offset 0x07E1 - Custom Config Tdp Control
  Config Tdp Control (0/1/2) value for custom cTDP level 1. Valid Range is 0 to 2
**/
  UINT8                       Custom2ConfigTdpControl;

/** Offset 0x07E2 - Custom Short term Power Limit time window
  Short term Power Limit time window value for custom CTDP level 3. Valid Range 0 to 128
**/
  UINT8                       Custom3PowerLimit1Time;

/** Offset 0x07E3 - Custom Turbo Activation Ratio
  Turbo Activation Ratio for custom cTDP level 3. Valid Range 0 to 255
**/
  UINT8                       Custom3TurboActivationRatio;

/** Offset 0x07E4 - Custom Config Tdp Control
  Config Tdp Control (0/1/2) value for custom cTDP level 1. Valid Range is 0 to 2
**/
  UINT8                       Custom3ConfigTdpControl;

/** Offset 0x07E5 - ConfigTdp mode settings Lock
  Lock the ConfigTdp mode settings from runtime changes; <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       ConfigTdpLock;

/** Offset 0x07E6 - Load Configurable TDP SSDT
  Configure whether to load Configurable TDP SSDT; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       ConfigTdpBios;

/** Offset 0x07E7 - PL1 Enable value
  PL1 Enable value to limit average platform power. <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       PsysPowerLimit1;

/** Offset 0x07E8 - PL1 timewindow
  PL1 timewindow in seconds.Valid values(Unit in seconds) 0 to 8 , 10 , 12 ,14 , 16
  , 20 , 24 , 28 , 32 , 40 , 48 , 56 , 64 , 80 , 96 , 112 , 128
**/
  UINT8                       PsysPowerLimit1Time;

/** Offset 0x07E9 - PL2 Enable Value
  PL2 Enable activates the PL2 value to limit average platform power.<b>0: Disable</b>;
  1: Enable.
  $EN_DIS
**/
  UINT8                       PsysPowerLimit2;

/** Offset 0x07EA - Enable or Disable MLC Streamer Prefetcher
  Enable or Disable MLC Streamer Prefetcher; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       MlcStreamerPrefetcher;

/** Offset 0x07EB - Enable or Disable MLC Spatial Prefetcher
  Enable or Disable MLC Spatial Prefetcher; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       MlcSpatialPrefetcher;

/** Offset 0x07EC - Enable or Disable Monitor /MWAIT instructions
  Enable or Disable Monitor /MWAIT instructions; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       MonitorMwaitEnable;

/** Offset 0x07ED - Enable or Disable initialization of machine check registers
  Enable or Disable initialization of machine check registers; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       MachineCheckEnable;

/** Offset 0x07EE - Enable or Disable processor debug features
  Enable or Disable processor debug features; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       DebugInterfaceEnable;

/** Offset 0x07EF - Lock or Unlock debug interface features
  Lock or Unlock debug interface features; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       DebugInterfaceLockEnable;

/** Offset 0x07F0 - AP Idle Manner of waiting for SIPI
  AP Idle Manner of waiting for SIPI; 1: HALT loop; <b>2: MWAIT loop</b>; 3: RUN loop.
  1: HALT loop, 2: MWAIT loop, 3: RUN loop
**/
  UINT8                       ApIdleManner;

/** Offset 0x07F1 - Control on Processor Trace output scheme
  Control on Processor Trace output scheme; <b>0: Single Range Output</b>; 1: ToPA Output.
  0: Single Range Output, 1: ToPA Output
**/
  UINT8                       ProcessorTraceOutputScheme;

/** Offset 0x07F2 - Enable or Disable Processor Trace feature
  Enable or Disable Processor Trace feature; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       ProcessorTraceEnable;

/** Offset 0x07F3 - Base of memory region allocated for Processor Trace
  Base address of memory region allocated for Processor Trace. Processor Trace requires
  2^N alignment and size in bytes per thread, from 4KB to 128MB. <b>0: Disable</b>
**/
  UINT64                      ProcessorTraceMemBase;

/** Offset 0x07FB - Memory region allocation for Processor Trace
  Length in bytes of memory region allocated for Processor Trace. Processor Trace
  requires 2^N alignment and size in bytes per thread, from 4KB to 128MB. <b>0: Disable</b>
**/
  UINT32                      ProcessorTraceMemLength;

/** Offset 0x07FF - Enable or Disable Voltage Optimization feature
  Enable or Disable Voltage Optimization feature 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       VoltageOptimization;

/** Offset 0x0800 - Enable or Disable Intel SpeedStep Technology
  Enable or Disable Intel SpeedStep Technology. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       Eist;

/** Offset 0x0801 - Enable or Disable Energy Efficient P-state
  Enable or Disable Energy Efficient P-state will be applied in Turbo mode. Disable;
  <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       EnergyEfficientPState;

/** Offset 0x0802 - Enable or Disable Energy Efficient Turbo
  Enable or Disable Energy Efficient Turbo, will be applied in Turbo mode. Disable;
  <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       EnergyEfficientTurbo;

/** Offset 0x0803 - Enable or Disable T states
  Enable or Disable T states; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       TStates;

/** Offset 0x0804 - Enable or Disable Bi-Directional PROCHOT#
  Enable or Disable Bi-Directional PROCHOT#; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       BiProcHot;

/** Offset 0x0805 - Enable or Disable PROCHOT# signal being driven externally
  Enable or Disable PROCHOT# signal being driven externally; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       DisableProcHotOut;

/** Offset 0x0806 - Enable or Disable PROCHOT# Response
  Enable or Disable PROCHOT# Response; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       ProcHotResponse;

/** Offset 0x0807 - Enable or Disable VR Thermal Alert
  Enable or Disable VR Thermal Alert; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       DisableVrThermalAlert;

/** Offset 0x0808 - Enable or Disable Thermal Reporting
  Enable or Disable Thermal Reporting through ACPI tables; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       AutoThermalReporting;

/** Offset 0x0809 - Enable or Disable Thermal Monitor
  Enable or Disable Thermal Monitor; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       ThermalMonitor;

/** Offset 0x080A - Enable or Disable CPU power states (C-states)
  Enable or Disable CPU power states (C-states). 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       Cx;

/** Offset 0x080B - Configure C-State Configuration Lock
  Configure C-State Configuration Lock; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       PmgCstCfgCtrlLock;

/** Offset 0x080C - Enable or Disable Enhanced C-states
  Enable or Disable Enhanced C-states. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       C1e;

/** Offset 0x080D - Enable or Disable Package Cstate Demotion
  Enable or Disable Package Cstate Demotion. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       PkgCStateDemotion;

/** Offset 0x080E - Enable or Disable Package Cstate UnDemotion
  Enable or Disable Package Cstate UnDemotion. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       PkgCStateUnDemotion;

/** Offset 0x080F - Enable or Disable CState-Pre wake
  Enable or Disable CState-Pre wake. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       CStatePreWake;

/** Offset 0x0810 - Enable or Disable TimedMwait Support.
  Enable or Disable TimedMwait Support. <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       TimedMwait;

/** Offset 0x0811 - Enable or Disable IO to MWAIT redirection
  Enable or Disable IO to MWAIT redirection; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       CstCfgCtrIoMwaitRedirection;

/** Offset 0x0812 - Set the Max Pkg Cstate
  Set the Max Pkg Cstate. Default set to Auto which limits the Max Pkg Cstate to deep
  C-state. Valid values 0 - C0/C1 , 1 - C2 , 2 - C3 , 3 - C6 , 4 - C7 , 5 - C7S ,
  6 - C8 , 7 - C9 , 8 - C10 , 254 - CPU Default , 255 - Auto
**/
  UINT8                       PkgCStateLimit;

/** Offset 0x0813 - TimeUnit for C-State Latency Control0
  TimeUnit for C-State Latency Control0; Valid values 0 - 1ns , 1 - 32ns , 2 - 1024ns
  , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl0TimeUnit;

/** Offset 0x0814 - TimeUnit for C-State Latency Control1
  TimeUnit for C-State Latency Control1;Valid values 0 - 1ns , 1 - 32ns , 2 - 1024ns
  , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl1TimeUnit;

/** Offset 0x0815 - TimeUnit for C-State Latency Control2
  TimeUnit for C-State Latency Control2;Valid values 0 - 1ns , 1 - 32ns , 2 - 1024ns
  , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl2TimeUnit;

/** Offset 0x0816 - TimeUnit for C-State Latency Control3
  TimeUnit for C-State Latency Control3;Valid values 0 - 1ns , 1 - 32ns , 2 - 1024ns
  , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl3TimeUnit;

/** Offset 0x0817 - TimeUnit for C-State Latency Control4
  Time - 1ns , 1 - 32ns , 2 - 1024ns , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl4TimeUnit;

/** Offset 0x0818 - TimeUnit for C-State Latency Control5
  TimeUnit for C-State Latency Control5;Valid values 0 - 1ns , 1 - 32ns , 2 - 1024ns
  , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl5TimeUnit;

/** Offset 0x0819 - Interrupt Redirection Mode Select
  Interrupt Redirection Mode Select.0: Fixed priority; 1: Round robin;2: Hash vector;7:
  No change.
**/
  UINT8                       PpmIrmSetting;

/** Offset 0x081A - Lock prochot configuration
  Lock prochot configuration Enable/Disable; <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       ProcHotLock;

/** Offset 0x081B - Configuration for boot TDP selection
  Configuration for boot TDP selection; <b>0: TDP Nominal</b>; 1: TDP Down; 2: TDP
  Up;0xFF : Deactivate
**/
  UINT8                       ConfigTdpLevel;

/** Offset 0x081C - Race To Halt
  Enable/Disable Race To Halt feature. RTH will dynamically increase CPU frequency
  in order to enter pkg C-State faster to reduce overall power. (RTH is controlled
  through MSR 1FC bit 20)Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       RaceToHalt;

/** Offset 0x081D - Max P-State Ratio
  Max P-State Ratio, Valid Range 0 to 0x7F
**/
  UINT8                       MaxRatio;

/** Offset 0x081E - P-state ratios for custom P-state table
  P-state ratios for custom P-state table. NumberOfEntries has valid range between
  0 to 40. For no. of P-States supported(NumberOfEntries) , StateRatio[NumberOfEntries]
  are configurable. Valid Range of each entry is 0 to 0x7F
**/
  UINT8                       StateRatio[40];

/** Offset 0x0846 - P-state ratios for max 16 version of custom P-state table
  P-state ratios for max 16 version of custom P-state table. This table is used for
  OS versions limited to a max of 16 P-States. If the first entry of this table is
  0, or if Number of Entries is 16 or less, then this table will be ignored, and
  up to the top 16 values of the StateRatio table will be used instead. Valid Range
  of each entry is 0 to 0x7F
**/
  UINT8                       StateRatioMax16[16];

/** Offset 0x0856 - Platform Power Pmax
  PCODE MMIO Mailbox: Platform Power Pmax. <b>0 - Auto</b> Specified in 1/8 Watt increments.
  Range 0-1024 Watts. Value of 800 = 100W
**/
  UINT16                      PsysPmax;

/** Offset 0x0858
**/
  UINT8                       Reserved0[2];

/** Offset 0x085A - Interrupt Response Time Limit of C-State LatencyContol1
  Interrupt Response Time Limit of C-State LatencyContol1.Range of value 0 to 0x3FF
**/
  UINT16                      CstateLatencyControl1Irtl;

/** Offset 0x085C - Interrupt Response Time Limit of C-State LatencyContol2
  Interrupt Response Time Limit of C-State LatencyContol2.Range of value 0 to 0x3FF
**/
  UINT16                      CstateLatencyControl2Irtl;

/** Offset 0x085E - Interrupt Response Time Limit of C-State LatencyContol3
  Interrupt Response Time Limit of C-State LatencyContol3.Range of value 0 to 0x3FF
**/
  UINT16                      CstateLatencyControl3Irtl;

/** Offset 0x0860 - Interrupt Response Time Limit of C-State LatencyContol4
  Interrupt Response Time Limit of C-State LatencyContol4.Range of value 0 to 0x3FF
**/
  UINT16                      CstateLatencyControl4Irtl;

/** Offset 0x0862 - Interrupt Response Time Limit of C-State LatencyContol5
  Interrupt Response Time Limit of C-State LatencyContol5.Range of value 0 to 0x3FF
**/
  UINT16                      CstateLatencyControl5Irtl;

/** Offset 0x0864 - Package Long duration turbo mode power limit
  Package Long duration turbo mode power limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 4095875 in Step size of 125
**/
  UINT32                      PowerLimit1;

/** Offset 0x0868 - Package Short duration turbo mode power limit
  Package Short duration turbo mode power limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      PowerLimit2Power;

/** Offset 0x086C - Package PL3 power limit
  Package PL3 power limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      PowerLimit3;

/** Offset 0x0870 - Package PL4 power limit
  Package PL4 power limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      PowerLimit4;

/** Offset 0x0874 - Tcc Offset Time Window for RATL
  Package PL4 power limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      TccOffsetTimeWindowForRatl;

/** Offset 0x0878 - Short term Power Limit value for custom cTDP level 1
  Short term Power Limit value for custom cTDP level 1. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom1PowerLimit1;

/** Offset 0x087C - Long term Power Limit value for custom cTDP level 1
  Long term Power Limit value for custom cTDP level 1. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom1PowerLimit2;

/** Offset 0x0880 - Short term Power Limit value for custom cTDP level 2
  Short term Power Limit value for custom cTDP level 2. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom2PowerLimit1;

/** Offset 0x0884 - Long term Power Limit value for custom cTDP level 2
  Long term Power Limit value for custom cTDP level 2. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom2PowerLimit2;

/** Offset 0x0888 - Short term Power Limit value for custom cTDP level 3
  Short term Power Limit value for custom cTDP level 3. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom3PowerLimit1;

/** Offset 0x088C - Long term Power Limit value for custom cTDP level 3
  Long term Power Limit value for custom cTDP level 3. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom3PowerLimit2;

/** Offset 0x0890 - Platform PL1 power
  Platform PL1 power. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid Range
  0 to 4095875 in Step size of 125
**/
  UINT32                      PsysPowerLimit1Power;

/** Offset 0x0894 - Platform PL2 power
  Platform PL2 power. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid Range
  0 to 4095875 in Step size of 125
**/
  UINT32                      PsysPowerLimit2Power;

/** Offset 0x0898 - Set Three Strike Counter Disable
  False (default): Three Strike counter will be incremented and True: Prevents Three
  Strike counter from incrementing; <b>0: False</b>; 1: True.
  0: False, 1: True
**/
  UINT8                       ThreeStrikeCounterDisable;

/** Offset 0x0899 - Set HW P-State Interrupts Enabled for for MISC_PWR_MGMT
  Set HW P-State Interrupts Enabled for for MISC_PWR_MGMT; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       HwpInterruptControl;

/** Offset 0x089A - 5-Core Ratio Limit
  5-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  5-Core Ratio Limit + OC Bins.This 5-Core Ratio Limit Must be Less than or equal
  to 1-Core Ratio Limit.Range is 0 to 83
  0x0:0xFF
**/
  UINT8                       FiveCoreRatioLimit;

/** Offset 0x089B - 6-Core Ratio Limit
  6-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  6-Core Ratio Limit + OC Bins.This 6-Core Ratio Limit Must be Less than or equal
  to 1-Core Ratio Limit.Range is 0 to 83
  0x0:0xFF
**/
  UINT8                       SixCoreRatioLimit;

/** Offset 0x089C - 7-Core Ratio Limit
  7-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  7-Core Ratio Limit + OC Bins.This 7-Core Ratio Limit Must be Less than or equal
  to 1-Core Ratio Limit.Range is 0 to 83
  0x0:0xFF
**/
  UINT8                       SevenCoreRatioLimit;

/** Offset 0x089D - 8-Core Ratio Limit
  8-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  8-Core Ratio Limit + OC Bins.This 8-Core Ratio Limit Must be Less than or equal
  to 1-Core Ratio Limit.Range is 0 to 83
  0x0:0xFF
**/
  UINT8                       EightCoreRatioLimit;

/** Offset 0x089E - Intel Turbo Boost Max Technology 3.0
  Intel Turbo Boost Max Technology 3.0. 0: Disabled; <b>1: Enabled</b>
  $EN_DIS
**/
  UINT8                       EnableItbm;

/** Offset 0x089F - Intel Turbo Boost Max Technology 3.0 Driver
  Intel Turbo Boost Max Technology 3.0 Driver <b>0: Disabled</b>; 1: Enabled
  $EN_DIS
**/
  UINT8                       EnableItbmDriver;

/** Offset 0x08A0 - Enable or Disable C1 Cstate Demotion
  Enable or Disable C1 Cstate Demotion. Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       C1StateAutoDemotion;

/** Offset 0x08A1 - Enable or Disable C1 Cstate UnDemotion
  Enable or Disable C1 Cstate UnDemotion. Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       C1StateUnDemotion;

/** Offset 0x08A2 - CpuWakeUpTimer
  Enable long CPU Wakeup Timer. When enabled, the cpu internal wakeup time is increased
  to 180 seconds. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       CpuWakeUpTimer;

/** Offset 0x08A3 - Minimum Ring ratio limit override
  Minimum Ring ratio limit override. <b>0: Hardware defaults.</b> Range: 0 - Max turbo
  ratio limit
**/
  UINT8                       MinRingRatioLimit;

/** Offset 0x08A4 - Minimum Ring ratio limit override
  Maximum Ring ratio limit override. <b>0: Hardware defaults.</b> Range: 0 - Max turbo
  ratio limit
**/
  UINT8                       MaxRingRatioLimit;

/** Offset 0x08A5 - ReservedCpuPostMemTest
  Reserved for CPU Post-Mem Test
  $EN_DIS
**/
  UINT8                       ReservedCpuPostMemTest[21];

/** Offset 0x08BA - SgxSinitDataFromTpm
  SgxSinitDataFromTpm default values
**/
  UINT8                       SgxSinitDataFromTpm;

/** Offset 0x08BB - End of Post message
  Test, Send End of Post message. Disable(0x0): Disable EOP message, Send in PEI(0x1):
  EOP send in PEI, Send in DXE(0x2)(Default): EOP send in PEI
  0:Disable, 1:Send in PEI, 2:Send in DXE, 3:Reserved
**/
  UINT8                       EndOfPostMessage;

/** Offset 0x08BC - D0I3 Setting for HECI Disable
  Test, 0: disable, 1: enable, Setting this option disables setting D0I3 bit for all
  HECI devices
  $EN_DIS
**/
  UINT8                       DisableD0I3SettingForHeci;

/** Offset 0x08BD - HD Audio Reset Wait Timer
  The delay timer after Azalia reset, the value is number of microseconds. Default is 600.
**/
  UINT16                      PchHdaResetWaitTimer;

/** Offset 0x08BF - Enable LOCKDOWN SMI
  Enable SMI_LOCK bit to prevent writes to the Global SMI Enable bit.
  $EN_DIS
**/
  UINT8                       PchLockDownGlobalSmi;

/** Offset 0x08C0 - Enable LOCKDOWN BIOS Interface
  Enable BIOS Interface Lock Down bit to prevent writes to the Backup Control Register.
  $EN_DIS
**/
  UINT8                       PchLockDownBiosInterface;

/** Offset 0x08C1 - Unlock all GPIO pads
  Force all GPIO pads to be unlocked for debug purpose.
  $EN_DIS
**/
  UINT8                       PchUnlockGpioPads;

/** Offset 0x08C2 - PCH Unlock SBI access
  This unlock the SBI lock bit to allow SBI after post time. 0: Lock SBI access; 1:
  Unlock SBI access.
  $EN_DIS
**/
  UINT8                       PchSbiUnlock;

/** Offset 0x08C3 - PCH Unlock SideBand access
  The SideBand PortID mask for certain end point (e.g. PSFx) will be locked before
  3rd party code execution. 0: Lock SideBand access; 1: Unlock SideBand access.
  $EN_DIS
**/
  UINT8                       PchSbAccessUnlock;

/** Offset 0x08C4 - PCIE RP Ltr Max Snoop Latency
  Latency Tolerance Reporting, Max Snoop Latency.
**/
  UINT16                      PcieRpLtrMaxSnoopLatency[24];

/** Offset 0x08F4 - PCIE RP Ltr Max No Snoop Latency
  Latency Tolerance Reporting, Max Non-Snoop Latency.
**/
  UINT16                      PcieRpLtrMaxNoSnoopLatency[24];

/** Offset 0x0924 - PCIE RP Snoop Latency Override Mode
  Latency Tolerance Reporting, Snoop Latency Override Mode.
**/
  UINT8                       PcieRpSnoopLatencyOverrideMode[24];

/** Offset 0x093C - PCIE RP Snoop Latency Override Multiplier
  Latency Tolerance Reporting, Snoop Latency Override Multiplier.
**/
  UINT8                       PcieRpSnoopLatencyOverrideMultiplier[24];

/** Offset 0x0954 - PCIE RP Snoop Latency Override Value
  Latency Tolerance Reporting, Snoop Latency Override Value.
**/
  UINT16                      PcieRpSnoopLatencyOverrideValue[24];

/** Offset 0x0984 - PCIE RP Non Snoop Latency Override Mode
  Latency Tolerance Reporting, Non-Snoop Latency Override Mode.
**/
  UINT8                       PcieRpNonSnoopLatencyOverrideMode[24];

/** Offset 0x099C - PCIE RP Non Snoop Latency Override Multiplier
  Latency Tolerance Reporting, Non-Snoop Latency Override Multiplier.
**/
  UINT8                       PcieRpNonSnoopLatencyOverrideMultiplier[24];

/** Offset 0x09B4 - PCIE RP Non Snoop Latency Override Value
  Latency Tolerance Reporting, Non-Snoop Latency Override Value.
**/
  UINT16                      PcieRpNonSnoopLatencyOverrideValue[24];

/** Offset 0x09E4 - PCIE RP Slot Power Limit Scale
  Specifies scale used for slot power limit value. Leave as 0 to set to default.
**/
  UINT8                       PcieRpSlotPowerLimitScale[24];

/** Offset 0x09FC - PCIE RP Slot Power Limit Value
  Specifies upper limit on power supplie by slot. Leave as 0 to set to default.
**/
  UINT16                      PcieRpSlotPowerLimitValue[24];

/** Offset 0x0A2C - PCIE RP Upstream Port Transmiter Preset
  Used during Gen3 Link Equalization. Used for all lanes.  Default is 5.
**/
  UINT8                       PcieRpUptp[24];

/** Offset 0x0A44 - PCIE RP Downstream Port Transmiter Preset
  Used during Gen3 Link Equalization. Used for all lanes.  Default is 7.
**/
  UINT8                       PcieRpDptp[24];

/** Offset 0x0A5C - PCIE RP Enable Port8xh Decode
  This member describes whether PCIE root port Port 8xh Decode is enabled. 0: Disable;
  1: Enable.
  $EN_DIS
**/
  UINT8                       PcieEnablePort8xhDecode;

/** Offset 0x0A5D - PCIE Port8xh Decode Port Index
  The Index of PCIe Port that is selected for Port8xh Decode (0 Based).
**/
  UINT8                       PchPciePort8xhDecodePortIndex;

/** Offset 0x0A5E - PCH Energy Reporting
  Disable/Enable PCH to CPU energy report feature.
  $EN_DIS
**/
  UINT8                       PchPmDisableEnergyReport;

/** Offset 0x0A5F - PCH Sata Test Mode
  Allow entrance to the PCH SATA test modes.
  $EN_DIS
**/
  UINT8                       SataTestMode;

/** Offset 0x0A60 - PCH USB OverCurrent mapping lock enable
  If this policy option is enabled then BIOS will program OCCFDONE bit in xHCI meaning
  that OC mapping data will be consumed by xHCI and OC mapping registers will be locked.
  $EN_DIS
**/
  UINT8                       PchXhciOcLock;

/** Offset 0x0A61
**/
  UINT8                       UnusedUpdSpace26[17];

/** Offset 0x0A72 - Skip POSTBOOT SAI
  This skip the Post Boot Sai programming. 0: Set Post Boot Sai; 1: Skip Post Boot Sai.
  $EN_DIS
**/
  UINT8                       SkipPostBootSai;

/** Offset 0x0A73 - Mctp Broadcast Cycle
  Test, Determine if MCTP Broadcast is enabled <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       MctpBroadcastCycle;

/** Offset 0x0A74
**/
  UINT8                       ReservedFspsTestUpd[12];
} FSP_S_TEST_CONFIG;

/** Fsp S UPD Configuration
**/
typedef struct {

/** Offset 0x0000
**/
  FSP_UPD_HEADER              FspUpdHeader;

/** Offset 0x0020
**/
  FSP_S_CONFIG                FspsConfig;

/** Offset 0x07AD
**/
  FSP_S_TEST_CONFIG           FspsTestConfig;

/** Offset 0x0A80
**/
  UINT16                      UpdTerminator;
} FSPS_UPD;

#pragma pack()

#endif
