/** @file

Copyright (c) 2017, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPSUPD_H__
#define __FSPSUPD_H__

#include <FspUpd.h>

#pragma pack(1)


#include <ConfigBlock/CpuConfigFspData.h>
///
/// Azalia Header structure
///
typedef struct {
  UINT16 VendorId;           ///< Codec Vendor ID
  UINT16 DeviceId;           ///< Codec Device ID
  UINT8  RevisionId;         ///< Revision ID of the codec. 0xFF matches any revision.
  UINT8  SdiNum;             ///< SDI number, 0xFF matches any SDI.
  UINT16 DataDwords;         ///< Number of data DWORDs pointed by the codec data buffer.
  UINT32 Reserved;           ///< Reserved for future use. Must be set to 0.
} AZALIA_HEADER;

///
/// Audio Azalia Verb Table structure
///
typedef struct {
  AZALIA_HEADER Header;      ///< AZALIA PCH header
  UINT32        *Data;       ///< Pointer to the data buffer. Its length is specified in the header
} AUDIO_AZALIA_VERB_TABLE;

///
/// Refer to the definition of PCH_INT_PIN
///
typedef enum {
  SiPchNoInt,        ///< No Interrupt Pin
  SiPchIntA,
  SiPchIntB,
  SiPchIntC,
  SiPchIntD
} SI_PCH_INT_PIN;
///
/// The PCH_DEVICE_INTERRUPT_CONFIG block describes interrupt pin, IRQ and interrupt mode for PCH device.
///
typedef struct {
  UINT8        Device;                  ///< Device number
  UINT8        Function;                ///< Device function
  UINT8        IntX;                    ///< Interrupt pin: INTA-INTD (see SI_PCH_INT_PIN)
  UINT8        Irq;                     ///< IRQ to be set for device.
} SI_PCH_DEVICE_INTERRUPT_CONFIG;

#define SI_PCH_MAX_DEVICE_INTERRUPT_CONFIG  64       ///< Number of all PCH devices


/** Fsp S Configuration
**/
typedef struct {

/** Offset 0x0020 - Logo Pointer
  Points to PEI Display Logo Image
**/
  UINT32                      LogoPtr;

/** Offset 0x0024 - Logo Size
  Size of PEI Display Logo Image
**/
  UINT32                      LogoSize;

/** Offset 0x0028 - Graphics Configuration Ptr
  Points to VBT
**/
  UINT32                      GraphicsConfigPtr;

/** Offset 0x002C - Enable Device 4
  Enable/disable Device 4
  $EN_DIS
**/
  UINT8                       Device4Enable;

/** Offset 0x002D - Enable Intel HD Audio (Azalia)
  Enable/disable Azalia controller.
  $EN_DIS
**/
  UINT8                       PchHdaEnable;

/** Offset 0x002E - Enable HD Audio DSP
  Enable/disable HD Audio DSP feature.
  $EN_DIS
**/
  UINT8                       PchHdaDspEnable;

/** Offset 0x002F - Select HDAudio IoBuffer Ownership
  Indicates the ownership of the I/O buffer between Intel HD Audio link vs I2S0 /
  I2S port. 0: Intel HD-Audio link owns all the I/O buffers. 1: Intel HD-Audio link
  owns 4 of the I/O buffers for 1 HD-Audio codec connection, and I2S1 port owns 4
  of the I/O buffers for 1 I2S codec connection. 2: Reserved. 3: I2S0 and I2S1 ports
  own all the I/O buffers.
  0:HD-A Link, 1:Shared HD-A Link and I2S Port, 3:I2S Ports
**/
  UINT8                       PchHdaIoBufferOwnership;

/** Offset 0x0030 - Enable CIO2 Controller
  Enable/disable SKYCAM CIO2 Controller.
  $EN_DIS
**/
  UINT8                       PchCio2Enable;

/** Offset 0x0031 - Enable eMMC Controller
  Enable/disable eMMC Controller.
  $EN_DIS
**/
  UINT8                       ScsEmmcEnabled;

/** Offset 0x0032 - Enable eMMC HS400 Mode
  Enable eMMC HS400 Mode.
  $EN_DIS
**/
  UINT8                       ScsEmmcHs400Enabled;

/** Offset 0x0033 - Enable SdCard Controller
  Enable/disable SD Card Controller.
  $EN_DIS
**/
  UINT8                       ScsSdCardEnabled;

/** Offset 0x0034 - Enable PCH ISH Controller
  Enable/disable ISH Controller.
  $EN_DIS
**/
  UINT8                       PchIshEnable;

/** Offset 0x0035 - Show SPI controller
  Enable/disable to show SPI controller.
  $EN_DIS
**/
  UINT8                       ShowSpiController;

/** Offset 0x0036 - Flash Configuration Lock Down
  Enable/disable flash lock down. If platform decides to skip this programming, it
  must lock SPI flash register DLOCK, FLOCKDN, and WRSDIS before end of post.
  $EN_DIS
**/
  UINT8                       SpiFlashCfgLockDown;

/** Offset 0x0037
**/
  UINT8                       UnusedUpdSpace0;

/** Offset 0x0038 - MicrocodeRegionBase
  Memory Base of Microcode Updates
**/
  UINT32                      MicrocodeRegionBase;

/** Offset 0x003C - MicrocodeRegionSize
  Size of Microcode Updates
**/
  UINT32                      MicrocodeRegionSize;

/** Offset 0x0040 - Turbo Mode
  Enable/Disable Turbo mode. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       TurboMode;

/** Offset 0x0041 - Enable SATA SALP Support
  Enable/disable SATA Aggressive Link Power Management.
  $EN_DIS
**/
  UINT8                       SataSalpSupport;

/** Offset 0x0042 - Enable SATA ports
  Enable/disable SATA ports. One byte for each port, byte0 for port0, byte1 for port1,
  and so on.
**/
  UINT8                       SataPortsEnable[8];

/** Offset 0x004A - Enable SATA DEVSLP Feature
  Enable/disable SATA DEVSLP per port. 0 is disable, 1 is enable. One byte for each
  port, byte0 for port0, byte1 for port1, and so on.
**/
  UINT8                       SataPortsDevSlp[8];

/** Offset 0x0052 - Enable USB2 ports
  Enable/disable per USB2 ports. One byte for each port, byte0 for port0, byte1 for
  port1, and so on.
**/
  UINT8                       PortUsb20Enable[16];

/** Offset 0x0062 - Enable USB3 ports
  Enable/disable per USB3 ports. One byte for each port, byte0 for port0, byte1 for
  port1, and so on.
**/
  UINT8                       PortUsb30Enable[10];

/** Offset 0x006C - Enable xDCI controller
  Enable/disable to xDCI controller.
  $EN_DIS
**/
  UINT8                       XdciEnable;

/** Offset 0x006D - Enable XHCI SSIC Enable
  Enable/disable XHCI SSIC port.
  $EN_DIS
**/
  UINT8                       SsicPortEnable;

/** Offset 0x006E
**/
  UINT8                       UnusedUpdSpace1;

/** Offset 0x006F - Number of DevIntConfig Entry
  Number of Device Interrupt Configuration Entry. If this is not zero, the DevIntConfigPtr
  must not be NULL.
**/
  UINT8                       NumOfDevIntConfig;

/** Offset 0x0070 - Address of PCH_DEVICE_INTERRUPT_CONFIG table.
  The address of the table of PCH_DEVICE_INTERRUPT_CONFIG.
**/
  UINT32                      DevIntConfigPtr;

/** Offset 0x0074 - Enable SerialIo Device Mode
  0:Disabled, 1:ACPI Mode, 2:PCI Mode, 3:Hidden mode, 4:Legacy UART mode - Enable/disable
  SerialIo I2C0,I2C1,I2C2,I2C3,I2C4,I2C5,SPI0,SPI1,UART0,UART1,UART2 device mode
  respectively. One byte for each controller, byte0 for I2C0, byte1 for I2C1, and so on.
**/
  UINT8                       SerialIoDevMode[11];

/** Offset 0x007F - PIRQx to IRQx Map Config
  PIRQx to IRQx mapping. The valid value is 0x00 to 0x0F for each. First byte is for
  PIRQA, second byte is for PIRQB, and so on. The setting is only available in Legacy
  8259 PCI mode.
**/
  UINT8                       PxRcConfig[8];

/** Offset 0x0087 - Select GPIO IRQ Route
  GPIO IRQ Select. The valid value is 14 or 15.
**/
  UINT8                       GpioIrqRoute;

/** Offset 0x0088 - Select SciIrqSelect
  SCI IRQ Select. The valid value is 9, 10, 11, and 20, 21, 22, 23 for APIC only.
**/
  UINT8                       SciIrqSelect;

/** Offset 0x0089 - Select TcoIrqSelect
  TCO IRQ Select. The valid value is 9, 10, 11, 20, 21, 22, 23.
**/
  UINT8                       TcoIrqSelect;

/** Offset 0x008A - Enable/Disable Tco IRQ
  Enable/disable TCO IRQ
  $EN_DIS
**/
  UINT8                       TcoIrqEnable;

/** Offset 0x008B - PCH HDA Verb Table Entry Number
  Number of Entries in Verb Table.
**/
  UINT8                       PchHdaVerbTableEntryNum;

/** Offset 0x008C - PCH HDA Verb Table Pointer
  Pointer to Array of pointers to Verb Table.
**/
  UINT32                      PchHdaVerbTablePtr;

/** Offset 0x0090
**/
  UINT8                       UnusedUpdSpace2;

/** Offset 0x0091 - Enable SATA
  Enable/disable SATA controller.
  $EN_DIS
**/
  UINT8                       SataEnable;

/** Offset 0x0092 - SATA Mode
  Select SATA controller working mode.
  0:AHCI, 1:RAID
**/
  UINT8                       SataMode;

/** Offset 0x0093 - USB Per Port HS Preemphasis Bias
  USB Per Port HS Preemphasis Bias. 000b-0mV, 001b-11.25mV, 010b-16.9mV, 011b-28.15mV,
  100b-28.15mV, 101b-39.35mV, 110b-45mV, 111b-56.3mV. One byte for each port.
**/
  UINT8                       Usb2AfePetxiset[16];

/** Offset 0x00A3 - USB Per Port HS Transmitter Bias
  USB Per Port HS Transmitter Bias. 000b-0mV, 001b-11.25mV, 010b-16.9mV, 011b-28.15mV,
  100b-28.15mV, 101b-39.35mV, 110b-45mV, 111b-56.3mV, One byte for each port.
**/
  UINT8                       Usb2AfeTxiset[16];

/** Offset 0x00B3 - USB Per Port HS Transmitter Emphasis
  USB Per Port HS Transmitter Emphasis. 00b - Emphasis OFF, 01b - De-emphasis ON,
  10b - Pre-emphasis ON, 11b - Pre-emphasis & De-emphasis ON. One byte for each port.
**/
  UINT8                       Usb2AfePredeemp[16];

/** Offset 0x00C3 - USB Per Port Half Bit Pre-emphasis
  USB Per Port Half Bit Pre-emphasis. 1b - half-bit pre-emphasis, 0b - full-bit pre-emphasis.
  One byte for each port.
**/
  UINT8                       Usb2AfePehalfbit[16];

/** Offset 0x00D3 - Enable the write to USB 3.0 TX Output -3.5dB De-Emphasis Adjustment
  Enable the write to USB 3.0 TX Output -3.5dB De-Emphasis Adjustment. Each value
  in arrary can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxDeEmphEnable[10];

/** Offset 0x00DD - USB 3.0 TX Output -3.5dB De-Emphasis Adjustment Setting
  USB 3.0 TX Output -3.5dB De-Emphasis Adjustment Setting, HSIO_TX_DWORD5[21:16],
  <b>Default = 29h</b> (approximately -3.5dB De-Emphasis). One byte for each port.
**/
  UINT8                       Usb3HsioTxDeEmph[10];

/** Offset 0x00E7 - Enable the write to USB 3.0 TX Output Downscale Amplitude Adjustment
  Enable the write to USB 3.0 TX Output Downscale Amplitude Adjustment, Each value
  in arrary can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxDownscaleAmpEnable[10];

/** Offset 0x00F1 - USB 3.0 TX Output Downscale Amplitude Adjustment
  USB 3.0 TX Output Downscale Amplitude Adjustment, HSIO_TX_DWORD8[21:16], <b>Default
  = 00h</b>. One byte for each port.
**/
  UINT8                       Usb3HsioTxDownscaleAmp[10];

/** Offset 0x00FB - Enable LAN
  Enable/disable LAN controller.
  $EN_DIS
**/
  UINT8                       PchLanEnable;

/** Offset 0x00FC - Delay USB PDO Programming
  Enable/disable delay of PDO programming for USB from PEI phase to DXE phase. 0:
  disable, 1: enable
  $EN_DIS
**/
  UINT8                       DelayUsbPdoProgramming;

/** Offset 0x00FD
**/
  UINT8                       UnusedUpdSpace3[23];

/** Offset 0x0114 - Enable PCIE RP CLKREQ Support
  Enable/disable PCIE Root Port CLKREQ support. 0: disable, 1: enable. One byte for
  each port, byte0 for port1, byte1 for port2, and so on.
**/
  UINT8                       PcieRpClkReqSupport[24];

/** Offset 0x012C - Configure CLKREQ Number
  Configure Root Port CLKREQ Number if CLKREQ is supported. Each value in arrary can
  be between 0-6. One byte for each port, byte0 for port1, byte1 for port2, and so on.
**/
  UINT8                       PcieRpClkReqNumber[24];

/** Offset 0x0144
**/
  UINT8                       UnusedUpdSpace4[5];

/** Offset 0x0149 - HECI3 state
  The HECI3 state from Mbp for reference in S3 path or when MbpHob is not installed.
  0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       Heci3Enabled;

/** Offset 0x014A
**/
  UINT8                       UnusedUpdSpace5[9];

/** Offset 0x0153 - AMT Switch
  Enable/Disable. 0: Disable, 1: enable, Enable or disable AMT functionality.
  $EN_DIS
**/
  UINT8                       AmtEnabled;

/** Offset 0x0154 - WatchDog Timer Switch
  Enable/Disable. 0: Disable, 1: enable, Enable or disable WatchDog timer.
  $EN_DIS
**/
  UINT8                       WatchDog;

/** Offset 0x0155 - ASF Switch
  Enable/Disable. 0: Disable, 1: enable, Enable or disable ASF functionality.
  $EN_DIS
**/
  UINT8                       AsfEnabled;

/** Offset 0x0156 - Manageability Mode set by Mebx
  Enable/Disable. 0: Disable, 1: enable, Enable or disable  Manageability Mode.
  $EN_DIS
**/
  UINT8                       ManageabilityMode;

/** Offset 0x0157 - PET Progress
  Enable/Disable. 0: Disable, 1: enable, Enable/Disable PET Events Progress to receive
  PET Events.
  $EN_DIS
**/
  UINT8                       FwProgress;

/** Offset 0x0158 - OS Timer
  16 bits Value, Set OS watchdog timer.
  $EN_DIS
**/
  UINT16                      WatchDogTimerOs;

/** Offset 0x015A - BIOS Timer
  16 bits Value, Set BIOS watchdog timer.
  $EN_DIS
**/
  UINT16                      WatchDogTimerBios;

/** Offset 0x015C - SOL Switch
  Enable/Disable. 0: Disable, 1: enable, Serial Over Lan enable/disable state by Mebx
  $EN_DIS
**/
  UINT8                       AmtSolEnabled;

/** Offset 0x015D - Configure CLKSRC Number
  Configure Root Port CLKSRC Number. Each value in arrary can be between 0-6 for valid
  clock numbers or 0x1F for an invalid number. One byte for each port, byte0 for
  port1, byte1 for port2, and so on.
**/
  UINT8                       PcieRpClkSrcNumber[24];

/** Offset 0x0175
**/
  UINT8                       UnusedUpdSpace6[139];

/** Offset 0x0200 - Subsystem Vendor ID for SA devices
  Subsystem ID that will be programmed to SA devices: Default SubSystemVendorId=0x8086
**/
  UINT16                      DefaultSvid;

/** Offset 0x0202 - Subsystem Device ID for SA devices
  Subsystem ID that will be programmed to SA devices: Default SubSystemId=0x2015
**/
  UINT16                      DefaultSid;

/** Offset 0x0204 - Enable/Disable SA CRID
  Enable: SA CRID, Disable (Default): SA CRID
  $EN_DIS
**/
  UINT8                       CridEnable;

/** Offset 0x0205 - DMI ASPM
  0=Disable, 2(Default)=L1
  0:Disable, 2:L1
**/
  UINT8                       DmiAspm;

/** Offset 0x0206 - PCIe Physical Slot Number per root port
  Physical Slot Number per root port
**/
  UINT16                      PegPhysicalSlotNumber[3];

/** Offset 0x020C - PCIe DeEmphasis control per root port
  0: -6dB, 1(Default): -3.5dB
  0:-6dB, 1:-3.5dB
**/
  UINT8                       PegDeEmphasis[3];

/** Offset 0x020F - PCIe Slot Power Limit value per root port
  Slot power limit value per root port
**/
  UINT8                       PegSlotPowerLimitValue[3];

/** Offset 0x0212 - PCIe Slot Power Limit scale per root port
  Slot power limit scale per root port
  0:1.0x, 1:0.1x, 2:0.01x, 3:0x001x
**/
  UINT8                       PegSlotPowerLimitScale[3];

/** Offset 0x0215 - Enable/Disable PavpEnable
  Enable(Default): Enable PavpEnable, Disable: Disable PavpEnable
  $EN_DIS
**/
  UINT8                       PavpEnable;

/** Offset 0x0216 - CdClock Frequency selection
  0=308.57 Mhz, 1=337.5 Mhz, 2=432 Mhz, 3=450 Mhz, 4=540 Mhz, 5=617.14 Mhz, 6(Default)= 675 Mhz
  0: 308.57 Mhz, 1: 337.5 Mhz, 2: 432 Mhz, 3: 450 Mhz, 4: 540 Mhz, 5: 617.14 Mhz,
  6: 675 Mhz
**/
  UINT8                       CdClock;

/** Offset 0x0217 - Enable/Disable PeiGraphicsPeimInit
  Enable: Enable PeiGraphicsPeimInit, Disable(Default): Disable PeiGraphicsPeimInit
  $EN_DIS
**/
  UINT8                       PeiGraphicsPeimInit;

/** Offset 0x0218 - Enable/Disable SA IMGU(SKYCAM)
  Enable(Default): Enable SA IMGU(SKYCAM), Disable: Disable SA IMGU(SKYCAM)
  $EN_DIS
**/
  UINT8                       SaImguEnable;

/** Offset 0x0219 - Enable or disable GMM device
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       GmmEnable;

/** Offset 0x021A - State of X2APIC_OPT_OUT bit in the DMAR table
  0=Disable/Clear, 1(Default)=Enable/Set
  $EN_DIS
**/
  UINT8                       X2ApicOptOut;

/** Offset 0x021B
**/
  UINT8                       UnusedUpdSpace7[1];

/** Offset 0x021C - Base addresses for VT-d function MMIO access
  Base addresses for VT-d MMIO access per VT-d engine
**/
  UINT32                      VtdBaseAddress[2];

/** Offset 0x0224
**/
  UINT8                       UnusedUpdSpace8[19];

/** Offset 0x0237 - SaPostMemProductionRsvd
  Reserved for SA Post-Mem Production
  $EN_DIS
**/
  UINT8                       SaPostMemProductionRsvd[16];

/** Offset 0x0247
**/
  UINT8                       UnusedUpdSpace9[7];

/** Offset 0x024E - Power State 3 enable/disable
  PCODE MMIO Mailbox: Power State 3 enable/disable; 0: Disable; <b>1: Enable</b>.
  For all VR Indexes
**/
  UINT8                       Psi3Enable[5];

/** Offset 0x0253 - Power State 4 enable/disable
  PCODE MMIO Mailbox: Power State 4 enable/disable; 0: Disable; <b>1: Enable</b>.For
  all VR Indexes
**/
  UINT8                       Psi4Enable[5];

/** Offset 0x0258 - Imon slope correction
  PCODE MMIO Mailbox: Imon slope correction. Specified in 1/100 increment values.
  Range is 0-200. 125 = 1.25. <b>0: Auto</b>.For all VR Indexes
**/
  UINT8                       ImonSlope[5];

/** Offset 0x025D - Imon offset correction
  PCODE MMIO Mailbox: Imon offset correction. Value is a 2's complement signed integer.
  Units 1/1000, Range 0-63999. For an offset = 12.580, use 12580. <b>0: Auto</b>
**/
  UINT8                       ImonOffset[5];

/** Offset 0x0262 - Enable/Disable BIOS configuration of VR
  Enable/Disable BIOS configuration of VR; <b>0: Disable</b>; 1: Enable.For all VR Indexes
**/
  UINT8                       VrConfigEnable[5];

/** Offset 0x0267 - Thermal Design Current enable/disable
  PCODE MMIO Mailbox: Thermal Design Current enable/disable; <b>0: Disable</b>; 1:
  Enable.For all VR Indexes
**/
  UINT8                       TdcEnable[5];

/** Offset 0x026C - HECI3 state
  PCODE MMIO Mailbox: Thermal Design Current time window. Defined in milli seconds.
  Valid Values 1 - 1ms , 2 - 2ms , 3 - 3ms , 4 - 4ms , 5 - 5ms , 6 - 6ms , 7 - 7ms
  , 8 - 8ms , 10 - 10ms.For all VR Indexe
**/
  UINT8                       TdcTimeWindow[5];

/** Offset 0x0271 - Thermal Design Current Lock
  PCODE MMIO Mailbox: Thermal Design Current Lock; <b>0: Disable</b>; 1: Enable.For
  all VR Indexes
**/
  UINT8                       TdcLock[5];

/** Offset 0x0276 - Platform Psys slope correction
  PCODE MMIO Mailbox: Platform Psys slope correction. <b>0 - Auto</b> Specified in
  1/100 increment values. Range is 0-200. 125 = 1.25
**/
  UINT8                       PsysSlope;

/** Offset 0x0277 - Platform Psys offset correction
  PCODE MMIO Mailbox: Platform Psys offset correction. <b>0 - Auto</b> Units 1/4,
  Range 0-255. Value of 100 = 100/4 = 25 offset
**/
  UINT8                       PsysOffset;

/** Offset 0x0278 - Acoustic Noise Mitigation feature
  Enable or Disable Acoustic Noise Mitigation feature. <b>0: Disabled</b>; 1: Enabled
  $EN_DIS
**/
  UINT8                       AcousticNoiseMitigation;

/** Offset 0x0279 - Disable Fast Slew Rate for Deep Package C States for VR IA domain
  Disable Fast Slew Rate for Deep Package C States based on Acoustic Noise Mitigation
  feature enabled. <b>0: False</b>; 1: True
  $EN_DIS
**/
  UINT8                       FastPkgCRampDisableIa;

/** Offset 0x027A - Slew Rate configuration for Deep Package C States for VR IA domain
  Slew Rate configuration for Deep Package C States for VR IA domain based on Acoustic
  Noise Mitigation feature enabled. <b>0: Fast/2</b>; 1: Fast/4; 2: Fast/8; 3: Fast/16
  0: Fast/2, 1: Fast/4, 2: Fast/8, 3: Fast/16
**/
  UINT8                       SlowSlewRateForIa;

/** Offset 0x027B - Slew Rate configuration for Deep Package C States for VR GT domain
  Slew Rate configuration for Deep Package C States for VR GT domain based on Acoustic
  Noise Mitigation feature enabled. <b>0: Fast/2</b>; 1: Fast/4; 2: Fast/8; 3: Fast/16
  0: Fast/2, 1: Fast/4, 2: Fast/8, 3: Fast/16
**/
  UINT8                       SlowSlewRateForGt;

/** Offset 0x027C - Slew Rate configuration for Deep Package C States for VR SA domain
  Slew Rate configuration for Deep Package C States for VR SA domain based on Acoustic
  Noise Mitigation feature enabled. <b>0: Fast/2</b>; 1: Fast/4; 2: Fast/8; 3: Fast/16
  0: Fast/2, 1: Fast/4, 2: Fast/8, 3: Fast/16
**/
  UINT8                       SlowSlewRateForSa;

/** Offset 0x027D
**/
  UINT8                       UnusedUpdSpace10[9];

/** Offset 0x0286 - Thermal Design Current current limit
  PCODE MMIO Mailbox: Thermal Design Current current limit. Specified in 1/8A units.
  Range is 0-4095. 1000 = 125A. <b>0: Auto</b>. For all VR Indexes
**/
  UINT16                      TdcPowerLimit[5];

/** Offset 0x0290
**/
  UINT8                       UnusedUpdSpace11[8];

/** Offset 0x0298 - AcLoadline
  PCODE MMIO Mailbox: AcLoadline in 1/100 mOhms (ie. 1250 = 12.50 mOhm); Range is
  0-6249. <b>Intel Recommended Defaults vary by domain and SKU.
**/
  UINT16                      AcLoadline[5];

/** Offset 0x02A2 - DcLoadline
  PCODE MMIO Mailbox: DcLoadline in 1/100 mOhms (ie. 1250 = 12.50 mOhm); Range is
  0-6249.<b>Intel Recommended Defaults vary by domain and SKU.</b>
**/
  UINT16                      DcLoadline[5];

/** Offset 0x02AC - Power State 1 Threshold current
  PCODE MMIO Mailbox: Power State 1 current cuttof in 1/4 Amp increments. Range is
  0-128A. Default Value = 20A.
**/
  UINT16                      Psi1Threshold[5];

/** Offset 0x02B6 - Power State 2 Threshold current
  PCODE MMIO Mailbox: Power State 2 current cuttof in 1/4 Amp increments. Range is
  0-128A. Default Value = 5A.
**/
  UINT16                      Psi2Threshold[5];

/** Offset 0x02C0 - Power State 3 Threshold current
  PCODE MMIO Mailbox: Power State 3 current cuttof in 1/4 Amp increments. Range is
  0-128A. Default Value = 1A.
**/
  UINT16                      Psi3Threshold[5];

/** Offset 0x02CA - Icc Max limit
  PCODE MMIO Mailbox: VR Icc Max limit. 0-255A in 1/4 A units. 400 = 100A
**/
  UINT16                      IccMax[5];

/** Offset 0x02D4 - VR Voltage Limit
  PCODE MMIO Mailbox: VR Voltage Limit. Range is 0-7999mV.
**/
  UINT16                      VrVoltageLimit[5];

/** Offset 0x02DE
**/
  UINT8                       UnusedUpdSpace12;

/** Offset 0x02DF - Disable Fast Slew Rate for Deep Package C States for VR GT domain
  Disable Fast Slew Rate for Deep Package C States based on Acoustic Noise Mitigation
  feature enabled. <b>0: False</b>; 1: True
  $EN_DIS
**/
  UINT8                       FastPkgCRampDisableGt;

/** Offset 0x02E0 - Disable Fast Slew Rate for Deep Package C States for VR SA domain
  Disable Fast Slew Rate for Deep Package C States based on Acoustic Noise Mitigation
  feature enabled. <b>0: False</b>; 1: True
  $EN_DIS
**/
  UINT8                       FastPkgCRampDisableSa;

/** Offset 0x02E1
**/
  UINT8                       UnusedUpdSpace13;

/** Offset 0x02E2 - Enable VR specific mailbox command
  VR specific mailbox commands. <b>00b - no VR specific command sent.</b>  01b - A
  VR mailbox command specifically for the MPS IMPV8 VR will be sent. 10b - VR specific
  command sent for PS4 exit issue. 11b - Reserved.
  $EN_DIS
**/
  UINT8                       SendVrMbxCmd;

/** Offset 0x02E3 - Select VR specific mailbox command to send
  VR specific mailbox commands. <b>000b - no VR specific command sent.</b>  001b -
  VR mailbox command specifically for the MPS IMPV8 VR will be sent. 010b - VR specific
  command sent for PS4 exit issue. 100b - VR specific command sent for MPS VR decay issue.
**/
  UINT8                       SendVrMbxCmd1;

/** Offset 0x02E4 - CpuS3ResumeMtrrData
  Pointer to CPU S3 Resume MTRR Data
**/
  UINT32                      CpuS3ResumeMtrrData;

/** Offset 0x02E8 - Cpu Configuration
  Cpu Configuration data.
**/
  CPU_CONFIG_FSP_DATA         CpuConfig;

/** Offset 0x02F0 - MicrocodePatchAddress
  Pointer to microcode patch that is suitable for this processor.
  0:Disable, 1:Enable
**/
  UINT64                      MicrocodePatchAddress;

/** Offset 0x02F8 - CpuS3ResumeMtrrDataSize
  Size of S3 resume MTRR data.
**/
  UINT16                      CpuS3ResumeMtrrDataSize;

/** Offset 0x02FA
**/
  UINT8                       UnusedUpdSpace14;

/** Offset 0x02FB - Enable SkyCam PortA Termination override
  Enable/disable PortA Termination override.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortATermOvrEnable;

/** Offset 0x02FC - Enable SkyCam PortB Termination override
  Enable/disable PortB Termination override.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortBTermOvrEnable;

/** Offset 0x02FD - Enable SkyCam PortC Termination override
  Enable/disable PortC Termination override.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortCTermOvrEnable;

/** Offset 0x02FE - Enable SkyCam PortD Termination override
  Enable/disable PortD Termination override.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortDTermOvrEnable;

/** Offset 0x02FF - Enable SkyCam PortA Clk Trim
  Enable/disable PortA Clk Trim.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortATrimEnable;

/** Offset 0x0300 - Enable SkyCam PortB Clk Trim
  Enable/disable PortB Clk Trim.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortBTrimEnable;

/** Offset 0x0301 - Enable SkyCam PortC Clk Trim
  Enable/disable PortC Clk Trim.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortCTrimEnable;

/** Offset 0x0302 - Enable SkyCam PortD Clk Trim
  Enable/disable PortD Clk Trim.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortDTrimEnable;

/** Offset 0x0303 - Enable SkyCam PortA Ctle
  Enable/disable PortA Ctle.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortACtleEnable;

/** Offset 0x0304 - Enable SkyCam PortB Ctle
  Enable/disable PortB Ctle.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortBCtleEnable;

/** Offset 0x0305 - Enable SkyCam PortCD Ctle
  Enable/disable PortCD Ctle.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortCDCtleEnable;

/** Offset 0x0306 - Enable SkyCam PortA Ctle Cap Value
  Enable/disable PortA Ctle Cap Value.
**/
  UINT8                       PchSkyCamPortACtleCapValue;

/** Offset 0x0307 - Enable SkyCam PortB Ctle Cap Value
  Enable/disable PortB Ctle Cap Value.
**/
  UINT8                       PchSkyCamPortBCtleCapValue;

/** Offset 0x0308 - Enable SkyCam PortCD Ctle Cap Value
  Enable/disable PortCD Ctle Cap Value.
**/
  UINT8                       PchSkyCamPortCDCtleCapValue;

/** Offset 0x0309 - Enable SkyCam PortA Ctle Res Value
  Enable/disable PortA Ctle Res Value.
**/
  UINT8                       PchSkyCamPortACtleResValue;

/** Offset 0x030A - Enable SkyCam PortB Ctle Res Value
  Enable/disable PortB Ctle Res Value.
**/
  UINT8                       PchSkyCamPortBCtleResValue;

/** Offset 0x030B - Enable SkyCam PortCD Ctle Res Value
  Enable/disable PortCD Ctle Res Value.
**/
  UINT8                       PchSkyCamPortCDCtleResValue;

/** Offset 0x030C - Enable SkyCam PortA Clk Trim Value
  Enable/disable PortA Clk Trim Value.
**/
  UINT8                       PchSkyCamPortAClkTrimValue;

/** Offset 0x030D - Enable SkyCam PortB Clk Trim Value
  Enable/disable PortB Clk Trim Value.
**/
  UINT8                       PchSkyCamPortBClkTrimValue;

/** Offset 0x030E - Enable SkyCam PortC Clk Trim Value
  Enable/disable PortC Clk Trim Value.
**/
  UINT8                       PchSkyCamPortCClkTrimValue;

/** Offset 0x030F - Enable SkyCam PortD Clk Trim Value
  Enable/disable PortD Clk Trim Value.
**/
  UINT8                       PchSkyCamPortDClkTrimValue;

/** Offset 0x0310 - Enable SkyCam Port A Data Trim Value
  Enable/disable Port A Data Trim Value.
**/
  UINT16                      PchSkyCamPortADataTrimValue;

/** Offset 0x0312 - Enable SkyCam Port B Data Trim Value
  Enable/disable Port B Data Trim Value.
**/
  UINT16                      PchSkyCamPortBDataTrimValue;

/** Offset 0x0314 - Enable SkyCam C/D Data Trim Value
  Enable/disable C/D Data Trim Value.
**/
  UINT16                      PchSkyCamPortCDDataTrimValue;

/** Offset 0x0316 - Enable DMI ASPM
  ASPM on PCH side of the DMI Link.
  $EN_DIS
**/
  UINT8                       PchDmiAspm;

/** Offset 0x0317 - Enable Power Optimizer
  Enable DMI Power Optimizer on PCH side.
  $EN_DIS
**/
  UINT8                       PchPwrOptEnable;

/** Offset 0x0318 - PCH Flash Protection Ranges Write Enble
  Write or erase is blocked by hardware.
**/
  UINT8                       PchWriteProtectionEnable[5];

/** Offset 0x031D - PCH Flash Protection Ranges Read Enble
  Read is blocked by hardware.
**/
  UINT8                       PchReadProtectionEnable[5];

/** Offset 0x0322 - PCH Protect Range Limit
  Left shifted address by 12 bits with address bits 11:0 are assumed to be FFFh for
  limit comparison.
**/
  UINT16                      PchProtectedRangeLimit[5];

/** Offset 0x032C - PCH Protect Range Base
  Left shifted address by 12 bits with address bits 11:0 are assumed to be 0.
**/
  UINT16                      PchProtectedRangeBase[5];

/** Offset 0x0336 - Enable Pme
  Enable Azalia wake-on-ring.
  $EN_DIS
**/
  UINT8                       PchHdaPme;

/** Offset 0x0337 - IO Buffer Voltage
  I/O Buffer Voltage Mode Select: 0: 3.3V, 1: 1.8V.
**/
  UINT8                       PchHdaIoBufferVoltage;

/** Offset 0x0338 - VC Type
  Virtual Channel Type Select: 0: VC0, 1: VC1.
**/
  UINT8                       PchHdaVcType;

/** Offset 0x0339 - HD Audio Link Frequency
  HDA Link Freq (PCH_HDAUDIO_LINK_FREQUENCY enum): 0: 6MHz, , 1: 12MHz, 2: 24MHz.
**/
  UINT8                       PchHdaLinkFrequency;

/** Offset 0x033A - iDisp-Link Frequency
  iDisp-Link Freq (PCH_HDAUDIO_LINK_FREQUENCY enum): 4: 96MHz, 3: 48MHz.
**/
  UINT8                       PchHdaIDispLinkFrequency;

/** Offset 0x033B - iDisp-Link T-mode
  iDisp-Link T-Mode (PCH_HDAUDIO_IDISP_TMODE enum): 0: 2T, 1: 1T.
**/
  UINT8                       PchHdaIDispLinkTmode;

/** Offset 0x033C - Universal Audio Architecture compliance for DSP enabled system
  0: Not-UAA Compliant (Intel SST driver supported only), 1: UAA Compliant (HDA Inbox
  driver or SST driver supported).
  $EN_DIS
**/
  UINT8                       PchHdaDspUaaCompliance;

/** Offset 0x033D - iDisplay Audio Codec disconnection
  0: Not disconnected, enumerable, 1: Disconnected SDI, not enumerable.
  $EN_DIS
**/
  UINT8                       PchHdaIDispCodecDisconnect;

/** Offset 0x033E - DSP DMIC Select (PCH_HDAUDIO_DMIC_TYPE enum)
  0: Disable; 1: 2ch array; 2: 4ch array; 3: 1ch array.
**/
  UINT8                       PchHdaDspEndpointDmic;

/** Offset 0x033F - DSP Bluetooth enablement
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchHdaDspEndpointBluetooth;

/** Offset 0x0340 - Bitmask of supported DSP features
  [BIT0] - WoV; [BIT1] - BT Sideband; [BIT2] - Codec VAD; [BIT5] - BT Intel HFP; [BIT6]
  - BT Intel A2DP; [BIT7] - DSP based speech pre-processing disabled; [BIT8] - 0:
  Intel WoV, 1: Windows Voice Activation.
**/
  UINT32                      PchHdaDspFeatureMask;

/** Offset 0x0344 - Bitmask of supported DSP Pre/Post-Processing Modules
  Deprecated: Specific pre/post-processing module bit position must be coherent with
  the ACPI implementation: \_SB.PCI0.HDAS._DSM Function 3: Query Pre/Post Processing
  Module Support.
**/
  UINT32                      PchHdaDspPpModuleMask;

/** Offset 0x0348 - DSP I2S enablement
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchHdaDspEndpointI2s;

/** Offset 0x0349 - Enable PCH Io Apic
  Set to 1 if BDF value is valid.
  $EN_DIS
**/
  UINT8                       PchIoApicBdfValid;

/** Offset 0x034A - PCH Io Apic Bus Number
  Bus/Device/Function used as Requestor / Completer ID. Default is 0xF0.
**/
  UINT8                       PchIoApicBusNumber;

/** Offset 0x034B - PCH Io Apic Device Number
  Bus/Device/Function used as Requestor / Completer ID. Default is 0x1F.
**/
  UINT8                       PchIoApicDeviceNumber;

/** Offset 0x034C - PCH Io Apic Function Number
  Bus/Device/Function used as Requestor / Completer ID. Default is 0x00.
**/
  UINT8                       PchIoApicFunctionNumber;

/** Offset 0x034D - Enable PCH Io Apic Entry 24-119
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIoApicEntry24_119;

/** Offset 0x034E - PCH Io Apic ID
  This member determines IOAPIC ID. Default is 0x02.
**/
  UINT8                       PchIoApicId;

/** Offset 0x034F - PCH Io Apic Range Select
  Define address bits 19:12 for the IOxAPIC range. Default is 0.
**/
  UINT8                       PchIoApicRangeSelect;

/** Offset 0x0350 - Enable PCH ISH SPI GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshSpiGpioAssign;

/** Offset 0x0351 - Enable PCH ISH UART0 GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshUart0GpioAssign;

/** Offset 0x0352 - Enable PCH ISH UART1 GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshUart1GpioAssign;

/** Offset 0x0353 - Enable PCH ISH I2C0 GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshI2c0GpioAssign;

/** Offset 0x0354 - Enable PCH ISH I2C1 GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshI2c1GpioAssign;

/** Offset 0x0355 - Enable PCH ISH I2C2 GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshI2c2GpioAssign;

/** Offset 0x0356 - Enable PCH ISH GP_0 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp0GpioAssign;

/** Offset 0x0357 - Enable PCH ISH GP_1 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp1GpioAssign;

/** Offset 0x0358 - Enable PCH ISH GP_2 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp2GpioAssign;

/** Offset 0x0359 - Enable PCH ISH GP_3 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp3GpioAssign;

/** Offset 0x035A - Enable PCH ISH GP_4 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp4GpioAssign;

/** Offset 0x035B - Enable PCH ISH GP_5 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp5GpioAssign;

/** Offset 0x035C - Enable PCH ISH GP_6 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp6GpioAssign;

/** Offset 0x035D - Enable PCH ISH GP_7 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp7GpioAssign;

/** Offset 0x035E - PCH ISH PDT Unlock Msg
  0: False; 1: True.
  $EN_DIS
**/
  UINT8                       PchIshPdtUnlock;

/** Offset 0x035F - Enable PCH Lan LTR capabilty of PCH internal LAN
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchLanLtrEnable;

/** Offset 0x0360 - Enable PCH Lan use CLKREQ for GbE power management
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchLanK1OffEnable;

/** Offset 0x0361 - Indicate whether dedicated CLKREQ# is supported
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchLanClkReqSupported;

/** Offset 0x0362 - CLKREQ# used by GbE
  Valid if ClkReqSupported is TRUE.
**/
  UINT8                       PchLanClkReqNumber;

/** Offset 0x0363 - Enable LOCKDOWN BIOS LOCK
  Enable the BIOS Lock feature and set EISS bit (D31:F5:RegDCh[5]) for the BIOS region
  protection.
  $EN_DIS
**/
  UINT8                       PchLockDownBiosLock;

/** Offset 0x0364 - Enable LOCKDOWN SPI Eiss
  Enable InSMM.STS (EISS) in SPI.
  $EN_DIS
**/
  UINT8                       PchLockDownSpiEiss;

/** Offset 0x0365 - PCH Compatibility Revision ID
  This member describes whether or not the CRID feature of PCH should be enabled.
  $EN_DIS
**/
  UINT8                       PchCrid;

/** Offset 0x0366 - PCH Sub system vendor ID
  Default Subsystem Vendor ID of the PCH devices. Default is 0x8086.
**/
  UINT16                      PchSubSystemVendorId;

/** Offset 0x0368 - PCH Sub system ID
  Default Subsystem ID of the PCH devices. Default is 0x7270.
**/
  UINT16                      PchSubSystemId;

/** Offset 0x036A - PCH Legacy IO Low Latency Enable
  todo
  $EN_DIS
**/
  UINT8                       PchLegacyIoLowLatency;

/** Offset 0x036B
**/
  UINT8                       UnusedUpdSpace15[5];

/** Offset 0x0370 - Enable PCIE RP HotPlug
  Indicate whether the root port is hot plug available.
**/
  UINT8                       PcieRpHotPlug[24];

/** Offset 0x0388 - Enable PCIE RP Pm Sci
  Indicate whether the root port power manager SCI is enabled.
**/
  UINT8                       PcieRpPmSci[24];

/** Offset 0x03A0 - Enable PCIE RP Ext Sync
  Indicate whether the extended synch is enabled.
**/
  UINT8                       PcieRpExtSync[24];

/** Offset 0x03B8 - Enable PCIE RP Transmitter Half Swing
  Indicate whether the Transmitter Half Swing is enabled.
**/
  UINT8                       PcieRpTransmitterHalfSwing[24];

/** Offset 0x03D0 - Enable PCIE RP Clk Req Detect
  Probe CLKREQ# signal before enabling CLKREQ# based power management.
**/
  UINT8                       PcieRpClkReqDetect[24];

/** Offset 0x03E8 - PCIE RP Advanced Error Report
  Indicate whether the Advanced Error Reporting is enabled.
**/
  UINT8                       PcieRpAdvancedErrorReporting[24];

/** Offset 0x0400 - PCIE RP Unsupported Request Report
  Indicate whether the Unsupported Request Report is enabled.
**/
  UINT8                       PcieRpUnsupportedRequestReport[24];

/** Offset 0x0418 - PCIE RP Fatal Error Report
  Indicate whether the Fatal Error Report is enabled.
**/
  UINT8                       PcieRpFatalErrorReport[24];

/** Offset 0x0430 - PCIE RP No Fatal Error Report
  Indicate whether the No Fatal Error Report is enabled.
**/
  UINT8                       PcieRpNoFatalErrorReport[24];

/** Offset 0x0448 - PCIE RP Correctable Error Report
  Indicate whether the Correctable Error Report is enabled.
**/
  UINT8                       PcieRpCorrectableErrorReport[24];

/** Offset 0x0460 - PCIE RP System Error On Fatal Error
  Indicate whether the System Error on Fatal Error is enabled.
**/
  UINT8                       PcieRpSystemErrorOnFatalError[24];

/** Offset 0x0478 - PCIE RP System Error On Non Fatal Error
  Indicate whether the System Error on Non Fatal Error is enabled.
**/
  UINT8                       PcieRpSystemErrorOnNonFatalError[24];

/** Offset 0x0490 - PCIE RP System Error On Correctable Error
  Indicate whether the System Error on Correctable Error is enabled.
**/
  UINT8                       PcieRpSystemErrorOnCorrectableError[24];

/** Offset 0x04A8 - PCIE RP Max Payload
  Max Payload Size supported, Default 128B, see enum PCH_PCIE_MAX_PAYLOAD.
**/
  UINT8                       PcieRpMaxPayload[24];

/** Offset 0x04C0 - PCIE RP Device Reset Pad Active High
  Indicated whether PERST# is active 0: Low; 1: High, See: DeviceResetPad.
**/
  UINT8                       PcieRpDeviceResetPadActiveHigh[24];

/** Offset 0x04D8 - PCIE RP Pcie Speed
  Determines each PCIE Port speed capability. 0: Auto; 1: Gen1; 2: Gen2; 3: Gen3 (see:
  PCH_PCIE_SPEED).
**/
  UINT8                       PcieRpPcieSpeed[24];

/** Offset 0x04F0 - PCIE RP Gen3 Equalization Phase Method
  PCIe Gen3 Eq Ph3 Method (see PCH_PCIE_EQ_METHOD). 0: Default; 2: Software Search;
  4: Fixed Coeficients.
**/
  UINT8                       PcieRpGen3EqPh3Method[24];

/** Offset 0x0508 - PCIE RP Physical Slot Number
  Indicates the slot number for the root port. Default is the value as root port index.
**/
  UINT8                       PcieRpPhysicalSlotNumber[24];

/** Offset 0x0520 - PCIE RP Completion Timeout
  The root port completion timeout(see: PCH_PCIE_COMPLETION_TIMEOUT). Default is PchPcieCompletionTO_Default.
**/
  UINT8                       PcieRpCompletionTimeout[24];

/** Offset 0x0538 - PCIE RP Device Reset Pad
  The PCH pin assigned to device PERST# signal if available, zero otherwise.  See
  also DeviceResetPadActiveHigh.
**/
  UINT32                      PcieRpDeviceResetPad[24];

/** Offset 0x0598 - PCIE RP Aspm
  The ASPM configuration of the root port (see: PCH_PCIE_ASPM_CONTROL). Default is
  PchPcieAspmAutoConfig.
**/
  UINT8                       PcieRpAspm[24];

/** Offset 0x05B0 - PCIE RP L1 Substates
  The L1 Substates configuration of the root port (see: PCH_PCIE_L1SUBSTATES_CONTROL).
  Default is PchPcieL1SubstatesL1_1_2.
**/
  UINT8                       PcieRpL1Substates[24];

/** Offset 0x05C8 - PCIE RP Ltr Enable
  Latency Tolerance Reporting Mechanism.
**/
  UINT8                       PcieRpLtrEnable[24];

/** Offset 0x05E0 - PCIE RP Ltr Config Lock
  0: Disable; 1: Enable.
**/
  UINT8                       PcieRpLtrConfigLock[24];

/** Offset 0x05F8 - PCIE Eq Ph3 Lane Param Cm
  PCH_PCIE_EQ_LANE_PARAM. Coefficient C-1.
**/
  UINT8                       PcieEqPh3LaneParamCm[24];

/** Offset 0x0610 - PCIE Eq Ph3 Lane Param Cp
  PCH_PCIE_EQ_LANE_PARAM. Coefficient C+1.
**/
  UINT8                       PcieEqPh3LaneParamCp[24];

/** Offset 0x0628 - PCIE Sw Eq CoeffList Cm
  PCH_PCIE_EQ_PARAM. Coefficient C-1.
**/
  UINT8                       PcieSwEqCoeffListCm[5];

/** Offset 0x062D - PCIE Sw Eq CoeffList Cp
  PCH_PCIE_EQ_PARAM. Coefficient C+1.
**/
  UINT8                       PcieSwEqCoeffListCp[5];

/** Offset 0x0632 - PCIE Disable RootPort Clock Gating
  Describes whether the PCI Express Clock Gating for each root port is enabled by
  platform modules. 0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PcieDisableRootPortClockGating;

/** Offset 0x0633 - PCIE Enable Peer Memory Write
  This member describes whether Peer Memory Writes are enabled on the platform.
  $EN_DIS
**/
  UINT8                       PcieEnablePeerMemoryWrite;

/** Offset 0x0634 - PCIE Allow No Ltr Icc PLL Shutdown
  Allows BIOS to control ICC PLL Shutdown by determining PCIe devices are LTR capable
  or leaving untouched.
  $EN_DIS
**/
  UINT8                       PcieAllowNoLtrIccPllShutdown;

/** Offset 0x0635 - PCIE Compliance Test Mode
  Compliance Test Mode shall be enabled when using Compliance Load Board.
  $EN_DIS
**/
  UINT8                       PcieComplianceTestMode;

/** Offset 0x0636 - PCIE Rp Detect Timeout Ms
  Will wait for link to exit Detect state for enabled ports before assuming there
  is no device and potentially disabling the port.
**/
  UINT16                      PcieDetectTimeoutMs;

/** Offset 0x0638 - PCIE Rp Function Swap
  Allows BIOS to use root port function number swapping when root port of function
  0 is disabled.
  $EN_DIS
**/
  UINT8                       PcieRpFunctionSwap;

/** Offset 0x0639 - PCH Pm PME_B0_S5_DIS
  When cleared (default), wake events from PME_B0_STS are allowed in S5 if PME_B0_EN = 1.
  $EN_DIS
**/
  UINT8                       PchPmPmeB0S5Dis;

/** Offset 0x063A - PCH Pm Slp S0 Voltage Margining Enable
  Indicates platform has support for VCCPrim_Core Voltage Margining in SLP_S0# asserted state.
  $EN_DIS
**/
  UINT8                       PchPmSlpS0VmEnable;

/** Offset 0x063B
**/
  UINT8                       UnusedUpdSpace16[5];

/** Offset 0x0640 - PCH Pm Wol Enable Override
  Corresponds to the WOL Enable Override bit in the General PM Configuration B (GEN_PMCON_B) register.
  $EN_DIS
**/
  UINT8                       PchPmWolEnableOverride;

/** Offset 0x0641 - PCH Pm Pcie Wake From DeepSx
  Determine if enable PCIe to wake from deep Sx.
  $EN_DIS
**/
  UINT8                       PchPmPcieWakeFromDeepSx;

/** Offset 0x0642 - PCH Pm WoW lan Enable
  Determine if WLAN wake from Sx, corresponds to the HOST_WLAN_PP_EN bit in the PWRM_CFG3 register.
  $EN_DIS
**/
  UINT8                       PchPmWoWlanEnable;

/** Offset 0x0643 - PCH Pm WoW lan DeepSx Enable
  Determine if WLAN wake from DeepSx, corresponds to the DSX_WLAN_PP_EN bit in the
  PWRM_CFG3 register.
  $EN_DIS
**/
  UINT8                       PchPmWoWlanDeepSxEnable;

/** Offset 0x0644 - PCH Pm Lan Wake From DeepSx
  Determine if enable LAN to wake from deep Sx.
  $EN_DIS
**/
  UINT8                       PchPmLanWakeFromDeepSx;

/** Offset 0x0645 - PCH Pm Deep Sx Pol
  Deep Sx Policy.
  $EN_DIS
**/
  UINT8                       PchPmDeepSxPol;

/** Offset 0x0646 - PCH Pm Slp S3 Min Assert
  SLP_S3 Minimum Assertion Width Policy. Default is PchSlpS350ms.
**/
  UINT8                       PchPmSlpS3MinAssert;

/** Offset 0x0647 - PCH Pm Slp S4 Min Assert
  SLP_S4 Minimum Assertion Width Policy. Default is PchSlpS44s.
**/
  UINT8                       PchPmSlpS4MinAssert;

/** Offset 0x0648 - PCH Pm Slp Sus Min Assert
  SLP_SUS Minimum Assertion Width Policy. Default is PchSlpSus4s.
**/
  UINT8                       PchPmSlpSusMinAssert;

/** Offset 0x0649 - PCH Pm Slp A Min Assert
  SLP_A Minimum Assertion Width Policy. Default is PchSlpA2s.
**/
  UINT8                       PchPmSlpAMinAssert;

/** Offset 0x064A
**/
  UINT8                       UnusedUpdSpace17[6];

/** Offset 0x0650 - PCH Pm Lpc Clock Run
  This member describes whether or not the LPC ClockRun feature of PCH should be enabled.
  $EN_DIS
**/
  UINT8                       PchPmLpcClockRun;

/** Offset 0x0651 - PCH Pm Slp Strch Sus Up
  Enable SLP_X Stretching After SUS Well Power Up.
  $EN_DIS
**/
  UINT8                       PchPmSlpStrchSusUp;

/** Offset 0x0652 - PCH Pm Slp Lan Low Dc
  Enable/Disable SLP_LAN# Low on DC Power.
  $EN_DIS
**/
  UINT8                       PchPmSlpLanLowDc;

/** Offset 0x0653 - PCH Pm Pwr Btn Override Period
  PCH power button override period. 000b-4s, 001b-6s, 010b-8s, 011b-10s, 100b-12s, 101b-14s.
**/
  UINT8                       PchPmPwrBtnOverridePeriod;

/** Offset 0x0654 - PCH Pm Disable Dsx Ac Present Pulldown
  When Disable, PCH will internal pull down AC_PRESENT in deep SX and during G3 exit.
  $EN_DIS
**/
  UINT8                       PchPmDisableDsxAcPresentPulldown;

/** Offset 0x0655 - PCH Pm Capsule Reset Type
  Deprecated: Determines type of reset issued during UpdateCapsule(). Always Warm reset.
  $EN_DIS
**/
  UINT8                       PchPmCapsuleResetType;

/** Offset 0x0656 - PCH Pm Disable Native Power Button
  Power button native mode disable.
  $EN_DIS
**/
  UINT8                       PchPmDisableNativePowerButton;

/** Offset 0x0657 - PCH Pm Slp S0 Enable
  Indicates whether SLP_S0# is to be asserted when PCH reaches idle state.
  $EN_DIS
**/
  UINT8                       PchPmSlpS0Enable;

/** Offset 0x0658 - PCH Pm ME_WAKE_STS
  Clear the ME_WAKE_STS bit in the Power and Reset Status (PRSTS) register.
  $EN_DIS
**/
  UINT8                       PchPmMeWakeSts;

/** Offset 0x0659 - PCH Pm WOL_OVR_WK_STS
  Clear the WOL_OVR_WK_STS bit in the Power and Reset Status (PRSTS) register.
  $EN_DIS
**/
  UINT8                       PchPmWolOvrWkSts;

/** Offset 0x065A - PCH Pm Reset Power Cycle Duration
  Could be customized in the unit of second. Please refer to EDS for all support settings.
  0 is default, 1 is 1 second, 2 is 2 seconds, ...
**/
  UINT8                       PchPmPwrCycDur;

/** Offset 0x065B
**/
  UINT8                       UnusedUpdSpace18;

/** Offset 0x065C - PCH Port 61h Config Enable/Disable
  Used for the emulation feature for Port61h read. The port is trapped and the SMI
  handler will toggle bit4 according to the handler's internal state.
  $EN_DIS
**/
  UINT8                       PchPort61hEnable;

/** Offset 0x065D - PCH Sata Pwr Opt Enable
  SATA Power Optimizer on PCH side.
  $EN_DIS
**/
  UINT8                       SataPwrOptEnable;

/** Offset 0x065E - PCH Sata eSATA Speed Limit
  When enabled, BIOS will configure the PxSCTL.SPD to 2 to limit the eSATA port speed.
  $EN_DIS
**/
  UINT8                       EsataSpeedLimit;

/** Offset 0x065F - PCH Sata Speed Limit
  Indicates the maximum speed the SATA controller can support 0h: PchSataSpeedDefault.
**/
  UINT8                       SataSpeedLimit;

/** Offset 0x0660 - Enable SATA Port HotPlug
  Enable SATA Port HotPlug.
**/
  UINT8                       SataPortsHotPlug[8];

/** Offset 0x0668 - Enable SATA Port Interlock Sw
  Enable SATA Port Interlock Sw.
**/
  UINT8                       SataPortsInterlockSw[8];

/** Offset 0x0670 - Enable SATA Port External
  Enable SATA Port External.
**/
  UINT8                       SataPortsExternal[8];

/** Offset 0x0678 - Enable SATA Port SpinUp
  Enable the COMRESET initialization Sequence to the device.
**/
  UINT8                       SataPortsSpinUp[8];

/** Offset 0x0680 - Enable SATA Port Solid State Drive
  0: HDD; 1: SSD.
**/
  UINT8                       SataPortsSolidStateDrive[8];

/** Offset 0x0688 - Enable SATA Port Enable Dito Config
  Enable DEVSLP Idle Timeout settings (DmVal, DitoVal).
**/
  UINT8                       SataPortsEnableDitoConfig[8];

/** Offset 0x0690 - Enable SATA Port DmVal
  DITO multiplier. Default is 15.
**/
  UINT8                       SataPortsDmVal[8];

/** Offset 0x0698 - Enable SATA Port DmVal
  DEVSLP Idle Timeout (DITO), Default is 625.
**/
  UINT16                      SataPortsDitoVal[8];

/** Offset 0x06A8 - Enable SATA Port ZpOdd
  Support zero power ODD.
**/
  UINT8                       SataPortsZpOdd[8];

/** Offset 0x06B0 - PCH Sata Rst Raid Alternate Id
  Enable RAID Alternate ID.
  0:Client, 1:Alternate, 2:Server
**/
  UINT8                       SataRstRaidAlternateId;

/** Offset 0x06B1 - PCH Sata Rst Raid0
  RAID0.
  $EN_DIS
**/
  UINT8                       SataRstRaid0;

/** Offset 0x06B2 - PCH Sata Rst Raid1
  RAID1.
  $EN_DIS
**/
  UINT8                       SataRstRaid1;

/** Offset 0x06B3 - PCH Sata Rst Raid10
  RAID10.
  $EN_DIS
**/
  UINT8                       SataRstRaid10;

/** Offset 0x06B4 - PCH Sata Rst Raid5
  RAID5.
  $EN_DIS
**/
  UINT8                       SataRstRaid5;

/** Offset 0x06B5 - PCH Sata Rst Irrt
  Intel Rapid Recovery Technology.
  $EN_DIS
**/
  UINT8                       SataRstIrrt;

/** Offset 0x06B6 - PCH Sata Rst Orom Ui Banner
  OROM UI and BANNER.
  $EN_DIS
**/
  UINT8                       SataRstOromUiBanner;

/** Offset 0x06B7 - PCH Sata Rst Orom Ui Delay
  00b: 2 secs; 01b: 4 secs; 10b: 6 secs; 11: 8 secs (see: PCH_SATA_OROM_DELAY).
**/
  UINT8                       SataRstOromUiDelay;

/** Offset 0x06B8 - PCH Sata Rst Hdd Unlock
  Indicates that the HDD password unlock in the OS is enabled.
  $EN_DIS
**/
  UINT8                       SataRstHddUnlock;

/** Offset 0x06B9 - PCH Sata Rst Led Locate
  Indicates that the LED/SGPIO hardware is attached and ping to locate feature is
  enabled on the OS.
  $EN_DIS
**/
  UINT8                       SataRstLedLocate;

/** Offset 0x06BA - PCH Sata Rst Irrt Only
  Allow only IRRT drives to span internal and external ports.
  $EN_DIS
**/
  UINT8                       SataRstIrrtOnly;

/** Offset 0x06BB - PCH Sata Rst Smart Storage
  RST Smart Storage caching Bit.
  $EN_DIS
**/
  UINT8                       SataRstSmartStorage;

/** Offset 0x06BC - PCH Sata Rst Pcie Storage Remap enable
  Enable Intel RST for PCIe Storage remapping.
**/
  UINT8                       SataRstPcieEnable[3];

/** Offset 0x06BF - PCH Sata Rst Pcie Storage Port
  Intel RST for PCIe Storage remapping - PCIe Port Selection (1-based, 0 = autodetect).
**/
  UINT8                       SataRstPcieStoragePort[3];

/** Offset 0x06C2 - PCH Sata Rst Pcie Device Reset Delay
  PCIe Storage Device Reset Delay in milliseconds. Default value is 100ms
**/
  UINT8                       SataRstPcieDeviceResetDelay[3];

/** Offset 0x06C5 - Enable eMMC HS400 Training
  Determine if HS400 Training is required.
  $EN_DIS
**/
  UINT8                       PchScsEmmcHs400TuningRequired;

/** Offset 0x06C6 - Set HS400 Tuning Data Valid
  Set if HS400 Tuning Data Valid.
  $EN_DIS
**/
  UINT8                       PchScsEmmcHs400DllDataValid;

/** Offset 0x06C7 - Rx Strobe Delay Control
  Rx Strobe Delay Control - Rx Strobe Delay DLL 1 (HS400 Mode).
**/
  UINT8                       PchScsEmmcHs400RxStrobeDll1;

/** Offset 0x06C8 - Tx Data Delay Control
  Tx Data Delay Control 1 - Tx Data Delay (HS400 Mode).
**/
  UINT8                       PchScsEmmcHs400TxDataDll;

/** Offset 0x06C9 - I/O Driver Strength
  I/O driver strength: 0 - 33 Ohm, 1 - 40 Ohm, 2 - 50 Ohm.
**/
  UINT8                       PchScsEmmcHs400DriverStrength;

/** Offset 0x06CA - Enable Pch Serial IO GPIO
  Determines if enable Serial IO GPIO.
  $EN_DIS
**/
  UINT8                       SerialIoGpio;

/** Offset 0x06CB - IO voltage for I2C controllers
  Selects the IO voltage for I2C controllers, 0: PchSerialIoIs33V, 1: PchSerialIoIs18V.
**/
  UINT8                       SerialIoI2cVoltage[6];

/** Offset 0x06D1 - SPI ChipSelect signal polarity
  Selects SPI ChipSelect signal polarity.
**/
  UINT8                       SerialIoSpiCsPolarity[2];

/** Offset 0x06D3 - Enables UART hardware flow control, CTS and RTS lines
  Enables UART hardware flow control, CTS and RTS linesh.
**/
  UINT8                       SerialIoUartHwFlowCtrl[3];

/** Offset 0x06D6 - UART Number For Debug Purpose
  UART number for debug purpose. 0:UART0, 1: UART1, 2:UART2.
**/
  UINT8                       SerialIoDebugUartNumber;

/** Offset 0x06D7 - Enable Debug UART Controller
  Enable debug UART controller after post.
**/
  UINT8                       SerialIoEnableDebugUartAfterPost;

/** Offset 0x06D8 - Enable Serial IRQ
  Determines if enable Serial IRQ.
  $EN_DIS
**/
  UINT8                       PchSirqEnable;

/** Offset 0x06D9 - Serial IRQ Mode Select
  Serial IRQ Mode Select, 0: quiet mode, 1: continuous mode.
  $EN_DIS
**/
  UINT8                       PchSirqMode;

/** Offset 0x06DA - Start Frame Pulse Width
  Start Frame Pulse Width, 0: PchSfpw4Clk, 1: PchSfpw6Clk, 2: PchSfpw8Clk.
**/
  UINT8                       PchStartFramePulse;

/** Offset 0x06DB - Enable Thermal Device
  Enable Thermal Device.
  $EN_DIS
**/
  UINT8                       PchThermalDeviceEnable;

/** Offset 0x06DC - Thermal Throttling Custimized T0Level Value
  Custimized T0Level value.
**/
  UINT16                      PchT0Level;

/** Offset 0x06DE - Thermal Throttling Custimized T1Level Value
  Custimized T1Level value.
**/
  UINT16                      PchT1Level;

/** Offset 0x06E0 - Thermal Throttling Custimized T2Level Value
  Custimized T2Level value.
**/
  UINT16                      PchT2Level;

/** Offset 0x06E2 - Thermal Device SMI Enable
  This locks down SMI Enable on Alert Thermal Sensor Trip.
  $EN_DIS
**/
  UINT8                       PchTsmicLock;

/** Offset 0x06E3 - Enable The Thermal Throttle
  Enable the thermal throttle function.
  $EN_DIS
**/
  UINT8                       PchTTEnable;

/** Offset 0x06E4 - PMSync State 13
  When set to 1 and the programmed GPIO pin is a 1, then PMSync state 13 will force
  at least T2 state.
  $EN_DIS
**/
  UINT8                       PchTTState13Enable;

/** Offset 0x06E5 - Thermal Throttle Lock
  Thermal Throttle Lock.
  $EN_DIS
**/
  UINT8                       PchTTLock;

/** Offset 0x06E6 - Thermal Throttling Suggested Setting
  Thermal Throttling Suggested Setting.
  $EN_DIS
**/
  UINT8                       TTSuggestedSetting;

/** Offset 0x06E7 - Enable PCH Cross Throttling
  Enable/Disable PCH Cross Throttling
  $EN_DIS
**/
  UINT8                       TTCrossThrottling;

/** Offset 0x06E8 - DMI Thermal Sensor Autonomous Width Enable
  DMI Thermal Sensor Autonomous Width Enable.
  $EN_DIS
**/
  UINT8                       PchDmiTsawEn;

/** Offset 0x06E9 - DMI Thermal Sensor Suggested Setting
  DMT thermal sensor suggested representative values.
  $EN_DIS
**/
  UINT8                       DmiSuggestedSetting;

/** Offset 0x06EA - Thermal Sensor 0 Target Width
  Thermal Sensor 0 Target Width.
**/
  UINT8                       DmiTS0TW;

/** Offset 0x06EB - Thermal Sensor 1 Target Width
  Thermal Sensor 1 Target Width.
**/
  UINT8                       DmiTS1TW;

/** Offset 0x06EC - Thermal Sensor 2 Target Width
  Thermal Sensor 2 Target Width.
**/
  UINT8                       DmiTS2TW;

/** Offset 0x06ED - Thermal Sensor 3 Target Width
  Thermal Sensor 3 Target Width.
**/
  UINT8                       DmiTS3TW;

/** Offset 0x06EE - Port 0 T1 Multipler
  Port 0 T1 Multipler.
**/
  UINT8                       SataP0T1M;

/** Offset 0x06EF - Port 0 T2 Multipler
  Port 0 T2 Multipler.
**/
  UINT8                       SataP0T2M;

/** Offset 0x06F0 - Port 0 T3 Multipler
  Port 0 T3 Multipler.
**/
  UINT8                       SataP0T3M;

/** Offset 0x06F1 - Port 0 Tdispatch
  Port 0 Tdispatch.
**/
  UINT8                       SataP0TDisp;

/** Offset 0x06F2 - Port 1 T1 Multipler
  Port 1 T1 Multipler.
**/
  UINT8                       SataP1T1M;

/** Offset 0x06F3 - Port 1 T2 Multipler
  Port 1 T2 Multipler.
**/
  UINT8                       SataP1T2M;

/** Offset 0x06F4 - Port 1 T3 Multipler
  Port 1 T3 Multipler.
**/
  UINT8                       SataP1T3M;

/** Offset 0x06F5 - Port 1 Tdispatch
  Port 1 Tdispatch.
**/
  UINT8                       SataP1TDisp;

/** Offset 0x06F6 - Port 0 Tinactive
  Port 0 Tinactive.
**/
  UINT8                       SataP0Tinact;

/** Offset 0x06F7 - Port 0 Alternate Fast Init Tdispatch
  Port 0 Alternate Fast Init Tdispatch.
  $EN_DIS
**/
  UINT8                       SataP0TDispFinit;

/** Offset 0x06F8 - Port 1 Tinactive
  Port 1 Tinactive.
**/
  UINT8                       SataP1Tinact;

/** Offset 0x06F9 - Port 1 Alternate Fast Init Tdispatch
  Port 1 Alternate Fast Init Tdispatch.
  $EN_DIS
**/
  UINT8                       SataP1TDispFinit;

/** Offset 0x06FA - Sata Thermal Throttling Suggested Setting
  Sata Thermal Throttling Suggested Setting.
  $EN_DIS
**/
  UINT8                       SataThermalSuggestedSetting;

/** Offset 0x06FB - Enable Memory Thermal Throttling
  Enable Memory Thermal Throttling.
  $EN_DIS
**/
  UINT8                       PchMemoryThrottlingEnable;

/** Offset 0x06FC - Memory Thermal Throttling
  Enable Memory Thermal Throttling.
**/
  UINT8                       PchMemoryPmsyncEnable[2];

/** Offset 0x06FE - Enable Memory Thermal Throttling
  Enable Memory Thermal Throttling.
**/
  UINT8                       PchMemoryC0TransmitEnable[2];

/** Offset 0x0700 - Enable Memory Thermal Throttling
  Enable Memory Thermal Throttling.
**/
  UINT8                       PchMemoryPinSelection[2];

/** Offset 0x0702 - Thermal Device Temperature
  Decides the temperature.
**/
  UINT16                      PchTemperatureHotLevel;

/** Offset 0x0704 - Disable XHCI Compliance Mode
  This policy will disable XHCI compliance mode on all ports. Complicance Mode should
  be default enabled.
  $EN_DIS
**/
  UINT8                       PchDisableComplianceMode;

/** Offset 0x0705 - USB2 Port Over Current Pin
  Describe the specific over current pin number of USB 2.0 Port N.
**/
  UINT8                       Usb2OverCurrentPin[16];

/** Offset 0x0715 - USB3 Port Over Current Pin
  Describe the specific over current pin number of USB 3.0 Port N.
**/
  UINT8                       Usb3OverCurrentPin[10];

/** Offset 0x071F - Enable 8254 Static Clock Gating in early POST time
  Set 8254CGE=1 is required for C11 support. However, set 8254CGE=1 in POST time might
  fail to boot legacy OS which using 8254 timer. Make sure it won't break legacy
  OS boot before enabling this.
  $EN_DIS
**/
  UINT8                       Early8254ClockGatingEnable;

/** Offset 0x0720 - PCH Sata Rst Optane Memory
  Optane Memory
  $EN_DIS
**/
  UINT8                       SataRstOptaneMemory;

/** Offset 0x0721
**/
  UINT8                       UnusedUpdSpace19[3];

/** Offset 0x0724 - Pch PCIE device override table pointer
  The PCIe device table is being used to override PCIe device ASPM settings. This
  is a pointer points to a 32bit address. And it's only used in PostMem phase. Please
  refer to PCH_PCIE_DEVICE_OVERRIDE structure for the table. Last entry VendorId
  must be 0.
**/
  UINT32                      PchPcieDeviceOverrideTablePtr;

/** Offset 0x0728 - Enable TCO timer.
  When FALSE, it disables PCH ACPI timer, and stops TCO timer. NOTE: This will have
  huge power impact when it's enabled. If TCO timer is disabled, uCode ACPI timer
  emulation must be enabled, and WDAT table must not be exposed to the OS.
  $EN_DIS
**/
  UINT8                       EnableTcoTimer;

/** Offset 0x0729 - EcCmdProvisionEav
  Ephemeral Authorization Value default values. Provisions an ephemeral shared secret to the EC
**/
  UINT8                       EcCmdProvisionEav;

/** Offset 0x072A - EcCmdLock
  EcCmdLock default values. Locks Ephemeral Authorization Value sent previously
**/
  UINT8                       EcCmdLock;

/** Offset 0x072B
**/
  UINT8                       UnusedUpdSpace20[5];

/** Offset 0x0730 - SendEcCmd
  SendEcCmd function pointer. \n
  @code typedef EFI_STATUS (EFIAPI *PLATFORM_SEND_EC_COMMAND) (IN EC_COMMAND_TYPE 
  EcCmdType, IN UINT8  EcCmd, IN UINT8  SendData, IN OUT UINT8  *ReceiveData); @endcode
**/
  UINT64                      SendEcCmd;

/** Offset 0x0738 - BgpdtHash[4]
  BgpdtHash values
**/
  UINT64                      BgpdtHash[4];

/** Offset 0x0758 - BiosGuardModulePtr
  BiosGuardModulePtr default values
**/
  UINT64                      BiosGuardModulePtr;

/** Offset 0x0760 - BiosGuardAttr
  BiosGuardAttr default values
**/
  UINT32                      BiosGuardAttr;

/** Offset 0x0764 - SgxSinitNvsData
  SgxSinitNvsData default values
**/
  UINT8                       SgxSinitNvsData;

/** Offset 0x0765
**/
  UINT8                       UnusedUpdSpace21[3];

/** Offset 0x0768 - SgxEpoch0
  SgxEpoch0 default values
**/
  UINT64                      SgxEpoch0;

/** Offset 0x0770 - SgxEpoch1
  SgxEpoch1 default values
**/
  UINT64                      SgxEpoch1;

/** Offset 0x0778 - Enable/Disable ME Unconfig on RTC clear
  Enable(Default): Enable ME Unconfig On Rtc Clear, Disable: Disable ME Unconfig On Rtc Clear
  $EN_DIS
**/
  UINT8                       MeUnconfigOnRtcClear;

/** Offset 0x0779 - Check if MeUnconfigOnRtcClear is valid
  The MeUnconfigOnRtcClear item could be not valid due to CMOS is clear.
  $EN_DIS
**/
  UINT8                       MeUnconfigIsValid;

/** Offset 0x077A - Activates VR mailbox command for Intersil VR C-state issues.
  Intersil VR mailbox command. <b>0 - no mailbox command sent.</b>  1 - VR mailbox
  command sent for IA/GT rails only. 2 - VR mailbox command sent for IA/GT/SA rails.
**/
  UINT8                       IslVrCmd;

/** Offset 0x077B
**/
  UINT8                       ReservedFspsUpd[5];
} FSP_S_CONFIG;

/** Fsp S Test Configuration
**/
typedef struct {

/** Offset 0x0780
**/
  UINT32                      Signature;

/** Offset 0x0784 - Enable/Disable Device 7 
  Enable: Device  7 enabled, Disable (Default): Device 7 disabled
  $EN_DIS
**/
  UINT8                       ChapDeviceEnable;

/** Offset 0x0785 - Skip PAM register lock
  Enable: PAM register will not be locked by RC, platform code should lock it, Disable(Default):
  PAM registers will be locked by RC
  $EN_DIS
**/
  UINT8                       SkipPamLock;

/** Offset 0x0786 - EDRAM Test Mode
  Enable: PAM register will not be locked by RC, platform code should lock it, Disable(Default):
  PAM registers will be locked by RC
  0: EDRAM SW disable, 1: EDRAM SW Enable, 2: EDRAM HW mode
**/
  UINT8                       EdramTestMode;

/** Offset 0x0787 - DMI Extended Sync Control
  Enable: Enable DMI Extended Sync Control, Disable(Default): Disable DMI Extended
  Sync Control
  $EN_DIS
**/
  UINT8                       DmiExtSync;

/** Offset 0x0788 - DMI IOT Control
  Enable: Enable DMI IOT Control, Disable(Default): Disable DMI IOT Control
  $EN_DIS
**/
  UINT8                       DmiIot;

/** Offset 0x0789 - PEG Max Payload size per root port
  0xFF(Default):Auto, 0x1: Force 128B, 0x2: Force 256B
  0xFF: Auto, 0x1: Force 128B, 0x2: Force 256B
**/
  UINT8                       PegMaxPayload[3];

/** Offset 0x078C - Enable/Disable IGFX RenderStandby
  Enable(Default): Enable IGFX RenderStandby, Disable: Disable IGFX RenderStandby
  $EN_DIS
**/
  UINT8                       RenderStandby;

/** Offset 0x078D - Enable/Disable IGFX PmSupport
  Enable(Default): Enable IGFX PmSupport, Disable: Disable IGFX PmSupport
  $EN_DIS
**/
  UINT8                       PmSupport;

/** Offset 0x078E - Enable/Disable CdynmaxClamp
  Enable(Default): Enable CdynmaxClamp, Disable: Disable CdynmaxClamp
  $EN_DIS
**/
  UINT8                       CdynmaxClampEnable;

/** Offset 0x078F - Disable VT-d
  0=Enable/FALSE(VT-d disabled), 1=Disable/TRUE (VT-d enabled)
  $EN_DIS
**/
  UINT8                       VtdDisable;

/** Offset 0x0790 - GT Frequency Limit
  0xFF: Auto(Default), 2: 100 Mhz, 3: 150 Mhz, 4: 200 Mhz, 5: 250 Mhz, 6: 300 Mhz,
  7: 350 Mhz, 8: 400 Mhz, 9: 450 Mhz, 0xA: 500 Mhz, 0xB: 550 Mhz, 0xC: 600 Mhz, 0xD:
  650 Mhz, 0xE: 700 Mhz, 0xF: 750 Mhz, 0x10: 800 Mhz, 0x11: 850 Mhz, 0x12:900 Mhz,
  0x13: 950 Mhz, 0x14: 1000 Mhz, 0x15: 1050 Mhz, 0x16: 1100 Mhz, 0x17: 1150 Mhz,
  0x18: 1200 Mhz
  0xFF: Auto(Default), 2: 100 Mhz, 3: 150 Mhz, 4: 200 Mhz, 5: 250 Mhz, 6: 300 Mhz,
  7: 350 Mhz, 8: 400 Mhz, 9: 450 Mhz, 0xA: 500 Mhz, 0xB: 550 Mhz, 0xC: 600 Mhz, 0xD:
  650 Mhz, 0xE: 700 Mhz, 0xF: 750 Mhz, 0x10: 800 Mhz, 0x11: 850 Mhz, 0x12:900 Mhz,
  0x13: 950 Mhz, 0x14: 1000 Mhz, 0x15: 1050 Mhz, 0x16: 1100 Mhz, 0x17: 1150 Mhz,
  0x18: 1200 Mhz
**/
  UINT8                       GtFreqMax;

/** Offset 0x0791 - SaPostMemTestRsvd
  Reserved for SA Post-Mem Test
  $EN_DIS
**/
  UINT8                       SaPostMemTestRsvd[11];

/** Offset 0x079C - 1-Core Ratio Limit
  1-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  1-Core Ratio Limit + OC Bins.This 1-Core Ratio Limit Must be greater than or equal
  to 2-Core Ratio Limit, 3-Core Ratio Limit, 4-Core Ratio Limit, 5-Core Ratio Limit,
  6-Core Ratio Limit, 7-Core Ratio Limit, 8-Core Ratio Limit. Range is 0 to 83
**/
  UINT8                       OneCoreRatioLimit;

/** Offset 0x079D - 2-Core Ratio Limit
  2-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  2-Core Ratio Limit + OC Bins.This 2-Core Ratio Limit Must be Less than or equal
  to 1-Core Ratio Limit.Range is 0 to 83
**/
  UINT8                       TwoCoreRatioLimit;

/** Offset 0x079E - 3-Core Ratio Limit
  3-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  3-Core Ratio Limit + OC Bins.This 3-Core Ratio Limit Must be Less than or equal
  to 1-Core Ratio Limit.Range is 0 to 83
**/
  UINT8                       ThreeCoreRatioLimit;

/** Offset 0x079F - 4-Core Ratio Limit
  4-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  4-Core Ratio Limit + OC Bins.This 4-Core Ratio Limit Must be Less than or equal
  to 1-Core Ratio Limit.Range is 0 to 83
**/
  UINT8                       FourCoreRatioLimit;

/** Offset 0x07A0
**/
  UINT8                       UnusedUpdSpace22;

/** Offset 0x07A1 - Enable or Disable HWP
  Enable or Disable HWP(Hardware P states) Support. 0: Disable; <b>1: Enable;</b>
  2-3:Reserved
  $EN_DIS
**/
  UINT8                       Hwp;

/** Offset 0x07A2 - Hardware Duty Cycle Control
  Hardware Duty Cycle Control configuration. 0: Disabled; <b>1: Enabled</b> 2-3:Reserved
  $EN_DIS
**/
  UINT8                       HdcControl;

/** Offset 0x07A3 - Package Long duration turbo mode time
  Package Long duration turbo mode time window in seconds. Valid values(Unit in seconds)
  0 to 8 , 10 , 12 ,14 , 16 , 20 , 24 , 28 , 32 , 40 , 48 , 56 , 64 , 80 , 96 , 112 , 128
**/
  UINT8                       PowerLimit1Time;

/** Offset 0x07A4 - Short Duration Turbo Mode
  Enable or Disable short duration Turbo Mode. </b>0 : Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       PowerLimit2;

/** Offset 0x07A5 - Turbo settings Lock
  Lock all Turbo settings Enable/Disable; <b>0: Disable , </b> 1: Enable
  $EN_DIS
**/
  UINT8                       TurboPowerLimitLock;

/** Offset 0x07A6 - Package PL3 time window
  Package PL3 time window range for this policy in milliseconds. Valid values are
  0, 3 to 8, 10, 12, 14, 16, 20 , 24, 28, 32, 40, 48, 55, 56, 64
**/
  UINT8                       PowerLimit3Time;

/** Offset 0x07A7 - Package PL3 Duty Cycle
  Package PL3 Duty Cycle; Valid Range is 0 to 100
**/
  UINT8                       PowerLimit3DutyCycle;

/** Offset 0x07A8 - Package PL3 Lock
  Package PL3 Lock Enable/Disable; <b>0: Disable ; <b> 1: Enable
  $EN_DIS
**/
  UINT8                       PowerLimit3Lock;

/** Offset 0x07A9 - Package PL4 Lock
  Package PL4 Lock Enable/Disable; <b>0: Disable ; <b>1: Enable
  $EN_DIS
**/
  UINT8                       PowerLimit4Lock;

/** Offset 0x07AA - TCC Activation Offset
  TCC Activation Offset. Offset from factory set TCC activation temperature at which
  the Thermal Control Circuit must be activated. TCC will be activated at TCC Activation
  Temperature, in volts.For SKL Y SKU, the recommended default for this policy is
  <b>10</b>, For all other SKUs the recommended default are <b>0</b>
**/
  UINT8                       TccActivationOffset;

/** Offset 0x07AB - Tcc Offset Clamp Enable/Disable
  Tcc Offset Clamp for Runtime Average Temperature Limit (RATL) allows CPU to throttle
  below P1.For SKL Y SKU, the recommended default for this policy is <b>1: Enabled</b>,
  For all other SKUs the recommended default are  <b>0: Disabled</b>.
  $EN_DIS
**/
  UINT8                       TccOffsetClamp;

/** Offset 0x07AC - Tcc Offset Lock
  Tcc Offset Lock for Runtime Average Temperature Limit (RATL) to lock temperature
  target; <b>0: Disabled</b>; 1: Enabled.
  $EN_DIS
**/
  UINT8                       TccOffsetLock;

/** Offset 0x07AD - Custom Ratio State Entries
  The number of custom ratio state entries, ranges from 0 to 40 for a valid custom
  ratio table.Sets the number of custom P-states. At least 2 states must be present
**/
  UINT8                       NumberOfEntries;

/** Offset 0x07AE - Custom Short term Power Limit time window
  Short term Power Limit time window value for custom CTDP level 1. Valid Range 0 to 128
**/
  UINT8                       Custom1PowerLimit1Time;

/** Offset 0x07AF - Custom Turbo Activation Ratio
  Turbo Activation Ratio for custom cTDP level 1. Valid Range 0 to 255
**/
  UINT8                       Custom1TurboActivationRatio;

/** Offset 0x07B0 - Custom Config Tdp Control
  Config Tdp Control (0/1/2) value for custom cTDP level 1. Valid Range is 0 to 2
**/
  UINT8                       Custom1ConfigTdpControl;

/** Offset 0x07B1 - Custom Short term Power Limit time window
  Short term Power Limit time window value for custom CTDP level 2. Valid Range 0 to 128
**/
  UINT8                       Custom2PowerLimit1Time;

/** Offset 0x07B2 - Custom Turbo Activation Ratio
  Turbo Activation Ratio for custom cTDP level 2. Valid Range 0 to 255
**/
  UINT8                       Custom2TurboActivationRatio;

/** Offset 0x07B3 - Custom Config Tdp Control
  Config Tdp Control (0/1/2) value for custom cTDP level 1. Valid Range is 0 to 2
**/
  UINT8                       Custom2ConfigTdpControl;

/** Offset 0x07B4 - Custom Short term Power Limit time window
  Short term Power Limit time window value for custom CTDP level 3. Valid Range 0 to 128
**/
  UINT8                       Custom3PowerLimit1Time;

/** Offset 0x07B5 - Custom Turbo Activation Ratio
  Turbo Activation Ratio for custom cTDP level 3. Valid Range 0 to 255
**/
  UINT8                       Custom3TurboActivationRatio;

/** Offset 0x07B6 - Custom Config Tdp Control
  Config Tdp Control (0/1/2) value for custom cTDP level 1. Valid Range is 0 to 2
**/
  UINT8                       Custom3ConfigTdpControl;

/** Offset 0x07B7 - ConfigTdp mode settings Lock
  Lock the ConfigTdp mode settings from runtime changes; <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       ConfigTdpLock;

/** Offset 0x07B8 - Load Configurable TDP SSDT
  Configure whether to load Configurable TDP SSDT; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       ConfigTdpBios;

/** Offset 0x07B9 - PL1 Enable value
  PL1 Enable value to limit average platform power. <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       PsysPowerLimit1;

/** Offset 0x07BA - PL1 timewindow
  PL1 timewindow in seconds.Valid values(Unit in seconds) 0 to 8 , 10 , 12 ,14 , 16
  , 20 , 24 , 28 , 32 , 40 , 48 , 56 , 64 , 80 , 96 , 112 , 128
**/
  UINT8                       PsysPowerLimit1Time;

/** Offset 0x07BB - PL2 Enable Value
  PL2 Enable activates the PL2 value to limit average platform power.<b>0: Disable</b>;
  1: Enable.
  $EN_DIS
**/
  UINT8                       PsysPowerLimit2;

/** Offset 0x07BC
**/
  UINT8                       UnusedUpdSpace23[2];

/** Offset 0x07BE - Enable or Disable MLC Streamer Prefetcher
  Enable or Disable MLC Streamer Prefetcher; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       MlcStreamerPrefetcher;

/** Offset 0x07BF - Enable or Disable MLC Spatial Prefetcher
  Enable or Disable MLC Spatial Prefetcher; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       MlcSpatialPrefetcher;

/** Offset 0x07C0 - Enable or Disable Monitor /MWAIT instructions
  Enable or Disable Monitor /MWAIT instructions; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       MonitorMwaitEnable;

/** Offset 0x07C1 - Enable or Disable initialization of machine check registers
  Enable or Disable initialization of machine check registers; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       MachineCheckEnable;

/** Offset 0x07C2 - Enable or Disable processor debug features
  Enable or Disable processor debug features; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       DebugInterfaceEnable;

/** Offset 0x07C3 - Lock or Unlock debug interface features
  Lock or Unlock debug interface features; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       DebugInterfaceLockEnable;

/** Offset 0x07C4 - AP Idle Manner of waiting for SIPI
  AP Idle Manner of waiting for SIPI; 1: HALT loop; <b>2: MWAIT loop</b>; 3: RUN loop.
  1:HALT loop, 2:MWAIT loop, 3:RUN loop
**/
  UINT8                       ApIdleManner;

/** Offset 0x07C5 - Settings for AP Handoff to OS
  Settings for AP Handoff to OS; 1: HALT loop; <b>2: MWAIT loop</b>.
  1:HALT loop, 2:MWAIT loop
**/
  UINT8                       ApHandoffManner;

/** Offset 0x07C6
**/
  UINT8                       UnusedUpdSpace24[2];

/** Offset 0x07C8 - Control on Processor Trace output scheme
  Control on Processor Trace output scheme; <b>0: Single Range Output</b>; 1: ToPA Output.
  0:Single Range Output, 1:ToPA Output
**/
  UINT8                       ProcTraceOutputScheme;

/** Offset 0x07C9 - Enable or Disable Processor Trace feature
  Enable or Disable Processor Trace feature; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       ProcTraceEnable;

/** Offset 0x07CA - Memory region allocation for Processor Trace
  Memory region allocation for Processor Trace, Total Memory required is up to requested
  value * 2 (for memory alignment) * 8 active threads, to enable Processor Trace,
  PcdFspReservedMemoryLength must be increased by the total memory required, and
  PlatformMemorySize policy must also be increased by the total memory required over
  32MB, Valid Values are 0 - 4KB , 0x1 - 8KB , 0x2 - 16KB , 0x3 - 32KB , 0x4 - 64KB
  , 0x5 - 128KB , 0x6 - 256KB , 0x7 - 512KB , 0x8 - 1MB , 0x9 - 2MB , 0xA - 4MB ,
  0xB - 8MB , 0xC - 16MB , 0xD - 32MB , 0xE - 64MB , 0xF - 128MB , 0xFF: Disable
**/
  UINT8                       ProcTraceMemSize;

/** Offset 0x07CB
**/
  UINT8                       UnusedUpdSpace25;

/** Offset 0x07CC - Enable or Disable Voltage Optimization feature
  Enable or Disable Voltage Optimization feature 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       VoltageOptimization;

/** Offset 0x07CD - Enable or Disable Intel SpeedStep Technology
  Enable or Disable Intel SpeedStep Technology. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       Eist;

/** Offset 0x07CE - Enable or Disable Energy Efficient P-state
  Enable or Disable Energy Efficient P-state will be applied in Turbo mode. Disable;
  <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       EnergyEfficientPState;

/** Offset 0x07CF - Enable or Disable Energy Efficient Turbo
  Enable or Disable Energy Efficient Turbo, will be applied in Turbo mode. Disable;
  <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       EnergyEfficientTurbo;

/** Offset 0x07D0 - Enable or Disable T states
  Enable or Disable T states; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       TStates;

/** Offset 0x07D1 - Enable or Disable Bi-Directional PROCHOT#
  Enable or Disable Bi-Directional PROCHOT#; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       BiProcHot;

/** Offset 0x07D2 - Enable or Disable PROCHOT# signal being driven externally
  Enable or Disable PROCHOT# signal being driven externally; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       DisableProcHotOut;

/** Offset 0x07D3 - Enable or Disable PROCHOT# Response
  Enable or Disable PROCHOT# Response; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       ProcHotResponse;

/** Offset 0x07D4 - Enable or Disable VR Thermal Alert
  Enable or Disable VR Thermal Alert; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       DisableVrThermalAlert;

/** Offset 0x07D5 - Enable or Disable Thermal Reporting
  Enable or Disable Thermal Reporting through ACPI tables; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       AutoThermalReporting;

/** Offset 0x07D6 - Enable or Disable Thermal Monitor
  Enable or Disable Thermal Monitor; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       ThermalMonitor;

/** Offset 0x07D7 - Enable or Disable CPU power states (C-states)
  Enable or Disable CPU power states (C-states). 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       Cx;

/** Offset 0x07D8 - Configure C-State Configuration Lock
  Configure C-State Configuration Lock; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       PmgCstCfgCtrlLock;

/** Offset 0x07D9 - Enable or Disable Enhanced C-states
  Enable or Disable Enhanced C-states. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       C1e;

/** Offset 0x07DA - Enable or Disable Package C-State Demotion
  Enable or Disable Package C-State Demotion. 0: Disable; 1: Enable; <b>2: Auto</b>
  (Auto: Enabled for Skylake; Disabled for Kabylake)
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       PkgCStateDemotion;

/** Offset 0x07DB - Enable or Disable Package C-State UnDemotion
  Enable or Disable Package C-State UnDemotion. 0: Disable; 1: Enable; <b>2: Auto</b>
  (Auto: Enabled for Skylake; Disabled for Kabylake)
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       PkgCStateUnDemotion;

/** Offset 0x07DC - Enable or Disable CState-Pre wake
  Enable or Disable CState-Pre wake. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       CStatePreWake;

/** Offset 0x07DD - Enable or Disable TimedMwait Support.
  Enable or Disable TimedMwait Support. <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       TimedMwait;

/** Offset 0x07DE - Enable or Disable IO to MWAIT redirection
  Enable or Disable IO to MWAIT redirection; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       CstCfgCtrIoMwaitRedirection;

/** Offset 0x07DF - Set the Max Pkg Cstate
  Set the Max Pkg Cstate. Default set to Auto which limits the Max Pkg Cstate to deep
  C-state. Valid values 0 - C0/C1 , 1 - C2 , 2 - C3 , 3 - C6 , 4 - C7 , 5 - C7S ,
  6 - C8 , 7 - C9 , 8 - C10 , 254 - CPU Default , 255 - Auto
**/
  UINT8                       PkgCStateLimit;

/** Offset 0x07E0 - TimeUnit for C-State Latency Control0
  TimeUnit for C-State Latency Control0; Valid values 0 - 1ns , 1 - 32ns , 2 - 1024ns
  , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl0TimeUnit;

/** Offset 0x07E1 - TimeUnit for C-State Latency Control1
  TimeUnit for C-State Latency Control1;Valid values 0 - 1ns , 1 - 32ns , 2 - 1024ns
  , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl1TimeUnit;

/** Offset 0x07E2 - TimeUnit for C-State Latency Control2
  TimeUnit for C-State Latency Control2;Valid values 0 - 1ns , 1 - 32ns , 2 - 1024ns
  , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl2TimeUnit;

/** Offset 0x07E3 - TimeUnit for C-State Latency Control3
  TimeUnit for C-State Latency Control3;Valid values 0 - 1ns , 1 - 32ns , 2 - 1024ns
  , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl3TimeUnit;

/** Offset 0x07E4 - TimeUnit for C-State Latency Control4
  TimeUnit for C-State Latency Control4;Valid values 0 - 1ns , 1 - 32ns , 2 - 1024ns
  , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl4TimeUnit;

/** Offset 0x07E5 - TimeUnit for C-State Latency Control5
  TimeUnit for C-State Latency Control5;Valid values 0 - 1ns , 1 - 32ns , 2 - 1024ns
  , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl5TimeUnit;

/** Offset 0x07E6 - Interrupt Redirection Mode Select
  Interrupt Redirection Mode Select.0: Fixed priority; 1: Round robin;2: Hash vector;4:
  PAIR with fixed priority;5: PAIR with round robin;6: PAIR with hash vector;7: No change.
**/
  UINT8                       PpmIrmSetting;

/** Offset 0x07E7 - Lock prochot configuration
  Lock prochot configuration Enable/Disable; <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       ProcHotLock;

/** Offset 0x07E8 - Configuration for boot TDP selection
  Configuration for boot TDP selection; <b>0: TDP Nominal</b>; 1: TDP Down; 2: TDP
  Up; 0xFF: Deactivate
  0:TDP Nominal, 1:TDP Down, 2:TDP Up, 0xFF:Deactivate
**/
  UINT8                       ConfigTdpLevel;

/** Offset 0x07E9 - Race To Halt
  Enable/Disable Race To Halt feature. RTH will dynamically increase CPU frequency
  in order to enter pkg C-State faster to reduce overall power. (RTH is controlled
  through MSR 1FC bit 20)Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       RaceToHalt;

/** Offset 0x07EA - Max P-State Ratio
  Max P-State Ratio , Valid Range 0 to 0x7F
**/
  UINT16                      MaxRatio;

/** Offset 0x07EC - Maximum P-state ratio to use in the custom P-state table
  Maximum P-state ratio to use in the custom P-state table. NumOfCustomPStates has
  valid range between 0 to 40. For no. of P-States supported(NumOfCustomPStates)
  , StateRatio[NumOfCustomPStates] are configurable. Valid Range of value is 0 to 0x7F
**/
  UINT16                      StateRatio[40];

/** Offset 0x083C - Interrupt Response Time Limit of C-State LatencyContol0
  Interrupt Response Time Limit of C-State LatencyContol0.Range of value 0 to 0x3FF,
  Default is 0x4E, Server Platform is 0x4B
**/
  UINT16                      CstateLatencyControl0Irtl;

/** Offset 0x083E - Interrupt Response Time Limit of C-State LatencyContol1
  Interrupt Response Time Limit of C-State LatencyContol1.Range of value 0 to 0x3FF,
  Default is 0x76, Server Platform is 0x6B
**/
  UINT16                      CstateLatencyControl1Irtl;

/** Offset 0x0840 - Interrupt Response Time Limit of C-State LatencyContol2
  Interrupt Response Time Limit of C-State LatencyContol2.Range of value 0 to 0x3FF
**/
  UINT16                      CstateLatencyControl2Irtl;

/** Offset 0x0842 - Interrupt Response Time Limit of C-State LatencyContol3
  Interrupt Response Time Limit of C-State LatencyContol3.Range of value 0 to 0x3FF
**/
  UINT16                      CstateLatencyControl3Irtl;

/** Offset 0x0844 - Interrupt Response Time Limit of C-State LatencyContol4
  Interrupt Response Time Limit of C-State LatencyContol4.Range of value 0 to 0x3FF
**/
  UINT16                      CstateLatencyControl4Irtl;

/** Offset 0x0846 - Interrupt Response Time Limit of C-State LatencyContol5
  Interrupt Response Time Limit of C-State LatencyContol5.Range of value 0 to 0x3FF
**/
  UINT16                      CstateLatencyControl5Irtl;

/** Offset 0x0848 - Package Long duration turbo mode power limit
  Package Long duration turbo mode power limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 4095875 in Step size of 125
**/
  UINT32                      PowerLimit1;

/** Offset 0x084C - Package Short duration turbo mode power limit
  Package Short duration turbo mode power limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      PowerLimit2Power;

/** Offset 0x0850 - Package PL3 power limit
  Package PL3 power limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      PowerLimit3;

/** Offset 0x0854 - Package PL4 power limit
  Package PL4 power limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      PowerLimit4;

/** Offset 0x0858 - Tcc Offset Time Window for RATL
  Package PL4 power limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      TccOffsetTimeWindowForRatl;

/** Offset 0x085C - Short term Power Limit value for custom cTDP level 1
  Short term Power Limit value for custom cTDP level 1. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom1PowerLimit1;

/** Offset 0x0860 - Long term Power Limit value for custom cTDP level 1
  Long term Power Limit value for custom cTDP level 1. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom1PowerLimit2;

/** Offset 0x0864 - Short term Power Limit value for custom cTDP level 2
  Short term Power Limit value for custom cTDP level 2. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom2PowerLimit1;

/** Offset 0x0868 - Long term Power Limit value for custom cTDP level 2
  Long term Power Limit value for custom cTDP level 2. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom2PowerLimit2;

/** Offset 0x086C - Short term Power Limit value for custom cTDP level 3
  Short term Power Limit value for custom cTDP level 3. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom3PowerLimit1;

/** Offset 0x0870 - Long term Power Limit value for custom cTDP level 3
  Long term Power Limit value for custom cTDP level 3. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom3PowerLimit2;

/** Offset 0x0874 - Platform PL1 power
  Platform PL1 power. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid Range
  0 to 4095875 in Step size of 125
**/
  UINT32                      PsysPowerLimit1Power;

/** Offset 0x0878 - Platform PL2 power
  Platform PL2 power. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid Range
  0 to 4095875 in Step size of 125
**/
  UINT32                      PsysPowerLimit2Power;

/** Offset 0x087C - Platform Power Pmax
  PCODE MMIO Mailbox: Platform Power Pmax. <b>0 - Auto</b> Specified in 1/8 Watt increments.
  Range 0-1024 Watts. Value of 800 = 100W
**/
  UINT16                      PsysPmax;

/** Offset 0x087E - CpuS3ResumeDataSize
  Size of CPU S3 Resume Data
**/
  UINT16                      CpuS3ResumeDataSize;

/** Offset 0x0880 - CpuS3ResumeData
  Pointer to CPU S3 Resume Data
**/
  UINT32                      CpuS3ResumeData;

/** Offset 0x0884 - 5-Core Ratio Limit
  5-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  5-Core Ratio Limit + OC Bins.This 5-Core Ratio Limit Must be Less than or equal
  to 1-Core Ratio Limit.Range is 0 to 83
**/
  UINT8                       FiveCoreRatioLimit;

/** Offset 0x0885 - 6-Core Ratio Limit
  6-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  6-Core Ratio Limit + OC Bins.This 6-Core Ratio Limit Must be Less than or equal
  to 1-Core Ratio Limit.Range is 0 to 83
**/
  UINT8                       SixCoreRatioLimit;

/** Offset 0x0886 - 7-Core Ratio Limit
  7-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  7-Core Ratio Limit + OC Bins.This 7-Core Ratio Limit Must be Less than or equal
  to 1-Core Ratio Limit.Range is 0 to 83
**/
  UINT8                       SevenCoreRatioLimit;

/** Offset 0x0887 - 8-Core Ratio Limit
  8-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  8-Core Ratio Limit + OC Bins.This 8-Core Ratio Limit Must be Less than or equal
  to 1-Core Ratio Limit.Range is 0 to 83
**/
  UINT8                       EightCoreRatioLimit;

/** Offset 0x0888 - Set Three Strike Counter Disable
  False (default): Three Strike counter will be incremented and True: Prevents Three
  Strike counter from incrementing; <b>0: False</b>; 1: True.
  0: False, 1: True
**/
  UINT8                       ThreeStrikeCounterDisable;

/** Offset 0x0889 - ReservedCpuPostMemTest
  Reserved for CPU Post-Mem Test
  $EN_DIS
**/
  UINT8                       ReservedCpuPostMemTest[1];

/** Offset 0x088A - SgxSinitDataFromTpm
  SgxSinitDataFromTpm default values
**/
  UINT8                       SgxSinitDataFromTpm;

/** Offset 0x088B - End of Post message
  Test, Send End of Post message. Disable(0x0): Disable EOP message, Send in PEI(0x1):
  EOP send in PEI, Send in DXE(0x2)(Default): EOP send in PEI
  0:Disable, 1:Send in PEI, 2:Send in DXE, 3:Reserved
**/
  UINT8                       EndOfPostMessage;

/** Offset 0x088C - D0I3 Setting for HECI Disable
  Test, 0: disable, 1: enable, Setting this option disables setting D0I3 bit for all
  HECI devices
  $EN_DIS
**/
  UINT8                       DisableD0I3SettingForHeci;

/** Offset 0x088D - Enable LOCKDOWN SMI
  Enable SMI_LOCK bit to prevent writes to the Global SMI Enable bit.
  $EN_DIS
**/
  UINT8                       PchLockDownGlobalSmi;

/** Offset 0x088E - HD Audio Reset Wait Timer
  The delay timer after Azalia reset, the value is number of microseconds. Default is 600.
**/
  UINT16                      PchHdaResetWaitTimer;

/** Offset 0x0890 - Enable LOCKDOWN BIOS Interface
  Enable BIOS Interface Lock Down bit to prevent writes to the Backup Control Register.
  $EN_DIS
**/
  UINT8                       PchLockDownBiosInterface;

/** Offset 0x0891 - RTC CMOS RAM LOCK
  Enable RTC lower and upper 128 byte Lock bits to lock Bytes 38h-3Fh in the upper
  and and lower 128-byte bank of RTC RAM.
  $EN_DIS
**/
  UINT8                       PchLockDownRtcLock;

/** Offset 0x0892 - PCH Sbi lock bit
  This unlock the SBI lock bit to allow SBI after post time. 0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchSbiUnlock;

/** Offset 0x0893 - PCH Psf lock bit
  The PSF registers will be locked before 3rd party code execution. 0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchSbAccessUnlock;

/** Offset 0x0894 - PCIE RP Ltr Max Snoop Latency
  Latency Tolerance Reporting, Max Snoop Latency.
**/
  UINT16                      PcieRpLtrMaxSnoopLatency[24];

/** Offset 0x08C4 - PCIE RP Ltr Max No Snoop Latency
  Latency Tolerance Reporting, Max Non-Snoop Latency.
**/
  UINT16                      PcieRpLtrMaxNoSnoopLatency[24];

/** Offset 0x08F4 - PCIE RP Snoop Latency Override Mode
  Latency Tolerance Reporting, Snoop Latency Override Mode.
**/
  UINT8                       PcieRpSnoopLatencyOverrideMode[24];

/** Offset 0x090C - PCIE RP Snoop Latency Override Multiplier
  Latency Tolerance Reporting, Snoop Latency Override Multiplier.
**/
  UINT8                       PcieRpSnoopLatencyOverrideMultiplier[24];

/** Offset 0x0924 - PCIE RP Snoop Latency Override Value
  Latency Tolerance Reporting, Snoop Latency Override Value.
**/
  UINT16                      PcieRpSnoopLatencyOverrideValue[24];

/** Offset 0x0954 - PCIE RP Non Snoop Latency Override Mode
  Latency Tolerance Reporting, Non-Snoop Latency Override Mode.
**/
  UINT8                       PcieRpNonSnoopLatencyOverrideMode[24];

/** Offset 0x096C - PCIE RP Non Snoop Latency Override Multiplier
  Latency Tolerance Reporting, Non-Snoop Latency Override Multiplier.
**/
  UINT8                       PcieRpNonSnoopLatencyOverrideMultiplier[24];

/** Offset 0x0984 - PCIE RP Non Snoop Latency Override Value
  Latency Tolerance Reporting, Non-Snoop Latency Override Value.
**/
  UINT16                      PcieRpNonSnoopLatencyOverrideValue[24];

/** Offset 0x09B4 - PCIE RP Slot Power Limit Scale
  Specifies scale used for slot power limit value. Leave as 0 to set to default.
**/
  UINT8                       PcieRpSlotPowerLimitScale[24];

/** Offset 0x09CC - PCIE RP Slot Power Limit Value
  Specifies upper limit on power supplie by slot. Leave as 0 to set to default.
**/
  UINT16                      PcieRpSlotPowerLimitValue[24];

/** Offset 0x09FC - PCIE RP Upstream Port Transmiter Preset
  Used during Gen3 Link Equalization. Used for all lanes.  Default is 5.
**/
  UINT8                       PcieRpUptp[24];

/** Offset 0x0A14 - PCIE RP Downstream Port Transmiter Preset
  Used during Gen3 Link Equalization. Used for all lanes.  Default is 7.
**/
  UINT8                       PcieRpDptp[24];

/** Offset 0x0A2C - PCIE RP Enable Port8xh Decode
  This member describes whether PCIE root port Port 8xh Decode is enabled. 0: Disable;
  1: Enable.
  $EN_DIS
**/
  UINT8                       PcieEnablePort8xhDecode;

/** Offset 0x0A2D - PCIE Port8xh Decode Port Index
  The Index of PCIe Port that is selected for Port8xh Decode (0 Based).
**/
  UINT8                       PchPciePort8xhDecodePortIndex;

/** Offset 0x0A2E - PCH Pm Disable Energy Report
  Disable/Enable PCH to CPU enery report feature.
  $EN_DIS
**/
  UINT8                       PchPmDisableEnergyReport;

/** Offset 0x0A2F - PCH Pm Pmc Read Disable
  Deprecated
  $EN_DIS
**/
  UINT8                       PchPmPmcReadDisable;

/** Offset 0x0A30 - PCH Sata Test Mode
  Allow entrance to the PCH SATA test modes.
  $EN_DIS
**/
  UINT8                       SataTestMode;

/** Offset 0x0A31
**/
  UINT8                       ReservedFspsTestUpd[15];
} FSP_S_TEST_CONFIG;

/** Fsp S UPD Configuration
**/
typedef struct {

/** Offset 0x0000
**/
  FSP_UPD_HEADER              FspUpdHeader;

/** Offset 0x0020
**/
  FSP_S_CONFIG                FspsConfig;

/** Offset 0x0780
**/
  FSP_S_TEST_CONFIG           FspsTestConfig;

/** Offset 0x0A40
**/
  UINT8                       UnusedUpdSpace26[470];

/** Offset 0x0C16
**/
  UINT16                      UpdTerminator;
} FSPS_UPD;

#pragma pack()

#endif
